/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.bkd;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BitUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.bkd.BKDConfig;
import org.gnit.lucenekmp.util.bkd.HeapPointReader;
import org.gnit.lucenekmp.util.bkd.PointReader;
import org.gnit.lucenekmp.util.bkd.PointValue;
import org.gnit.lucenekmp.util.bkd.PointWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0002\b\u0012\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001>B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0005J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0016H\u0016J\u0016\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005J\u0016\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010!\u001a\u00020\u0005J&\u0010\"\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u0005J\u001e\u0010&\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u0005J\u001e\u0010'\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005J&\u0010'\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u0005J(\u0010'\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u0005H\u0002J\u0016\u0010-\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005J\u001e\u0010-\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u0005J(\u0010-\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u0005H\u0002J\u001e\u0010/\u001a\u00020\u00052\u0006\u00100\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u00052\u0006\u00102\u001a\u000203J\b\u00104\u001a\u000205H\u0016J\u0018\u00106\u001a\u0002072\u0006\u00108\u001a\u0002052\u0006\u00109\u001a\u000205H\u0016J\b\u0010:\u001a\u00020\u0019H\u0016J\b\u0010;\u001a\u00020\u0019H\u0016J\b\u0010<\u001a\u00020=H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lorg/gnit/lucenekmp/util/bkd/HeapPointWriter;", "Lorg/gnit/lucenekmp/util/bkd/PointWriter;", "config", "Lorg/gnit/lucenekmp/util/bkd/BKDConfig;", "size", "", "<init>", "(Lorg/gnit/lucenekmp/util/bkd/BKDConfig;I)V", "getSize", "()I", "block", "", "scratch", "dimComparator", "Lorg/gnit/lucenekmp/util/ArrayUtil$Companion$ByteArrayComparator;", "dataDimsAndDocLength", "nextWrite", "closed", "", "pointValue", "Lorg/gnit/lucenekmp/util/bkd/HeapPointWriter$HeapPointValue;", "getPackedValueSlice", "Lorg/gnit/lucenekmp/util/bkd/PointValue;", "index", "append", "", "packedValue", "docID", "swap", "i", "j", "byteAt", "", "k", "copyDim", "dim", "bytes", "offset", "copyDataDimsAndDoc", "compareDim", "dimValue", "blockI", "offsetI", "blockJ", "offsetJ", "compareDataDimsAndDoc", "dataDimsAndDocs", "computeCardinality", "from", "to", "commonPrefixLengths", "", "count", "", "getReader", "Lorg/gnit/lucenekmp/util/bkd/PointReader;", "start", "length", "close", "destroy", "toString", "", "HeapPointValue", "core"})
@SourceDebugExtension(value={"SMAP\nHeapPointWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HeapPointWriter.kt\norg/gnit/lucenekmp/util/bkd/HeapPointWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,257:1\n1#2:258\n*E\n"})
public final class HeapPointWriter
implements PointWriter {
    @NotNull
    private final BKDConfig config;
    private final int size;
    @NotNull
    private final byte[] block;
    @NotNull
    private final byte[] scratch;
    @NotNull
    private final ArrayUtil.Companion.ByteArrayComparator dimComparator;
    private final int dataDimsAndDocLength;
    private int nextWrite;
    private boolean closed;
    @Nullable
    private HeapPointValue pointValue;

    public HeapPointWriter(@NotNull BKDConfig config, int size2) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        this.size = size2;
        this.block = new byte[this.config.bytesPerDoc() * this.size];
        this.scratch = new byte[this.config.bytesPerDoc()];
        this.dimComparator = ArrayUtil.Companion.getUnsignedComparator(this.config.getBytesPerDim());
        this.dataDimsAndDocLength = this.config.bytesPerDoc() - this.config.packedIndexBytesLength();
        this.pointValue = this.size > 0 ? new HeapPointValue(this.config, this.block) : null;
    }

    public final int getSize() {
        return this.size;
    }

    @Nullable
    public final PointValue getPackedValueSlice(int index) {
        if (!(index < this.nextWrite)) {
            boolean bl = false;
            String string = "nextWrite=" + this.nextWrite + " vs index=" + index;
            throw new IllegalArgumentException(string.toString());
        }
        HeapPointValue heapPointValue = this.pointValue;
        Intrinsics.checkNotNull((Object)heapPointValue);
        heapPointValue.setOffset(index * this.config.bytesPerDoc());
        return this.pointValue;
    }

    @Override
    public void append(@NotNull byte[] packedValue, int docID) {
        Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
        if (!(!this.closed)) {
            boolean $i$a$-require-HeapPointWriter$append$42 = false;
            String $i$a$-require-HeapPointWriter$append$42 = "point writer is already closed";
            throw new IllegalArgumentException($i$a$-require-HeapPointWriter$append$42.toString());
        }
        if (!(packedValue.length == this.config.packedBytesLength())) {
            boolean $i$a$-require-HeapPointWriter$append$52 = false;
            String $i$a$-require-HeapPointWriter$append$52 = "[packedValue] must have length [" + this.config.packedBytesLength() + "] but was [" + packedValue.length + "]";
            throw new IllegalArgumentException($i$a$-require-HeapPointWriter$append$52.toString());
        }
        if (!(this.nextWrite < this.size)) {
            boolean bl = false;
            String string = "nextWrite=" + (this.nextWrite + 1) + " vs size=" + this.size;
            throw new IllegalArgumentException(string.toString());
        }
        int position = this.nextWrite * this.config.bytesPerDoc();
        System.INSTANCE.arraycopy(packedValue, 0, this.block, position, this.config.packedBytesLength());
        BitUtil.VH_BE_INT.INSTANCE.set(this.block, position + this.config.packedBytesLength(), docID);
        int n = this.nextWrite;
        this.nextWrite = n + 1;
    }

    @Override
    public void append(@NotNull PointValue pointValue) {
        Intrinsics.checkNotNullParameter((Object)pointValue, (String)"pointValue");
        if (!(!this.closed)) {
            boolean $i$a$-require-HeapPointWriter$append$72 = false;
            String $i$a$-require-HeapPointWriter$append$72 = "point writer is already closed";
            throw new IllegalArgumentException($i$a$-require-HeapPointWriter$append$72.toString());
        }
        if (!(this.nextWrite < this.size)) {
            boolean $i$a$-require-HeapPointWriter$append$82 = false;
            String $i$a$-require-HeapPointWriter$append$82 = "nextWrite=" + (this.nextWrite + 1) + " vs size=" + this.size;
            throw new IllegalArgumentException($i$a$-require-HeapPointWriter$append$82.toString());
        }
        BytesRef packedValueDocID = pointValue.packedValueDocIDBytes();
        if (!(packedValueDocID.getLength() == this.config.bytesPerDoc())) {
            boolean bl = false;
            String string = "[packedValue] must have length [" + this.config.bytesPerDoc() + "] but was [" + packedValueDocID.getLength() + "]";
            throw new IllegalArgumentException(string.toString());
        }
        int position = this.nextWrite * this.config.bytesPerDoc();
        System.INSTANCE.arraycopy(packedValueDocID.getBytes(), packedValueDocID.getOffset(), this.block, position, this.config.bytesPerDoc());
        int n = this.nextWrite;
        this.nextWrite = n + 1;
    }

    public final void swap(int i, int j) {
        int indexI = i * this.config.bytesPerDoc();
        int indexJ = j * this.config.bytesPerDoc();
        System.INSTANCE.arraycopy(this.block, indexI, this.scratch, 0, this.config.bytesPerDoc());
        System.INSTANCE.arraycopy(this.block, indexJ, this.block, indexI, this.config.bytesPerDoc());
        System.INSTANCE.arraycopy(this.scratch, 0, this.block, indexJ, this.config.bytesPerDoc());
    }

    public final byte byteAt(int i, int k) {
        return (byte)(this.block[i * this.config.bytesPerDoc() + k] & 0xFF);
    }

    public final void copyDim(int i, int dim, @NotNull byte[] bytes, int offset) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        System.INSTANCE.arraycopy(this.block, i * this.config.bytesPerDoc() + dim, bytes, offset, this.config.getBytesPerDim());
    }

    public final void copyDataDimsAndDoc(int i, @NotNull byte[] bytes, int offset) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        System.INSTANCE.arraycopy(this.block, i * this.config.bytesPerDoc() + this.config.packedIndexBytesLength(), bytes, offset, this.dataDimsAndDocLength);
    }

    public final int compareDim(int i, int j, int dim) {
        int iOffset = i * this.config.bytesPerDoc() + dim;
        int jOffset = j * this.config.bytesPerDoc() + dim;
        return this.compareDim(this.block, iOffset, this.block, jOffset);
    }

    public final int compareDim(int j, @NotNull byte[] dimValue, int offset, int dim) {
        Intrinsics.checkNotNullParameter((Object)dimValue, (String)"dimValue");
        int jOffset = j * this.config.bytesPerDoc() + dim;
        return this.compareDim(dimValue, offset, this.block, jOffset);
    }

    private final int compareDim(byte[] blockI, int offsetI, byte[] blockJ, int offsetJ) {
        return this.dimComparator.compare(blockI, offsetI, blockJ, offsetJ);
    }

    public final int compareDataDimsAndDoc(int i, int j) {
        int iOffset = i * this.config.bytesPerDoc() + this.config.packedIndexBytesLength();
        int jOffset = j * this.config.bytesPerDoc() + this.config.packedIndexBytesLength();
        return this.compareDataDimsAndDoc(this.block, iOffset, this.block, jOffset);
    }

    public final int compareDataDimsAndDoc(int j, @NotNull byte[] dataDimsAndDocs, int offset) {
        Intrinsics.checkNotNullParameter((Object)dataDimsAndDocs, (String)"dataDimsAndDocs");
        int jOffset = j * this.config.bytesPerDoc() + this.config.packedIndexBytesLength();
        return this.compareDataDimsAndDoc(dataDimsAndDocs, offset, this.block, jOffset);
    }

    private final int compareDataDimsAndDoc(byte[] blockI, int offsetI, byte[] blockJ, int offsetJ) {
        return Arrays.INSTANCE.compareUnsigned(blockI, offsetI, offsetI + this.dataDimsAndDocLength, blockJ, offsetJ, offsetJ + this.dataDimsAndDocLength);
    }

    public final int computeCardinality(int from, int to, @NotNull int[] commonPrefixLengths) {
        Intrinsics.checkNotNullParameter((Object)commonPrefixLengths, (String)"commonPrefixLengths");
        int leafCardinality = 1;
        block0: for (int i = from + 1; i < to; ++i) {
            int pointOffset = (i - 1) * this.config.bytesPerDoc();
            int nextPointOffset = pointOffset + this.config.bytesPerDoc();
            int n = this.config.getNumDims();
            for (int dim = 0; dim < n; ++dim) {
                int end;
                int start = dim * this.config.getBytesPerDim() + commonPrefixLengths[dim];
                if (Arrays.INSTANCE.mismatch(this.block, nextPointOffset + start, nextPointOffset + (end = dim * this.config.getBytesPerDim() + this.config.getBytesPerDim()), this.block, pointOffset + start, pointOffset + end) == -1) continue;
                ++leafCardinality;
                continue block0;
            }
        }
        return leafCardinality;
    }

    @Override
    public long count() {
        return this.nextWrite;
    }

    @Override
    @NotNull
    public PointReader getReader(long start, long length) {
        if (!this.closed) {
            boolean $i$a$-require-HeapPointWriter$getReader$42 = false;
            String $i$a$-require-HeapPointWriter$getReader$42 = "point writer is still open and trying to get a reader";
            throw new IllegalArgumentException($i$a$-require-HeapPointWriter$getReader$42.toString());
        }
        if (!(start + length <= (long)this.size)) {
            boolean $i$a$-require-HeapPointWriter$getReader$52 = false;
            String $i$a$-require-HeapPointWriter$getReader$52 = "start=" + start + " length=" + length + " docIDs.length=" + this.size;
            throw new IllegalArgumentException($i$a$-require-HeapPointWriter$getReader$52.toString());
        }
        if (!(start + length <= (long)this.nextWrite)) {
            boolean bl = false;
            String string = "start=" + start + " length=" + length + " nextWrite=" + this.nextWrite;
            throw new IllegalArgumentException(string.toString());
        }
        return new HeapPointReader((Function1<? super Integer, ? extends PointValue>)((Function1)arg_0 -> HeapPointWriter.getReader$lambda$10(this, arg_0)), (int)start, Math.INSTANCE.toIntExact(start + length));
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public void destroy() {
    }

    @NotNull
    public String toString() {
        return "HeapPointWriter(count=" + this.nextWrite + " size=" + this.size + ")";
    }

    private static final PointValue getReader$lambda$10(HeapPointWriter this$0, int index) {
        return this$0.getPackedValueSlice(index);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fJ\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\tH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/util/bkd/HeapPointWriter$HeapPointValue;", "Lorg/gnit/lucenekmp/util/bkd/PointValue;", "config", "Lorg/gnit/lucenekmp/util/bkd/BKDConfig;", "value", "", "<init>", "(Lorg/gnit/lucenekmp/util/bkd/BKDConfig;[B)V", "packedValue", "Lorg/gnit/lucenekmp/util/BytesRef;", "packedValueDocID", "packedValueLength", "", "setOffset", "", "offset", "docID", "packedValueDocIDBytes", "core"})
    private static final class HeapPointValue
    implements PointValue {
        @NotNull
        private final BytesRef packedValue;
        @NotNull
        private final BytesRef packedValueDocID;
        private final int packedValueLength;

        public HeapPointValue(@NotNull BKDConfig config, @NotNull byte[] value) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.packedValueDocID = new BytesRef(value, 0, config.bytesPerDoc());
            this.packedValueLength = config.packedBytesLength();
            this.packedValue = new BytesRef(value, 0, this.packedValueLength);
        }

        public final void setOffset(int offset) {
            this.packedValue.setOffset(offset);
            this.packedValueDocID.setOffset(offset);
        }

        @Override
        @NotNull
        public BytesRef packedValue() {
            return this.packedValue;
        }

        @Override
        public int docID() {
            int position = this.packedValueDocID.getOffset() + this.packedValueLength;
            return BitUtil.VH_BE_INT.INSTANCE.get(this.packedValueDocID.getBytes(), position);
        }

        @Override
        @NotNull
        public BytesRef packedValueDocIDBytes() {
            return this.packedValueDocID;
        }
    }
}

