/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.fst;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.StringHelper;
import org.gnit.lucenekmp.util.fst.Outputs;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0016R\u0014\u0010\u0015\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lorg/gnit/lucenekmp/util/fst/ByteSequenceOutputs;", "Lorg/gnit/lucenekmp/util/fst/Outputs;", "Lorg/gnit/lucenekmp/util/BytesRef;", "<init>", "()V", "common", "output1", "output2", "subtract", "output", "inc", "add", "prefix", "write", "", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "read", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "skipOutput", "noOutput", "getNoOutput", "()Lorg/gnit/lucenekmp/util/BytesRef;", "outputToString", "", "ramBytesUsed", "", "toString", "Companion", "core"})
public final class ByteSequenceOutputs
extends Outputs<BytesRef> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final BytesRef NO_OUTPUT = new BytesRef();
    @NotNull
    private static final ByteSequenceOutputs singleton = new ByteSequenceOutputs();
    private static final long BASE_NUM_BYTES = RamUsageEstimator.Companion.shallowSizeOf(NO_OUTPUT);

    private ByteSequenceOutputs() {
    }

    @Override
    @NotNull
    public BytesRef common(@NotNull BytesRef output1, @NotNull BytesRef output2) {
        int mismatchPos;
        Intrinsics.checkNotNullParameter((Object)output1, (String)"output1");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output2");
        int n = mismatchPos = Arrays.INSTANCE.mismatch(output1.getBytes(), output1.getOffset(), output1.getOffset() + output1.getLength(), output2.getBytes(), output2.getOffset(), output2.getOffset() + output2.getLength());
        if (n == 0) {
            return NO_OUTPUT;
        }
        if (n == -1) {
            return output1;
        }
        if (n == output1.getLength()) {
            return output1;
        }
        if (n == output2.getLength()) {
            return output2;
        }
        return new BytesRef(output1.getBytes(), output1.getOffset(), mismatchPos);
    }

    @Override
    @NotNull
    public BytesRef subtract(@NotNull BytesRef output, @NotNull BytesRef inc) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)inc, (String)"inc");
        if (inc == NO_OUTPUT) {
            return output;
        }
        if (!StringHelper.INSTANCE.startsWith(output, inc)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (inc.getLength() == output.getLength()) {
            return NO_OUTPUT;
        }
        if (!(inc.getLength() < output.getLength())) {
            boolean bl = false;
            String string = "inc.length=" + inc.getLength() + " vs output.length=" + output.getLength();
            throw new IllegalArgumentException(string.toString());
        }
        if (!(inc.getLength() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new BytesRef(output.getBytes(), output.getOffset() + inc.getLength(), output.getLength() - inc.getLength());
    }

    @Override
    @NotNull
    public BytesRef add(@NotNull BytesRef prefix, @NotNull BytesRef output) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (prefix == NO_OUTPUT) {
            return output;
        }
        if (output == NO_OUTPUT) {
            return prefix;
        }
        if (!(prefix.getLength() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(output.getLength() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        BytesRef result = new BytesRef(prefix.getLength() + output.getLength());
        System.INSTANCE.arraycopy(prefix.getBytes(), prefix.getOffset(), result.getBytes(), 0, prefix.getLength());
        System.INSTANCE.arraycopy(output.getBytes(), output.getOffset(), result.getBytes(), prefix.getLength(), output.getLength());
        result.setLength(prefix.getLength() + output.getLength());
        return result;
    }

    @Override
    public void write(@NotNull BytesRef prefix, @NotNull DataOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeVInt(prefix.getLength());
        out.writeBytes(prefix.getBytes(), prefix.getOffset(), prefix.getLength());
    }

    @Override
    @NotNull
    public BytesRef read(@NotNull DataInput in) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        int len = in.readVInt();
        if (len == 0) {
            return NO_OUTPUT;
        }
        BytesRef output = new BytesRef(len);
        in.readBytes(output.getBytes(), 0, len);
        output.setLength(len);
        return output;
    }

    @Override
    public void skipOutput(@NotNull DataInput in) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        int len = in.readVInt();
        if (len != 0) {
            in.skipBytes(len);
        }
    }

    @Override
    @NotNull
    public BytesRef getNoOutput() {
        return NO_OUTPUT;
    }

    @Override
    @NotNull
    public String outputToString(@NotNull BytesRef output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return output.toString();
    }

    @Override
    public long ramBytesUsed(@NotNull BytesRef output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return BASE_NUM_BYTES + RamUsageEstimator.Companion.sizeOf(output.getBytes());
    }

    @NotNull
    public String toString() {
        return "ByteSequenceOutputs";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/fst/ByteSequenceOutputs$Companion;", "", "<init>", "()V", "NO_OUTPUT", "Lorg/gnit/lucenekmp/util/BytesRef;", "singleton", "Lorg/gnit/lucenekmp/util/fst/ByteSequenceOutputs;", "getSingleton", "()Lorg/gnit/lucenekmp/util/fst/ByteSequenceOutputs;", "BASE_NUM_BYTES", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ByteSequenceOutputs getSingleton() {
            return singleton;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

