/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.fst;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.CharsRef;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.fst.Outputs;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\b\u0010\u001c\u001a\u00020\u0019H\u0016R\u0014\u0010\u0015\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lorg/gnit/lucenekmp/util/fst/CharSequenceOutputs;", "Lorg/gnit/lucenekmp/util/fst/Outputs;", "Lorg/gnit/lucenekmp/util/CharsRef;", "<init>", "()V", "common", "output1", "output2", "subtract", "output", "inc", "add", "prefix", "write", "", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "read", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "skipOutput", "noOutput", "getNoOutput", "()Lorg/gnit/lucenekmp/util/CharsRef;", "outputToString", "", "ramBytesUsed", "", "toString", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nCharSequenceOutputs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharSequenceOutputs.kt\norg/gnit/lucenekmp/util/fst/CharSequenceOutputs\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class CharSequenceOutputs
extends Outputs<CharsRef> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final CharsRef NO_OUTPUT = new CharsRef(null, 0, 0, 7, null);
    @NotNull
    private static final CharSequenceOutputs singleton = new CharSequenceOutputs();
    private static final long BASE_NUM_BYTES = RamUsageEstimator.Companion.shallowSizeOf(NO_OUTPUT);

    private CharSequenceOutputs() {
    }

    @Override
    @NotNull
    public CharsRef common(@NotNull CharsRef output1, @NotNull CharsRef output2) {
        int mismatchPos;
        Intrinsics.checkNotNullParameter((Object)output1, (String)"output1");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output2");
        int n = mismatchPos = Arrays.INSTANCE.mismatch(output1.getChars(), output1.getOffset(), output1.getOffset() + output1.length(), output2.getChars(), output2.getOffset(), output2.getOffset() + output2.length());
        return n == 0 ? NO_OUTPUT : (n == -1 ? output1 : (n == output1.length() ? output1 : (n == output2.length() ? output2 : new CharsRef(output1.getChars(), output1.getOffset(), mismatchPos))));
    }

    @Override
    @NotNull
    public CharsRef subtract(@NotNull CharsRef output, @NotNull CharsRef inc) {
        CharsRef charsRef;
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)inc, (String)"inc");
        if (inc == NO_OUTPUT) {
            charsRef = output;
        } else if (inc.length() == output.length()) {
            charsRef = NO_OUTPUT;
        } else {
            if (!(inc.length() < output.length())) {
                boolean bl = false;
                String string = "inc.length=" + inc.length() + " vs output.length=" + output.length();
                throw new IllegalArgumentException(string.toString());
            }
            if (!(inc.length() > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            charsRef = new CharsRef(output.getChars(), output.getOffset() + inc.length(), output.length() - inc.length());
        }
        return charsRef;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CharsRef add(@NotNull CharsRef prefix, @NotNull CharsRef output) {
        CharsRef charsRef;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (prefix == NO_OUTPUT) {
            charsRef = output;
        } else if (output == NO_OUTPUT) {
            charsRef = prefix;
        } else {
            void var3_5;
            if (!(prefix.length() > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(output.length() > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            CharsRef result = new CharsRef(prefix.length() + output.length());
            System.INSTANCE.arraycopy(prefix.getChars(), prefix.getOffset(), result.getChars(), 0, prefix.length());
            System.INSTANCE.arraycopy(output.getChars(), output.getOffset(), result.getChars(), prefix.length(), output.length());
            result.setLength(prefix.length() + output.length());
            charsRef = var3_5;
        }
        return charsRef;
    }

    @Override
    public void write(@NotNull CharsRef prefix, @NotNull DataOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeVInt(prefix.length());
        int n = prefix.length();
        for (int i = 0; i < n; ++i) {
            out.writeVInt(prefix.getChars()[prefix.getOffset() + i]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CharsRef read(@NotNull DataInput in) throws IOException {
        CharsRef charsRef;
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        int len = in.readVInt();
        if (len == 0) {
            charsRef = NO_OUTPUT;
        } else {
            void var3_3;
            CharsRef output = new CharsRef(len);
            for (int i = 0; i < len; ++i) {
                output.getChars()[i] = (char)in.readVInt();
            }
            output.setLength(len);
            charsRef = var3_3;
        }
        return charsRef;
    }

    @Override
    public void skipOutput(@NotNull DataInput in) throws IOException {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        int len = in.readVInt();
        for (int i = 0; i < len; ++i) {
            in.readVInt();
        }
    }

    @Override
    @NotNull
    public CharsRef getNoOutput() {
        return NO_OUTPUT;
    }

    @Override
    @NotNull
    public String outputToString(@NotNull CharsRef output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return output.toString();
    }

    @Override
    public long ramBytesUsed(@NotNull CharsRef output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return BASE_NUM_BYTES + RamUsageEstimator.Companion.sizeOf(output.getChars());
    }

    @NotNull
    public String toString() {
        return "CharSequenceOutputs";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/fst/CharSequenceOutputs$Companion;", "", "<init>", "()V", "NO_OUTPUT", "Lorg/gnit/lucenekmp/util/CharsRef;", "singleton", "Lorg/gnit/lucenekmp/util/fst/CharSequenceOutputs;", "getSingleton", "()Lorg/gnit/lucenekmp/util/fst/CharSequenceOutputs;", "BASE_NUM_BYTES", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CharSequenceOutputs getSingleton() {
            return singleton;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

