/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.fst;

import java.io.IOException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.ByteArrayDataOutput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.IntsRefBuilder;
import org.gnit.lucenekmp.util.fst.FST;
import org.gnit.lucenekmp.util.fst.FSTReader;
import org.gnit.lucenekmp.util.fst.FSTSuffixNodeCache;
import org.gnit.lucenekmp.util.fst.GrowableByteArrayDataOutput;
import org.gnit.lucenekmp.util.fst.Outputs;
import org.gnit.lucenekmp.util.fst.ReadWriteDataOutput;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u0089\u0001*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0010\u0082\u0001\u0083\u0001\u0084\u0001\u0085\u0001\u0086\u0001\u0087\u0001\u0088\u0001\u0089\u0001BG\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0006\u0010T\u001a\u00020UJ\r\u0010?\u001a\u00020)H\u0007\u00a2\u0006\u0002\bVJ\u0016\u0010W\u001a\u00020X2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0002J\u0014\u0010Z\u001a\u00020)2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00028\u00000&J\b\u0010[\u001a\u00020\\H\u0002J\u0018\u0010]\u001a\u00020\\2\u0006\u0010^\u001a\u00020\f2\u0006\u0010_\u001a\u00020\u0010H\u0002J\u0016\u0010`\u001a\u00020\n2\f\u0010a\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0002J.\u0010b\u001a\u00020\n2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00028\u00000&2\u0006\u0010.\u001a\u00020\u00102\u0006\u0010c\u001a\u00020\u00102\u0006\u0010d\u001a\u00020\u0010H\u0002J\u001e\u0010e\u001a\u00020\\2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00028\u00000&2\u0006\u0010f\u001a\u00020\u0010H\u0002J\b\u0010g\u001a\u00020\\H\u0002J(\u0010h\u001a\u00020\\2\u0006\u0010i\u001a\u00020\u00102\u0006\u0010j\u001a\u00020k2\u0006\u0010l\u001a\u00020\u00102\u0006\u0010m\u001a\u00020\u0010H\u0002J.\u0010n\u001a\u00020\\2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00028\u00000&2\u0006\u0010c\u001a\u00020\u00102\u0006\u0010d\u001a\u00020\u00102\u0006\u0010o\u001a\u00020\nH\u0002J\u0016\u0010p\u001a\u00020\\2\f\u0010Y\u001a\b\u0012\u0004\u0012\u00028\u00000&H\u0002J\u0010\u0010q\u001a\u00020\\2\u0006\u0010r\u001a\u00020\u0010H\u0002J\u001b\u0010s\u001a\u00020\\2\u0006\u0010t\u001a\u00020u2\u0006\u0010v\u001a\u00028\u0000\u00a2\u0006\u0002\u0010wJ\u0013\u0010x\u001a\u00020\\2\u0006\u0010_\u001a\u00028\u0000\u00a2\u0006\u0002\u0010yJ\u000e\u0010z\u001a\u00020\\2\u0006\u0010{\u001a\u00020)J\u0015\u0010|\u001a\u00020\n2\u0006\u0010v\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010}J\u000e\u0010~\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u007fJ\u0007\u0010\u0080\u0001\u001a\u00020)J\u0007\u0010\u0081\u0001\u001a\u00020)R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0016\u0010\u0019\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00000\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0010\u0010\u001f\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010$\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000&0%X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010'R\u001a\u0010(\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R\u001a\u00104\u001a\u00020/X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00101\"\u0004\b6\u00103R\u0011\u00107\u001a\u000208\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u001a\u0010;\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010+\"\u0004\b=\u0010-R\u001a\u0010>\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010+\"\u0004\b@\u0010-R\u001a\u0010A\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010+\"\u0004\bC\u0010-R\u001a\u0010D\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010+\"\u0004\bF\u0010-R\u001a\u0010G\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bH\u0010+\"\u0004\bI\u0010-R\u001a\u0010J\u001a\u00020)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bK\u0010+\"\u0004\bL\u0010-R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010NR\u0011\u0010O\u001a\u00020P\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010RR\u000e\u0010S\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u008a\u0001"}, d2={"Lorg/gnit/lucenekmp/util/fst/FSTCompiler;", "T", "", "inputType", "Lorg/gnit/lucenekmp/util/fst/FST$INPUT_TYPE;", "suffixRAMLimitMB", "", "outputs", "Lorg/gnit/lucenekmp/util/fst/Outputs;", "allowFixedLengthArcs", "", "dataOutput", "Lorg/gnit/lucenekmp/store/DataOutput;", "directAddressingMaxOversizingFactor", "", "version", "", "<init>", "(Lorg/gnit/lucenekmp/util/fst/FST$INPUT_TYPE;DLorg/gnit/lucenekmp/util/fst/Outputs;ZLorg/gnit/lucenekmp/store/DataOutput;FI)V", "getAllowFixedLengthArcs", "()Z", "getDirectAddressingMaxOversizingFactor", "()F", "getVersion", "()I", "suffixDedupCache", "Lorg/gnit/lucenekmp/util/fst/FSTSuffixNodeCache;", "fst", "Lorg/gnit/lucenekmp/util/fst/FST;", "getFst", "()Lorg/gnit/lucenekmp/util/fst/FST;", "NO_OUTPUT", "Ljava/lang/Object;", "lastInput", "Lorg/gnit/lucenekmp/util/IntsRefBuilder;", "paddingBytePending", "frontier", "", "Lorg/gnit/lucenekmp/util/fst/FSTCompiler$UnCompiledNode;", "[Lorg/gnit/lucenekmp/util/fst/FSTCompiler$UnCompiledNode;", "lastFrozenNode", "", "getLastFrozenNode", "()J", "setLastFrozenNode", "(J)V", "numBytesPerArc", "", "getNumBytesPerArc", "()[I", "setNumBytesPerArc", "([I)V", "numLabelBytesPerArc", "getNumLabelBytesPerArc", "setNumLabelBytesPerArc", "fixedLengthArcsBuffer", "Lorg/gnit/lucenekmp/util/fst/FSTCompiler$FixedLengthArcsBuffer;", "getFixedLengthArcsBuffer", "()Lorg/gnit/lucenekmp/util/fst/FSTCompiler$FixedLengthArcsBuffer;", "arcCount", "getArcCount", "setArcCount", "nodeCount", "getNodeCount", "setNodeCount", "binarySearchNodeCount", "getBinarySearchNodeCount", "setBinarySearchNodeCount", "directAddressingNodeCount", "getDirectAddressingNodeCount", "setDirectAddressingNodeCount", "continuousNodeCount", "getContinuousNodeCount", "setContinuousNodeCount", "directAddressingExpansionCredit", "getDirectAddressingExpansionCredit", "setDirectAddressingExpansionCredit", "getDataOutput", "()Lorg/gnit/lucenekmp/store/DataOutput;", "scratchBytes", "Lorg/gnit/lucenekmp/util/fst/GrowableByteArrayDataOutput;", "getScratchBytes", "()Lorg/gnit/lucenekmp/util/fst/GrowableByteArrayDataOutput;", "numBytesWritten", "getFSTReader", "Lorg/gnit/lucenekmp/util/fst/FSTReader;", "getNodeCountKt", "compileNode", "Lorg/gnit/lucenekmp/util/fst/FSTCompiler$CompiledNode;", "nodeIn", "addNode", "writePaddingByte", "", "writeLabel", "out", "v", "shouldExpandNodeWithFixedLengthArcs", "node", "shouldExpandNodeWithDirectAddressing", "maxBytesPerArcWithoutLabel", "labelRange", "writeNodeForBinarySearch", "maxBytesPerArc", "reverseScratchBytes", "writeScratchBytes", "destPos", "bytes", "", "offset", "length", "writeNodeForDirectAddressingOrContinuous", "continuous", "writePresenceBits", "freezeTail", "prefixLenPlus1", "add", "input", "Lorg/gnit/lucenekmp/util/IntsRef;", "output", "(Lorg/gnit/lucenekmp/util/IntsRef;Ljava/lang/Object;)V", "setEmptyOutput", "(Ljava/lang/Object;)V", "finish", "newStartNode", "validOutput", "(Ljava/lang/Object;)Z", "compile", "Lorg/gnit/lucenekmp/util/fst/FST$FSTMetadata;", "fstRamBytesUsed", "fstSizeInBytes", "NullFSTReader", "Builder", "Arc", "Node", "CompiledNode", "UnCompiledNode", "FixedLengthArcsBuffer", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nFSTCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FSTCompiler.kt\norg/gnit/lucenekmp/util/fst/FSTCompiler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArrayUtil.kt\norg/gnit/lucenekmp/util/ArrayUtil$Companion\n*L\n1#1,1198:1\n1#2:1199\n207#3,5:1200\n180#3,5:1205\n212#3:1210\n*S KotlinDebug\n*F\n+ 1 FSTCompiler.kt\norg/gnit/lucenekmp/util/fst/FSTCompiler\n*L\n831#1:1200,5\n831#1:1205,5\n831#1:1210\n*E\n"})
public final class FSTCompiler<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean allowFixedLengthArcs;
    private final float directAddressingMaxOversizingFactor;
    private final int version;
    @Nullable
    private final FSTSuffixNodeCache<T> suffixDedupCache;
    @NotNull
    private final FST<T> fst;
    private final T NO_OUTPUT;
    @NotNull
    private final IntsRefBuilder lastInput;
    private boolean paddingBytePending;
    @NotNull
    private UnCompiledNode<T>[] frontier;
    private long lastFrozenNode;
    @NotNull
    private int[] numBytesPerArc;
    @NotNull
    private int[] numLabelBytesPerArc;
    @NotNull
    private final FixedLengthArcsBuffer fixedLengthArcsBuffer;
    private long arcCount;
    private long nodeCount;
    private long binarySearchNodeCount;
    private long directAddressingNodeCount;
    private long continuousNodeCount;
    private long directAddressingExpansionCredit;
    @NotNull
    private final DataOutput dataOutput;
    @NotNull
    private final GrowableByteArrayDataOutput scratchBytes;
    private long numBytesWritten;
    public static final float DIRECT_ADDRESSING_MAX_OVERSIZING_FACTOR = 1.0f;
    public static final int FIXED_LENGTH_ARC_SHALLOW_DEPTH = 3;
    public static final int FIXED_LENGTH_ARC_SHALLOW_NUM_ARCS = 5;
    public static final int FIXED_LENGTH_ARC_DEEP_NUM_ARCS = 10;
    private static final float DIRECT_ADDRESSING_MAX_OVERSIZE_WITH_CREDIT_FACTOR = 1.66f;
    @NotNull
    private static final FSTReader NULL_FST_READER = new NullFSTReader();

    private FSTCompiler(FST.INPUT_TYPE inputType, double suffixRAMLimitMB, Outputs<T> outputs, boolean allowFixedLengthArcs, DataOutput dataOutput, float directAddressingMaxOversizingFactor, int version) {
        this.allowFixedLengthArcs = allowFixedLengthArcs;
        this.directAddressingMaxOversizingFactor = directAddressingMaxOversizingFactor;
        this.version = version;
        this.lastInput = new IntsRefBuilder();
        this.numBytesPerArc = new int[4];
        this.numLabelBytesPerArc = new int[this.numBytesPerArc.length];
        this.fixedLengthArcsBuffer = new FixedLengthArcsBuffer();
        this.scratchBytes = new GrowableByteArrayDataOutput();
        long l = this.numBytesWritten;
        this.numBytesWritten = l + 1L;
        this.paddingBytePending = true;
        this.dataOutput = dataOutput;
        this.fst = new FST<Object>(new FST.FSTMetadata<Object>(inputType, outputs, null, -1L, this.version, 0L), NULL_FST_READER);
        if (!(!(suffixRAMLimitMB < 0.0))) {
            boolean $i$a$-require-FSTCompiler$22 = false;
            String $i$a$-require-FSTCompiler$22 = "ramLimitMB must be >= 0; got: " + suffixRAMLimitMB;
            throw new IllegalArgumentException($i$a$-require-FSTCompiler$22.toString());
        }
        this.suffixDedupCache = suffixRAMLimitMB > 0.0 ? new FSTSuffixNodeCache(this, suffixRAMLimitMB) : null;
        this.NO_OUTPUT = outputs.getNoOutput();
        UnCompiledNode[] f = new UnCompiledNode[10];
        this.frontier = f;
        int n = this.frontier.length;
        for (int idx = 0; idx < n; ++idx) {
            this.frontier[idx] = new UnCompiledNode(this, idx);
        }
    }

    public final boolean getAllowFixedLengthArcs() {
        return this.allowFixedLengthArcs;
    }

    public final float getDirectAddressingMaxOversizingFactor() {
        return this.directAddressingMaxOversizingFactor;
    }

    public final int getVersion() {
        return this.version;
    }

    @NotNull
    public final FST<T> getFst() {
        return this.fst;
    }

    public final long getLastFrozenNode() {
        return this.lastFrozenNode;
    }

    public final void setLastFrozenNode(long l) {
        this.lastFrozenNode = l;
    }

    @NotNull
    public final int[] getNumBytesPerArc() {
        return this.numBytesPerArc;
    }

    public final void setNumBytesPerArc(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.numBytesPerArc = nArray;
    }

    @NotNull
    public final int[] getNumLabelBytesPerArc() {
        return this.numLabelBytesPerArc;
    }

    public final void setNumLabelBytesPerArc(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.numLabelBytesPerArc = nArray;
    }

    @NotNull
    public final FixedLengthArcsBuffer getFixedLengthArcsBuffer() {
        return this.fixedLengthArcsBuffer;
    }

    public final long getArcCount() {
        return this.arcCount;
    }

    public final void setArcCount(long l) {
        this.arcCount = l;
    }

    public final long getNodeCount() {
        return this.nodeCount;
    }

    public final void setNodeCount(long l) {
        this.nodeCount = l;
    }

    public final long getBinarySearchNodeCount() {
        return this.binarySearchNodeCount;
    }

    public final void setBinarySearchNodeCount(long l) {
        this.binarySearchNodeCount = l;
    }

    public final long getDirectAddressingNodeCount() {
        return this.directAddressingNodeCount;
    }

    public final void setDirectAddressingNodeCount(long l) {
        this.directAddressingNodeCount = l;
    }

    public final long getContinuousNodeCount() {
        return this.continuousNodeCount;
    }

    public final void setContinuousNodeCount(long l) {
        this.continuousNodeCount = l;
    }

    public final long getDirectAddressingExpansionCredit() {
        return this.directAddressingExpansionCredit;
    }

    public final void setDirectAddressingExpansionCredit(long l) {
        this.directAddressingExpansionCredit = l;
    }

    @NotNull
    public final DataOutput getDataOutput() {
        return this.dataOutput;
    }

    @NotNull
    public final GrowableByteArrayDataOutput getScratchBytes() {
        return this.scratchBytes;
    }

    @NotNull
    public final FSTReader getFSTReader() {
        if (this.dataOutput instanceof FSTReader) {
            DataOutput dataOutput = this.dataOutput;
            Intrinsics.checkNotNull((Object)dataOutput, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.fst.FSTReader");
            return (FSTReader)((Object)dataOutput);
        }
        throw new IllegalStateException("The DataOutput must implement FSTReader, but got " + this.dataOutput);
    }

    @JvmName(name="getNodeCountKt")
    public final long getNodeCountKt() {
        return 1L + this.nodeCount;
    }

    private final CompiledNode compileNode(UnCompiledNode<T> nodeIn) throws IOException {
        long node = 0L;
        long bytesPosStart = this.numBytesWritten;
        if (this.suffixDedupCache != null) {
            if (nodeIn.getNumArcs() == 0) {
                this.lastFrozenNode = node = this.addNode(nodeIn);
            } else {
                node = this.suffixDedupCache.add(nodeIn);
            }
        } else {
            node = this.addNode(nodeIn);
        }
        if (!(node != -2L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long bytesPosEnd = this.numBytesWritten;
        if (bytesPosEnd != bytesPosStart) {
            if (!(bytesPosEnd > bytesPosStart)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.lastFrozenNode = node;
        }
        nodeIn.clear();
        CompiledNode fn = new CompiledNode();
        fn.setNode(node);
        return fn;
    }

    public final long addNode(@NotNull UnCompiledNode<T> nodeIn) throws IOException {
        Intrinsics.checkNotNullParameter(nodeIn, (String)"nodeIn");
        if (nodeIn.getNumArcs() == 0) {
            return nodeIn.isFinal() ? -1L : 0L;
        }
        this.scratchBytes.setPosition(0);
        boolean doFixedLengthArcs = this.shouldExpandNodeWithFixedLengthArcs(nodeIn);
        if (doFixedLengthArcs && this.numBytesPerArc.length < nodeIn.getNumArcs()) {
            this.numBytesPerArc = new int[ArrayUtil.Companion.oversize(nodeIn.getNumArcs(), 4)];
            this.numLabelBytesPerArc = new int[this.numBytesPerArc.length];
        }
        this.arcCount += (long)nodeIn.getNumArcs();
        int lastArc = nodeIn.getNumArcs() - 1;
        long lastArcStart = 0L;
        int maxBytesPerArc = 0;
        int maxBytesPerArcWithoutLabel = 0;
        int n = nodeIn.getNumArcs();
        for (int arcIdx = 0; arcIdx < n; ++arcIdx) {
            int numArcBytes;
            boolean targetHasArcs;
            Arc<T> arc = nodeIn.getArcs()[arcIdx];
            Node node = arc.getTarget();
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.fst.FSTCompiler.CompiledNode");
            CompiledNode target = (CompiledNode)node;
            int flags = 0;
            if (arcIdx == lastArc) {
                flags += 2;
            }
            if (this.lastFrozenNode == target.getNode() && !doFixedLengthArcs) {
                flags += 4;
            }
            if (arc.isFinal()) {
                ++flags;
                if (arc.getNextFinalOutput() != this.NO_OUTPUT) {
                    flags += 32;
                }
            } else if (!(arc.getNextFinalOutput() == this.NO_OUTPUT)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            boolean bl = targetHasArcs = target.getNode() > 0L;
            if (!targetHasArcs) {
                flags += 8;
            }
            if (arc.getOutput() != this.NO_OUTPUT) {
                flags += 16;
            }
            this.scratchBytes.writeByte((byte)flags);
            long labelStart = this.scratchBytes.getPosition();
            this.writeLabel(this.scratchBytes, arc.getLabel());
            int numLabelBytes = (int)((long)this.scratchBytes.getPosition() - labelStart);
            if (arc.getOutput() != this.NO_OUTPUT) {
                Outputs<T> outputs = this.fst.getOutputs();
                T t = arc.getOutput();
                Intrinsics.checkNotNull(t);
                outputs.write(t, this.scratchBytes);
            }
            if (arc.getNextFinalOutput() != this.NO_OUTPUT) {
                Outputs<T> outputs = this.fst.getOutputs();
                T t = arc.getNextFinalOutput();
                Intrinsics.checkNotNull(t);
                outputs.writeFinalOutput(t, this.scratchBytes);
            }
            if (targetHasArcs && (flags & 4) == 0) {
                if (!(target.getNode() > 0L)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                this.scratchBytes.writeVLong(target.getNode());
            }
            if (!doFixedLengthArcs) continue;
            this.numBytesPerArc[arcIdx] = numArcBytes = (int)((long)this.scratchBytes.getPosition() - lastArcStart);
            this.numLabelBytesPerArc[arcIdx] = numLabelBytes;
            lastArcStart = this.scratchBytes.getPosition();
            maxBytesPerArc = Math.max(maxBytesPerArc, numArcBytes);
            maxBytesPerArcWithoutLabel = Math.max(maxBytesPerArcWithoutLabel, numArcBytes - numLabelBytes);
        }
        if (doFixedLengthArcs) {
            boolean continuousLabel;
            if (!(maxBytesPerArc > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int labelRange = nodeIn.getArcs()[nodeIn.getNumArcs() - 1].getLabel() - nodeIn.getArcs()[0].getLabel() + 1;
            if (!(labelRange > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            boolean bl = continuousLabel = labelRange == nodeIn.getNumArcs();
            if (continuousLabel && this.version >= 9) {
                this.writeNodeForDirectAddressingOrContinuous(nodeIn, maxBytesPerArcWithoutLabel, labelRange, true);
                long l = this.continuousNodeCount;
                this.continuousNodeCount = l + 1L;
                v7 = l;
            } else if (this.shouldExpandNodeWithDirectAddressing(nodeIn, maxBytesPerArc, maxBytesPerArcWithoutLabel, labelRange)) {
                this.writeNodeForDirectAddressingOrContinuous(nodeIn, maxBytesPerArcWithoutLabel, labelRange, false);
                long l = this.directAddressingNodeCount;
                this.directAddressingNodeCount = l + 1L;
                v7 = l;
            } else {
                this.writeNodeForBinarySearch(nodeIn, maxBytesPerArc);
                long l = this.binarySearchNodeCount;
                this.binarySearchNodeCount = l + 1L;
                v7 = l;
            }
        }
        this.reverseScratchBytes();
        if (this.paddingBytePending) {
            this.writePaddingByte();
        }
        this.scratchBytes.writeTo(this.dataOutput);
        this.numBytesWritten += (long)this.scratchBytes.getPosition();
        long l = this.nodeCount;
        this.nodeCount = l + 1L;
        return this.numBytesWritten - 1L;
    }

    private final void writePaddingByte() throws IOException {
        if (!this.paddingBytePending) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.dataOutput.writeByte((byte)0);
        this.paddingBytePending = false;
    }

    private final void writeLabel(DataOutput out, int v) throws IOException {
        if (!(v >= 0)) {
            boolean $i$a$-require-FSTCompiler$writeLabel$42 = false;
            String $i$a$-require-FSTCompiler$writeLabel$42 = "v=" + v;
            throw new IllegalArgumentException($i$a$-require-FSTCompiler$writeLabel$42.toString());
        }
        if (this.fst.getMetadata().getInputType() == FST.INPUT_TYPE.BYTE1) {
            if (!(v <= 255)) {
                boolean $i$a$-require-FSTCompiler$writeLabel$52 = false;
                String $i$a$-require-FSTCompiler$writeLabel$52 = "v=" + v;
                throw new IllegalArgumentException($i$a$-require-FSTCompiler$writeLabel$52.toString());
            }
            out.writeByte((byte)v);
        } else if (this.fst.getMetadata().getInputType() == FST.INPUT_TYPE.BYTE2) {
            if (!(v <= 65535)) {
                boolean bl = false;
                String string = "v=" + v;
                throw new IllegalArgumentException(string.toString());
            }
            out.writeShort((short)v);
        } else {
            out.writeVInt(v);
        }
    }

    private final boolean shouldExpandNodeWithFixedLengthArcs(UnCompiledNode<T> node) {
        return this.allowFixedLengthArcs && (node.getDepth() <= 3 && node.getNumArcs() >= 5 || node.getNumArcs() >= 10);
    }

    private final boolean shouldExpandNodeWithDirectAddressing(UnCompiledNode<T> nodeIn, int numBytesPerArc, int maxBytesPerArcWithoutLabel, int labelRange) {
        int allowedOversize;
        int sizeForBinarySearch = numBytesPerArc * nodeIn.getNumArcs();
        int sizeForDirectAddressing = FST.Companion.getNumPresenceBytes(labelRange) + this.numLabelBytesPerArc[0] + maxBytesPerArcWithoutLabel * nodeIn.getNumArcs();
        int expansionCost = sizeForDirectAddressing - (allowedOversize = (int)((float)sizeForBinarySearch * this.directAddressingMaxOversizingFactor));
        if (expansionCost <= 0 || this.directAddressingExpansionCredit >= (long)expansionCost && (float)sizeForDirectAddressing <= (float)allowedOversize * 1.66f) {
            this.directAddressingExpansionCredit -= (long)expansionCost;
            return true;
        }
        return false;
    }

    private final void writeNodeForBinarySearch(UnCompiledNode<T> nodeIn, int maxBytesPerArc) {
        this.fixedLengthArcsBuffer.resetPosition().writeByte((byte)32).writeVInt(nodeIn.getNumArcs()).writeVInt(maxBytesPerArc);
        int headerLen = this.fixedLengthArcsBuffer.getPosition();
        int srcPos = 0;
        srcPos = this.scratchBytes.getPosition();
        int destPos = 0;
        destPos = headerLen + nodeIn.getNumArcs() * maxBytesPerArc;
        if (!(destPos >= srcPos)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (destPos > srcPos) {
            this.scratchBytes.setPosition(destPos);
            for (int arcIdx = nodeIn.getNumArcs() - 1; -1 < arcIdx; --arcIdx) {
                int arcLen = this.numBytesPerArc[arcIdx];
                if ((srcPos -= arcLen) == (destPos -= maxBytesPerArc)) continue;
                if (!(destPos > srcPos)) {
                    boolean bl = false;
                    String string = "destPos=" + destPos + " srcPos=" + srcPos + " arcIdx=" + arcIdx + " maxBytesPerArc=" + maxBytesPerArc + " arcLen=" + arcLen + " nodeIn.numArcs=" + nodeIn.getNumArcs();
                    throw new IllegalArgumentException(string.toString());
                }
                this.writeScratchBytes(destPos, this.scratchBytes.getBytes(), srcPos, arcLen);
            }
        }
        this.writeScratchBytes(0, this.fixedLengthArcsBuffer.getBytes(), 0, headerLen);
    }

    private final void reverseScratchBytes() {
        int pos = this.scratchBytes.getPosition();
        byte[] bytes = this.scratchBytes.getBytes();
        int limit = pos / 2;
        for (int i = 0; i < limit; ++i) {
            byte b = bytes[i];
            bytes[i] = bytes[pos - 1 - i];
            bytes[pos - 1 - i] = b;
        }
    }

    private final void writeScratchBytes(int destPos, byte[] bytes, int offset, int length) {
        if (!(destPos + length <= this.scratchBytes.getPosition())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        System.INSTANCE.arraycopy(bytes, offset, this.scratchBytes.getBytes(), destPos, length);
    }

    private final void writeNodeForDirectAddressingOrContinuous(UnCompiledNode<T> nodeIn, int maxBytesPerArcWithoutLabel, int labelRange, boolean continuous) {
        int headerMaxLen = 11;
        int numPresenceBytes = continuous ? 0 : FST.Companion.getNumPresenceBytes(labelRange);
        int srcPos = this.scratchBytes.getPosition();
        int totalArcBytes = this.numLabelBytesPerArc[0] + nodeIn.getNumArcs() * maxBytesPerArcWithoutLabel;
        int bufferOffset = headerMaxLen + numPresenceBytes + totalArcBytes;
        byte[] buffer = this.fixedLengthArcsBuffer.ensureCapacity(bufferOffset).getBytes();
        for (int arcIdx = nodeIn.getNumArcs() - 1; -1 < arcIdx; --arcIdx) {
            int srcArcLen = this.numBytesPerArc[arcIdx];
            int labelLen = this.numLabelBytesPerArc[arcIdx];
            this.scratchBytes.writeTo(srcPos -= srcArcLen, buffer, bufferOffset -= maxBytesPerArcWithoutLabel, 1);
            int remainingArcLen = srcArcLen - 1 - labelLen;
            if (remainingArcLen != 0) {
                this.scratchBytes.writeTo(srcPos + 1 + labelLen, buffer, bufferOffset + 1, remainingArcLen);
            }
            if (arcIdx != 0) continue;
            this.scratchBytes.writeTo(srcPos + 1, buffer, bufferOffset -= labelLen, labelLen);
        }
        if (!(bufferOffset == headerMaxLen + numPresenceBytes)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.fixedLengthArcsBuffer.resetPosition().writeByte(continuous ? (byte)96 : 64).writeVInt(labelRange).writeVInt(maxBytesPerArcWithoutLabel);
        int headerLen = this.fixedLengthArcsBuffer.getPosition();
        this.scratchBytes.setPosition(0);
        this.scratchBytes.writeBytes(this.fixedLengthArcsBuffer.getBytes(), 0, headerLen);
        if (!continuous) {
            this.writePresenceBits(nodeIn);
            if (!(this.scratchBytes.getPosition() == headerLen + numPresenceBytes)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
        }
        this.scratchBytes.writeBytes(this.fixedLengthArcsBuffer.getBytes(), bufferOffset, totalArcBytes);
        if (!(this.scratchBytes.getPosition() == headerLen + numPresenceBytes + totalArcBytes)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final void writePresenceBits(UnCompiledNode<T> nodeIn) {
        byte presenceBits = 1;
        int presenceIndex = 0;
        int previousLabel = nodeIn.getArcs()[0].getLabel();
        int n = nodeIn.getNumArcs();
        for (int arcIdx = 1; arcIdx < n; ++arcIdx) {
            int label = nodeIn.getArcs()[arcIdx].getLabel();
            if (!(label > previousLabel)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            presenceIndex += label - previousLabel;
            while (presenceIndex >= 8) {
                this.scratchBytes.writeByte(presenceBits);
                presenceBits = 0;
                presenceIndex -= 8;
            }
            presenceBits = (byte)(presenceBits | (byte)(1 << presenceIndex));
            previousLabel = label;
        }
        if (!(presenceIndex == (nodeIn.getArcs()[nodeIn.getNumArcs() - 1].getLabel() - nodeIn.getArcs()[0].getLabel()) % 8)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(presenceBits != 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!((presenceBits & 1 << presenceIndex) != 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.scratchBytes.writeByte(presenceBits);
    }

    private final void freezeTail(int prefixLenPlus1) throws IOException {
        int idx;
        int downTo = Math.max(1, prefixLenPlus1);
        if (downTo <= (idx = this.lastInput.length())) {
            while (true) {
                UnCompiledNode<T> node = this.frontier[idx];
                int prevIdx = idx - 1;
                UnCompiledNode<T> parent = this.frontier[prevIdx];
                T nextFinalOutput = node.getOutput();
                boolean isFinal = node.isFinal() || node.getNumArcs() == 0;
                parent.replaceLast(this.lastInput.intAt(prevIdx), this.compileNode(node), nextFinalOutput, isFinal);
                if (idx == downTo) break;
                --idx;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void add(@NotNull IntsRef input, T output) throws IOException {
        int idx;
        String string;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        T output2 = output;
        if (Intrinsics.areEqual(output2, this.NO_OUTPUT)) {
            output2 = this.NO_OUTPUT;
        }
        if (!(this.lastInput.length() == 0 || input.compareTo(this.lastInput.get()) >= 0)) {
            boolean $i$a$-require-FSTCompiler$add$22 = false;
            String $i$a$-require-FSTCompiler$add$22 = "inputs are added out of order lastInput=" + this.lastInput.get() + " vs input=" + input;
            throw new IllegalArgumentException($i$a$-require-FSTCompiler$add$22.toString());
        }
        if (!this.validOutput(output2)) {
            String $i$a$-require-FSTCompiler$add$22 = "Failed requirement.";
            throw new IllegalArgumentException($i$a$-require-FSTCompiler$add$22.toString());
        }
        if (input.getLength() == 0) {
            this.frontier[0].setFinal(true);
            this.setEmptyOutput(output2);
            return;
        }
        int pos = 0;
        if (this.lastInput.length() > 0) {
            int mismatch = Arrays.INSTANCE.mismatch(this.lastInput.ints(), 0, this.lastInput.length(), input.getInts(), input.getOffset(), input.getLength());
            pos += mismatch == -1 ? this.lastInput.length() : mismatch;
        }
        int prefixLenPlus1 = pos + 1;
        if (this.frontier.length < input.getLength() + 1) {
            UnCompiledNode[] unCompiledNodeArray;
            void array$iv2;
            ArrayUtil.Companion companion = ArrayUtil.Companion;
            UnCompiledNode<T>[] unCompiledNodeArray2 = this.frontier;
            int minSize$iv = input.getLength() + 1;
            boolean $i$f$grow = false;
            if (minSize$iv < 0) {
                throw new Exception("size must be positive (got " + minSize$iv + "): likely integer overflow?");
            }
            if (((void)array$iv2).length < minSize$iv) {
                UnCompiledNode[] newArray$iv$iv;
                void array$iv$iv;
                void this_$iv;
                int newLength$iv = this_$iv.oversize(minSize$iv, 4);
                void var12_20 = this_$iv;
                string = array$iv2;
                int newLength$iv$iv = newLength$iv;
                boolean $i$f$growExact = false;
                if (newLength$iv$iv < ((void)array$iv$iv).length) {
                    throw new IndexOutOfBoundsException("newLength (" + newLength$iv$iv + ") < array.size (" + ((void)array$iv$iv).length + ")");
                }
                UnCompiledNode[] unCompiledNodeArray3 = new UnCompiledNode[newLength$iv$iv];
                for (int i = 0; i < newLength$iv$iv; ++i) {
                    int n = i;
                    unCompiledNodeArray3[n] = n < ((void)array$iv$iv).length ? array$iv$iv[n] : null;
                }
                unCompiledNodeArray = newArray$iv$iv = unCompiledNodeArray3;
            } else {
                unCompiledNodeArray = array$iv2;
            }
            void next = unCompiledNodeArray;
            int array$iv2 = ((void)next).length;
            for (idx = this.frontier.length; idx < array$iv2; ++idx) {
                next[idx] = new UnCompiledNode(this, idx);
            }
            this.frontier = next;
        }
        this.freezeTail(prefixLenPlus1);
        int idx2 = prefixLenPlus1;
        idx = input.getLength();
        if (idx2 <= idx) {
            while (true) {
                this.frontier[idx2 - 1].addArc(input.getInts()[input.getOffset() + idx2 - 1], this.frontier[idx2]);
                if (idx2 == idx) break;
                ++idx2;
            }
        }
        UnCompiledNode<T> lastNode = this.frontier[input.getLength()];
        if (this.lastInput.length() != input.getLength() || prefixLenPlus1 != input.getLength() + 1) {
            lastNode.setFinal(true);
            lastNode.setOutput(this.NO_OUTPUT);
        }
        for (idx = 1; idx < prefixLenPlus1; ++idx) {
            T lastOutput;
            UnCompiledNode<Object> node = this.frontier[idx];
            UnCompiledNode<T> parentNode = this.frontier[idx - 1];
            T t = lastOutput = parentNode.getLastOutput(input.getInts()[input.getOffset() + idx - 1]);
            Intrinsics.checkNotNull(t);
            if (!this.validOutput(t)) {
                String this_$iv$iv = "Failed requirement.";
                throw new IllegalArgumentException(this_$iv$iv.toString());
            }
            Object commonOutputPrefix = null;
            if (lastOutput != this.NO_OUTPUT) {
                commonOutputPrefix = this.fst.getOutputs().common(output2, lastOutput);
                if (!this.validOutput(commonOutputPrefix)) {
                    string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                Object wordSuffix = this.fst.getOutputs().subtract(lastOutput, commonOutputPrefix);
                if (!this.validOutput(wordSuffix)) {
                    String string2 = "Failed requirement.";
                    throw new IllegalArgumentException(string2.toString());
                }
                parentNode.setLastOutput(input.getInts()[input.getOffset() + idx - 1], commonOutputPrefix);
                node.prependOutput(wordSuffix);
            } else {
                commonOutputPrefix = this.NO_OUTPUT;
            }
            output2 = this.fst.getOutputs().subtract(output2, commonOutputPrefix);
            if (this.validOutput(output2)) continue;
            string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.lastInput.length() == input.getLength() && prefixLenPlus1 == 1 + input.getLength()) {
            lastNode.setOutput(this.fst.getOutputs().merge(lastNode.getOutput(), output2));
        } else {
            this.frontier[prefixLenPlus1 - 1].setLastOutput(input.getInts()[input.getOffset() + prefixLenPlus1 - 1], output2);
        }
        this.lastInput.copyInts(input);
    }

    public final void setEmptyOutput(T v) {
        if (this.fst.getMetadata().getEmptyOutput() != null) {
            FST.FSTMetadata<T> fSTMetadata = this.fst.getMetadata();
            Outputs<T> outputs = this.fst.getOutputs();
            T t = this.fst.getMetadata().getEmptyOutput();
            Intrinsics.checkNotNull(t);
            fSTMetadata.setEmptyOutput(outputs.merge(t, v));
        } else {
            this.fst.getMetadata().setEmptyOutput(v);
        }
    }

    public final void finish(long newStartNode) {
        long newStartNode2 = newStartNode;
        if (!(newStartNode2 <= this.numBytesWritten)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.fst.getMetadata().getStartNode() == -1L)) {
            boolean bl = false;
            String string = "already finished";
            throw new IllegalStateException(string.toString());
        }
        if (newStartNode2 == -1L && this.fst.getMetadata().getEmptyOutput() != null) {
            newStartNode2 = 0L;
        }
        this.fst.getMetadata().setStartNode(newStartNode2);
        this.fst.getMetadata().setNumBytes(this.numBytesWritten);
        if (this.dataOutput instanceof ReadWriteDataOutput) {
            ((ReadWriteDataOutput)this.dataOutput).freeze();
        }
    }

    private final boolean validOutput(T output) {
        return output == this.NO_OUTPUT || !Intrinsics.areEqual(output, this.NO_OUTPUT);
    }

    @Nullable
    public final FST.FSTMetadata<T> compile() throws IOException {
        UnCompiledNode<T> root = this.frontier[0];
        this.freezeTail(0);
        if (root.getNumArcs() == 0) {
            if (this.fst.getMetadata().getEmptyOutput() == null) {
                return null;
            }
            this.writePaddingByte();
        }
        this.finish(this.compileNode(root).getNode());
        return this.fst.getMetadata();
    }

    public final long fstRamBytesUsed() {
        long ramBytesUsed = this.scratchBytes.ramBytesUsed();
        if (this.dataOutput instanceof Accountable) {
            DataOutput dataOutput = this.dataOutput;
            Intrinsics.checkNotNull((Object)dataOutput, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.Accountable");
            ramBytesUsed += ((Accountable)((Object)dataOutput)).ramBytesUsed();
        }
        return ramBytesUsed;
    }

    public final long fstSizeInBytes() {
        return this.numBytesWritten;
    }

    public /* synthetic */ FSTCompiler(FST.INPUT_TYPE inputType, double suffixRAMLimitMB, Outputs outputs, boolean allowFixedLengthArcs, DataOutput dataOutput, float directAddressingMaxOversizingFactor, int version, DefaultConstructorMarker $constructor_marker) {
        this(inputType, suffixRAMLimitMB, outputs, allowFixedLengthArcs, dataOutput, directAddressingMaxOversizingFactor, version);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u0004\u0018\u00018\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001e\u0010\u001c\u001a\u0004\u0018\u00018\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u001d\u0010\u0018\"\u0004\b\u001e\u0010\u001a\u00a8\u0006\u001f"}, d2={"Lorg/gnit/lucenekmp/util/fst/FSTCompiler$Arc;", "T", "", "<init>", "()V", "label", "", "getLabel", "()I", "setLabel", "(I)V", "target", "Lorg/gnit/lucenekmp/util/fst/FSTCompiler$Node;", "getTarget", "()Lorg/gnit/lucenekmp/util/fst/FSTCompiler$Node;", "setTarget", "(Lorg/gnit/lucenekmp/util/fst/FSTCompiler$Node;)V", "isFinal", "", "()Z", "setFinal", "(Z)V", "output", "getOutput", "()Ljava/lang/Object;", "setOutput", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "nextFinalOutput", "getNextFinalOutput", "setNextFinalOutput", "core"})
    public static final class Arc<T> {
        private int label;
        @Nullable
        private Node target;
        private boolean isFinal;
        @Nullable
        private T output;
        @Nullable
        private T nextFinalOutput;

        public final int getLabel() {
            return this.label;
        }

        public final void setLabel(int n) {
            this.label = n;
        }

        @Nullable
        public final Node getTarget() {
            return this.target;
        }

        public final void setTarget(@Nullable Node node) {
            this.target = node;
        }

        public final boolean isFinal() {
            return this.isFinal;
        }

        public final void setFinal(boolean bl) {
            this.isFinal = bl;
        }

        @Nullable
        public final T getOutput() {
            return this.output;
        }

        public final void setOutput(@Nullable T t) {
            this.output = t;
        }

        @Nullable
        public final T getNextFinalOutput() {
            return this.nextFinalOutput;
        }

        public final void setNextFinalOutput(@Nullable T t) {
            this.nextFinalOutput = t;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0013\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0014\u001a\u00020\u0010J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00028\u00010\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/util/fst/FSTCompiler$Builder;", "T", "", "inputType", "Lorg/gnit/lucenekmp/util/fst/FST$INPUT_TYPE;", "outputs", "Lorg/gnit/lucenekmp/util/fst/Outputs;", "<init>", "(Lorg/gnit/lucenekmp/util/fst/FST$INPUT_TYPE;Lorg/gnit/lucenekmp/util/fst/Outputs;)V", "suffixRAMLimitMB", "", "allowFixedLengthArcs", "", "dataOutput", "Lorg/gnit/lucenekmp/store/DataOutput;", "directAddressingMaxOversizingFactor", "", "version", "", "mb", "factor", "setVersion", "build", "Lorg/gnit/lucenekmp/util/fst/FSTCompiler;", "core"})
    @SourceDebugExtension(value={"SMAP\nFSTCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FSTCompiler.kt\norg/gnit/lucenekmp/util/fst/FSTCompiler$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1198:1\n1#2:1199\n*E\n"})
    public static final class Builder<T> {
        @NotNull
        private final FST.INPUT_TYPE inputType;
        @NotNull
        private final Outputs<T> outputs;
        private double suffixRAMLimitMB;
        private boolean allowFixedLengthArcs;
        @Nullable
        private DataOutput dataOutput;
        private float directAddressingMaxOversizingFactor;
        private int version;

        public Builder(@NotNull FST.INPUT_TYPE inputType, @NotNull Outputs<T> outputs) {
            Intrinsics.checkNotNullParameter((Object)((Object)inputType), (String)"inputType");
            Intrinsics.checkNotNullParameter(outputs, (String)"outputs");
            this.inputType = inputType;
            this.outputs = outputs;
            this.suffixRAMLimitMB = 32.0;
            this.allowFixedLengthArcs = true;
            this.directAddressingMaxOversizingFactor = 1.0f;
            this.version = 9;
        }

        @NotNull
        public final Builder<T> suffixRAMLimitMB(double mb) {
            if (!(!(mb < 0.0))) {
                boolean bl = false;
                String string = "suffixRAMLimitMB must be >= 0; got: " + mb;
                throw new IllegalArgumentException(string.toString());
            }
            this.suffixRAMLimitMB = mb;
            return this;
        }

        @NotNull
        public final Builder<T> allowFixedLengthArcs(boolean allowFixedLengthArcs) {
            this.allowFixedLengthArcs = allowFixedLengthArcs;
            return this;
        }

        @NotNull
        public final Builder<T> dataOutput(@NotNull DataOutput dataOutput) {
            Intrinsics.checkNotNullParameter((Object)dataOutput, (String)"dataOutput");
            this.dataOutput = dataOutput;
            return this;
        }

        @NotNull
        public final Builder<T> directAddressingMaxOversizingFactor(float factor) {
            this.directAddressingMaxOversizingFactor = factor;
            return this;
        }

        @NotNull
        public final Builder<T> setVersion(int version) {
            if (!(version >= 8 && version <= 9)) {
                boolean bl = false;
                String string = "Expected version in range [8, 9], got " + version;
                throw new IllegalArgumentException(string.toString());
            }
            this.version = version;
            return this;
        }

        @NotNull
        public final FSTCompiler<T> build() {
            if (this.dataOutput == null) {
                this.dataOutput = Companion.getOnHeapReaderWriter(15);
            }
            DataOutput dataOutput = this.dataOutput;
            Intrinsics.checkNotNull((Object)dataOutput);
            return new FSTCompiler(this.inputType, this.suffixRAMLimitMB, this.outputs, this.allowFixedLengthArcs, dataOutput, this.directAddressingMaxOversizingFactor, this.version, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/util/fst/FSTCompiler$Companion;", "", "<init>", "()V", "DIRECT_ADDRESSING_MAX_OVERSIZING_FACTOR", "", "FIXED_LENGTH_ARC_SHALLOW_DEPTH", "", "FIXED_LENGTH_ARC_SHALLOW_NUM_ARCS", "FIXED_LENGTH_ARC_DEEP_NUM_ARCS", "DIRECT_ADDRESSING_MAX_OVERSIZE_WITH_CREDIT_FACTOR", "NULL_FST_READER", "Lorg/gnit/lucenekmp/util/fst/FSTReader;", "getOnHeapReaderWriter", "Lorg/gnit/lucenekmp/store/DataOutput;", "blockBits", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DataOutput getOnHeapReaderWriter(int blockBits) {
            return new ReadWriteDataOutput(blockBits);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/fst/FSTCompiler$CompiledNode;", "Lorg/gnit/lucenekmp/util/fst/FSTCompiler$Node;", "<init>", "()V", "node", "", "getNode", "()J", "setNode", "(J)V", "isCompiled", "", "core"})
    public static final class CompiledNode
    implements Node {
        private long node;

        public final long getNode() {
            return this.node;
        }

        public final void setNode(long l) {
            this.node = l;
        }

        @Override
        public boolean isCompiled() {
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u0000J\u000e\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\rR\u001e\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/util/fst/FSTCompiler$FixedLengthArcsBuffer;", "", "<init>", "()V", "value", "", "bytes", "getBytes", "()[B", "bado", "Lorg/gnit/lucenekmp/store/ByteArrayDataOutput;", "ensureCapacity", "capacity", "", "resetPosition", "writeByte", "b", "", "writeVInt", "i", "position", "getPosition", "()I", "core"})
    public static final class FixedLengthArcsBuffer {
        @NotNull
        private byte[] bytes = new byte[11];
        @NotNull
        private final ByteArrayDataOutput bado = new ByteArrayDataOutput(this.bytes);

        @NotNull
        public final byte[] getBytes() {
            return this.bytes;
        }

        @NotNull
        public final FixedLengthArcsBuffer ensureCapacity(int capacity) {
            if (this.bytes.length < capacity) {
                this.bytes = new byte[ArrayUtil.Companion.oversize(capacity, 1)];
                ByteArrayDataOutput.reset$default(this.bado, this.bytes, 0, 0, 6, null);
            }
            return this;
        }

        @NotNull
        public final FixedLengthArcsBuffer resetPosition() {
            ByteArrayDataOutput.reset$default(this.bado, this.bytes, 0, 0, 6, null);
            return this;
        }

        @NotNull
        public final FixedLengthArcsBuffer writeByte(byte b) {
            this.bado.writeByte(b);
            return this;
        }

        @NotNull
        public final FixedLengthArcsBuffer writeVInt(int i) {
            try {
                this.bado.writeVInt(i);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public final int getPosition() {
            return this.bado.getPosition();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/util/fst/FSTCompiler$Node;", "", "isCompiled", "", "core"})
    public static interface Node {
        public boolean isCompiled();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/fst/FSTCompiler$NullFSTReader;", "Lorg/gnit/lucenekmp/util/fst/FSTReader;", "<init>", "()V", "ramBytesUsed", "", "getReverseBytesReader", "Lorg/gnit/lucenekmp/util/fst/FST$BytesReader;", "writeTo", "", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "core"})
    private static final class NullFSTReader
    implements FSTReader {
        @Override
        public long ramBytesUsed() {
            return 0L;
        }

        @Override
        @NotNull
        public FST.BytesReader getReverseBytesReader() {
            throw new UnsupportedOperationException("FST was not constructed with getOnHeapReaderWriter()");
        }

        @Override
        public void writeTo(@NotNull DataOutput out) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            throw new UnsupportedOperationException("FST was not constructed with getOnHeapReaderWriter()");
        }

        @Override
        @NotNull
        public Collection<Accountable> getChildResources() {
            return FSTReader.super.getChildResources();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u000f\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010$\u001a\u00020\u001fH\u0016J\u0006\u0010%\u001a\u00020&J\u0015\u0010'\u001a\u0004\u0018\u00018\u00012\u0006\u0010(\u001a\u00020\u0006\u00a2\u0006\u0002\u0010)J\u0016\u0010*\u001a\u00020&2\u0006\u0010+\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u0002J+\u0010-\u001a\u00020&2\u0006\u0010(\u001a\u00020\u00062\u0006\u0010,\u001a\u00020\u00022\u0006\u0010.\u001a\u00028\u00012\u0006\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\u0002\u0010/J\u001b\u00100\u001a\u00020&2\u0006\u0010(\u001a\u00020\u00062\u0006\u00101\u001a\u00028\u0001\u00a2\u0006\u0002\u00102J\u0013\u00103\u001a\u00020&2\u0006\u00104\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u001cR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR(\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00120\u0011X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0017\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0018\u001a\u00028\u0001X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010 \"\u0004\b!\u0010\"R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\r\u00a8\u00065"}, d2={"Lorg/gnit/lucenekmp/util/fst/FSTCompiler$UnCompiledNode;", "T", "Lorg/gnit/lucenekmp/util/fst/FSTCompiler$Node;", "owner", "Lorg/gnit/lucenekmp/util/fst/FSTCompiler;", "depth", "", "<init>", "(Lorg/gnit/lucenekmp/util/fst/FSTCompiler;I)V", "getOwner", "()Lorg/gnit/lucenekmp/util/fst/FSTCompiler;", "numArcs", "getNumArcs", "()I", "setNumArcs", "(I)V", "arcs", "", "Lorg/gnit/lucenekmp/util/fst/FSTCompiler$Arc;", "getArcs", "()[Lorg/gnit/lucenekmp/util/fst/FSTCompiler$Arc;", "setArcs", "([Lorg/gnit/lucenekmp/util/fst/FSTCompiler$Arc;)V", "[Lorg/gnit/lucenekmp/util/fst/FSTCompiler$Arc;", "output", "getOutput", "()Ljava/lang/Object;", "setOutput", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "isFinal", "", "()Z", "setFinal", "(Z)V", "getDepth", "isCompiled", "clear", "", "getLastOutput", "labelToMatch", "(I)Ljava/lang/Object;", "addArc", "label", "target", "replaceLast", "nextFinalOutput", "(ILorg/gnit/lucenekmp/util/fst/FSTCompiler$Node;Ljava/lang/Object;Z)V", "setLastOutput", "newOutput", "(ILjava/lang/Object;)V", "prependOutput", "outputPrefix", "core"})
    @SourceDebugExtension(value={"SMAP\nFSTCompiler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FSTCompiler.kt\norg/gnit/lucenekmp/util/fst/FSTCompiler$UnCompiledNode\n+ 2 ArrayUtil.kt\norg/gnit/lucenekmp/util/ArrayUtil$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1198:1\n217#2,5:1199\n189#2,2:1204\n222#2:1206\n1#3:1207\n*S KotlinDebug\n*F\n+ 1 FSTCompiler.kt\norg/gnit/lucenekmp/util/fst/FSTCompiler$UnCompiledNode\n*L\n1064#1:1199,5\n1064#1:1204,2\n1064#1:1206\n*E\n"})
    public static final class UnCompiledNode<T>
    implements Node {
        @NotNull
        private final FSTCompiler<T> owner;
        private int numArcs;
        @NotNull
        private Arc<T>[] arcs;
        private T output;
        private boolean isFinal;
        private final int depth;

        public UnCompiledNode(@NotNull FSTCompiler<T> owner, int depth) {
            Intrinsics.checkNotNullParameter(owner, (String)"owner");
            this.owner = owner;
            this.arcs = new Arc[1];
            this.arcs[0] = new Arc();
            this.output = ((FSTCompiler)this.owner).NO_OUTPUT;
            this.depth = depth;
        }

        @NotNull
        public final FSTCompiler<T> getOwner() {
            return this.owner;
        }

        public final int getNumArcs() {
            return this.numArcs;
        }

        public final void setNumArcs(int n) {
            this.numArcs = n;
        }

        @NotNull
        public final Arc<T>[] getArcs() {
            return this.arcs;
        }

        public final void setArcs(@NotNull Arc<T>[] arcArray) {
            Intrinsics.checkNotNullParameter(arcArray, (String)"<set-?>");
            this.arcs = arcArray;
        }

        public final T getOutput() {
            return this.output;
        }

        public final void setOutput(T t) {
            this.output = t;
        }

        public final boolean isFinal() {
            return this.isFinal;
        }

        public final void setFinal(boolean bl) {
            this.isFinal = bl;
        }

        public final int getDepth() {
            return this.depth;
        }

        @Override
        public boolean isCompiled() {
            return false;
        }

        public final void clear() {
            this.numArcs = 0;
            this.isFinal = false;
            this.output = ((FSTCompiler)this.owner).NO_OUTPUT;
        }

        @Nullable
        public final T getLastOutput(int labelToMatch) {
            if (!(this.numArcs > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(this.arcs[this.numArcs - 1].getLabel() == labelToMatch)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            return this.arcs[this.numArcs - 1].getOutput();
        }

        /*
         * WARNING - void declaration
         */
        public final void addArc(int label, @NotNull Node target) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (!(label >= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(this.numArcs == 0 || label > this.arcs[this.numArcs - 1].getLabel())) {
                boolean $i$a$-require-FSTCompiler$UnCompiledNode$addArc$22 = false;
                String $i$a$-require-FSTCompiler$UnCompiledNode$addArc$22 = "arc[numArcs-1].label=" + this.arcs[this.numArcs - 1].getLabel() + " new label=" + label + " numArcs=" + this.numArcs;
                throw new IllegalArgumentException($i$a$-require-FSTCompiler$UnCompiledNode$addArc$22.toString());
            }
            if (this.numArcs == this.arcs.length) {
                Arc[] arcArray;
                void array$iv;
                ArrayUtil.Companion $i$a$-require-FSTCompiler$UnCompiledNode$addArc$22 = ArrayUtil.Companion;
                Arc<T>[] arcArray2 = this.arcs;
                int minSize$iv = this.arcs.length + 1;
                boolean $i$f$growNullable = false;
                if (minSize$iv < 0) {
                    throw new Exception("size must be positive (got " + minSize$iv + "): likely integer overflow?");
                }
                if (((void)array$iv).length < minSize$iv) {
                    void array$iv$iv;
                    void this_$iv;
                    int newLength$iv = this_$iv.oversize(minSize$iv, 4);
                    void var9_13 = this_$iv;
                    void var10_14 = array$iv;
                    int newLength$iv$iv = newLength$iv;
                    boolean $i$f$growExactNullable = false;
                    if (newLength$iv$iv < ((void)array$iv$iv).length) {
                        throw new IndexOutOfBoundsException("newLength (" + newLength$iv$iv + ") < array.size (" + ((void)array$iv$iv).length + ")");
                    }
                    Arc[] arcArray3 = new Arc[newLength$iv$iv];
                    for (int i = 0; i < newLength$iv$iv; ++i) {
                        int n = i;
                        arcArray3[n] = n < ((void)array$iv$iv).length ? array$iv$iv[n] : null;
                    }
                    arcArray = arcArray3;
                } else {
                    arcArray = array$iv;
                }
                void newArcs = arcArray;
                int n = ((void)newArcs).length;
                for (int arcIdx = this.numArcs; arcIdx < n; ++arcIdx) {
                    newArcs[arcIdx] = new Arc();
                }
                this.arcs = newArcs;
            }
            int n = this.numArcs;
            this.numArcs = n + 1;
            Arc<Object> arc = this.arcs[n];
            arc.setLabel(label);
            arc.setTarget(target);
            arc.setNextFinalOutput(((FSTCompiler)this.owner).NO_OUTPUT);
            arc.setOutput(arc.getNextFinalOutput());
            arc.setFinal(false);
        }

        public final void replaceLast(int labelToMatch, @NotNull Node target, T nextFinalOutput, boolean isFinal) {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            if (!(this.numArcs > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Arc<T> arc = this.arcs[this.numArcs - 1];
            if (!(arc.getLabel() == labelToMatch)) {
                boolean bl = false;
                String string = "arc.label=" + arc.getLabel() + " vs " + labelToMatch;
                throw new IllegalArgumentException(string.toString());
            }
            arc.setTarget(target);
            arc.setNextFinalOutput(nextFinalOutput);
            arc.setFinal(isFinal);
        }

        public final void setLastOutput(int labelToMatch, T newOutput) {
            if (!((FSTCompiler)this.owner).validOutput(newOutput)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(this.numArcs > 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Arc<T> arc = this.arcs[this.numArcs - 1];
            if (!(arc.getLabel() == labelToMatch)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            arc.setOutput(newOutput);
        }

        public final void prependOutput(T outputPrefix) {
            if (!((FSTCompiler)this.owner).validOutput(outputPrefix)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int n = this.numArcs;
            for (int arcIdx = 0; arcIdx < n; ++arcIdx) {
                Arc<T> arc = this.arcs[arcIdx];
                Outputs<T> outputs = this.owner.getFst().getOutputs();
                T t = this.arcs[arcIdx].getOutput();
                Intrinsics.checkNotNull(t);
                arc.setOutput(outputs.add(outputPrefix, t));
                T t2 = this.arcs[arcIdx].getOutput();
                Intrinsics.checkNotNull(t2);
                if (((FSTCompiler)this.owner).validOutput(t2)) continue;
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.isFinal) {
                this.output = this.owner.getFst().getOutputs().add(outputPrefix, this.output);
                if (!((FSTCompiler)this.owner).validOutput(this.output)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
            }
        }
    }
}

