/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.fst;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.util.ByteBlockPool;
import org.gnit.lucenekmp.util.fst.ByteBlockPoolReverseBytesReader;
import org.gnit.lucenekmp.util.fst.FST;
import org.gnit.lucenekmp.util.fst.FSTCompiler;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.gnit.lucenekmp.util.packed.PagedGrowableWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0019B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\u0013\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u0016\u001a\u00020\fH\u0002J\u0014\u0010\u0017\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015J\u0016\u0010\u0016\u001a\u00020\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0002R\u0018\u0010\t\u001a\f0\nR\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0018\u00010\nR\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/util/fst/FSTSuffixNodeCache;", "T", "", "fstCompiler", "Lorg/gnit/lucenekmp/util/fst/FSTCompiler;", "ramLimitMB", "", "<init>", "(Lorg/gnit/lucenekmp/util/fst/FSTCompiler;D)V", "primaryTable", "Lorg/gnit/lucenekmp/util/fst/FSTSuffixNodeCache$PagedGrowableHash;", "ramLimitBytes", "", "fallbackTable", "scratchArc", "Lorg/gnit/lucenekmp/util/fst/FST$Arc;", "lastFallbackNodeLength", "", "lastFallbackHashSlot", "getFallback", "nodeIn", "Lorg/gnit/lucenekmp/util/fst/FSTCompiler$UnCompiledNode;", "hash", "add", "node", "PagedGrowableHash", "core"})
@SourceDebugExtension(value={"SMAP\nFSTSuffixNodeCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FSTSuffixNodeCache.kt\norg/gnit/lucenekmp/util/fst/FSTSuffixNodeCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,490:1\n1#2:491\n*E\n"})
public final class FSTSuffixNodeCache<T> {
    @NotNull
    private PagedGrowableHash primaryTable;
    private final long ramLimitBytes;
    @Nullable
    private PagedGrowableHash fallbackTable;
    @NotNull
    private final FSTCompiler<T> fstCompiler;
    @NotNull
    private final FST.Arc<T> scratchArc;
    private int lastFallbackNodeLength;
    private long lastFallbackHashSlot;

    public FSTSuffixNodeCache(@NotNull FSTCompiler<T> fstCompiler, double ramLimitMB) {
        Intrinsics.checkNotNullParameter(fstCompiler, (String)"fstCompiler");
        this.scratchArc = new FST.Arc();
        if (!(!(ramLimitMB <= 0.0))) {
            boolean bl = false;
            String string = "ramLimitMB must be > 0; got: " + ramLimitMB;
            throw new IllegalArgumentException(string.toString());
        }
        double asBytes = ramLimitMB * (double)1024 * (double)1024;
        this.ramLimitBytes = asBytes >= 9.223372036854776E18 ? Long.MAX_VALUE : (long)asBytes;
        this.primaryTable = new PagedGrowableHash();
        this.fstCompiler = fstCompiler;
    }

    private final long getFallback(FSTCompiler.UnCompiledNode<T> nodeIn, long hash) throws IOException {
        this.lastFallbackNodeLength = -1;
        this.lastFallbackHashSlot = -1L;
        if (this.fallbackTable == null) {
            return 0L;
        }
        PagedGrowableHash pagedGrowableHash = this.fallbackTable;
        Intrinsics.checkNotNull((Object)pagedGrowableHash);
        long hashSlot = hash & pagedGrowableHash.getMask();
        int c = 0;
        while (true) {
            PagedGrowableHash pagedGrowableHash2 = this.fallbackTable;
            Intrinsics.checkNotNull((Object)pagedGrowableHash2);
            long nodeAddress = pagedGrowableHash2.getNodeAddress(hashSlot);
            if (nodeAddress == 0L) {
                return 0L;
            }
            PagedGrowableHash pagedGrowableHash3 = this.fallbackTable;
            Intrinsics.checkNotNull((Object)pagedGrowableHash3);
            int length = pagedGrowableHash3.nodesEqual(nodeIn, nodeAddress, hashSlot);
            if (length != -1) {
                this.lastFallbackNodeLength = length;
                this.lastFallbackHashSlot = hashSlot;
                return nodeAddress;
            }
            long l = hashSlot + (long)(++c);
            PagedGrowableHash pagedGrowableHash4 = this.fallbackTable;
            Intrinsics.checkNotNull((Object)pagedGrowableHash4);
            hashSlot = l & pagedGrowableHash4.getMask();
        }
    }

    public final long add(@NotNull FSTCompiler.UnCompiledNode<T> nodeIn) throws IOException {
        Intrinsics.checkNotNullParameter(nodeIn, (String)"nodeIn");
        long hash = this.hash(nodeIn);
        long hashSlot = 0L;
        hashSlot = hash & this.primaryTable.getMask();
        int c = 0;
        while (true) {
            long nodeAddress = 0L;
            nodeAddress = this.primaryTable.getNodeAddress(hashSlot);
            if (nodeAddress == 0L) {
                nodeAddress = this.getFallback(nodeIn, hash);
                if (nodeAddress != 0L) {
                    if (!(this.lastFallbackHashSlot != -1L && this.lastFallbackNodeLength != -1)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.primaryTable.setNodeAddress(hashSlot, nodeAddress);
                    PagedGrowableHash pagedGrowableHash = this.fallbackTable;
                    Intrinsics.checkNotNull((Object)pagedGrowableHash);
                    this.primaryTable.copyFallbackNodeBytes(hashSlot, pagedGrowableHash, this.lastFallbackHashSlot, this.lastFallbackNodeLength);
                } else {
                    nodeAddress = this.fstCompiler.addNode(nodeIn);
                    if (!(nodeAddress != -1L && nodeAddress != 0L)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.primaryTable.setNodeAddress(hashSlot, nodeAddress);
                    this.primaryTable.copyNodeBytes(hashSlot, this.fstCompiler.getScratchBytes().getBytes(), this.fstCompiler.getScratchBytes().getPosition());
                    if (!(this.primaryTable.hash(nodeAddress, hashSlot) == hash)) {
                        boolean bl = false;
                        String string = "mismatch frozenHash=" + this.primaryTable.hash(nodeAddress, hashSlot) + " vs hash=" + hash;
                        throw new IllegalArgumentException(string.toString());
                    }
                }
                long copiedBytes = this.primaryTable.getCopiedNodes().getPosition();
                long ramBytesUsed = this.primaryTable.getCount() * (long)2 * (long)PackedInts.INSTANCE.bitsRequired(nodeAddress) / (long)8 + this.primaryTable.getCount() * (long)2 * (long)PackedInts.INSTANCE.bitsRequired(copiedBytes) / (long)8 + copiedBytes;
                if (ramBytesUsed >= this.ramLimitBytes / (long)2) {
                    this.fallbackTable = this.primaryTable;
                    this.primaryTable = new PagedGrowableHash(nodeAddress, java.lang.Math.max(16L, this.primaryTable.getFstNodeAddress().size()));
                } else if ((float)this.primaryTable.getCount() > (float)this.primaryTable.getFstNodeAddress().size() * 0.6666667f) {
                    this.primaryTable.rehash(nodeAddress);
                }
                return nodeAddress;
            }
            if (this.primaryTable.nodesEqual(nodeIn, nodeAddress, hashSlot) != -1) {
                return nodeAddress;
            }
            hashSlot = hashSlot + (long)(++c) & this.primaryTable.getMask();
        }
    }

    private final long hash(FSTCompiler.UnCompiledNode<T> node) {
        int PRIME = 31;
        long h = 0L;
        int n = node.getNumArcs();
        for (int arcIdx = 0; arcIdx < n; ++arcIdx) {
            FSTCompiler.Arc<T> arc = node.getArcs()[arcIdx];
            h = (long)PRIME * h + (long)arc.getLabel();
            FSTCompiler.Node node2 = arc.getTarget();
            Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.fst.FSTCompiler.CompiledNode");
            long n2 = ((FSTCompiler.CompiledNode)node2).getNode();
            h = (long)PRIME * h + (long)((int)(n2 ^ n2 >> 32));
            T t = arc.getOutput();
            h = (long)PRIME * h + (long)(t != null ? t.hashCode() : 0);
            T t2 = arc.getNextFinalOutput();
            h = (long)PRIME * h + (long)(t2 != null ? t2.hashCode() : 0);
            if (!arc.isFinal()) continue;
            h += (long)17;
        }
        return h;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0007J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005J\u0016\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0005J\u001e\u0010&\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!J0\u0010(\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\u00052\u0010\u0010)\u001a\f0\u0000R\b\u0012\u0004\u0012\u00028\u00000*2\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020!J\u000e\u0010-\u001a\u00020$2\u0006\u0010\u0004\u001a\u00020\u0005J\u0016\u0010.\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005J$\u0010/\u001a\u00020!2\f\u00100\u001a\b\u0012\u0004\u0012\u00028\u0000012\u0006\u00102\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005J\u0018\u00103\u001a\u0002042\u0006\u0010%\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0005H\u0002R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/gnit/lucenekmp/util/fst/FSTSuffixNodeCache$PagedGrowableHash;", "", "<init>", "(Lorg/gnit/lucenekmp/util/fst/FSTSuffixNodeCache;)V", "lastNodeAddress", "", "size", "(Lorg/gnit/lucenekmp/util/fst/FSTSuffixNodeCache;JJ)V", "fstNodeAddress", "Lorg/gnit/lucenekmp/util/packed/PagedGrowableWriter;", "getFstNodeAddress", "()Lorg/gnit/lucenekmp/util/packed/PagedGrowableWriter;", "setFstNodeAddress", "(Lorg/gnit/lucenekmp/util/packed/PagedGrowableWriter;)V", "copiedNodeAddress", "count", "getCount", "()J", "setCount", "(J)V", "mask", "getMask", "setMask", "copiedNodes", "Lorg/gnit/lucenekmp/util/ByteBlockPool;", "getCopiedNodes", "()Lorg/gnit/lucenekmp/util/ByteBlockPool;", "bytesReader", "Lorg/gnit/lucenekmp/util/fst/ByteBlockPoolReverseBytesReader;", "getBytes", "", "hashSlot", "length", "", "getNodeAddress", "setNodeAddress", "", "nodeAddress", "copyNodeBytes", "bytes", "copyFallbackNodeBytes", "fallbackTable", "Lorg/gnit/lucenekmp/util/fst/FSTSuffixNodeCache;", "fallbackHashSlot", "nodeLength", "rehash", "hash", "nodesEqual", "node", "Lorg/gnit/lucenekmp/util/fst/FSTCompiler$UnCompiledNode;", "address", "getBytesReader", "Lorg/gnit/lucenekmp/util/fst/FST$BytesReader;", "BLOCK_SIZE_BYTES", "core"})
    @SourceDebugExtension(value={"SMAP\nFSTSuffixNodeCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FSTSuffixNodeCache.kt\norg/gnit/lucenekmp/util/fst/FSTSuffixNodeCache$PagedGrowableHash\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,490:1\n1#2:491\n*E\n"})
    public final class PagedGrowableHash {
        @NotNull
        private PagedGrowableWriter fstNodeAddress;
        @NotNull
        private PagedGrowableWriter copiedNodeAddress;
        private long count;
        private long mask;
        @NotNull
        private final ByteBlockPool copiedNodes;
        @NotNull
        private final ByteBlockPoolReverseBytesReader bytesReader;
        private final int BLOCK_SIZE_BYTES;

        @NotNull
        public final PagedGrowableWriter getFstNodeAddress() {
            return this.fstNodeAddress;
        }

        public final void setFstNodeAddress(@NotNull PagedGrowableWriter pagedGrowableWriter) {
            Intrinsics.checkNotNullParameter((Object)pagedGrowableWriter, (String)"<set-?>");
            this.fstNodeAddress = pagedGrowableWriter;
        }

        public final long getCount() {
            return this.count;
        }

        public final void setCount(long l) {
            this.count = l;
        }

        public final long getMask() {
            return this.mask;
        }

        public final void setMask(long l) {
            this.mask = l;
        }

        @NotNull
        public final ByteBlockPool getCopiedNodes() {
            return this.copiedNodes;
        }

        public PagedGrowableHash() {
            this.BLOCK_SIZE_BYTES = 262144;
            this.fstNodeAddress = new PagedGrowableWriter(16L, this.BLOCK_SIZE_BYTES, 8, 0.0f);
            this.copiedNodeAddress = new PagedGrowableWriter(16L, this.BLOCK_SIZE_BYTES, 8, 0.0f);
            this.mask = 15L;
            this.copiedNodes = new ByteBlockPool(new ByteBlockPool.DirectAllocator());
            this.bytesReader = new ByteBlockPoolReverseBytesReader(this.copiedNodes);
        }

        public PagedGrowableHash(long lastNodeAddress, long size2) {
            this.BLOCK_SIZE_BYTES = 262144;
            this.fstNodeAddress = new PagedGrowableWriter(size2, this.BLOCK_SIZE_BYTES, PackedInts.INSTANCE.bitsRequired(lastNodeAddress), 0.0f);
            this.copiedNodeAddress = new PagedGrowableWriter(size2, this.BLOCK_SIZE_BYTES, 8, 0.0f);
            this.mask = size2 - 1L;
            if (!((this.mask & size2) == 0L)) {
                boolean bl = false;
                String string = "size must be a power-of-2; got size=" + size2 + " mask=" + this.mask;
                throw new IllegalArgumentException(string.toString());
            }
            this.copiedNodes = new ByteBlockPool(new ByteBlockPool.DirectAllocator());
            this.bytesReader = new ByteBlockPoolReverseBytesReader(this.copiedNodes);
        }

        @NotNull
        public final byte[] getBytes(long hashSlot, int length) {
            long address = this.copiedNodeAddress.get(hashSlot);
            if (!(address - (long)length + 1L >= 0L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            byte[] buf = new byte[length];
            this.copiedNodes.readBytes(address - (long)length + 1L, buf, 0, length);
            return buf;
        }

        public final long getNodeAddress(long hashSlot) {
            return this.fstNodeAddress.get(hashSlot);
        }

        public final void setNodeAddress(long hashSlot, long nodeAddress) {
            if (!(this.fstNodeAddress.get(hashSlot) == 0L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.fstNodeAddress.set(hashSlot, nodeAddress);
            long l = this.count;
            this.count = l + 1L;
        }

        public final void copyNodeBytes(long hashSlot, @NotNull byte[] bytes, int length) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            if (!(this.copiedNodeAddress.get(hashSlot) == 0L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.copiedNodes.append(bytes, 0, length);
            this.copiedNodeAddress.set(hashSlot, this.copiedNodes.getPosition() - 1L);
        }

        public final void copyFallbackNodeBytes(long hashSlot, @NotNull PagedGrowableHash fallbackTable, long fallbackHashSlot, int nodeLength) {
            Intrinsics.checkNotNullParameter((Object)fallbackTable, (String)"fallbackTable");
            if (!(this.copiedNodeAddress.get(hashSlot) == 0L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            long fallbackAddress = fallbackTable.copiedNodeAddress.get(fallbackHashSlot);
            long fallbackStartAddress = fallbackAddress - (long)nodeLength + 1L;
            if (!(fallbackStartAddress >= 0L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.copiedNodes.append(fallbackTable.copiedNodes, fallbackStartAddress, nodeLength);
            this.copiedNodeAddress.set(hashSlot, this.copiedNodes.getPosition() - 1L);
        }

        public final void rehash(long lastNodeAddress) throws IOException {
            long newSize = (long)2 * this.fstNodeAddress.size();
            PagedGrowableWriter newCopiedNodeAddress = new PagedGrowableWriter(newSize, this.BLOCK_SIZE_BYTES, PackedInts.INSTANCE.bitsRequired(this.copiedNodes.getPosition()), 0.0f);
            PagedGrowableWriter newFSTNodeAddress = new PagedGrowableWriter(newSize, this.BLOCK_SIZE_BYTES, PackedInts.INSTANCE.bitsRequired(lastNodeAddress), 0.0f);
            long newMask = newFSTNodeAddress.size() - 1L;
            long l = this.fstNodeAddress.size();
            block0: for (long idx = 0L; idx < l; ++idx) {
                long address = this.fstNodeAddress.get(idx);
                if (address == 0L) continue;
                long hashSlot = this.hash(address, idx) & newMask;
                int c = 0;
                while (true) {
                    if (newFSTNodeAddress.get(hashSlot) == 0L) {
                        newFSTNodeAddress.set(hashSlot, address);
                        newCopiedNodeAddress.set(hashSlot, this.copiedNodeAddress.get(idx));
                        continue block0;
                    }
                    hashSlot = hashSlot + (long)(++c) & newMask;
                }
            }
            this.mask = newMask;
            this.fstNodeAddress = newFSTNodeAddress;
            this.copiedNodeAddress = newCopiedNodeAddress;
        }

        public final long hash(long nodeAddress, long hashSlot) throws IOException {
            FST.BytesReader in = this.getBytesReader(nodeAddress, hashSlot);
            int PRIME = 31;
            long h = 0L;
            FSTSuffixNodeCache.this.fstCompiler.getFst().readFirstRealTargetArc(nodeAddress, FSTSuffixNodeCache.this.scratchArc, in);
            while (true) {
                h = (long)PRIME * h + (long)FSTSuffixNodeCache.this.scratchArc.label();
                h = (long)PRIME * h + (long)((int)(FSTSuffixNodeCache.this.scratchArc.target() ^ FSTSuffixNodeCache.this.scratchArc.target() >> 32));
                Object t = FSTSuffixNodeCache.this.scratchArc.output();
                h = (long)PRIME * h + (long)(t != null ? t.hashCode() : 0);
                Object t2 = FSTSuffixNodeCache.this.scratchArc.nextFinalOutput();
                h = (long)PRIME * h + (long)(t2 != null ? t2.hashCode() : 0);
                if (FSTSuffixNodeCache.this.scratchArc.isFinal()) {
                    h += (long)17;
                }
                if (FSTSuffixNodeCache.this.scratchArc.isLast()) break;
                FSTSuffixNodeCache.this.fstCompiler.getFst().readNextRealArc(FSTSuffixNodeCache.this.scratchArc, in);
            }
            return h;
        }

        public final int nodesEqual(@NotNull FSTCompiler.UnCompiledNode<T> node, long address, long hashSlot) throws IOException {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            FST.BytesReader in = this.getBytesReader(address, hashSlot);
            FSTSuffixNodeCache.this.fstCompiler.getFst().readFirstRealTargetArc(address, FSTSuffixNodeCache.this.scratchArc, in);
            if (FSTSuffixNodeCache.this.scratchArc.bytesPerArc() != 0) {
                if (!(node.getNumArcs() > 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                byte by = FSTSuffixNodeCache.this.scratchArc.nodeFlags();
                if (by == 32) {
                    if (node.getNumArcs() != FSTSuffixNodeCache.this.scratchArc.numArcs()) {
                        return -1;
                    }
                } else if (by == 64) {
                    if (node.getArcs()[node.getNumArcs() - 1].getLabel() - node.getArcs()[0].getLabel() + 1 != FSTSuffixNodeCache.this.scratchArc.numArcs() || node.getNumArcs() != FST.Arc.BitTable.INSTANCE.countBits(FSTSuffixNodeCache.this.scratchArc, in)) {
                        return -1;
                    }
                } else if (by == 96) {
                    if (node.getArcs()[node.getNumArcs() - 1].getLabel() - node.getArcs()[0].getLabel() + 1 != FSTSuffixNodeCache.this.scratchArc.numArcs()) {
                        return -1;
                    }
                } else {
                    throw new AssertionError((Object)("unhandled scratchArc.nodeFlag() " + FSTSuffixNodeCache.this.scratchArc.nodeFlags()));
                }
            }
            int n = node.getNumArcs();
            for (int arcUpto = 0; arcUpto < n; ++arcUpto) {
                block18: {
                    block17: {
                        FSTCompiler.Arc arc = node.getArcs()[arcUpto];
                        if (arc.getLabel() != FSTSuffixNodeCache.this.scratchArc.label()) break block17;
                        Object t = arc.getOutput();
                        Intrinsics.checkNotNull(t);
                        if (!Intrinsics.areEqual(t, FSTSuffixNodeCache.this.scratchArc.output())) break block17;
                        FSTCompiler.Node node2 = arc.getTarget();
                        Intrinsics.checkNotNull((Object)node2, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.fst.FSTCompiler.CompiledNode");
                        if (((FSTCompiler.CompiledNode)node2).getNode() != FSTSuffixNodeCache.this.scratchArc.target()) break block17;
                        Object t2 = arc.getNextFinalOutput();
                        Intrinsics.checkNotNull(t2);
                        if (Intrinsics.areEqual(t2, FSTSuffixNodeCache.this.scratchArc.nextFinalOutput()) && arc.isFinal() == FSTSuffixNodeCache.this.scratchArc.isFinal()) break block18;
                    }
                    return -1;
                }
                if (FSTSuffixNodeCache.this.scratchArc.isLast()) {
                    return arcUpto == node.getNumArcs() - 1 ? Math.INSTANCE.toIntExact(address - in.getPosition()) : -1;
                }
                FSTSuffixNodeCache.this.fstCompiler.getFst().readNextRealArc(FSTSuffixNodeCache.this.scratchArc, in);
            }
            return -1;
        }

        private final FST.BytesReader getBytesReader(long nodeAddress, long hashSlot) {
            if (!(this.fstNodeAddress.get(hashSlot) == nodeAddress)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            long localAddress = this.copiedNodeAddress.get(hashSlot);
            this.bytesReader.setPosDelta(nodeAddress - localAddress);
            return this.bytesReader;
        }
    }
}

