/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.fst;

import java.io.IOException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0011\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u00012\u00020\u0002:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u000bH\u0002J\u000e\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u0001J&\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bJ\b\u0010 \u001a\u00020!H\u0016R\u001e\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006#"}, d2={"Lorg/gnit/lucenekmp/util/fst/GrowableByteArrayDataOutput;", "Lorg/gnit/lucenekmp/store/DataOutput;", "Lorg/gnit/lucenekmp/util/Accountable;", "<init>", "()V", "value", "", "bytes", "getBytes", "()[B", "nextWrite", "", "writeByte", "", "b", "", "writeBytes", "offset", "len", "newLen", "position", "getPosition", "()I", "setPosition", "(I)V", "ensureCapacity", "capacityToWrite", "writeTo", "out", "srcOffset", "dest", "destOffset", "ramBytesUsed", "", "Companion", "core"})
public final class GrowableByteArrayDataOutput
extends DataOutput
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private byte[] bytes = new byte[256];
    private int nextWrite;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(GrowableByteArrayDataOutput.class));
    private static final int INITIAL_SIZE = 256;

    @NotNull
    public final byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public void writeByte(byte b) {
        this.ensureCapacity(1);
        int n = this.nextWrite;
        this.nextWrite = n + 1;
        this.bytes[n] = b;
    }

    @Override
    public void writeBytes(@NotNull byte[] b, int offset, int len) {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (len == 0) {
            return;
        }
        this.ensureCapacity(len);
        System.INSTANCE.arraycopy(b, offset, this.bytes, this.nextWrite, len);
        this.nextWrite += len;
    }

    public final int getPosition() {
        return this.nextWrite;
    }

    public final void setPosition(int newLen) {
        if (!(newLen >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (newLen > this.nextWrite) {
            this.ensureCapacity(newLen - this.nextWrite);
        }
        this.nextWrite = newLen;
    }

    private final void ensureCapacity(int capacityToWrite) {
        if (!(capacityToWrite > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.bytes = ArrayUtil.Companion.grow(this.bytes, this.nextWrite + capacityToWrite);
    }

    public final void writeTo(@NotNull DataOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeBytes(this.bytes, 0, this.nextWrite);
    }

    public final void writeTo(int srcOffset, @NotNull byte[] dest, int destOffset, int len) {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (!(srcOffset + len <= this.nextWrite)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        System.INSTANCE.arraycopy(this.bytes, srcOffset, dest, destOffset, len);
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.Companion.sizeOf(this.bytes);
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/util/fst/GrowableByteArrayDataOutput$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "INITIAL_SIZE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

