/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.fst;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.fst.Outputs;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016J\u0018\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\u0002H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\t\u001a\u00020\u0002H\u0016R\u0014\u0010\u0015\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Lorg/gnit/lucenekmp/util/fst/IntSequenceOutputs;", "Lorg/gnit/lucenekmp/util/fst/Outputs;", "Lorg/gnit/lucenekmp/util/IntsRef;", "<init>", "()V", "common", "output1", "output2", "subtract", "output", "inc", "add", "prefix", "write", "", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "read", "input", "Lorg/gnit/lucenekmp/store/DataInput;", "skipOutput", "noOutput", "getNoOutput", "()Lorg/gnit/lucenekmp/util/IntsRef;", "outputToString", "", "toString", "ramBytesUsed", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nIntSequenceOutputs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntSequenceOutputs.kt\norg/gnit/lucenekmp/util/fst/IntSequenceOutputs\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1#2:97\n*E\n"})
public final class IntSequenceOutputs
extends Outputs<IntsRef> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final IntsRef NO_OUTPUT = new IntsRef();
    private static final long BASE_NUM_BYTES = RamUsageEstimator.Companion.shallowSizeOf(NO_OUTPUT);
    @NotNull
    private static final IntSequenceOutputs singleton = new IntSequenceOutputs();

    private IntSequenceOutputs() {
    }

    @Override
    @NotNull
    public IntsRef common(@NotNull IntsRef output1, @NotNull IntsRef output2) {
        int idx;
        Intrinsics.checkNotNullParameter((Object)output1, (String)"output1");
        Intrinsics.checkNotNullParameter((Object)output2, (String)"output2");
        int len1 = output1.getLength();
        int len2 = output2.getLength();
        int limit = Math.min(len1, len2);
        for (idx = 0; idx < limit && output1.getInts()[output1.getOffset() + idx] == output2.getInts()[output2.getOffset() + idx]; ++idx) {
        }
        return idx == 0 ? NO_OUTPUT : (idx == len1 && idx == len2 ? output1 : (idx == len1 ? output1 : (idx == len2 ? output2 : new IntsRef(output1.getInts(), output1.getOffset(), idx))));
    }

    @Override
    @NotNull
    public IntsRef subtract(@NotNull IntsRef output, @NotNull IntsRef inc) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)inc, (String)"inc");
        if (inc == NO_OUTPUT) {
            return output;
        }
        if (inc.getLength() == output.getLength()) {
            return NO_OUTPUT;
        }
        if (!(inc.getLength() < output.getLength())) {
            boolean bl = false;
            String string = "inc.length=" + inc.getLength() + " vs output.length=" + output.getLength();
            throw new IllegalArgumentException(string.toString());
        }
        if (!(inc.getLength() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return new IntsRef(output.getInts(), output.getOffset() + inc.getLength(), output.getLength() - inc.getLength());
    }

    @Override
    @NotNull
    public IntsRef add(@NotNull IntsRef prefix, @NotNull IntsRef output) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        if (prefix == NO_OUTPUT) {
            return output;
        }
        if (output == NO_OUTPUT) {
            return prefix;
        }
        int[] result = new int[prefix.getLength() + output.getLength()];
        System.INSTANCE.arraycopy(prefix.getInts(), prefix.getOffset(), result, 0, prefix.getLength());
        System.INSTANCE.arraycopy(output.getInts(), output.getOffset(), result, prefix.getLength(), output.getLength());
        return new IntsRef(result, 0, result.length);
    }

    @Override
    public void write(@NotNull IntsRef output, @NotNull DataOutput out) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeVInt(output.getLength());
        int n = output.getLength();
        for (int i = 0; i < n; ++i) {
            out.writeVInt(output.getInts()[output.getOffset() + i]);
        }
    }

    @Override
    @NotNull
    public IntsRef read(@NotNull DataInput input) {
        IntsRef intsRef;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int len = input.readVInt();
        if (len == 0) {
            intsRef = NO_OUTPUT;
        } else {
            int[] ints = new int[len];
            for (int i = 0; i < len; ++i) {
                ints[i] = input.readVInt();
            }
            intsRef = new IntsRef(ints, 0, len);
        }
        return intsRef;
    }

    @Override
    public void skipOutput(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int len = input.readVInt();
        if (len == 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            input.readVInt();
        }
    }

    @Override
    @NotNull
    public IntsRef getNoOutput() {
        return NO_OUTPUT;
    }

    @Override
    @NotNull
    public String outputToString(@NotNull IntsRef output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return output.toString();
    }

    @NotNull
    public String toString() {
        return "IntSequenceOutputs";
    }

    @Override
    public long ramBytesUsed(@NotNull IntsRef output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        return BASE_NUM_BYTES + RamUsageEstimator.Companion.sizeOf(output.getInts());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/fst/IntSequenceOutputs$Companion;", "", "<init>", "()V", "NO_OUTPUT", "Lorg/gnit/lucenekmp/util/IntsRef;", "BASE_NUM_BYTES", "", "singleton", "Lorg/gnit/lucenekmp/util/fst/IntSequenceOutputs;", "getSingleton", "()Lorg/gnit/lucenekmp/util/fst/IntSequenceOutputs;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntSequenceOutputs getSingleton() {
            return singleton;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

