/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.fst;

import java.io.IOException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.fst.FST;
import org.gnit.lucenekmp.util.fst.FSTCompiler;
import org.gnit.lucenekmp.util.fst.FSTReader;
import org.gnit.lucenekmp.util.fst.ReadWriteDataOutput;
import org.gnit.lucenekmp.util.fst.ReverseBytesReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u000e\u001a\u00020\u0007H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/util/fst/OnHeapFSTStore;", "Lorg/gnit/lucenekmp/util/fst/FSTReader;", "maxBlockBits", "", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "numBytes", "", "<init>", "(ILorg/gnit/lucenekmp/store/DataInput;J)V", "dataOutput", "Lorg/gnit/lucenekmp/util/fst/ReadWriteDataOutput;", "bytesArray", "", "ramBytesUsed", "getReverseBytesReader", "Lorg/gnit/lucenekmp/util/fst/FST$BytesReader;", "writeTo", "", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nOnHeapFSTStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OnHeapFSTStore.kt\norg/gnit/lucenekmp/util/fst/OnHeapFSTStore\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,69:1\n1#2:70\n*E\n"})
public final class OnHeapFSTStore
implements FSTReader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ReadWriteDataOutput dataOutput;
    @Nullable
    private final byte[] bytesArray;
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.Companion.shallowSizeOfInstance(Reflection.getOrCreateKotlinClass(OnHeapFSTStore.class));

    public OnHeapFSTStore(int maxBlockBits, @NotNull DataInput in, long numBytes) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        if (!(maxBlockBits >= 1 && maxBlockBits <= 30)) {
            boolean bl = false;
            String string = "maxBlockBits should be 1 .. 30; got " + maxBlockBits;
            throw new IllegalArgumentException(string.toString());
        }
        if (numBytes > (long)(1 << maxBlockBits)) {
            DataOutput dataOutput = FSTCompiler.Companion.getOnHeapReaderWriter(maxBlockBits);
            Intrinsics.checkNotNull((Object)dataOutput, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.util.fst.ReadWriteDataOutput");
            ReadWriteDataOutput readWriteDataOutput = this.dataOutput = (ReadWriteDataOutput)dataOutput;
            Intrinsics.checkNotNull((Object)readWriteDataOutput);
            readWriteDataOutput.copyBytes(in, numBytes);
            ReadWriteDataOutput readWriteDataOutput2 = this.dataOutput;
            Intrinsics.checkNotNull((Object)readWriteDataOutput2);
            readWriteDataOutput2.freeze();
            this.bytesArray = null;
        } else {
            this.bytesArray = new byte[(int)numBytes];
            in.readBytes(this.bytesArray, 0, this.bytesArray.length);
        }
    }

    @Override
    public long ramBytesUsed() {
        long l;
        long size2 = BASE_RAM_BYTES_USED;
        if (this.bytesArray != null) {
            l = this.bytesArray.length;
        } else {
            ReadWriteDataOutput readWriteDataOutput = this.dataOutput;
            Intrinsics.checkNotNull((Object)readWriteDataOutput);
            l = readWriteDataOutput.ramBytesUsed();
        }
        return size2 += l;
    }

    @Override
    @NotNull
    public FST.BytesReader getReverseBytesReader() {
        FST.BytesReader bytesReader;
        if (this.bytesArray != null) {
            bytesReader = new ReverseBytesReader(this.bytesArray);
        } else {
            ReadWriteDataOutput readWriteDataOutput = this.dataOutput;
            Intrinsics.checkNotNull((Object)readWriteDataOutput);
            bytesReader = readWriteDataOutput.getReverseBytesReader();
        }
        return bytesReader;
    }

    @Override
    public void writeTo(@NotNull DataOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        if (this.dataOutput != null) {
            ReadWriteDataOutput readWriteDataOutput = this.dataOutput;
            Intrinsics.checkNotNull((Object)readWriteDataOutput);
            readWriteDataOutput.writeTo(out);
        } else {
            byte[] byArray = this.bytesArray;
            if (this.bytesArray == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            out.writeBytes(this.bytesArray, 0, this.bytesArray.length);
        }
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return FSTReader.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/fst/OnHeapFSTStore$Companion;", "", "<init>", "()V", "BASE_RAM_BYTES_USED", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

