/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.fst;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.CharsKt;
import org.gnit.lucenekmp.internal.hppc.IntArrayList;
import org.gnit.lucenekmp.internal.hppc.IntCursor;
import org.gnit.lucenekmp.jdkport.BitSet;
import org.gnit.lucenekmp.jdkport.Character;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.TreeSet;
import org.gnit.lucenekmp.jdkport.Writer;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.gnit.lucenekmp.util.IntsRef;
import org.gnit.lucenekmp.util.IntsRefBuilder;
import org.gnit.lucenekmp.util.fst.FST;
import org.gnit.lucenekmp.util.fst.Outputs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0005:;<=>B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J)\u0010\u0004\u001a\u0004\u0018\u0001H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ)\u0010\u0004\u001a\u0004\u0018\u0001H\u0005\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\b\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJc\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000e\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00102\u0006\u0010\u0011\u001a\u0002H\u00052\u0016\u0010\u0012\u001a\u0012\u0012\u0004\u0012\u0002H\u00050\u0013j\b\u0012\u0004\u0012\u0002H\u0005`\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\u0002\u0010\u0019J2\u0010\u001a\u001a\u00020\u001b\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u0018J6\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\"2\b\u0010$\u001a\u0004\u0018\u00010\"2\b\u0010%\u001a\u0004\u0018\u00010\"H\u0002J\u0010\u0010&\u001a\u00020\"2\u0006\u0010%\u001a\u00020\u0016H\u0002J\u0016\u0010'\u001a\u00020\t2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J\u0016\u0010,\u001a\u00020\t2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+J&\u0010,\u001a\u00020\t2\u0006\u0010(\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00162\u0006\u0010/\u001a\u00020\u00162\u0006\u0010*\u001a\u00020+J\u0016\u00100\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020+J\u0016\u00101\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010*\u001a\u000202JN\u00103\u001a\n\u0012\u0004\u0012\u0002H\u0005\u0018\u00010\u0010\"\u0004\b\u0000\u0010\u00052\u0006\u0010%\u001a\u00020\u00162\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u00104\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00102\f\u00105\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00102\u0006\u00106\u001a\u000207J0\u00108\u001a\u00020\u0016\"\u0004\b\u0000\u0010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00072\f\u00105\u001a\b\u0012\u0004\u0012\u0002H\u00050\u00102\u0006\u00109\u001a\u00020\u0016\u00a8\u0006?"}, d2={"Lorg/gnit/lucenekmp/util/fst/Util;", "", "<init>", "()V", "get", "T", "fst", "Lorg/gnit/lucenekmp/util/fst/FST;", "input", "Lorg/gnit/lucenekmp/util/IntsRef;", "(Lorg/gnit/lucenekmp/util/fst/FST;Lorg/gnit/lucenekmp/util/IntsRef;)Ljava/lang/Object;", "Lorg/gnit/lucenekmp/util/BytesRef;", "(Lorg/gnit/lucenekmp/util/fst/FST;Lorg/gnit/lucenekmp/util/BytesRef;)Ljava/lang/Object;", "shortestPaths", "Lorg/gnit/lucenekmp/util/fst/Util$TopResults;", "fromNode", "Lorg/gnit/lucenekmp/util/fst/FST$Arc;", "startOutput", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "topN", "", "allowEmptyString", "", "(Lorg/gnit/lucenekmp/util/fst/FST;Lorg/gnit/lucenekmp/util/fst/FST$Arc;Ljava/lang/Object;Ljava/util/Comparator;IZ)Lorg/gnit/lucenekmp/util/fst/Util$TopResults;", "toDot", "", "out", "Lorg/gnit/lucenekmp/jdkport/Writer;", "sameRank", "labelStates", "emitDotState", "name", "", "shape", "color", "label", "printableLabel", "toUTF16", "s", "", "scratch", "Lorg/gnit/lucenekmp/util/IntsRefBuilder;", "toUTF32", "", "offset", "length", "toIntsRef", "toBytesRef", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "readCeilArc", "follow", "arc", "in", "Lorg/gnit/lucenekmp/util/fst/FST$BytesReader;", "binarySearch", "targetLabel", "FSTPath", "TieBreakByInputComparator", "TopNSearcher", "Result", "TopResults", "core"})
@SourceDebugExtension(value={"SMAP\nUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Util.kt\norg/gnit/lucenekmp/util/fst/Util\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,876:1\n1#2:877\n*E\n"})
public final class Util {
    @NotNull
    public static final Util INSTANCE = new Util();

    private Util() {
    }

    @Nullable
    public final <T> T get(@NotNull FST<T> fst, @NotNull IntsRef input) throws IOException {
        T t;
        Intrinsics.checkNotNullParameter(fst, (String)"fst");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        FST.Arc<T> arc = fst.getFirstArc(new FST.Arc());
        FST.BytesReader fstReader = fst.getBytesReader();
        T output = fst.getOutputs().getNoOutput();
        int n = input.getLength();
        for (int i = 0; i < n; ++i) {
            if (fst.findTargetArc(input.getInts()[input.getOffset() + i], arc, arc, fstReader) == null) {
                return null;
            }
            Outputs<T> outputs = fst.getOutputs();
            T t2 = arc.output();
            Intrinsics.checkNotNull(t2);
            output = outputs.add(output, t2);
        }
        if (arc.isFinal()) {
            Outputs<T> outputs = fst.getOutputs();
            T t3 = arc.nextFinalOutput();
            Intrinsics.checkNotNull(t3);
            t = outputs.add(output, t3);
        } else {
            t = null;
        }
        return t;
    }

    @Nullable
    public final <T> T get(@NotNull FST<T> fst, @NotNull BytesRef input) throws IOException {
        T t;
        Intrinsics.checkNotNullParameter(fst, (String)"fst");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!(fst.getMetadata().getInputType() == FST.INPUT_TYPE.BYTE1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        FST.BytesReader fstReader = fst.getBytesReader();
        FST.Arc<T> arc = fst.getFirstArc(new FST.Arc());
        T output = fst.getOutputs().getNoOutput();
        int n = input.getLength();
        for (int i = 0; i < n; ++i) {
            if (fst.findTargetArc((byte)(input.getBytes()[i + input.getOffset()] & 0xFFFFFFFF), arc, arc, fstReader) == null) {
                return null;
            }
            Outputs<T> outputs = fst.getOutputs();
            T t2 = arc.output();
            Intrinsics.checkNotNull(t2);
            output = outputs.add(output, t2);
        }
        if (arc.isFinal()) {
            Outputs<T> outputs = fst.getOutputs();
            T t3 = arc.nextFinalOutput();
            Intrinsics.checkNotNull(t3);
            t = outputs.add(output, t3);
        } else {
            t = null;
        }
        return t;
    }

    @NotNull
    public final <T> TopResults<T> shortestPaths(@NotNull FST<T> fst, @NotNull FST.Arc<T> fromNode, T startOutput, @NotNull Comparator<T> comparator2, int topN, boolean allowEmptyString) throws IOException {
        Intrinsics.checkNotNullParameter(fst, (String)"fst");
        Intrinsics.checkNotNullParameter(fromNode, (String)"fromNode");
        Intrinsics.checkNotNullParameter(comparator2, (String)"comparator");
        TopNSearcher<T> searcher = new TopNSearcher<T>(fst, topN, topN, comparator2);
        searcher.addStartPaths(fromNode, startOutput, allowEmptyString, new IntsRefBuilder());
        return searcher.search();
    }

    public final <T> void toDot(@NotNull FST<T> fst, @NotNull Writer out, boolean sameRank, boolean labelStates) throws IOException {
        Intrinsics.checkNotNullParameter(fst, (String)"fst");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        String expandedNodeColor = "blue";
        FST.Arc<T> startArc = fst.getFirstArc(new FST.Arc());
        List thisLevelQueue = new ArrayList();
        List nextLevelQueue = new ArrayList();
        nextLevelQueue.add(startArc);
        IntArrayList sameLevelStates = new IntArrayList();
        BitSet seen = new BitSet();
        seen.set((int)startArc.target());
        String stateShape = "circle";
        String finalStateShape = "doublecircle";
        out.write("digraph FST {\n");
        out.write("  rankdir = LR; splines=true; concentrate=true; ordering=out; ranksep=2.5; \n");
        if (!labelStates) {
            out.write("  node [shape=circle, width=.2, height=.2, style=filled]\n");
        }
        this.emitDotState(out, "initial", "point", "white", "");
        T NO_OUTPUT2 = fst.getOutputs().getNoOutput();
        FST.BytesReader r = fst.getBytesReader();
        Util $this$toDot_u24lambda_u240 = this;
        boolean bl = false;
        String stateColor = fst.isExpandedTarget(startArc, r) ? expandedNodeColor : null;
        boolean isFinal = false;
        String finalOutput = null;
        if (startArc.isFinal()) {
            isFinal = true;
            finalOutput = startArc.nextFinalOutput() == NO_OUTPUT2 ? null : (String)startArc.nextFinalOutput();
        } else {
            isFinal = false;
            finalOutput = null;
        }
        INSTANCE.emitDotState(out, String.valueOf(startArc.target()), isFinal ? finalStateShape : stateShape, stateColor, finalOutput == null ? "" : fst.getOutputs().outputToString(finalOutput));
        out.write("  initial -> " + startArc.target() + "\n");
        int level = 0;
        while (!nextLevelQueue.isEmpty()) {
            thisLevelQueue.addAll(nextLevelQueue);
            nextLevelQueue.clear();
            out.write("\n  // Transitions and states at level: " + ++level + "\n");
            block1: while (!thisLevelQueue.isEmpty()) {
                FST.Arc arc = (FST.Arc)thisLevelQueue.remove(thisLevelQueue.size() - 1);
                if (!FST.Companion.targetHasArcs(arc)) continue;
                long node = arc.target();
                fst.readFirstRealTargetArc(arc.target(), arc, r);
                while (true) {
                    if (arc.target() >= 0L && !seen.get((int)arc.target())) {
                        String string;
                        String stateColor2;
                        String string2 = stateColor2 = fst.isExpandedTarget(arc, r) ? expandedNodeColor : null;
                        if (arc.nextFinalOutput() != null && arc.nextFinalOutput() != NO_OUTPUT2) {
                            Outputs outputs = fst.getOutputs();
                            Object t = arc.nextFinalOutput();
                            Intrinsics.checkNotNull(t);
                            string = outputs.outputToString(t);
                        } else {
                            string = "";
                        }
                        finalOutput = string;
                        this.emitDotState(out, String.valueOf(arc.target()), stateShape, stateColor2, finalOutput);
                        seen.set((int)arc.target());
                        nextLevelQueue.add(new FST.Arc().copyFrom(arc));
                        sameLevelStates.add((int)arc.target());
                    }
                    Object outs = null;
                    if (arc.output() != NO_OUTPUT2) {
                        Outputs outputs = fst.getOutputs();
                        Object t = arc.output();
                        Intrinsics.checkNotNull(t);
                        v6 = "/" + outputs.outputToString(t);
                    } else {
                        v6 = outs = "";
                    }
                    if (!FST.Companion.targetHasArcs(arc) && arc.isFinal() && arc.nextFinalOutput() != NO_OUTPUT2) {
                        Outputs outputs = fst.getOutputs();
                        Object t = arc.nextFinalOutput();
                        Intrinsics.checkNotNull(t);
                        outs = (String)outs + "/[" + outputs.outputToString(t) + "]";
                    }
                    String arcColor = arc.flag(4) ? "red" : "black";
                    if (!(arc.label() != -1)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    out.write("  " + node + " -> " + arc.target() + " [label=\"" + this.printableLabel(arc.label()) + (String)outs + "\"" + (arc.isFinal() ? " style=\"bold\"" : "") + " color=\"" + arcColor + "\"]\n");
                    if (arc.isLast()) continue block1;
                    fst.readNextRealArc(arc, r);
                }
            }
            if (sameRank && sameLevelStates.size() > 1) {
                out.write("  {rank=same; ");
                for (IntCursor state2 : sameLevelStates) {
                    out.write(state2.getValue() + "; ");
                }
                out.write(" }\n");
            }
            sameLevelStates.clear();
        }
        out.write("  -1 [style=filled, color=black, shape=doublecircle, label=\"\"]\n\n");
        out.write("  {rank=sink; -1 }\n");
        out.write("}\n");
        out.flush();
    }

    private final void emitDotState(Writer out, String name, String shape, String color, String label) throws IOException {
        String string = shape;
        String string2 = color;
        String string3 = label;
        out.write("  " + name + " [" + (String)(string != null ? "shape=" + string : "") + " " + (String)(string2 != null ? "color=" + string2 : "") + " " + (String)(string3 != null ? "label=\"" + string3 + "\"" : "label=\"\"") + " ]\n");
    }

    private final String printableLabel(int label) {
        if (label >= 32 && label <= 125 && label != 34 && label != 92) {
            return String.valueOf((char)label);
        }
        return "0x" + IntExtKt.toHexString(IntCompanionObject.INSTANCE, label);
    }

    @NotNull
    public final IntsRef toUTF16(@NotNull CharSequence s, @NotNull IntsRefBuilder scratch) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)scratch, (String)"scratch");
        int charLimit = s.length();
        scratch.setLength(charLimit);
        scratch.growNoCopy(charLimit);
        for (int idx = 0; idx < charLimit; ++idx) {
            scratch.setIntAt(idx, CharsKt.digitToInt((char)s.charAt(idx)));
        }
        return scratch.get();
    }

    @NotNull
    public final IntsRef toUTF32(@NotNull CharSequence s, @NotNull IntsRefBuilder scratch) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)scratch, (String)"scratch");
        int charIdx = 0;
        int intIdx = 0;
        int charLimit = s.length();
        while (charIdx < charLimit) {
            scratch.grow(intIdx + 1);
            int utf32 = Character.Companion.codePointAt(s, charIdx);
            scratch.setIntAt(intIdx, utf32);
            charIdx += Character.Companion.charCount(utf32);
            ++intIdx;
        }
        scratch.setLength(intIdx);
        return scratch.get();
    }

    @NotNull
    public final IntsRef toUTF32(@NotNull char[] s, int offset, int length, @NotNull IntsRefBuilder scratch) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        Intrinsics.checkNotNullParameter((Object)scratch, (String)"scratch");
        int charIdx = offset;
        int intIdx = 0;
        int charLimit = offset + length;
        while (charIdx < charLimit) {
            scratch.grow(intIdx + 1);
            int utf32 = Character.Companion.codePointAt(s, charIdx, charLimit);
            scratch.setIntAt(intIdx, utf32);
            charIdx += Character.Companion.charCount(utf32);
            ++intIdx;
        }
        scratch.setLength(intIdx);
        return scratch.get();
    }

    @NotNull
    public final IntsRef toIntsRef(@NotNull BytesRef input, @NotNull IntsRefBuilder scratch) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)scratch, (String)"scratch");
        scratch.growNoCopy(input.getLength());
        int n = input.getLength();
        for (int i = 0; i < n; ++i) {
            int value = input.getBytes()[i + input.getOffset()] & 0xFF;
            scratch.setIntAt(i, value);
        }
        scratch.setLength(input.getLength());
        return scratch.get();
    }

    @NotNull
    public final BytesRef toBytesRef(@NotNull IntsRef input, @NotNull BytesRefBuilder scratch) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)scratch, (String)"scratch");
        scratch.growNoCopy(input.getLength());
        int n = input.getLength();
        for (int i = 0; i < n; ++i) {
            int value = input.getInts()[i + input.getOffset()];
            if (!(value >= -128 && value <= 255)) {
                boolean bl = false;
                String string = "value " + value + " doesn't fit into byte";
                throw new IllegalArgumentException(string.toString());
            }
            scratch.setByteAt(i, (byte)value);
        }
        scratch.setLength(input.getLength());
        return scratch.get();
    }

    @Nullable
    public final <T> FST.Arc<T> readCeilArc(int label, @NotNull FST<T> fst, @NotNull FST.Arc<T> follow, @NotNull FST.Arc<T> arc, @NotNull FST.BytesReader in) throws IOException {
        Intrinsics.checkNotNullParameter(fst, (String)"fst");
        Intrinsics.checkNotNullParameter(follow, (String)"follow");
        Intrinsics.checkNotNullParameter(arc, (String)"arc");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        if (label == -1) {
            return FST.Companion.readEndArc(follow, arc);
        }
        if (!FST.Companion.targetHasArcs(follow)) {
            return null;
        }
        fst.readFirstTargetArc(follow, arc, in);
        if (arc.bytesPerArc() != 0 && arc.label() != -1) {
            if (arc.nodeFlags() == 64) {
                int targetIndex = label - arc.label();
                if (targetIndex >= arc.numArcs()) {
                    return null;
                }
                if (targetIndex < 0) {
                    return arc;
                }
                if (FST.Arc.BitTable.INSTANCE.isBitSet(targetIndex, arc, in)) {
                    fst.readArcByDirectAddressing(arc, in, targetIndex);
                    if (!(arc.label() == label)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                } else {
                    int ceilIndex = FST.Arc.BitTable.INSTANCE.nextBitSet(targetIndex, arc, in);
                    if (!(ceilIndex != -1)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    fst.readArcByDirectAddressing(arc, in, ceilIndex);
                    if (!(arc.label() > label)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                }
                return arc;
            }
            if (arc.nodeFlags() == 96) {
                int targetIndex = label - arc.label();
                if (targetIndex >= arc.numArcs()) {
                    return null;
                }
                if (targetIndex < 0) {
                    return arc;
                }
                fst.readArcByContinuous(arc, in, targetIndex);
                if (!(arc.label() == label)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                return arc;
            }
            int idx = this.binarySearch(fst, arc, label);
            if (idx >= 0) {
                return fst.readArcByIndex(arc, in, idx);
            }
            if ((idx = -1 - idx) == arc.numArcs()) {
                return null;
            }
            return fst.readArcByIndex(arc, in, idx);
        }
        fst.readFirstRealTargetArc(follow.target(), arc, in);
        while (arc.label() < label) {
            if (arc.isLast()) {
                return null;
            }
            fst.readNextRealArc(arc, in);
        }
        return arc;
    }

    public final <T> int binarySearch(@NotNull FST<T> fst, @NotNull FST.Arc<T> arc, int targetLabel) throws IOException {
        Intrinsics.checkNotNullParameter(fst, (String)"fst");
        Intrinsics.checkNotNullParameter(arc, (String)"arc");
        if (!(arc.nodeFlags() == 32)) {
            boolean $i$a$-require-Util$binarySearch$22 = false;
            String $i$a$-require-Util$binarySearch$22 = "Arc is not encoded as packed array for binary search (nodeFlags=" + arc.nodeFlags() + ")";
            throw new IllegalArgumentException($i$a$-require-Util$binarySearch$22.toString());
        }
        FST.BytesReader in = fst.getBytesReader();
        int low = arc.arcIdx();
        int mid = 0;
        int high = arc.numArcs() - 1;
        while (low <= high) {
            mid = low + high >>> 1;
            in.setPosition(arc.posArcsStart());
            in.skipBytes((long)arc.bytesPerArc() * (long)mid + 1L);
            int midLabel = fst.readLabel(in);
            int cmp = midLabel - targetLabel;
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1 - low;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002BA\b\u0000\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0006\u0010\u0003\u001a\u00028\u00002\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020&H\u0016R\u001c\u0010\u0003\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0014\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"\u00a8\u0006'"}, d2={"Lorg/gnit/lucenekmp/util/fst/Util$FSTPath;", "T", "", "output", "arc", "Lorg/gnit/lucenekmp/util/fst/FST$Arc;", "input", "Lorg/gnit/lucenekmp/util/IntsRefBuilder;", "boost", "", "context", "", "payload", "", "<init>", "(Ljava/lang/Object;Lorg/gnit/lucenekmp/util/fst/FST$Arc;Lorg/gnit/lucenekmp/util/IntsRefBuilder;FLjava/lang/CharSequence;I)V", "getOutput", "()Ljava/lang/Object;", "setOutput", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getInput", "()Lorg/gnit/lucenekmp/util/IntsRefBuilder;", "getBoost", "()F", "getContext", "()Ljava/lang/CharSequence;", "getPayload", "()I", "setPayload", "(I)V", "getArc", "()Lorg/gnit/lucenekmp/util/fst/FST$Arc;", "setArc", "(Lorg/gnit/lucenekmp/util/fst/FST$Arc;)V", "newPath", "(Ljava/lang/Object;Lorg/gnit/lucenekmp/util/IntsRefBuilder;)Lorg/gnit/lucenekmp/util/fst/Util$FSTPath;", "toString", "", "core"})
    public static final class FSTPath<T> {
        private T output;
        @NotNull
        private final IntsRefBuilder input;
        private final float boost;
        @Nullable
        private final CharSequence context;
        private int payload;
        @NotNull
        private FST.Arc<T> arc;

        public FSTPath(T output, @NotNull FST.Arc<T> arc, @NotNull IntsRefBuilder input, float boost, @Nullable CharSequence context, int payload) {
            Intrinsics.checkNotNullParameter(arc, (String)"arc");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            this.output = output;
            this.input = input;
            this.boost = boost;
            this.context = context;
            this.payload = payload;
            this.arc = new FST.Arc<T>().copyFrom(arc);
        }

        public final T getOutput() {
            return this.output;
        }

        public final void setOutput(T t) {
            this.output = t;
        }

        @NotNull
        public final IntsRefBuilder getInput() {
            return this.input;
        }

        public final float getBoost() {
            return this.boost;
        }

        @Nullable
        public final CharSequence getContext() {
            return this.context;
        }

        public final int getPayload() {
            return this.payload;
        }

        public final void setPayload(int n) {
            this.payload = n;
        }

        @NotNull
        public final FST.Arc<T> getArc() {
            return this.arc;
        }

        public final void setArc(@NotNull FST.Arc<T> arc) {
            Intrinsics.checkNotNullParameter(arc, (String)"<set-?>");
            this.arc = arc;
        }

        @NotNull
        public final FSTPath<T> newPath(T output, @NotNull IntsRefBuilder input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return new FSTPath<T>(output, this.arc, input, this.boost, this.context, this.payload);
        }

        @NotNull
        public String toString() {
            return "input=" + this.input.get() + " output=" + this.output + " context=" + this.context + " boost=" + this.boost + " payload=" + this.payload;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/gnit/lucenekmp/util/fst/Util$Result;", "T", "", "input", "Lorg/gnit/lucenekmp/util/IntsRef;", "output", "<init>", "(Lorg/gnit/lucenekmp/util/IntsRef;Ljava/lang/Object;)V", "getInput", "()Lorg/gnit/lucenekmp/util/IntsRef;", "getOutput", "()Ljava/lang/Object;", "Ljava/lang/Object;", "core"})
    public static final class Result<T> {
        @NotNull
        private final IntsRef input;
        private final T output;

        public Result(@NotNull IntsRef input, T output) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            this.input = input;
            this.output = output;
        }

        @NotNull
        public final IntsRef getInput() {
            return this.input;
        }

        public final T getOutput() {
            return this.output;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0003`\u0004B\u001f\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0002j\b\u0012\u0004\u0012\u00028\u0000`\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00032\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003H\u0016J\u0019\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0002j\b\u0012\u0004\u0012\u00028\u0000`\u0004H\u00c6\u0003J)\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\u0018\b\u0002\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0002j\b\u0012\u0004\u0012\u00028\u0000`\u0004H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R!\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u0002j\b\u0012\u0004\u0012\u00028\u0000`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/util/fst/Util$TieBreakByInputComparator;", "T", "Ljava/util/Comparator;", "Lorg/gnit/lucenekmp/util/fst/Util$FSTPath;", "Lkotlin/Comparator;", "comparator", "<init>", "(Ljava/util/Comparator;)V", "getComparator", "()Ljava/util/Comparator;", "compare", "", "a", "b", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "", "core"})
    private static final class TieBreakByInputComparator<T>
    implements Comparator<FSTPath<T>> {
        @NotNull
        private final Comparator<T> comparator;

        public TieBreakByInputComparator(@NotNull Comparator<T> comparator2) {
            Intrinsics.checkNotNullParameter(comparator2, (String)"comparator");
            this.comparator = comparator2;
        }

        @NotNull
        public final Comparator<T> getComparator() {
            return this.comparator;
        }

        @Override
        public int compare(@NotNull FSTPath<T> a, @NotNull FSTPath<T> b) {
            Intrinsics.checkNotNullParameter(a, (String)"a");
            Intrinsics.checkNotNullParameter(b, (String)"b");
            int cmp = this.comparator.compare(a.getOutput(), b.getOutput());
            return cmp == 0 ? a.getInput().get().compareTo(b.getInput().get()) : cmp;
        }

        @NotNull
        public final Comparator<T> component1() {
            return this.comparator;
        }

        @NotNull
        public final TieBreakByInputComparator<T> copy(@NotNull Comparator<T> comparator2) {
            Intrinsics.checkNotNullParameter(comparator2, (String)"comparator");
            return new TieBreakByInputComparator<T>(comparator2);
        }

        public static /* synthetic */ TieBreakByInputComparator copy$default(TieBreakByInputComparator tieBreakByInputComparator, Comparator comparator2, int n, Object object) {
            if ((n & 1) != 0) {
                comparator2 = tieBreakByInputComparator.comparator;
            }
            return tieBreakByInputComparator.copy(comparator2);
        }

        @NotNull
        public String toString() {
            return "TieBreakByInputComparator(comparator=" + this.comparator + ")";
        }

        public int hashCode() {
            return this.comparator.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TieBreakByInputComparator)) {
                return false;
            }
            TieBreakByInputComparator tieBreakByInputComparator = (TieBreakByInputComparator)other;
            return Intrinsics.areEqual(this.comparator, tieBreakByInputComparator.comparator);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002Ba\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00028\u00000\tj\b\u0012\u0004\u0012\u00028\u0000`\n\u0012\"\u0010\u000b\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\tj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f`\n\u00a2\u0006\u0004\b\r\u0010\u000eB?\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00028\u00000\tj\b\u0012\u0004\u0012\u00028\u0000`\n\u00a2\u0006\u0004\b\r\u0010\u000fJ\u0016\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0004J1\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u001f\u001a\u00028\u00002\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#\u00a2\u0006\u0002\u0010$JK\u0010\u001d\u001a\u00020\u001b2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00132\u0006\u0010\u001f\u001a\u00028\u00002\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020\u0006\u00a2\u0006\u0002\u0010*J\f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000,J\u0016\u0010-\u001a\u00020!2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0004J\u0016\u0010.\u001a\u00020!2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0004J\u001d\u0010-\u001a\u00020!2\u0006\u0010\"\u001a\u00020/2\u0006\u00100\u001a\u00028\u0000H\u0004\u00a2\u0006\u0002\u00101R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00028\u00000\tj\b\u0012\u0004\u0012\u00028\u0000`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000b\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\tj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00000\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0014\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u00062"}, d2={"Lorg/gnit/lucenekmp/util/fst/Util$TopNSearcher;", "T", "", "fst", "Lorg/gnit/lucenekmp/util/fst/FST;", "topN", "", "maxQueueDepth", "comparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "pathComparator", "Lorg/gnit/lucenekmp/util/fst/Util$FSTPath;", "<init>", "(Lorg/gnit/lucenekmp/util/fst/FST;IILjava/util/Comparator;Ljava/util/Comparator;)V", "(Lorg/gnit/lucenekmp/util/fst/FST;IILjava/util/Comparator;)V", "bytesReader", "Lorg/gnit/lucenekmp/util/fst/FST$BytesReader;", "scratchArc", "Lorg/gnit/lucenekmp/util/fst/FST$Arc;", "queue", "Lorg/gnit/lucenekmp/jdkport/TreeSet;", "getQueue", "()Lorg/gnit/lucenekmp/jdkport/TreeSet;", "setQueue", "(Lorg/gnit/lucenekmp/jdkport/TreeSet;)V", "addIfCompetitive", "", "path", "addStartPaths", "node", "startOutput", "allowEmptyString", "", "input", "Lorg/gnit/lucenekmp/util/IntsRefBuilder;", "(Lorg/gnit/lucenekmp/util/fst/FST$Arc;Ljava/lang/Object;ZLorg/gnit/lucenekmp/util/IntsRefBuilder;)V", "boost", "", "context", "", "payload", "(Lorg/gnit/lucenekmp/util/fst/FST$Arc;Ljava/lang/Object;ZLorg/gnit/lucenekmp/util/IntsRefBuilder;FLjava/lang/CharSequence;I)V", "search", "Lorg/gnit/lucenekmp/util/fst/Util$TopResults;", "acceptResult", "acceptPartialPath", "Lorg/gnit/lucenekmp/util/IntsRef;", "output", "(Lorg/gnit/lucenekmp/util/IntsRef;Ljava/lang/Object;)Z", "core"})
    public static class TopNSearcher<T> {
        @NotNull
        private final FST<T> fst;
        private final int topN;
        private final int maxQueueDepth;
        @NotNull
        private final Comparator<T> comparator;
        @NotNull
        private final Comparator<FSTPath<T>> pathComparator;
        @NotNull
        private final FST.BytesReader bytesReader;
        @NotNull
        private final FST.Arc<T> scratchArc;
        @Nullable
        private TreeSet<FSTPath<T>> queue;

        public TopNSearcher(@NotNull FST<T> fst, int topN, int maxQueueDepth, @NotNull Comparator<T> comparator2, @NotNull Comparator<FSTPath<T>> pathComparator) {
            Intrinsics.checkNotNullParameter(fst, (String)"fst");
            Intrinsics.checkNotNullParameter(comparator2, (String)"comparator");
            Intrinsics.checkNotNullParameter(pathComparator, (String)"pathComparator");
            this.fst = fst;
            this.topN = topN;
            this.maxQueueDepth = maxQueueDepth;
            this.comparator = comparator2;
            this.pathComparator = pathComparator;
            this.bytesReader = this.fst.getBytesReader();
            this.scratchArc = new FST.Arc();
            this.queue = new TreeSet<FSTPath<T>>(this.pathComparator);
        }

        @Nullable
        public final TreeSet<FSTPath<T>> getQueue() {
            return this.queue;
        }

        public final void setQueue(@Nullable TreeSet<FSTPath<T>> treeSet) {
            this.queue = treeSet;
        }

        public TopNSearcher(@NotNull FST<T> fst, int topN, int maxQueueDepth, @NotNull Comparator<T> comparator2) {
            Intrinsics.checkNotNullParameter(fst, (String)"fst");
            Intrinsics.checkNotNullParameter(comparator2, (String)"comparator");
            this(fst, topN, maxQueueDepth, comparator2, new TieBreakByInputComparator<T>(comparator2));
        }

        protected final void addIfCompetitive(@NotNull FSTPath<T> path) {
            Intrinsics.checkNotNullParameter(path, (String)"path");
            if (this.queue == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            Outputs<T> outputs = this.fst.getOutputs();
            T t = path.getOutput();
            T t2 = path.getArc().output();
            Intrinsics.checkNotNull(t2);
            T output = outputs.add(t, t2);
            TreeSet<FSTPath<T>> treeSet = this.queue;
            Intrinsics.checkNotNull(treeSet);
            if (treeSet.size() == this.maxQueueDepth) {
                TreeSet<FSTPath<T>> treeSet2 = this.queue;
                Intrinsics.checkNotNull(treeSet2);
                FSTPath<T> bottom = treeSet2.last();
                int comp = this.pathComparator.compare(path, bottom);
                if (comp > 0) {
                    return;
                }
                if (comp == 0) {
                    path.getInput().append(path.getArc().label());
                    int cmp = bottom.getInput().get().compareTo(path.getInput().get());
                    path.getInput().setLength(path.getInput().length() - 1);
                    if (!(cmp != 0)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (cmp < 0) {
                        return;
                    }
                }
            }
            IntsRefBuilder newInput = new IntsRefBuilder();
            newInput.copyInts(path.getInput().get());
            newInput.append(path.getArc().label());
            FSTPath<T> newPath = path.newPath(output, newInput);
            if (this.acceptPartialPath(newPath)) {
                TreeSet<FSTPath<T>> treeSet3 = this.queue;
                Intrinsics.checkNotNull(treeSet3);
                treeSet3.add(newPath);
                TreeSet<FSTPath<T>> treeSet4 = this.queue;
                Intrinsics.checkNotNull(treeSet4);
                if (treeSet4.size() == this.maxQueueDepth + 1) {
                    TreeSet<FSTPath<T>> treeSet5 = this.queue;
                    Intrinsics.checkNotNull(treeSet5);
                    treeSet5.pollLast();
                }
            }
        }

        public final void addStartPaths(@NotNull FST.Arc<T> node, T startOutput, boolean allowEmptyString, @NotNull IntsRefBuilder input) throws IOException {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            this.addStartPaths(node, startOutput, allowEmptyString, input, 0.0f, null, -1);
        }

        public final void addStartPaths(@NotNull FST.Arc<T> node, T startOutput, boolean allowEmptyString, @NotNull IntsRefBuilder input, float boost, @Nullable CharSequence context, int payload) throws IOException {
            Intrinsics.checkNotNullParameter(node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            T startOutput2 = startOutput;
            if (Intrinsics.areEqual(startOutput2, this.fst.getOutputs().getNoOutput())) {
                startOutput2 = this.fst.getOutputs().getNoOutput();
            }
            FSTPath<T> path = new FSTPath<T>(startOutput2, node, input, boost, context, payload);
            this.fst.readFirstTargetArc(node, path.getArc(), this.bytesReader);
            while (true) {
                if (allowEmptyString || path.getArc().label() != -1) {
                    this.addIfCompetitive(path);
                }
                if (path.getArc().isLast()) break;
                this.fst.readNextArc(path.getArc(), this.bytesReader);
            }
        }

        @NotNull
        public final TopResults<T> search() throws IOException {
            List results2 = new ArrayList();
            FST.BytesReader fstReader = this.fst.getBytesReader();
            T NO_OUTPUT2 = this.fst.getOutputs().getNoOutput();
            int rejectCount = 0;
            block0: while (results2.size() < this.topN && this.queue != null) {
                TreeSet<FSTPath<T>> treeSet = this.queue;
                Intrinsics.checkNotNull(treeSet);
                FSTPath<T> path = treeSet.pollFirst();
                if (path == null) break;
                if (!this.acceptPartialPath(path)) continue;
                if (path.getArc().label() == -1) {
                    path.getInput().setLength(path.getInput().length() - 1);
                    results2.add(new Result<T>(path.getInput().get(), path.getOutput()));
                    continue;
                }
                if (results2.size() == this.topN - 1 && this.maxQueueDepth == this.topN) {
                    this.queue = null;
                }
                do {
                    this.fst.readFirstTargetArc(path.getArc(), path.getArc(), fstReader);
                    boolean foundZero = false;
                    boolean arcCopyIsPending = false;
                    while (true) {
                        T t = path.getArc().output();
                        Intrinsics.checkNotNull(t);
                        if (this.comparator.compare(NO_OUTPUT2, t) == 0) {
                            if (this.queue == null) {
                                foundZero = true;
                                break;
                            }
                            if (!foundZero) {
                                arcCopyIsPending = true;
                                foundZero = true;
                            } else {
                                this.addIfCompetitive(path);
                            }
                        } else if (this.queue != null) {
                            this.addIfCompetitive(path);
                        }
                        if (path.getArc().isLast()) break;
                        if (arcCopyIsPending) {
                            this.scratchArc.copyFrom(path.getArc());
                            arcCopyIsPending = false;
                        }
                        this.fst.readNextArc(path.getArc(), fstReader);
                    }
                    if (!foundZero) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (this.queue != null && !arcCopyIsPending) {
                        path.getArc().copyFrom(this.scratchArc);
                    }
                    if (path.getArc().label() == -1) {
                        Outputs<T> outputs = this.fst.getOutputs();
                        T t = path.getOutput();
                        T t2 = path.getArc().output();
                        Intrinsics.checkNotNull(t2);
                        path.setOutput(outputs.add(t, t2));
                        if (this.acceptResult(path)) {
                            results2.add(new Result<T>(path.getInput().get(), path.getOutput()));
                            continue block0;
                        }
                        ++rejectCount;
                        continue block0;
                    }
                    path.getInput().append(path.getArc().label());
                    Outputs<T> outputs = this.fst.getOutputs();
                    T t = path.getOutput();
                    T t3 = path.getArc().output();
                    Intrinsics.checkNotNull(t3);
                    path.setOutput(outputs.add(t, t3));
                } while (this.acceptPartialPath(path));
            }
            return new TopResults(rejectCount + this.topN <= this.maxQueueDepth, results2);
        }

        protected final boolean acceptResult(@NotNull FSTPath<T> path) {
            Intrinsics.checkNotNullParameter(path, (String)"path");
            return this.acceptResult(path.getInput().get(), path.getOutput());
        }

        protected final boolean acceptPartialPath(@NotNull FSTPath<T> path) {
            Intrinsics.checkNotNullParameter(path, (String)"path");
            return true;
        }

        protected final boolean acceptResult(@NotNull IntsRef input, T output) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            return true;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0010)\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00030\u0002B%\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u000eH\u0096\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00030\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/util/fst/Util$TopResults;", "T", "", "Lorg/gnit/lucenekmp/util/fst/Util$Result;", "isComplete", "", "topN", "", "<init>", "(ZLjava/util/List;)V", "()Z", "getTopN", "()Ljava/util/List;", "iterator", "", "core"})
    public static final class TopResults<T>
    implements Iterable<Result<T>>,
    KMappedMarker {
        private final boolean isComplete;
        @NotNull
        private final List<Result<T>> topN;

        public TopResults(boolean isComplete, @NotNull List<Result<T>> topN) {
            Intrinsics.checkNotNullParameter(topN, (String)"topN");
            this.isComplete = isComplete;
            this.topN = topN;
        }

        public final boolean isComplete() {
            return this.isComplete;
        }

        @NotNull
        public final List<Result<T>> getTopN() {
            return this.topN;
        }

        @Override
        @NotNull
        public Iterator<Result<T>> iterator() {
            return this.topN.iterator();
        }
    }
}

