/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.hnsw;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.search.KnnCollector;
import org.gnit.lucenekmp.util.BitSet;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.SparseFixedBitSet;
import org.gnit.lucenekmp.util.hnsw.HnswGraph;
import org.gnit.lucenekmp.util.hnsw.HnswGraphSearcher;
import org.gnit.lucenekmp.util.hnsw.NeighborQueue;
import org.gnit.lucenekmp.util.hnsw.RandomVectorScorer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ:\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0002R\u000e\u0010\f\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/FilteredHnswGraphSearcher;", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraphSearcher;", "candidates", "Lorg/gnit/lucenekmp/util/hnsw/NeighborQueue;", "visited", "Lorg/gnit/lucenekmp/util/BitSet;", "filterSize", "", "graph", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraph;", "<init>", "(Lorg/gnit/lucenekmp/util/hnsw/NeighborQueue;Lorg/gnit/lucenekmp/util/BitSet;ILorg/gnit/lucenekmp/util/hnsw/HnswGraph;)V", "maxExplorationMultiplier", "minToScore", "searchLevel", "", "results", "Lorg/gnit/lucenekmp/search/KnnCollector;", "scorer", "Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorer;", "level", "eps", "", "acceptOrds", "Lorg/gnit/lucenekmp/util/Bits;", "prepareScratchState", "IntArrayQueue", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nFilteredHnswGraphSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilteredHnswGraphSearcher.kt\norg/gnit/lucenekmp/util/hnsw/FilteredHnswGraphSearcher\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n1#2:244\n*E\n"})
public final class FilteredHnswGraphSearcher
extends HnswGraphSearcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxExplorationMultiplier;
    private final int minToScore;
    private static final float EXPANDED_EXPLORATION_LAMBDA = 0.1f;

    private FilteredHnswGraphSearcher(NeighborQueue candidates, BitSet visited, int filterSize, HnswGraph graph) {
        super(candidates, visited);
        if (!(graph.maxConn() > 0)) {
            boolean bl = false;
            String string = "graph must have known max connections";
            throw new IllegalArgumentException(string.toString());
        }
        int filterRatio = filterSize / graph.size();
        this.maxExplorationMultiplier = Math.INSTANCE.round(java.lang.Math.min(1.0f / (float)filterRatio, (float)graph.maxConn() / 2.0f));
        this.minToScore = Math.INSTANCE.round(java.lang.Math.min(java.lang.Math.max(0.0f, 1.0f / (float)filterRatio - 2.0f * (float)graph.maxConn()), (float)graph.maxConn()));
    }

    @Override
    public void searchLevel(@NotNull KnnCollector results2, @NotNull RandomVectorScorer scorer2, int level, @NotNull int[] eps, @NotNull HnswGraph graph, @Nullable Bits acceptOrds) throws IOException {
        float topCandidateSimilarity;
        Intrinsics.checkNotNullParameter((Object)results2, (String)"results");
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        Intrinsics.checkNotNullParameter((Object)eps, (String)"eps");
        Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
        if (!(level == 0)) {
            boolean $i$a$-require-FilteredHnswGraphSearcher$searchLevel$22 = false;
            String $i$a$-require-FilteredHnswGraphSearcher$searchLevel$22 = "Filtered search only works on the base level";
            throw new IllegalArgumentException($i$a$-require-FilteredHnswGraphSearcher$searchLevel$22.toString());
        }
        int size2 = HnswGraphSearcher.Companion.getGraphSize(graph);
        this.prepareScratchState();
        for (int ep : eps) {
            if (this.getVisited().getAndSet(ep)) continue;
            if (results2.earlyTerminated()) {
                return;
            }
            float score2 = scorer2.score(ep);
            results2.incVisitedCount(1);
            this.getCandidates().add(ep, score2);
            Bits bits = acceptOrds;
            Intrinsics.checkNotNull((Object)bits);
            if (!bits.get(ep)) continue;
            results2.collect(ep, score2);
        }
        IntArrayQueue toScore = new IntArrayQueue(graph.maxConn() * 2 * this.maxExplorationMultiplier);
        IntArrayQueue toExplore = new IntArrayQueue(graph.maxConn() * 2 * this.maxExplorationMultiplier);
        float minAcceptedSimilarity = Math.INSTANCE.nextUp(results2.minCompetitiveSimilarity());
        block1: while (this.getCandidates().size() > 0 && !results2.earlyTerminated() && !(minAcceptedSimilarity > (topCandidateSimilarity = this.getCandidates().topScore()))) {
            int friendOfAFriendOrd;
            int it;
            int topCandidateNode = this.getCandidates().pop();
            graph.seek(level, topCandidateNode);
            int neighborCount = graph.neighborCount();
            toScore.clear();
            toExplore.clear();
            int friendOrd = 0;
            while (true) {
                int n;
                int it2 = n = graph.nextNeighbor();
                boolean bl = false;
                friendOrd = it2;
                if (n == Integer.MAX_VALUE || toScore.isFull()) break;
                if (!(friendOrd < size2)) {
                    boolean $i$a$-require-FilteredHnswGraphSearcher$searchLevel$42 = false;
                    String $i$a$-require-FilteredHnswGraphSearcher$searchLevel$42 = "friendOrd=" + friendOrd + "; size=" + size2;
                    throw new IllegalArgumentException($i$a$-require-FilteredHnswGraphSearcher$searchLevel$42.toString());
                }
                if (this.getVisited().getAndSet(friendOrd)) continue;
                Bits bits = acceptOrds;
                Intrinsics.checkNotNull((Object)bits);
                if (bits.get(friendOrd)) {
                    toScore.add(friendOrd);
                    continue;
                }
                toExplore.add(friendOrd);
            }
            float filteredAmount = (float)toExplore.count() / (float)neighborCount;
            int maxToScoreCount = (int)((float)neighborCount * java.lang.Math.min((float)this.maxExplorationMultiplier, 1.0f / (1.0f - filteredAmount)));
            int maxAdditionalToExploreCount = toExplore.capacity() - 1;
            int totalExplored = toScore.count() + toExplore.count();
            if (toScore.count() < maxToScoreCount && filteredAmount > 0.1f) {
                int exploreFriend = 0;
                block3: while (true) {
                    int n;
                    it = n = toExplore.poll();
                    boolean bl = false;
                    exploreFriend = it;
                    if (n == Integer.MAX_VALUE || totalExplored >= maxAdditionalToExploreCount || toScore.count() >= maxToScoreCount) break;
                    this.graphSeek(graph, level, exploreFriend);
                    friendOfAFriendOrd = 0;
                    while (true) {
                        int it3 = it = graph.nextNeighbor();
                        boolean bl2 = false;
                        friendOfAFriendOrd = it3;
                        if (it == Integer.MAX_VALUE || toScore.count() >= maxToScoreCount) continue block3;
                        if (this.getVisited().getAndSet(friendOfAFriendOrd)) continue;
                        ++totalExplored;
                        Bits bits = acceptOrds;
                        Intrinsics.checkNotNull((Object)bits);
                        if (bits.get(friendOfAFriendOrd)) {
                            toScore.add(friendOfAFriendOrd);
                            continue;
                        }
                        if (totalExplored >= maxAdditionalToExploreCount || toScore.count() >= this.minToScore) continue;
                        toExplore.add(friendOfAFriendOrd);
                    }
                    break;
                }
            }
            int toScoreOrd = 0;
            while (true) {
                it = friendOfAFriendOrd = toScore.poll();
                boolean bl = false;
                toScoreOrd = it;
                if (friendOfAFriendOrd == Integer.MAX_VALUE) continue block1;
                float friendSimilarity = scorer2.score(toScoreOrd);
                results2.incVisitedCount(1);
                if (!(friendSimilarity > minAcceptedSimilarity)) continue;
                this.getCandidates().add(toScoreOrd, friendSimilarity);
                if (!results2.collect(toScoreOrd, friendSimilarity)) continue;
                minAcceptedSimilarity = Math.INSTANCE.nextUp(results2.minCompetitiveSimilarity());
            }
        }
    }

    private final void prepareScratchState() {
        this.getCandidates().clear();
        this.getVisited().clear();
    }

    public /* synthetic */ FilteredHnswGraphSearcher(NeighborQueue candidates, BitSet visited, int filterSize, HnswGraph graph, DefaultConstructorMarker $constructor_marker) {
        this(candidates, visited, filterSize, graph);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/FilteredHnswGraphSearcher$Companion;", "", "<init>", "()V", "EXPANDED_EXPLORATION_LAMBDA", "", "create", "Lorg/gnit/lucenekmp/util/hnsw/FilteredHnswGraphSearcher;", "k", "", "graph", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraph;", "filterSize", "acceptOrds", "Lorg/gnit/lucenekmp/util/Bits;", "bitSet", "Lorg/gnit/lucenekmp/util/BitSet;", "", "graphSize", "topk", "expectedBits", "totalBits", "core"})
    @SourceDebugExtension(value={"SMAP\nFilteredHnswGraphSearcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FilteredHnswGraphSearcher.kt\norg/gnit/lucenekmp/util/hnsw/FilteredHnswGraphSearcher$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,243:1\n1#2:244\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FilteredHnswGraphSearcher create(int k, @NotNull HnswGraph graph, int filterSize, @NotNull Bits acceptOrds) {
            Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
            Intrinsics.checkNotNullParameter((Object)acceptOrds, (String)"acceptOrds");
            if (!(filterSize > 0 && filterSize < HnswGraphSearcher.Companion.getGraphSize(graph))) {
                boolean bl = false;
                String string = "filterSize must be > 0 and < graph size";
                throw new IllegalArgumentException(string.toString());
            }
            return new FilteredHnswGraphSearcher(new NeighborQueue(k, true), this.bitSet(filterSize, HnswGraphSearcher.Companion.getGraphSize(graph), k), filterSize, graph, null);
        }

        private final BitSet bitSet(long filterSize, int graphSize, int topk) {
            float percentFiltered = (float)filterSize / (float)graphSize;
            if (!(percentFiltered > 0.0f && percentFiltered < 1.0f)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            double totalOps = java.lang.Math.log(graphSize) * (double)topk;
            int approximateVisitation = (int)(totalOps / (double)percentFiltered);
            return this.bitSet(approximateVisitation, graphSize);
        }

        private final BitSet bitSet(int expectedBits, int totalBits) {
            return expectedBits < totalBits >>> 7 ? (BitSet)new SparseFixedBitSet(totalBits) : (BitSet)new FixedBitSet(totalBits);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u0011\u001a\u00020\u0003J\u0006\u0010\u0012\u001a\u00020\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/FilteredHnswGraphSearcher$IntArrayQueue;", "", "capacity", "", "<init>", "(I)V", "nodes", "", "upto", "size", "count", "add", "", "node", "isFull", "", "()Z", "poll", "clear", "core"})
    private static final class IntArrayQueue {
        @NotNull
        private final int[] nodes;
        private int upto;
        private int size;

        public IntArrayQueue(int capacity) {
            this.nodes = new int[capacity];
        }

        public final int capacity() {
            return this.nodes.length;
        }

        public final int count() {
            return this.size - this.upto;
        }

        public final void add(int node) {
            if (this.isFull()) {
                throw new UnsupportedOperationException("Initial capacity should remain unchanged");
            }
            int n = this.size;
            this.size = n + 1;
            this.nodes[n] = node;
        }

        public final boolean isFull() {
            return this.size == this.nodes.length;
        }

        public final int poll() {
            if (this.upto == this.size) {
                return Integer.MAX_VALUE;
            }
            int n = this.upto;
            this.upto = n + 1;
            return this.nodes[n];
        }

        public final void clear() {
            this.upto = 0;
            this.size = 0;
        }
    }
}

