/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.hnsw;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\r\u001a\u00020\u0007J\u0006\u0010\u000e\u001a\u00020\fJ\u0006\u0010\u000f\u001a\u00020\fJ\u0006\u0010\b\u001a\u00020\u0003J\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\fH\u0002J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0003H\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/FloatHeap;", "", "maxSize", "", "<init>", "(I)V", "heap", "", "size", "offer", "", "value", "", "getHeap", "poll", "peek", "clear", "", "push", "element", "updateTop", "downHeap", "i", "upHeap", "origPos", "core"})
public final class FloatHeap {
    private final int maxSize;
    @NotNull
    private final float[] heap;
    private int size;

    public FloatHeap(int maxSize) {
        this.maxSize = maxSize;
        this.heap = new float[this.maxSize + 1];
    }

    public final boolean offer(float value) {
        if (this.size >= this.maxSize) {
            if (value < this.heap[1]) {
                return false;
            }
            this.updateTop(value);
            return true;
        }
        this.push(value);
        return true;
    }

    @NotNull
    public final float[] getHeap() {
        float[] result = new float[this.size];
        ArraysKt.copyInto((float[])this.heap, (float[])result, (int)0, (int)1, (int)(this.size + 1));
        return result;
    }

    public final float poll() {
        if (this.size > 0) {
            float result = this.heap[1];
            this.heap[1] = this.heap[this.size];
            int n = this.size;
            this.size = n + -1;
            this.downHeap(1);
            return result;
        }
        throw new IllegalStateException("The heap is empty");
    }

    public final float peek() {
        return this.heap[1];
    }

    public final int size() {
        return this.size;
    }

    public final void clear() {
        this.size = 0;
    }

    private final void push(float element) {
        int n = this.size;
        this.size = n + 1;
        this.heap[this.size] = element;
        this.upHeap(this.size);
    }

    private final float updateTop(float value) {
        this.heap[1] = value;
        this.downHeap(1);
        return this.heap[1];
    }

    private final void downHeap(int i) {
        int i2 = i;
        float value = this.heap[i2];
        int j = i2 << 1;
        int k = j + 1;
        if (k <= this.size && this.heap[k] < this.heap[j]) {
            j = k;
        }
        while (j <= this.size && this.heap[j] < value) {
            this.heap[i2] = this.heap[j];
            i2 = j;
            k = (j = i2 << 1) + 1;
            if (k > this.size || !(this.heap[k] < this.heap[j])) continue;
            j = k;
        }
        this.heap[i2] = value;
    }

    private final void upHeap(int origPos) {
        int i = origPos;
        float value = this.heap[i];
        for (int j = i >>> 1; j > 0 && value < this.heap[j]; j >>>= 1) {
            this.heap[i] = this.heap[j];
            i = j;
        }
        this.heap[i] = value;
    }
}

