/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.hnsw;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.gnit.lucenekmp.jdkport.Callable;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.search.TaskExecutor;
import org.gnit.lucenekmp.util.BitSet;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.InfoStream;
import org.gnit.lucenekmp.util.hnsw.HnswBuilder;
import org.gnit.lucenekmp.util.hnsw.HnswGraph;
import org.gnit.lucenekmp.util.hnsw.HnswGraphBuilder;
import org.gnit.lucenekmp.util.hnsw.HnswGraphSearcher;
import org.gnit.lucenekmp.util.hnsw.HnswLock;
import org.gnit.lucenekmp.util.hnsw.Lock;
import org.gnit.lucenekmp.util.hnsw.NeighborArray;
import org.gnit.lucenekmp.util.hnsw.NeighborQueue;
import org.gnit.lucenekmp.util.hnsw.OnHeapHnswGraph;
import org.gnit.lucenekmp.util.hnsw.RandomVectorScorerSupplier;
import org.gnit.lucenekmp.util.hnsw.UpdateableRandomVectorScorer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\u0018\u0000 )2\u00020\u0001:\u0003'()B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0019\u001a\u00020\n2\u0006\u0010\u001a\u001a\u00020\u0005H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\"\u001a\u00020\u001cH\u0002J\u000e\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0014\u0010#\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010!\u00a8\u0006*"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/HnswConcurrentMergeBuilder;", "Lorg/gnit/lucenekmp/util/hnsw/HnswBuilder;", "taskExecutor", "Lorg/gnit/lucenekmp/search/TaskExecutor;", "numWorker", "", "scorerSupplier", "Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;", "beamWidth", "hnsw", "Lorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;", "initializedNodes", "Lorg/gnit/lucenekmp/util/BitSet;", "<init>", "(Lorg/gnit/lucenekmp/search/TaskExecutor;ILorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;ILorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;Lorg/gnit/lucenekmp/util/BitSet;)V", "workers", "", "Lorg/gnit/lucenekmp/util/hnsw/HnswConcurrentMergeBuilder$ConcurrentMergeWorker;", "[Lorg/gnit/lucenekmp/util/hnsw/HnswConcurrentMergeBuilder$ConcurrentMergeWorker;", "hnswLock", "Lorg/gnit/lucenekmp/util/hnsw/HnswLock;", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "frozen", "", "build", "maxOrd", "addGraphNode", "", "node", "setInfoStream", "completedGraph", "getCompletedGraph", "()Lorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;", "finish", "graph", "getGraph", "setBatchSize", "newSize", "ConcurrentMergeWorker", "MergeSearcher", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nHnswConcurrentMergeBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HnswConcurrentMergeBuilder.kt\norg/gnit/lucenekmp/util/hnsw/HnswConcurrentMergeBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,224:1\n1#2:225\n*E\n"})
public final class HnswConcurrentMergeBuilder
implements HnswBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TaskExecutor taskExecutor;
    @NotNull
    private final ConcurrentMergeWorker[] workers;
    @NotNull
    private final HnswLock hnswLock;
    @NotNull
    private InfoStream infoStream;
    private boolean frozen;
    private static final int DEFAULT_BATCH_SIZE = 2048;

    public HnswConcurrentMergeBuilder(@NotNull TaskExecutor taskExecutor, int numWorker, @NotNull RandomVectorScorerSupplier scorerSupplier2, int beamWidth, @NotNull OnHeapHnswGraph hnsw, @Nullable BitSet initializedNodes) {
        Intrinsics.checkNotNullParameter((Object)taskExecutor, (String)"taskExecutor");
        Intrinsics.checkNotNullParameter((Object)scorerSupplier2, (String)"scorerSupplier");
        Intrinsics.checkNotNullParameter((Object)hnsw, (String)"hnsw");
        this.taskExecutor = taskExecutor;
        this.infoStream = InfoStream.Companion.getDefault();
        AtomicInteger workProgress = new AtomicInteger(0);
        this.workers = new ConcurrentMergeWorker[numWorker];
        this.hnswLock = new HnswLock();
        for (int i = 0; i < numWorker; ++i) {
            this.workers[i] = new ConcurrentMergeWorker(scorerSupplier2.copy(), beamWidth, HnswGraphBuilder.Companion.getRandSeed(), hnsw, this.hnswLock, initializedNodes, workProgress);
        }
    }

    @Override
    @NotNull
    public OnHeapHnswGraph build(int maxOrd) throws IOException {
        if (!(!this.frozen)) {
            boolean $i$a$-check-HnswConcurrentMergeBuilder$build$22 = false;
            String $i$a$-check-HnswConcurrentMergeBuilder$build$22 = "graph has already been built";
            throw new IllegalStateException($i$a$-check-HnswConcurrentMergeBuilder$build$22.toString());
        }
        if (this.infoStream.isEnabled("HNSW")) {
            this.infoStream.message("HNSW", "build graph from " + maxOrd + " vectors, with " + this.workers.length + " workers");
        }
        List futures = new ArrayList();
        int i = 0;
        int n = this.workers.length;
        while (i < n) {
            int finalI = i++;
            futures.add(new Callable(this, finalI, maxOrd){
                final /* synthetic */ HnswConcurrentMergeBuilder this$0;
                final /* synthetic */ int $finalI;
                final /* synthetic */ int $maxOrd;
                {
                    this.this$0 = $receiver;
                    this.$finalI = $finalI;
                    this.$maxOrd = $maxOrd;
                }

                public final Void call() {
                    ConcurrentMergeWorker concurrentMergeWorker = HnswConcurrentMergeBuilder.access$getWorkers$p(this.this$0)[this.$finalI];
                    Intrinsics.checkNotNull((Object)concurrentMergeWorker);
                    concurrentMergeWorker.run(this.$maxOrd);
                    return null;
                }
            });
        }
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List>, Object>(this, (List<Callable>)futures, null){
            int label;
            final /* synthetic */ HnswConcurrentMergeBuilder this$0;
            final /* synthetic */ List<Callable> $futures;
            {
                this.this$0 = $receiver;
                this.$futures = $futures;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = HnswConcurrentMergeBuilder.access$getTaskExecutor$p(this.this$0).invokeAll((Collection)this.$futures, (Continuation)this);
                        if (object2 != object) return object2;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return object2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        return this.getCompletedGraph();
    }

    @Override
    public void addGraphNode(int node) throws IOException {
        throw new UnsupportedOperationException("This builder is for merge only");
    }

    @Override
    public void setInfoStream(@NotNull InfoStream infoStream) {
        Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
        this.infoStream = infoStream;
        ConcurrentMergeWorker[] concurrentMergeWorkerArray = this.workers;
        int n = concurrentMergeWorkerArray.length;
        for (int i = 0; i < n; ++i) {
            ConcurrentMergeWorker worker;
            ConcurrentMergeWorker concurrentMergeWorker = worker = concurrentMergeWorkerArray[i];
            Intrinsics.checkNotNull((Object)concurrentMergeWorker);
            concurrentMergeWorker.setInfoStream(infoStream);
        }
    }

    @Override
    @NotNull
    public OnHeapHnswGraph getCompletedGraph() {
        if (!this.frozen) {
            this.finish();
            this.frozen = true;
        }
        return this.getGraph();
    }

    private final void finish() throws IOException {
        ConcurrentMergeWorker concurrentMergeWorker = this.workers[0];
        Intrinsics.checkNotNull((Object)concurrentMergeWorker);
        concurrentMergeWorker.finish();
    }

    @Override
    @NotNull
    public OnHeapHnswGraph getGraph() {
        ConcurrentMergeWorker concurrentMergeWorker = this.workers[0];
        Intrinsics.checkNotNull((Object)concurrentMergeWorker);
        return concurrentMergeWorker.getGraph();
    }

    public final void setBatchSize(int newSize) {
        ConcurrentMergeWorker[] concurrentMergeWorkerArray = this.workers;
        int n = concurrentMergeWorkerArray.length;
        for (int i = 0; i < n; ++i) {
            ConcurrentMergeWorker worker;
            ConcurrentMergeWorker concurrentMergeWorker = worker = concurrentMergeWorkerArray[i];
            Intrinsics.checkNotNull((Object)concurrentMergeWorker);
            concurrentMergeWorker.setBatchSize(newSize);
        }
    }

    public static final /* synthetic */ ConcurrentMergeWorker[] access$getWorkers$p(HnswConcurrentMergeBuilder $this) {
        return $this.workers;
    }

    public static final /* synthetic */ TaskExecutor access$getTaskExecutor$p(HnswConcurrentMergeBuilder $this) {
        return $this.taskExecutor;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/HnswConcurrentMergeBuilder$Companion;", "", "<init>", "()V", "DEFAULT_BATCH_SIZE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005J\u0018\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u0005H\u0016R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/HnswConcurrentMergeBuilder$ConcurrentMergeWorker;", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraphBuilder;", "scorerSupplier", "Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;", "beamWidth", "", "seed", "", "hnsw", "Lorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;", "hnswLock", "Lorg/gnit/lucenekmp/util/hnsw/HnswLock;", "initializedNodes", "Lorg/gnit/lucenekmp/util/BitSet;", "workProgress", "Lkotlin/concurrent/atomics/AtomicInt;", "Lorg/gnit/lucenekmp/jdkport/AtomicInteger;", "<init>", "(Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;IJLorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;Lorg/gnit/lucenekmp/util/hnsw/HnswLock;Lorg/gnit/lucenekmp/util/BitSet;Ljava/util/concurrent/atomic/AtomicInteger;)V", "Ljava/util/concurrent/atomic/AtomicInteger;", "batchSize", "getBatchSize", "()I", "setBatchSize", "(I)V", "scorer", "Lorg/gnit/lucenekmp/util/hnsw/UpdateableRandomVectorScorer;", "run", "", "maxOrd", "getStartPos", "addGraphNode", "node", "core"})
    private static final class ConcurrentMergeWorker
    extends HnswGraphBuilder {
        @Nullable
        private final BitSet initializedNodes;
        @NotNull
        private final AtomicInteger workProgress;
        private int batchSize;
        @NotNull
        private final UpdateableRandomVectorScorer scorer;

        public ConcurrentMergeWorker(@NotNull RandomVectorScorerSupplier scorerSupplier2, int beamWidth, long seed, @NotNull OnHeapHnswGraph hnsw, @NotNull HnswLock hnswLock, @Nullable BitSet initializedNodes, @NotNull AtomicInteger workProgress) {
            Intrinsics.checkNotNullParameter((Object)scorerSupplier2, (String)"scorerSupplier");
            Intrinsics.checkNotNullParameter((Object)hnsw, (String)"hnsw");
            Intrinsics.checkNotNullParameter((Object)hnswLock, (String)"hnswLock");
            Intrinsics.checkNotNullParameter((Object)workProgress, (String)"workProgress");
            super(scorerSupplier2, beamWidth, seed, hnsw, hnswLock, new MergeSearcher(new NeighborQueue(beamWidth, true), hnswLock, new FixedBitSet(hnsw.maxNodeId() + 1)));
            this.initializedNodes = initializedNodes;
            this.workProgress = workProgress;
            this.batchSize = 2048;
            this.scorer = scorerSupplier2.scorer();
        }

        public final int getBatchSize() {
            return this.batchSize;
        }

        public final void setBatchSize(int n) {
            this.batchSize = n;
        }

        public final void run(int maxOrd) throws IOException {
            int start = this.getStartPos(maxOrd);
            int end = 0;
            while (start != -1) {
                end = Math.min(maxOrd, start + this.batchSize);
                this.addVectors(start, end);
                start = this.getStartPos(maxOrd);
            }
        }

        public final int getStartPos(int maxOrd) {
            int start = this.workProgress.getAndAdd(this.batchSize);
            return start < maxOrd ? start : -1;
        }

        @Override
        public void addGraphNode(int node, @NotNull UpdateableRandomVectorScorer scorer2) throws IOException {
            Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
            if (this.initializedNodes != null && this.initializedNodes.get(node)) {
                return;
            }
            super.addGraphNode(node, scorer2);
        }

        @Override
        public void addGraphNode(int node) throws IOException {
            if (this.initializedNodes != null && this.initializedNodes.get(node)) {
                return;
            }
            this.scorer.setScoringOrdinal(node);
            this.addGraphNode(node, this.scorer);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\rH\u0016J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/HnswConcurrentMergeBuilder$MergeSearcher;", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraphSearcher;", "candidates", "Lorg/gnit/lucenekmp/util/hnsw/NeighborQueue;", "hnswLock", "Lorg/gnit/lucenekmp/util/hnsw/HnswLock;", "visited", "Lorg/gnit/lucenekmp/util/BitSet;", "<init>", "(Lorg/gnit/lucenekmp/util/hnsw/NeighborQueue;Lorg/gnit/lucenekmp/util/hnsw/HnswLock;Lorg/gnit/lucenekmp/util/BitSet;)V", "nodeBuffer", "", "upto", "", "size", "graphSeek", "", "graph", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraph;", "level", "targetNode", "graphNextNeighbor", "core"})
    private static final class MergeSearcher
    extends HnswGraphSearcher {
        @NotNull
        private final HnswLock hnswLock;
        @Nullable
        private int[] nodeBuffer;
        private int upto;
        private int size;

        public MergeSearcher(@NotNull NeighborQueue candidates, @NotNull HnswLock hnswLock, @NotNull BitSet visited) {
            Intrinsics.checkNotNullParameter((Object)candidates, (String)"candidates");
            Intrinsics.checkNotNullParameter((Object)hnswLock, (String)"hnswLock");
            Intrinsics.checkNotNullParameter((Object)visited, (String)"visited");
            super(candidates, visited);
            this.hnswLock = hnswLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void graphSeek(@NotNull HnswGraph graph, int level, int targetNode) {
            Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
            Lock lock2 = this.hnswLock.read(level, targetNode);
            try {
                NeighborArray neighborArray;
                block7: {
                    block6: {
                        neighborArray = ((OnHeapHnswGraph)graph).getNeighbors(level, targetNode);
                        if (this.nodeBuffer == null) break block6;
                        Intrinsics.checkNotNull((Object)this.nodeBuffer);
                        if (this.nodeBuffer.length >= neighborArray.size()) break block7;
                    }
                    this.nodeBuffer = new int[neighborArray.size()];
                }
                this.size = neighborArray.size();
                int[] nArray = neighborArray.nodes();
                Intrinsics.checkNotNull((Object)this.nodeBuffer);
                System.INSTANCE.arraycopy(nArray, 0, this.nodeBuffer, 0, this.size);
            }
            finally {
                lock2.unlock();
            }
            this.upto = -1;
        }

        @Override
        public int graphNextNeighbor(@NotNull HnswGraph graph) {
            Intrinsics.checkNotNullParameter((Object)graph, (String)"graph");
            ++this.upto;
            if (this.upto < this.size) {
                Intrinsics.checkNotNull((Object)this.nodeBuffer);
                return this.nodeBuffer[this.upto];
            }
            return Integer.MAX_VALUE;
        }
    }
}

