/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.hnsw;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.KnnVectorsReader;
import org.gnit.lucenekmp.codecs.hnsw.HnswGraphProvider;
import org.gnit.lucenekmp.codecs.perfield.PerFieldKnnVectorsFormat;
import org.gnit.lucenekmp.index.CodecReader;
import org.gnit.lucenekmp.index.FilterLeafReader;
import org.gnit.lucenekmp.index.IndexReader;
import org.gnit.lucenekmp.index.LeafReader;
import org.gnit.lucenekmp.index.LeafReaderContext;
import org.gnit.lucenekmp.internal.hppc.IntHashSet;
import org.gnit.lucenekmp.jdkport.ArrayDequeExtKt;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.hnsw.HnswGraph;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u0007J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\nJ.\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\t2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\nJ:\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\nH\u0002J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0016\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d\u00a8\u0006\u001f"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/HnswUtil;", "", "<init>", "()V", "isRooted", "", "knnValues", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraph;", "componentSizes", "", "", "hnsw", "level", "components", "Lorg/gnit/lucenekmp/util/hnsw/HnswUtil$Component;", "notFullyConnected", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "maxConn", "markRooted", "hnswGraph", "connectedNodes", "entryPoint", "nextClearBit", "bits", "index", "graphIsRooted", "reader", "Lorg/gnit/lucenekmp/index/IndexReader;", "vectorField", "", "Component", "core"})
@SourceDebugExtension(value={"SMAP\nHnswUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HnswUtil.kt\norg/gnit/lucenekmp/util/hnsw/HnswUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,250:1\n1563#2:251\n1634#2,3:252\n1#3:255\n*S KotlinDebug\n*F\n+ 1 HnswUtil.kt\norg/gnit/lucenekmp/util/hnsw/HnswUtil\n*L\n59#1:251\n59#1:252,3\n*E\n"})
public final class HnswUtil {
    @NotNull
    public static final HnswUtil INSTANCE = new HnswUtil();

    private HnswUtil() {
    }

    public final boolean isRooted(@NotNull HnswGraph knnValues) throws IOException {
        Intrinsics.checkNotNullParameter((Object)knnValues, (String)"knnValues");
        int n = knnValues.numLevels();
        for (int level = 0; level < n; ++level) {
            if (this.components(knnValues, level, null, 0).size() <= 1) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final List<Integer> componentSizes(@NotNull HnswGraph hnsw) throws IOException {
        Intrinsics.checkNotNullParameter((Object)hnsw, (String)"hnsw");
        return this.componentSizes(hnsw, 0);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> componentSizes(@NotNull HnswGraph hnsw, int level) throws IOException {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)hnsw, (String)"hnsw");
        Iterable $this$map$iv = this.components(hnsw, level, null, 0);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Component component = (Component)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSize());
        }
        return CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
    }

    @NotNull
    public final List<Component> components(@NotNull HnswGraph hnsw, int level, @Nullable FixedBitSet notFullyConnected, int maxConn) throws IOException {
        Intrinsics.checkNotNullParameter((Object)hnsw, (String)"hnsw");
        List components = new ArrayList();
        FixedBitSet connectedNodes = new FixedBitSet(hnsw.size());
        if (!(hnsw.size() == hnsw.getNodesOnLevel(0).size())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int total = 0;
        if (!(level < hnsw.numLevels())) {
            boolean $i$a$-require-HnswUtil$components$32 = false;
            String $i$a$-require-HnswUtil$components$32 = "Level " + level + " too large for graph with " + hnsw.numLevels() + " levels";
            throw new IllegalArgumentException($i$a$-require-HnswUtil$components$32.toString());
        }
        HnswGraph.NodesIterator entryPoints = null;
        if (level == hnsw.numLevels() - 1) {
            int[] $i$a$-require-HnswUtil$components$32 = new int[]{hnsw.entryNode()};
            entryPoints = new HnswGraph.ArrayNodesIterator($i$a$-require-HnswUtil$components$32, 1);
        } else {
            entryPoints = hnsw.getNodesOnLevel(level + 1);
        }
        while (entryPoints.hasNext()) {
            int entryPoint = entryPoints.nextInt();
            Component component = this.markRooted(hnsw, level, connectedNodes, notFullyConnected, maxConn, entryPoint);
            total += component.getSize();
        }
        int entryPoint = 0;
        entryPoint = notFullyConnected != null ? notFullyConnected.nextSetBit(0) : connectedNodes.nextSetBit(0);
        if (total > 0) {
            components.add(new Component(entryPoint, total));
        }
        if (level == 0) {
            int nextClear = this.nextClearBit(connectedNodes, 0);
            while (nextClear != Integer.MAX_VALUE) {
                Component component = this.markRooted(hnsw, level, connectedNodes, notFullyConnected, maxConn, nextClear);
                if (!(component.getSize() > 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                components.add(component);
                total += component.getSize();
                nextClear = this.nextClearBit(connectedNodes, component.getStart());
            }
        } else {
            HnswGraph.NodesIterator nodes = hnsw.getNodesOnLevel(level);
            while (nodes.hasNext()) {
                int nextClear = nodes.nextInt();
                if (connectedNodes.get(nextClear)) continue;
                Component component = this.markRooted(hnsw, level, connectedNodes, notFullyConnected, maxConn, nextClear);
                if (!(component.getStart() == nextClear)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(component.getSize() > 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                components.add(component);
                total += component.getSize();
            }
        }
        if (!(total == hnsw.getNodesOnLevel(level).size())) {
            boolean bl = false;
            String string = "total=" + total + " level nodes on level " + level + " = " + hnsw.getNodesOnLevel(level).size();
            throw new IllegalArgumentException(string.toString());
        }
        return components;
    }

    private final Component markRooted(HnswGraph hnswGraph, int level, FixedBitSet connectedNodes, FixedBitSet notFullyConnected, int maxConn, int entryPoint) throws IOException {
        if (connectedNodes.get(entryPoint)) {
            return new Component(entryPoint, 0);
        }
        IntHashSet nodesInStack = new IntHashSet();
        ArrayDeque stack = new ArrayDeque();
        ArrayDequeExtKt.push(stack, entryPoint);
        int count = 0;
        while (!stack.isEmpty()) {
            int node = ((Number)ArrayDequeExtKt.pop(stack)).intValue();
            if (connectedNodes.get(node)) continue;
            ++count;
            connectedNodes.set(node);
            hnswGraph.seek(level, node);
            int friendOrd = 0;
            int friendCount = 0;
            while (true) {
                int n;
                int it = n = hnswGraph.nextNeighbor();
                boolean bl = false;
                friendOrd = it;
                if (n == Integer.MAX_VALUE) break;
                ++friendCount;
                if (connectedNodes.get(friendOrd) || nodesInStack.contains(friendOrd)) continue;
                ArrayDequeExtKt.push(stack, friendOrd);
                nodesInStack.add(friendOrd);
            }
            if (friendCount >= maxConn || notFullyConnected == null) continue;
            notFullyConnected.set(node);
        }
        return new Component(entryPoint, count);
    }

    private final int nextClearBit(FixedBitSet bits, int index) {
        long[] barray = bits.getBits();
        if (!(index >= 0 && index < bits.length())) {
            boolean $i$a$-require-HnswUtil$nextClearBit$22 = false;
            String $i$a$-require-HnswUtil$nextClearBit$22 = "index=" + index + ", numBits=" + bits.length();
            throw new IllegalArgumentException($i$a$-require-HnswUtil$nextClearBit$22.toString());
        }
        int i = index >> 6;
        long word = barray[i] >> index ^ 0xFFFFFFFFFFFFFFFFL;
        int next = Integer.MAX_VALUE;
        if (word != 0L) {
            next = index + LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, word);
        } else {
            while (++i < barray.length) {
                word = barray[i] ^ 0xFFFFFFFFFFFFFFFFL;
                if (word == 0L) continue;
                next = (i << 6) + LongExtKt.numberOfTrailingZeros(LongCompanionObject.INSTANCE, word);
                break;
            }
        }
        if (next >= bits.length()) {
            return Integer.MAX_VALUE;
        }
        return next;
    }

    public final boolean graphIsRooted(@NotNull IndexReader reader2, @NotNull String vectorField) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)vectorField, (String)"vectorField");
        for (LeafReaderContext ctx : reader2.leaves()) {
            LeafReader leafReader = FilterLeafReader.Companion.unwrap(ctx.reader());
            Intrinsics.checkNotNull((Object)leafReader, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.index.CodecReader");
            CodecReader codecReader = (CodecReader)leafReader;
            KnnVectorsReader knnVectorsReader = codecReader.getVectorReader();
            Intrinsics.checkNotNull((Object)knnVectorsReader, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.codecs.perfield.PerFieldKnnVectorsFormat.FieldsReader");
            KnnVectorsReader vectorsReader = ((PerFieldKnnVectorsFormat.FieldsReader)knnVectorsReader).getFieldReader(vectorField);
            if (vectorsReader instanceof HnswGraphProvider) {
                HnswGraph graph;
                HnswGraph hnswGraph = graph = ((HnswGraphProvider)((Object)vectorsReader)).getGraph(vectorField);
                Intrinsics.checkNotNull((Object)hnswGraph);
                if (this.isRooted(hnswGraph)) continue;
                return false;
            }
            throw new IllegalArgumentException("not a graph: " + vectorsReader);
        }
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/HnswUtil$Component;", "", "start", "", "size", "<init>", "(II)V", "getStart", "()I", "getSize", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    public static final class Component {
        private final int start;
        private final int size;

        public Component(int start, int size2) {
            this.start = start;
            this.size = size2;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getSize() {
            return this.size;
        }

        public final int component1() {
            return this.start;
        }

        public final int component2() {
            return this.size;
        }

        @NotNull
        public final Component copy(int start, int size2) {
            return new Component(start, size2);
        }

        public static /* synthetic */ Component copy$default(Component component, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = component.start;
            }
            if ((n3 & 2) != 0) {
                n2 = component.size;
            }
            return component.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "Component(start=" + this.start + ", size=" + this.size + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.start);
            result = result * 31 + Integer.hashCode(this.size);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Component)) {
                return false;
            }
            Component component = (Component)other;
            if (this.start != component.start) {
                return false;
            }
            return this.size == component.size;
        }
    }
}

