/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.hnsw;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.KnnVectorsReader;
import org.gnit.lucenekmp.codecs.hnsw.HnswGraphProvider;
import org.gnit.lucenekmp.index.ByteVectorValues;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FloatVectorValues;
import org.gnit.lucenekmp.index.KnnVectorValues;
import org.gnit.lucenekmp.index.MergeState;
import org.gnit.lucenekmp.index.VectorEncoding;
import org.gnit.lucenekmp.internal.hppc.IntIntHashMap;
import org.gnit.lucenekmp.util.BitSet;
import org.gnit.lucenekmp.util.Bits;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.InfoStream;
import org.gnit.lucenekmp.util.hnsw.HnswBuilder;
import org.gnit.lucenekmp.util.hnsw.HnswGraph;
import org.gnit.lucenekmp.util.hnsw.HnswGraphBuilder;
import org.gnit.lucenekmp.util.hnsw.HnswGraphMerger;
import org.gnit.lucenekmp.util.hnsw.InitializedHnswGraphBuilder;
import org.gnit.lucenekmp.util.hnsw.OnHeapHnswGraph;
import org.gnit.lucenekmp.util.hnsw.RandomVectorScorerSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 42\u00020\u0001:\u00014B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ \u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0007H\u0014J \u0010,\u001a\u00020-2\u0006\u0010)\u001a\u00020*2\u0006\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020\u0007H\u0016J\u0018\u00100\u001a\u0002012\u0006\u0010)\u001a\u00020*2\u0006\u00102\u001a\u000203H\u0004R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0010\"\u0004\b \u0010!\u00a8\u00065"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/IncrementalHnswGraphMerger;", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraphMerger;", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "scorerSupplier", "Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;", "M", "", "beamWidth", "<init>", "(Lorg/gnit/lucenekmp/index/FieldInfo;Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;II)V", "getFieldInfo", "()Lorg/gnit/lucenekmp/index/FieldInfo;", "getScorerSupplier", "()Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;", "getM", "()I", "getBeamWidth", "initReader", "Lorg/gnit/lucenekmp/codecs/KnnVectorsReader;", "getInitReader", "()Lorg/gnit/lucenekmp/codecs/KnnVectorsReader;", "setInitReader", "(Lorg/gnit/lucenekmp/codecs/KnnVectorsReader;)V", "initDocMap", "Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "getInitDocMap", "()Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "setInitDocMap", "(Lorg/gnit/lucenekmp/index/MergeState$DocMap;)V", "initGraphSize", "getInitGraphSize", "setInitGraphSize", "(I)V", "addReader", "reader", "docMap", "liveDocs", "Lorg/gnit/lucenekmp/util/Bits;", "createBuilder", "Lorg/gnit/lucenekmp/util/hnsw/HnswBuilder;", "mergedVectorValues", "Lorg/gnit/lucenekmp/index/KnnVectorValues;", "maxOrd", "merge", "Lorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;", "infoStream", "Lorg/gnit/lucenekmp/util/InfoStream;", "getNewOrdMapping", "", "initializedNodes", "Lorg/gnit/lucenekmp/util/BitSet;", "Companion", "core"})
public class IncrementalHnswGraphMerger
implements HnswGraphMerger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FieldInfo fieldInfo;
    @NotNull
    private final RandomVectorScorerSupplier scorerSupplier;
    private final int M;
    private final int beamWidth;
    @Nullable
    private KnnVectorsReader initReader;
    @Nullable
    private MergeState.DocMap initDocMap;
    private int initGraphSize;

    public IncrementalHnswGraphMerger(@NotNull FieldInfo fieldInfo, @NotNull RandomVectorScorerSupplier scorerSupplier2, int M, int beamWidth) {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)scorerSupplier2, (String)"scorerSupplier");
        this.fieldInfo = fieldInfo;
        this.scorerSupplier = scorerSupplier2;
        this.M = M;
        this.beamWidth = beamWidth;
    }

    @NotNull
    protected final FieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    @NotNull
    protected final RandomVectorScorerSupplier getScorerSupplier() {
        return this.scorerSupplier;
    }

    protected final int getM() {
        return this.M;
    }

    protected final int getBeamWidth() {
        return this.beamWidth;
    }

    @Nullable
    protected final KnnVectorsReader getInitReader() {
        return this.initReader;
    }

    protected final void setInitReader(@Nullable KnnVectorsReader knnVectorsReader) {
        this.initReader = knnVectorsReader;
    }

    @Nullable
    protected final MergeState.DocMap getInitDocMap() {
        return this.initDocMap;
    }

    protected final void setInitDocMap(@Nullable MergeState.DocMap docMap) {
        this.initDocMap = docMap;
    }

    protected final int getInitGraphSize() {
        return this.initGraphSize;
    }

    protected final void setInitGraphSize(int n) {
        this.initGraphSize = n;
    }

    @Override
    @NotNull
    public IncrementalHnswGraphMerger addReader(@NotNull KnnVectorsReader reader2, @NotNull MergeState.DocMap docMap, @NotNull Bits liveDocs2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)docMap, (String)"docMap");
        Intrinsics.checkNotNullParameter((Object)liveDocs2, (String)"liveDocs");
        if (IncrementalHnswGraphMerger.Companion.hasDeletes(liveDocs2) || !(reader2 instanceof HnswGraphProvider)) {
            return this;
        }
        HnswGraph graph = ((HnswGraphProvider)((Object)reader2)).getGraph(this.fieldInfo.getName());
        if (graph == null || graph.size() == 0) {
            return this;
        }
        int candidateVectorCount = 0;
        switch (WhenMappings.$EnumSwitchMapping$0[this.fieldInfo.getVectorEncoding().ordinal()]) {
            case 1: {
                ByteVectorValues byteVectorValues = reader2.getByteVectorValues(this.fieldInfo.getName());
                if (byteVectorValues == null) {
                    return this;
                }
                candidateVectorCount = byteVectorValues.size();
                break;
            }
            case 2: {
                FloatVectorValues vectorValues = reader2.getFloatVectorValues(this.fieldInfo.getName());
                if (vectorValues == null) {
                    return this;
                }
                candidateVectorCount = vectorValues.size();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (candidateVectorCount > this.initGraphSize) {
            this.initReader = reader2;
            this.initDocMap = docMap;
            this.initGraphSize = candidateVectorCount;
        }
        return this;
    }

    @NotNull
    protected HnswBuilder createBuilder(@NotNull KnnVectorValues mergedVectorValues, int maxOrd) throws IOException {
        HnswGraph initializerGraph;
        Intrinsics.checkNotNullParameter((Object)mergedVectorValues, (String)"mergedVectorValues");
        if (this.initReader == null) {
            return HnswGraphBuilder.Companion.create(this.scorerSupplier, this.M, this.beamWidth, HnswGraphBuilder.Companion.getRandSeed(), maxOrd);
        }
        KnnVectorsReader knnVectorsReader = this.initReader;
        Intrinsics.checkNotNull((Object)knnVectorsReader, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.codecs.hnsw.HnswGraphProvider");
        HnswGraph hnswGraph = initializerGraph = ((HnswGraphProvider)((Object)knnVectorsReader)).getGraph(this.fieldInfo.getName());
        Intrinsics.checkNotNull((Object)hnswGraph);
        if (hnswGraph.size() == 0) {
            return HnswGraphBuilder.Companion.create(this.scorerSupplier, this.M, this.beamWidth, HnswGraphBuilder.Companion.getRandSeed(), maxOrd);
        }
        BitSet initializedNodes = new FixedBitSet(maxOrd);
        int[] oldToNewOrdinalMap = this.getNewOrdMapping(mergedVectorValues, initializedNodes);
        return InitializedHnswGraphBuilder.Companion.fromGraph(this.scorerSupplier, this.beamWidth, HnswGraphBuilder.Companion.getRandSeed(), initializerGraph, oldToNewOrdinalMap, initializedNodes, maxOrd);
    }

    @Override
    @NotNull
    public OnHeapHnswGraph merge(@NotNull KnnVectorValues mergedVectorValues, @NotNull InfoStream infoStream, int maxOrd) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mergedVectorValues, (String)"mergedVectorValues");
        Intrinsics.checkNotNullParameter((Object)infoStream, (String)"infoStream");
        HnswBuilder builder = this.createBuilder(mergedVectorValues, maxOrd);
        builder.setInfoStream(infoStream);
        return builder.build(maxOrd);
    }

    @NotNull
    protected final int[] getNewOrdMapping(@NotNull KnnVectorValues mergedVectorValues, @NotNull BitSet initializedNodes) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mergedVectorValues, (String)"mergedVectorValues");
        Intrinsics.checkNotNullParameter((Object)initializedNodes, (String)"initializedNodes");
        KnnVectorValues.DocIndexIterator initializerIterator = switch (WhenMappings.$EnumSwitchMapping$0[this.fieldInfo.getVectorEncoding().ordinal()]) {
            case 1 -> {
                KnnVectorsReader v0 = this.initReader;
                Intrinsics.checkNotNull((Object)v0);
                ByteVectorValues v1 = v0.getByteVectorValues(this.fieldInfo.getName());
                Intrinsics.checkNotNull((Object)v1);
                yield v1.iterator();
            }
            case 2 -> {
                KnnVectorsReader v3 = this.initReader;
                Intrinsics.checkNotNull((Object)v3);
                FloatVectorValues v4 = v3.getFloatVectorValues(this.fieldInfo.getName());
                Intrinsics.checkNotNull((Object)v4);
                yield v4.iterator();
            }
            default -> throw new NoWhenBranchMatchedException();
        };
        IntIntHashMap newIdToOldOrdinal = new IntIntHashMap(this.initGraphSize, 0.0, 2, null);
        int maxNewDocID = -1;
        int docId = initializerIterator.nextDoc();
        while (docId != Integer.MAX_VALUE) {
            MergeState.DocMap docMap = this.initDocMap;
            Intrinsics.checkNotNull((Object)docMap);
            int newId = docMap.get(docId);
            maxNewDocID = Math.max(newId, maxNewDocID);
            newIdToOldOrdinal.put(newId, initializerIterator.index());
            docId = initializerIterator.nextDoc();
        }
        if (maxNewDocID == -1) {
            return new int[0];
        }
        int[] oldToNewOrdinalMap = new int[this.initGraphSize];
        KnnVectorValues.DocIndexIterator mergedVectorIterator = mergedVectorValues.iterator();
        int newDocId = mergedVectorIterator.nextDoc();
        while (newDocId <= maxNewDocID) {
            int hashDocIndex = newIdToOldOrdinal.indexOf(newDocId);
            if (newIdToOldOrdinal.indexExists(hashDocIndex)) {
                int newOrd = mergedVectorIterator.index();
                initializedNodes.set(newOrd);
                oldToNewOrdinalMap[newIdToOldOrdinal.indexGet((int)hashDocIndex)] = newOrd;
            }
            newDocId = mergedVectorIterator.nextDoc();
        }
        return oldToNewOrdinalMap;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/IncrementalHnswGraphMerger$Companion;", "", "<init>", "()V", "hasDeletes", "", "liveDocs", "Lorg/gnit/lucenekmp/util/Bits;", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean hasDeletes(Bits liveDocs2) {
            if (liveDocs2 == null) {
                return false;
            }
            int n = liveDocs2.length();
            for (int i = 0; i < n; ++i) {
                if (liveDocs2.get(i)) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VectorEncoding.values().length];
            try {
                nArray[VectorEncoding.BYTE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VectorEncoding.FLOAT32.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

