/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.hnsw;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.util.BitSet;
import org.gnit.lucenekmp.util.hnsw.HnswGraph;
import org.gnit.lucenekmp.util.hnsw.HnswGraphBuilder;
import org.gnit.lucenekmp.util.hnsw.NeighborArray;
import org.gnit.lucenekmp.util.hnsw.OnHeapHnswGraph;
import org.gnit.lucenekmp.util.hnsw.RandomVectorScorerSupplier;
import org.gnit.lucenekmp.util.hnsw.UpdateableRandomVectorScorer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/InitializedHnswGraphBuilder;", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraphBuilder;", "scorerSupplier", "Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;", "beamWidth", "", "seed", "", "initializedGraph", "Lorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;", "initializedNodes", "Lorg/gnit/lucenekmp/util/BitSet;", "<init>", "(Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;IJLorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;Lorg/gnit/lucenekmp/util/BitSet;)V", "addGraphNode", "", "node", "scorer", "Lorg/gnit/lucenekmp/util/hnsw/UpdateableRandomVectorScorer;", "Companion", "core"})
public final class InitializedHnswGraphBuilder
extends HnswGraphBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BitSet initializedNodes;

    public InitializedHnswGraphBuilder(@NotNull RandomVectorScorerSupplier scorerSupplier2, int beamWidth, long seed, @NotNull OnHeapHnswGraph initializedGraph, @NotNull BitSet initializedNodes) {
        Intrinsics.checkNotNullParameter((Object)scorerSupplier2, (String)"scorerSupplier");
        Intrinsics.checkNotNullParameter((Object)initializedGraph, (String)"initializedGraph");
        Intrinsics.checkNotNullParameter((Object)initializedNodes, (String)"initializedNodes");
        super(scorerSupplier2, beamWidth, seed, initializedGraph);
        this.initializedNodes = initializedNodes;
    }

    @Override
    public void addGraphNode(int node, @NotNull UpdateableRandomVectorScorer scorer2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        if (this.initializedNodes.get(node)) {
            return;
        }
        super.addGraphNode(node, scorer2);
    }

    @Override
    public void addGraphNode(int node) throws IOException {
        if (this.initializedNodes.get(node)) {
            return;
        }
        super.addGraphNode(node);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J>\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tJ\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\t\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/InitializedHnswGraphBuilder$Companion;", "", "<init>", "()V", "fromGraph", "Lorg/gnit/lucenekmp/util/hnsw/InitializedHnswGraphBuilder;", "scorerSupplier", "Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorerSupplier;", "beamWidth", "", "seed", "", "initializerGraph", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraph;", "newOrdMap", "", "initializedNodes", "Lorg/gnit/lucenekmp/util/BitSet;", "totalNumberOfVectors", "initGraph", "Lorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InitializedHnswGraphBuilder fromGraph(@NotNull RandomVectorScorerSupplier scorerSupplier2, int beamWidth, long seed, @NotNull HnswGraph initializerGraph, @NotNull int[] newOrdMap, @NotNull BitSet initializedNodes, int totalNumberOfVectors) throws IOException {
            Intrinsics.checkNotNullParameter((Object)scorerSupplier2, (String)"scorerSupplier");
            Intrinsics.checkNotNullParameter((Object)initializerGraph, (String)"initializerGraph");
            Intrinsics.checkNotNullParameter((Object)newOrdMap, (String)"newOrdMap");
            Intrinsics.checkNotNullParameter((Object)initializedNodes, (String)"initializedNodes");
            return new InitializedHnswGraphBuilder(scorerSupplier2, beamWidth, seed, this.initGraph(initializerGraph, newOrdMap, totalNumberOfVectors), initializedNodes);
        }

        @NotNull
        public final OnHeapHnswGraph initGraph(@NotNull HnswGraph initializerGraph, @NotNull int[] newOrdMap, int totalNumberOfVectors) throws IOException {
            Intrinsics.checkNotNullParameter((Object)initializerGraph, (String)"initializerGraph");
            Intrinsics.checkNotNullParameter((Object)newOrdMap, (String)"newOrdMap");
            OnHeapHnswGraph hnsw = new OnHeapHnswGraph(initializerGraph.maxConn(), totalNumberOfVectors);
            for (int level = initializerGraph.numLevels() - 1; -1 < level; --level) {
                HnswGraph.NodesIterator it = initializerGraph.getNodesOnLevel(level);
                while (it.hasNext()) {
                    int oldOrd = it.nextInt();
                    int newOrd = newOrdMap[oldOrd];
                    hnsw.addNode(level, newOrd);
                    hnsw.trySetNewEntryNode(newOrd, level);
                    NeighborArray newNeighbors = hnsw.getNeighbors(level, newOrd);
                    initializerGraph.seek(level, oldOrd);
                    int oldNeighbor = initializerGraph.nextNeighbor();
                    while (oldNeighbor != Integer.MAX_VALUE) {
                        int newNeighbor = newOrdMap[oldNeighbor];
                        newNeighbors.addOutOfOrder(newNeighbor, Float.NaN);
                        oldNeighbor = initializerGraph.nextNeighbor();
                    }
                }
            }
            return hnsw;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

