/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.hnsw;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.hnsw.RandomVectorScorer;
import org.gnit.lucenekmp.util.hnsw.UpdateableRandomVectorScorer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0016\u001a\u00020\u0019J\u0012\u0010\u001a\u001a\u00020\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u0019H\u0002J\u0016\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\b\u001a\u00020\u0003J\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u001c\u001a\u00020\u000fJ\u0006\u0010\u001d\u001a\u00020\u000fJ\u000e\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u0003J\b\u0010 \u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0018\u0010$\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u0003H\u0002J\u0010\u0010%\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\f2\u0006\u0010)\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0019H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/NeighborArray;", "", "maxSize", "", "scoresDescOrder", "", "<init>", "(IZ)V", "size", "scores", "", "nodes", "", "sortedNodeSize", "addInOrder", "", "newNode", "newScore", "", "addOutOfOrder", "addAndEnsureDiversity", "nodeId", "scorer", "Lorg/gnit/lucenekmp/util/hnsw/UpdateableRandomVectorScorer;", "sort", "Lorg/gnit/lucenekmp/util/hnsw/RandomVectorScorer;", "insertSortedInternal", "insertSorted", "clear", "removeLast", "removeIndex", "idx", "toString", "", "ascSortFindRightMostInsertionPoint", "bound", "descSortFindRightMostInsertionPoint", "findWorstNonDiverse", "isWorstNonDiverse", "candidateIndex", "uncheckedIndexes", "uncheckedCursor", "core"})
@SourceDebugExtension(value={"SMAP\nNeighborArray.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NeighborArray.kt\norg/gnit/lucenekmp/util/hnsw/NeighborArray\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,274:1\n1#2:275\n*E\n"})
public final class NeighborArray {
    private final boolean scoresDescOrder;
    private int size;
    @NotNull
    private final float[] scores;
    @NotNull
    private final int[] nodes;
    private int sortedNodeSize;

    public NeighborArray(int maxSize, boolean scoresDescOrder) {
        this.scoresDescOrder = scoresDescOrder;
        this.scores = new float[maxSize];
        this.nodes = new int[maxSize];
    }

    public final void addInOrder(int newNode, float newScore) {
        if (!(this.size == this.sortedNodeSize)) {
            boolean $i$a$-require-NeighborArray$addInOrder$22 = false;
            String $i$a$-require-NeighborArray$addInOrder$22 = "cannot call addInOrder after addOutOfOrder";
            throw new IllegalArgumentException($i$a$-require-NeighborArray$addInOrder$22.toString());
        }
        if (!(this.size != this.nodes.length)) {
            boolean bl = false;
            String string = "No growth is allowed";
            throw new IllegalStateException(string.toString());
        }
        if (this.size > 0) {
            float previousScore = this.scores[this.size - 1];
            if (!(this.scoresDescOrder && previousScore >= newScore || !this.scoresDescOrder && previousScore <= newScore)) {
                boolean bl = false;
                String string = "Nodes are added in the incorrect order! Comparing " + newScore + " to " + Arrays.INSTANCE.toString(ArrayUtil.Companion.copyOfSubArray(this.scores, 0, this.size));
                throw new IllegalArgumentException(string.toString());
            }
        }
        this.nodes[this.size] = newNode;
        this.scores[this.size] = newScore;
        ++this.size;
        ++this.sortedNodeSize;
    }

    public final void addOutOfOrder(int newNode, float newScore) {
        if (!(this.size != this.nodes.length)) {
            boolean bl = false;
            String string = "No growth is allowed";
            throw new IllegalStateException(string.toString());
        }
        this.scores[this.size] = newScore;
        this.nodes[this.size] = newNode;
        int n = this.size;
        this.size = n + 1;
    }

    public final void addAndEnsureDiversity(int newNode, float newScore, int nodeId, @NotNull UpdateableRandomVectorScorer scorer2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        this.addOutOfOrder(newNode, newScore);
        if (this.size < this.nodes.length) {
            return;
        }
        scorer2.setScoringOrdinal(nodeId);
        this.removeIndex(this.findWorstNonDiverse(scorer2));
        if (!(this.size == this.nodes.length - 1)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Nullable
    public final int[] sort(@NotNull RandomVectorScorer scorer2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)scorer2, (String)"scorer");
        if (this.size == this.sortedNodeSize) {
            return null;
        }
        if (!(this.sortedNodeSize < this.size)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int[] uncheckedIndexes = new int[this.size - this.sortedNodeSize];
        int count = 0;
        while (this.sortedNodeSize != this.size) {
            uncheckedIndexes[count] = this.insertSortedInternal(scorer2);
            int n = count;
            for (int i = 0; i < n; ++i) {
                if (uncheckedIndexes[i] < uncheckedIndexes[count]) continue;
                int n2 = i;
                int n3 = uncheckedIndexes[n2];
                uncheckedIndexes[n2] = n3 + 1;
            }
            ++count;
        }
        Arrays.INSTANCE.sort(uncheckedIndexes);
        return uncheckedIndexes;
    }

    private final int insertSortedInternal(RandomVectorScorer scorer2) throws IOException {
        if (!(this.sortedNodeSize < this.size)) {
            boolean $i$a$-require-NeighborArray$insertSortedInternal$22 = false;
            String $i$a$-require-NeighborArray$insertSortedInternal$22 = "Call this method only when there's unsorted node";
            throw new IllegalArgumentException($i$a$-require-NeighborArray$insertSortedInternal$22.toString());
        }
        int tmpNode = this.nodes[this.sortedNodeSize];
        float tmpScore = this.scores[this.sortedNodeSize];
        if (FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, tmpScore)) {
            RandomVectorScorer randomVectorScorer = scorer2;
            Intrinsics.checkNotNull((Object)randomVectorScorer);
            tmpScore = randomVectorScorer.score(tmpNode);
        }
        int insertionPoint = this.scoresDescOrder ? this.descSortFindRightMostInsertionPoint(tmpScore, this.sortedNodeSize) : this.ascSortFindRightMostInsertionPoint(tmpScore, this.sortedNodeSize);
        System.INSTANCE.arraycopy(this.nodes, insertionPoint, this.nodes, insertionPoint + 1, this.sortedNodeSize - insertionPoint);
        System.INSTANCE.arraycopy(this.scores, insertionPoint, this.scores, insertionPoint + 1, this.sortedNodeSize - insertionPoint);
        this.nodes[insertionPoint] = tmpNode;
        this.scores[insertionPoint] = tmpScore;
        ++this.sortedNodeSize;
        return insertionPoint;
    }

    public final void insertSorted(int newNode, float newScore) throws IOException {
        this.addOutOfOrder(newNode, newScore);
        this.insertSortedInternal(null);
    }

    public final int size() {
        return this.size;
    }

    @NotNull
    public final int[] nodes() {
        return this.nodes;
    }

    @NotNull
    public final float[] scores() {
        return this.scores;
    }

    public final void clear() {
        this.size = 0;
        this.sortedNodeSize = 0;
    }

    public final void removeLast() {
        int n = this.size;
        this.size = n + -1;
        this.sortedNodeSize = Math.min(this.sortedNodeSize, this.size);
    }

    public final void removeIndex(int idx) {
        int n;
        if (idx == this.size - 1) {
            this.removeLast();
            return;
        }
        System.INSTANCE.arraycopy(this.nodes, idx + 1, this.nodes, idx, this.size - idx - 1);
        System.INSTANCE.arraycopy(this.scores, idx + 1, this.scores, idx, this.size - idx - 1);
        if (idx < this.sortedNodeSize) {
            n = this.sortedNodeSize;
            this.sortedNodeSize = n + -1;
        }
        n = this.size;
        this.size = n + -1;
    }

    @NotNull
    public String toString() {
        return "NeighborArray[" + this.size + "]";
    }

    private final int ascSortFindRightMostInsertionPoint(float newScore, int bound) {
        int insertionPoint = Arrays.INSTANCE.binarySearch(this.scores, 0, bound, newScore);
        if (insertionPoint >= 0) {
            while (insertionPoint < bound - 1 && this.scores[insertionPoint + 1] == this.scores[insertionPoint]) {
                ++insertionPoint;
            }
            ++insertionPoint;
        } else {
            insertionPoint = -insertionPoint - 1;
        }
        return insertionPoint;
    }

    private final int descSortFindRightMostInsertionPoint(float newScore, int bound) {
        int start = 0;
        int end = bound - 1;
        while (start <= end) {
            int mid = (start + end) / 2;
            if (this.scores[mid] < newScore) {
                end = mid - 1;
                continue;
            }
            start = mid + 1;
        }
        return start;
    }

    private final int findWorstNonDiverse(UpdateableRandomVectorScorer scorer2) throws IOException {
        int[] nArray = this.sort(scorer2);
        if (nArray == null) {
            boolean $i$a$-checkNotNull-NeighborArray$findWorstNonDiverse$uncheckedIndexes$22 = false;
            String $i$a$-checkNotNull-NeighborArray$findWorstNonDiverse$uncheckedIndexes$22 = "We will always have something unchecked";
            throw new IllegalStateException($i$a$-checkNotNull-NeighborArray$findWorstNonDiverse$uncheckedIndexes$22.toString());
        }
        int[] uncheckedIndexes = nArray;
        int uncheckedCursor = uncheckedIndexes.length - 1;
        for (int i = this.size - 1; 0 < i && uncheckedCursor >= 0; --i) {
            scorer2.setScoringOrdinal(this.nodes[i]);
            if (this.isWorstNonDiverse(i, uncheckedIndexes, uncheckedCursor, scorer2)) {
                return i;
            }
            if (i != uncheckedIndexes[uncheckedCursor]) continue;
            --uncheckedCursor;
        }
        return this.size - 1;
    }

    private final boolean isWorstNonDiverse(int candidateIndex, int[] uncheckedIndexes, int uncheckedCursor, RandomVectorScorer scorer2) throws IOException {
        float minAcceptedSimilarity = this.scores[candidateIndex];
        if (candidateIndex == uncheckedIndexes[uncheckedCursor]) {
            for (int i = candidateIndex - 1; -1 < i; --i) {
                float neighborSimilarity = scorer2.score(this.nodes[i]);
                if (!(neighborSimilarity >= minAcceptedSimilarity)) continue;
                return true;
            }
        } else {
            if (!(candidateIndex > uncheckedIndexes[uncheckedCursor])) {
                String neighborSimilarity = "Failed requirement.";
                throw new IllegalArgumentException(neighborSimilarity.toString());
            }
            for (int i = uncheckedCursor; -1 < i; --i) {
                float neighborSimilarity = scorer2.score(this.nodes[uncheckedIndexes[i]]);
                if (!(neighborSimilarity >= minAcceptedSimilarity)) continue;
                return true;
            }
        }
        return false;
    }
}

