/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.hnsw;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.concurrent.atomics.AtomicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.internal.hppc.IntArrayList;
import org.gnit.lucenekmp.jdkport.AtomicIntExtKt;
import org.gnit.lucenekmp.jdkport.AtomicReferenceExtKt;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.hnsw.HnswGraph;
import org.gnit.lucenekmp.util.hnsw.NeighborArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 :2\u00020\u00012\u00020\u0002:\u00029:B\u0019\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010$\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004J\b\u0010\u0014\u001a\u00020\u0004H\u0016J\b\u0010\u001c\u001a\u00020\u0004H\u0016J\u0016\u0010'\u001a\u00020(2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004J\u0018\u0010)\u001a\u00020(2\u0006\u0010%\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0004H\u0016J\b\u0010+\u001a\u00020\u0004H\u0016J\b\u0010,\u001a\u00020\u0004H\u0016J\b\u0010-\u001a\u00020\u0004H\u0016J\b\u0010.\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\u0016\u0010/\u001a\u00020!2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004J\u001e\u00100\u001a\u00020!2\u0006\u0010&\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004J\u0010\u00102\u001a\u0002032\u0006\u0010%\u001a\u00020\u0004H\u0016J\b\u00104\u001a\u00020(H\u0002J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000208H\u0016R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000bR \u0010\f\u001a\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u001a\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00060\u0015j\u0002`\u0016X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u0012\u0004\b\u0017\u0010\u0018R\u001a\u0010\u001a\u001a\u00060\u0015j\u0002`\u0016X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u0012\u0004\b\u001b\u0010\u0018R\u001a\u0010\u001c\u001a\u00060\u0015j\u0002`\u0016X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\u0019\u0012\u0004\b\u001d\u0010\u0018R\u000e\u0010\u001e\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph;", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraph;", "Lorg/gnit/lucenekmp/util/Accountable;", "M", "", "numNodes", "<init>", "(II)V", "entryNode", "Lkotlin/concurrent/atomics/AtomicReference;", "Lorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph$EntryNode;", "Ljava/util/concurrent/atomic/AtomicReference;", "graph", "", "Lorg/gnit/lucenekmp/util/hnsw/NeighborArray;", "[[Lorg/gnit/lucenekmp/util/hnsw/NeighborArray;", "levelToNodes", "Lorg/gnit/lucenekmp/internal/hppc/IntArrayList;", "[Lorg/gnit/lucenekmp/internal/hppc/IntArrayList;", "lastFreezeSize", "size", "Lkotlin/concurrent/atomics/AtomicInt;", "Lorg/gnit/lucenekmp/jdkport/AtomicInteger;", "getSize$annotations", "()V", "Ljava/util/concurrent/atomic/AtomicInteger;", "nonZeroLevelSize", "getNonZeroLevelSize$annotations", "maxNodeId", "getMaxNodeId$annotations", "nsize", "nsize0", "noGrowth", "", "upto", "cur", "getNeighbors", "level", "node", "addNode", "", "seek", "targetNode", "neighborCount", "nextNeighbor", "numLevels", "maxConn", "trySetNewEntryNode", "tryPromoteNewEntryNode", "expectOldLevel", "getNodesOnLevel", "Lorg/gnit/lucenekmp/util/hnsw/HnswGraph$NodesIterator;", "generateLevelToNodes", "ramBytesUsed", "", "toString", "", "EntryNode", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nOnHeapHnswGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OnHeapHnswGraph.kt\norg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArrayUtil.kt\norg/gnit/lucenekmp/util/ArrayUtil$Companion\n*L\n1#1,327:1\n1#2:328\n217#3,5:329\n189#3,2:334\n222#3:336\n*S KotlinDebug\n*F\n+ 1 OnHeapHnswGraph.kt\norg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph\n*L\n141#1:329,5\n141#1:334,2\n141#1:336\n*E\n"})
public final class OnHeapHnswGraph
extends HnswGraph
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicReference<EntryNode> entryNode;
    @Nullable
    private NeighborArray[][] graph;
    @Nullable
    private IntArrayList[] levelToNodes;
    private int lastFreezeSize;
    @NotNull
    private final AtomicInteger size = new AtomicInteger(0);
    @NotNull
    private final AtomicInteger nonZeroLevelSize = new AtomicInteger(0);
    @NotNull
    private final AtomicInteger maxNodeId = new AtomicInteger(-1);
    private final int nsize;
    private final int nsize0;
    private final boolean noGrowth;
    private int upto;
    @Nullable
    private NeighborArray cur;
    private static final int INIT_SIZE = 128;

    public OnHeapHnswGraph(int M, int numNodes) {
        int numNodes2 = numNodes;
        this.entryNode = new AtomicReference<EntryNode>(new EntryNode(-1, 1));
        this.nsize = M + 1;
        this.nsize0 = M * 2 + 1;
        boolean bl = this.noGrowth = numNodes2 != -1;
        if (!this.noGrowth) {
            numNodes2 = 128;
        }
        this.graph = new NeighborArray[numNodes2][];
    }

    private static /* synthetic */ void getSize$annotations() {
    }

    private static /* synthetic */ void getNonZeroLevelSize$annotations() {
    }

    private static /* synthetic */ void getMaxNodeId$annotations() {
    }

    @NotNull
    public final NeighborArray getNeighbors(int level, int node) {
        Intrinsics.checkNotNull((Object)this.graph);
        if (!(node < ((Object[])this.graph).length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)this.graph);
        NeighborArray[] neighborArrayArray = this.graph[node];
        Intrinsics.checkNotNull((Object)neighborArrayArray);
        if (!(level < neighborArrayArray.length)) {
            boolean $i$a$-require-OnHeapHnswGraph$getNeighbors$22 = false;
            Intrinsics.checkNotNull((Object)this.graph);
            NeighborArray[] neighborArrayArray2 = this.graph[node];
            Intrinsics.checkNotNull((Object)neighborArrayArray2);
            String $i$a$-require-OnHeapHnswGraph$getNeighbors$22 = "level=" + level + ", node " + node + " has only " + neighborArrayArray2.length + " levels for graph " + this;
            throw new IllegalArgumentException($i$a$-require-OnHeapHnswGraph$getNeighbors$22.toString());
        }
        Intrinsics.checkNotNull((Object)this.graph);
        NeighborArray[] neighborArrayArray3 = this.graph[node];
        Intrinsics.checkNotNull((Object)neighborArrayArray3);
        if (neighborArrayArray3[level] == null) {
            boolean bl = false;
            String string = "node=" + node + ", level=" + level;
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNull((Object)this.graph);
        NeighborArray[] neighborArrayArray4 = this.graph[node];
        Intrinsics.checkNotNull((Object)neighborArrayArray4);
        return neighborArrayArray4[level];
    }

    @Override
    public int size() {
        return AtomicIntExtKt.get(this.size);
    }

    @Override
    public int maxNodeId() {
        int n;
        if (this.noGrowth) {
            Intrinsics.checkNotNull((Object)this.graph);
            n = ((Object[])this.graph).length - 1;
        } else {
            n = AtomicIntExtKt.get(this.maxNodeId);
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public final void addNode(int level, int node) {
        Intrinsics.checkNotNull((Object)this.graph);
        if (node >= ((Object[])this.graph).length) {
            if (!(this.noGrowth == false)) {
                $i$a$-check-OnHeapHnswGraph$addNode$1 = false;
                $i$a$-check-OnHeapHnswGraph$addNode$1 = "The graph does not expect to grow when an initial size is given";
                throw new IllegalStateException($i$a$-check-OnHeapHnswGraph$addNode$1.toString());
            }
            var3_8 = ArrayUtil.Companion;
            Intrinsics.checkNotNull((Object)this.graph);
            $i$a$-check-OnHeapHnswGraph$addNode$1 = (Object[])this.graph;
            var5_9 = node + 1;
            var15_10 = this;
            $i$f$growNullable = false;
            if (minSize$iv < 0) {
                throw new Exception("size must be positive (got " + (int)minSize$iv + "): likely integer overflow?");
            }
            if (((void)array$iv).length < minSize$iv) {
                newLength$iv = this_$iv.oversize((int)minSize$iv, 4);
                var8_13 = this_$iv;
                var9_14 = array$iv;
                newLength$iv$iv = newLength$iv;
                $i$f$growExactNullable = false;
                if (newLength$iv$iv < ((void)array$iv$iv).length) {
                    throw new IndexOutOfBoundsException("newLength (" + newLength$iv$iv + ") < array.size (" + ((void)array$iv$iv).length + ")");
                }
                var13_18 = new NeighborArray[newLength$iv$iv][];
                for (var12_17 = 0; var12_17 < newLength$iv$iv; ++var12_17) {
                    var14_19 = var12_17;
                    var13_18[var14_19] = var14_19 < ((void)array$iv$iv).length ? array$iv$iv[var14_19] : null;
                }
                v0 = var13_18;
            } else {
                v0 = array$iv;
            }
            var15_10.graph = v0;
        }
        Intrinsics.checkNotNull((Object)this.graph);
        if (this.graph[node] == null) ** GOTO lbl-1000
        Intrinsics.checkNotNull((Object)this.graph);
        v1 = this.graph[node];
        Intrinsics.checkNotNull((Object)v1);
        if (v1.length > level) lbl-1000:
        // 2 sources

        {
            v2 = true;
        } else {
            v2 = false;
        }
        if (!v2) {
            $i$a$-require-OnHeapHnswGraph$addNode$2 = false;
            var4_7 = "node must be inserted from the top level";
            throw new IllegalArgumentException(var4_7.toString());
        }
        Intrinsics.checkNotNull((Object)this.graph);
        if (this.graph[node] == null) {
            Intrinsics.checkNotNull((Object)this.graph);
            this.graph[node] = new NeighborArray[level + 1];
            AtomicsKt.incrementAndFetch((AtomicInteger)this.size);
        }
        if (level == 0) {
            Intrinsics.checkNotNull((Object)this.graph);
            v3 = this.graph[node];
            Intrinsics.checkNotNull((Object)v3);
            v3[level] = new NeighborArray(this.nsize0, true);
        } else {
            Intrinsics.checkNotNull((Object)this.graph);
            v4 = this.graph[node];
            Intrinsics.checkNotNull((Object)v4);
            v4[level] = new NeighborArray(this.nsize, true);
            AtomicsKt.incrementAndFetch((AtomicInteger)this.nonZeroLevelSize);
        }
        AtomicIntExtKt.accumulateAndGet(this.maxNodeId, node, (Function2<? super Integer, ? super Integer, Integer>)(Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, addNode$lambda$4(int int ), (Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/Integer;)());
    }

    @Override
    public void seek(int level, int targetNode) {
        this.cur = this.getNeighbors(level, targetNode);
        this.upto = -1;
    }

    @Override
    public int neighborCount() {
        NeighborArray neighborArray = this.cur;
        Intrinsics.checkNotNull((Object)neighborArray);
        return neighborArray.size();
    }

    @Override
    public int nextNeighbor() {
        ++this.upto;
        NeighborArray neighborArray = this.cur;
        Intrinsics.checkNotNull((Object)neighborArray);
        if (this.upto < neighborArray.size()) {
            NeighborArray neighborArray2 = this.cur;
            Intrinsics.checkNotNull((Object)neighborArray2);
            return neighborArray2.nodes()[this.upto];
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int numLevels() {
        return AtomicReferenceExtKt.get(this.entryNode).getLevel() + 1;
    }

    @Override
    public int maxConn() {
        return this.nsize - 1;
    }

    @Override
    public int entryNode() {
        return AtomicReferenceExtKt.get(this.entryNode).getNode();
    }

    public final boolean trySetNewEntryNode(int node, int level) {
        EntryNode current = AtomicReferenceExtKt.get(this.entryNode);
        if (current.getNode() == -1) {
            return this.entryNode.compareAndSet(current, new EntryNode(node, level));
        }
        return false;
    }

    public final boolean tryPromoteNewEntryNode(int node, int level, int expectOldLevel) {
        if (!(level > expectOldLevel)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        EntryNode currentEntry = AtomicReferenceExtKt.get(this.entryNode);
        if (currentEntry.getLevel() == expectOldLevel) {
            return this.entryNode.compareAndSet(currentEntry, new EntryNode(node, level));
        }
        return false;
    }

    @Override
    @NotNull
    public HnswGraph.NodesIterator getNodesOnLevel(int level) {
        if (!(this.size() == this.maxNodeId() + 1)) {
            boolean bl = false;
            String string = "graph build not complete, size=" + this.size() + " maxNodeId=" + this.maxNodeId();
            throw new IllegalStateException(string.toString());
        }
        if (level == 0) {
            return new HnswGraph.ArrayNodesIterator(this.size());
        }
        this.generateLevelToNodes();
        Intrinsics.checkNotNull((Object)this.levelToNodes);
        IntArrayList intArrayList = this.levelToNodes[level];
        Intrinsics.checkNotNull((Object)intArrayList);
        return new HnswGraph.CollectionNodesIterator(intArrayList);
    }

    private final void generateLevelToNodes() {
        if (this.lastFreezeSize == this.size()) {
            return;
        }
        int maxLevels = this.numLevels();
        this.levelToNodes = new IntArrayList[maxLevels];
        for (int i = 1; i < maxLevels; ++i) {
            Intrinsics.checkNotNull((Object)this.levelToNodes);
            this.levelToNodes[i] = new IntArrayList();
        }
        int nonNullNode = 0;
        Intrinsics.checkNotNull((Object)this.graph);
        int n = ((Object[])this.graph).length;
        for (int node = 0; node < n; ++node) {
            Intrinsics.checkNotNull((Object)this.graph);
            if (this.graph[node] == null) continue;
            ++nonNullNode;
            Intrinsics.checkNotNull((Object)this.graph);
            NeighborArray[] neighborArrayArray = this.graph[node];
            Intrinsics.checkNotNull((Object)neighborArrayArray);
            int n2 = neighborArrayArray.length;
            for (int i = 1; i < n2; ++i) {
                Intrinsics.checkNotNull((Object)this.levelToNodes);
                IntArrayList intArrayList = this.levelToNodes[i];
                Intrinsics.checkNotNull((Object)intArrayList);
                intArrayList.add(node);
            }
            if (nonNullNode == this.size()) break;
        }
        this.lastFreezeSize = this.size();
    }

    @Override
    public long ramBytesUsed() {
        long neighborArrayBytes0 = (long)this.nsize0 * (long)8 + 16L + 8L + (long)12;
        long neighborArrayBytes = (long)this.nsize * (long)8 + 16L + 8L + (long)12;
        long total = 0L;
        total += (long)this.size() * (neighborArrayBytes0 + (long)8) + (long)8;
        total += (long)AtomicIntExtKt.get(this.nonZeroLevelSize) * neighborArrayBytes;
        total += 16L;
        ++total;
        total += (long)20;
        total += 36L;
        total += (long)4;
        total += (long)8;
        if (this.levelToNodes != null) {
            total += (long)(this.numLevels() - 1) * (long)4;
            total += (long)AtomicIntExtKt.get(this.nonZeroLevelSize) * (long)20;
        }
        return total;
    }

    @NotNull
    public String toString() {
        return "OnHeapHnswGraph(size=" + this.size() + ", numLevels=" + this.numLevels() + ", entryNode=" + this.entryNode() + ")";
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    private static final int addNode$lambda$4(int a, int b) {
        return Math.max(a, b);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph$Companion;", "", "<init>", "()V", "INIT_SIZE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/util/hnsw/OnHeapHnswGraph$EntryNode;", "", "node", "", "level", "<init>", "(II)V", "getNode", "()I", "getLevel", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "core"})
    private static final class EntryNode {
        private final int node;
        private final int level;

        public EntryNode(int node, int level) {
            this.node = node;
            this.level = level;
        }

        public final int getNode() {
            return this.node;
        }

        public final int getLevel() {
            return this.level;
        }

        public final int component1() {
            return this.node;
        }

        public final int component2() {
            return this.level;
        }

        @NotNull
        public final EntryNode copy(int node, int level) {
            return new EntryNode(node, level);
        }

        public static /* synthetic */ EntryNode copy$default(EntryNode entryNode, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = entryNode.node;
            }
            if ((n3 & 2) != 0) {
                n2 = entryNode.level;
            }
            return entryNode.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "EntryNode(node=" + this.node + ", level=" + this.level + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.node);
            result = result * 31 + Integer.hashCode(this.level);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EntryNode)) {
                return false;
            }
            EntryNode entryNode = (EntryNode)other;
            if (this.node != entryNode.node) {
                return false;
            }
            return this.level == entryNode.level;
        }
    }
}

