/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\n\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\b&\u0018\u0000 12\u00020\u0001:\u00011B\u0019\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010'\u001a\u00020(2\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010)\u001a\u00020(H\u0002J\u000e\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\u001cJ\u0006\u0010,\u001a\u00020(J\u0006\u0010-\u001a\u00020(J\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010.\u001a\u00020(H$J\u0010\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020\u0005H\u0004R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u00062"}, d2={"Lorg/gnit/lucenekmp/util/packed/AbstractBlockPackedWriter;", "", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "blockSize", "", "<init>", "(Lorg/gnit/lucenekmp/store/DataOutput;I)V", "getOut", "()Lorg/gnit/lucenekmp/store/DataOutput;", "setOut", "(Lorg/gnit/lucenekmp/store/DataOutput;)V", "values", "", "getValues", "()[J", "blocks", "", "getBlocks", "()[B", "setBlocks", "([B)V", "off", "getOff", "()I", "setOff", "(I)V", "ord", "", "getOrd", "()J", "setOrd", "(J)V", "finished", "", "getFinished", "()Z", "setFinished", "(Z)V", "reset", "", "checkNotFinished", "add", "l", "addBlockOfZeros", "finish", "flush", "writeValues", "bitsRequired", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nAbstractBlockPackedWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractBlockPackedWriter.kt\norg/gnit/lucenekmp/util/packed/AbstractBlockPackedWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,122:1\n1#2:123\n*E\n"})
public abstract class AbstractBlockPackedWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private DataOutput out;
    @NotNull
    private final long[] values;
    @Nullable
    private byte[] blocks;
    private int off;
    private long ord;
    private boolean finished;
    public static final int MIN_BLOCK_SIZE = 64;
    public static final int MAX_BLOCK_SIZE = 0x8000000;
    public static final int MIN_VALUE_EQUALS_0 = 1;
    public static final int BPV_SHIFT = 1;

    protected AbstractBlockPackedWriter(@NotNull DataOutput out, int blockSize) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        PackedInts.INSTANCE.checkBlockSize(blockSize, 64, 0x8000000);
        this.reset(out);
        this.values = new long[blockSize];
    }

    @Nullable
    protected final DataOutput getOut() {
        return this.out;
    }

    protected final void setOut(@Nullable DataOutput dataOutput) {
        this.out = dataOutput;
    }

    @NotNull
    protected final long[] getValues() {
        return this.values;
    }

    @Nullable
    protected final byte[] getBlocks() {
        return this.blocks;
    }

    protected final void setBlocks(@Nullable byte[] byArray) {
        this.blocks = byArray;
    }

    protected final int getOff() {
        return this.off;
    }

    protected final void setOff(int n) {
        this.off = n;
    }

    protected final long getOrd() {
        return this.ord;
    }

    protected final void setOrd(long l) {
        this.ord = l;
    }

    protected final boolean getFinished() {
        return this.finished;
    }

    protected final void setFinished(boolean bl) {
        this.finished = bl;
    }

    public final void reset(@NotNull DataOutput out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.out = out;
        this.off = 0;
        this.ord = 0L;
        this.finished = false;
    }

    private final void checkNotFinished() {
        if (!(!this.finished)) {
            boolean bl = false;
            String string = "Already finished";
            throw new IllegalStateException(string.toString());
        }
    }

    public final void add(long l) throws IOException {
        this.checkNotFinished();
        if (this.off == this.values.length) {
            this.flush();
        }
        int n = this.off;
        this.off = n + 1;
        this.values[n] = l;
        ++this.ord;
    }

    public final void addBlockOfZeros() throws IOException {
        this.checkNotFinished();
        if (!(this.off == 0 || this.off == this.values.length)) {
            boolean bl = false;
            String string = "" + this.off;
            throw new IllegalStateException(string.toString());
        }
        if (this.off == this.values.length) {
            this.flush();
        }
        Arrays.INSTANCE.fill(this.values, 0L);
        this.off = this.values.length;
        this.ord += (long)this.values.length;
    }

    public final void finish() throws IOException {
        this.checkNotFinished();
        if (this.off > 0) {
            this.flush();
        }
        this.finished = true;
    }

    public final long ord() {
        return this.ord;
    }

    protected abstract void flush() throws IOException;

    protected final void writeValues(int bitsRequired) throws IOException {
        int iterations;
        PackedInts.Encoder encoder;
        block5: {
            int blockSize;
            block4: {
                encoder = PackedInts.INSTANCE.getEncoder(PackedInts.Format.PACKED, PackedInts.INSTANCE.getVERSION_CURRENT(), bitsRequired);
                iterations = this.values.length / encoder.byteValueCount();
                blockSize = encoder.byteBlockCount() * iterations;
                if (this.blocks == null) break block4;
                Intrinsics.checkNotNull((Object)this.blocks);
                if (this.blocks.length >= blockSize) break block5;
            }
            this.blocks = new byte[blockSize];
        }
        if (this.off < this.values.length) {
            Arrays.INSTANCE.fill(this.values, this.off, this.values.length, 0L);
        }
        Intrinsics.checkNotNull((Object)this.blocks);
        encoder.encode(this.values, 0, this.blocks, 0, iterations);
        int blockCount = (int)PackedInts.Format.PACKED.byteCount(PackedInts.INSTANCE.getVERSION_CURRENT(), this.off, bitsRequired);
        DataOutput dataOutput = this.out;
        Intrinsics.checkNotNull((Object)dataOutput);
        Intrinsics.checkNotNull((Object)this.blocks);
        dataOutput.writeBytes(this.blocks, blockCount);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/util/packed/AbstractBlockPackedWriter$Companion;", "", "<init>", "()V", "MIN_BLOCK_SIZE", "", "MAX_BLOCK_SIZE", "MIN_VALUE_EQUALS_0", "BPV_SHIFT", "writeVLong", "", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "i", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final void writeVLong(@NotNull DataOutput out, long i) throws IOException {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            long i2 = i;
            int k = 0;
            while ((i2 & 0xFFFFFFFFFFFFFF80L) != 0L && k++ < 8) {
                out.writeByte((byte)(i2 & 0x7FL | 0x80L));
                i2 >>>= 7;
            }
            out.writeByte((byte)i2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

