/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.LongValues;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\f\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 .*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00002\u00020\u00022\u00020\u0003:\u0001.B!\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010\u0019\u001a\u00020\u001aH\u0004J\u0018\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H$J\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\b\u001a\u00020\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0007J\u000e\u0010 \u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u0007J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020\u0007H\u0016J\u0016\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007J\b\u0010$\u001a\u00020\u0007H\u0014J\b\u0010%\u001a\u00020\u0007H\u0016J\u0015\u0010&\u001a\u00028\u00002\u0006\u0010'\u001a\u00020\u0007H$\u00a2\u0006\u0002\u0010(J\u0013\u0010)\u001a\u00028\u00002\u0006\u0010'\u001a\u00020\u0007\u00a2\u0006\u0002\u0010(J\u0017\u0010*\u001a\u00028\u00002\b\b\u0002\u0010+\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010(J\b\u0010,\u001a\u00020-H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u001b\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006/"}, d2={"Lorg/gnit/lucenekmp/util/packed/AbstractPagedMutable;", "T", "Lorg/gnit/lucenekmp/util/LongValues;", "Lorg/gnit/lucenekmp/util/Accountable;", "bitsPerValue", "", "size", "", "pageSize", "<init>", "(IJI)V", "getBitsPerValue", "()I", "getSize", "()J", "pageShift", "getPageShift", "pageMask", "getPageMask", "subMutables", "", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Mutable;", "getSubMutables", "()[Lorg/gnit/lucenekmp/util/packed/PackedInts$Mutable;", "[Lorg/gnit/lucenekmp/util/packed/PackedInts$Mutable;", "fillPages", "", "newMutable", "valueCount", "lastPageSize", "pageIndex", "index", "indexInPage", "get", "set", "value", "baseRamBytesUsed", "ramBytesUsed", "newUnfilledCopy", "newSize", "(J)Lorg/gnit/lucenekmp/util/packed/AbstractPagedMutable;", "resize", "grow", "minSize", "toString", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nAbstractPagedMutable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractPagedMutable.kt\norg/gnit/lucenekmp/util/packed/AbstractPagedMutable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
public abstract class AbstractPagedMutable<T extends AbstractPagedMutable<T>>
extends LongValues
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int bitsPerValue;
    private final long size;
    private final int pageShift;
    private final int pageMask;
    @NotNull
    private final PackedInts.Mutable[] subMutables;
    public static final int MIN_BLOCK_SIZE = 64;
    public static final int MAX_BLOCK_SIZE = 0x40000000;

    public AbstractPagedMutable(int bitsPerValue, long size2, int pageSize) {
        this.bitsPerValue = bitsPerValue;
        this.size = size2;
        this.pageShift = PackedInts.INSTANCE.checkBlockSize(pageSize, 64, 0x40000000);
        this.pageMask = pageSize - 1;
        int numPages = PackedInts.INSTANCE.numBlocks(this.size, pageSize);
        this.subMutables = new PackedInts.Mutable[numPages];
    }

    public final int getBitsPerValue() {
        return this.bitsPerValue;
    }

    public final long getSize() {
        return this.size;
    }

    public final int getPageShift() {
        return this.pageShift;
    }

    public final int getPageMask() {
        return this.pageMask;
    }

    @NotNull
    public final PackedInts.Mutable[] getSubMutables() {
        return this.subMutables;
    }

    protected final void fillPages() {
        int numPages = PackedInts.INSTANCE.numBlocks(this.size, this.pageSize());
        for (int i = 0; i < numPages; ++i) {
            int valueCount = i == numPages - 1 ? this.lastPageSize(this.size) : this.pageSize();
            this.subMutables[i] = this.newMutable(valueCount, this.bitsPerValue);
        }
    }

    @NotNull
    protected abstract PackedInts.Mutable newMutable(int var1, int var2);

    public final int lastPageSize(long size2) {
        int sz = this.indexInPage(size2);
        return sz == 0 ? this.pageSize() : sz;
    }

    public final int pageSize() {
        return this.pageMask + 1;
    }

    public final long size() {
        return this.size;
    }

    public final int pageIndex(long index) {
        return (int)(index >>> this.pageShift);
    }

    public final int indexInPage(long index) {
        return (int)index & this.pageMask;
    }

    @Override
    public long get(long index) {
        if (!(index >= 0L && index < this.size)) {
            boolean $i$a$-require-AbstractPagedMutable$get$22 = false;
            String $i$a$-require-AbstractPagedMutable$get$22 = "index=" + index + " size=" + this.size;
            throw new IllegalArgumentException($i$a$-require-AbstractPagedMutable$get$22.toString());
        }
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        PackedInts.Mutable mutable = this.subMutables[pageIndex];
        Intrinsics.checkNotNull((Object)mutable);
        return mutable.get(indexInPage);
    }

    public final void set(long index, long value) {
        if (!(index >= 0L && index < this.size)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int pageIndex = this.pageIndex(index);
        int indexInPage = this.indexInPage(index);
        PackedInts.Mutable mutable = this.subMutables[pageIndex];
        Intrinsics.checkNotNull((Object)mutable);
        mutable.set(indexInPage, value);
    }

    protected long baseRamBytesUsed() {
        return 32L;
    }

    @Override
    public long ramBytesUsed() {
        long bytesUsed = RamUsageEstimator.Companion.alignObjectSize(this.baseRamBytesUsed());
        bytesUsed += RamUsageEstimator.Companion.alignObjectSize(RamUsageEstimator.Companion.shallowSizeOf((Object)this.subMutables));
        PackedInts.Mutable[] mutableArray = this.subMutables;
        int n = mutableArray.length;
        for (int i = 0; i < n; ++i) {
            PackedInts.Mutable gw;
            PackedInts.Mutable mutable = gw = mutableArray[i];
            Intrinsics.checkNotNull((Object)mutable);
            bytesUsed += mutable.ramBytesUsed();
        }
        return bytesUsed;
    }

    @NotNull
    protected abstract T newUnfilledCopy(long var1);

    @NotNull
    public final T resize(long newSize) {
        T copy = this.newUnfilledCopy(newSize);
        int numCommonPages = Math.min(((AbstractPagedMutable)copy).subMutables.length, this.subMutables.length);
        long[] copyBuffer = new long[1024];
        int n = ((AbstractPagedMutable)copy).subMutables.length;
        for (int i = 0; i < n; ++i) {
            int n2;
            int valueCount;
            int n3 = valueCount = i == ((AbstractPagedMutable)copy).subMutables.length - 1 ? this.lastPageSize(newSize) : this.pageSize();
            if (i < numCommonPages) {
                PackedInts.Mutable mutable = this.subMutables[i];
                Intrinsics.checkNotNull((Object)mutable);
                n2 = mutable.getBitsPerValue();
            } else {
                n2 = this.bitsPerValue;
            }
            int bpv = n2;
            ((AbstractPagedMutable)copy).subMutables[i] = this.newMutable(valueCount, bpv);
            if (i >= numCommonPages) continue;
            PackedInts.Mutable mutable = this.subMutables[i];
            Intrinsics.checkNotNull((Object)mutable);
            int copyLength = Math.min(valueCount, mutable.size());
            PackedInts.Mutable mutable2 = this.subMutables[i];
            Intrinsics.checkNotNull((Object)mutable2);
            PackedInts.Reader reader2 = mutable2;
            PackedInts.Mutable mutable3 = ((AbstractPagedMutable)copy).subMutables[i];
            Intrinsics.checkNotNull((Object)mutable3);
            PackedInts.INSTANCE.copy(reader2, 0, mutable3, 0, copyLength, copyBuffer);
        }
        return copy;
    }

    @JvmOverloads
    @NotNull
    public final T grow(long minSize) {
        if (!(minSize >= 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (minSize <= this.size()) {
            Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type T of org.gnit.lucenekmp.util.packed.AbstractPagedMutable");
            AbstractPagedMutable result = this;
            return (T)result;
        }
        long extra = minSize >>> 3;
        if (extra < 3L) {
            extra = 3L;
        }
        long newSize = minSize + extra;
        return this.resize(newSize);
    }

    public static /* synthetic */ AbstractPagedMutable grow$default(AbstractPagedMutable abstractPagedMutable, long l, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: grow");
        }
        if ((n & 1) != 0) {
            l = abstractPagedMutable.size() + 1L;
        }
        return abstractPagedMutable.grow(l);
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(size=" + this.size() + ",pageSize=" + this.pageSize() + ")";
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @JvmOverloads
    @NotNull
    public final T grow() {
        return (T)AbstractPagedMutable.grow$default(this, 0L, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/gnit/lucenekmp/util/packed/AbstractPagedMutable$Companion;", "", "<init>", "()V", "MIN_BLOCK_SIZE", "", "MAX_BLOCK_SIZE", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

