/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import java.io.EOFException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.util.BitUtil;
import org.gnit.lucenekmp.util.LongsRef;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 22\u00020\u0001:\u00012B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0016\u0010+\u001a\u00020,2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020\bJ\u0010\u0010/\u001a\u00020,2\u0006\u0010.\u001a\u00020\bH\u0002J\u0006\u00100\u001a\u00020\bJ\u000e\u00100\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u0005J\b\u00101\u001a\u00020,H\u0002J\u0006\u0010(\u001a\u00020\bR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0010\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0012\"\u0004\b*\u0010\u0014\u00a8\u00063"}, d2={"Lorg/gnit/lucenekmp/util/packed/BlockPackedReaderIterator;", "", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "packedIntsVersion", "", "blockSize", "valueCount", "", "<init>", "(Lorg/gnit/lucenekmp/store/DataInput;IIJ)V", "getIn", "()Lorg/gnit/lucenekmp/store/DataInput;", "setIn", "(Lorg/gnit/lucenekmp/store/DataInput;)V", "getPackedIntsVersion", "()I", "getValueCount", "()J", "setValueCount", "(J)V", "getBlockSize", "values", "", "getValues", "()[J", "valuesRef", "Lorg/gnit/lucenekmp/util/LongsRef;", "getValuesRef", "()Lorg/gnit/lucenekmp/util/LongsRef;", "blocks", "", "getBlocks", "()[B", "setBlocks", "([B)V", "off", "getOff", "setOff", "(I)V", "ord", "getOrd", "setOrd", "reset", "", "skip", "count", "skipBytes", "next", "refill", "Companion", "core"})
public final class BlockPackedReaderIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private DataInput in;
    private final int packedIntsVersion;
    private long valueCount;
    private final int blockSize;
    @NotNull
    private final long[] values;
    @NotNull
    private final LongsRef valuesRef;
    @Nullable
    private byte[] blocks;
    private int off;
    private long ord;

    public BlockPackedReaderIterator(@NotNull DataInput in, int packedIntsVersion, int blockSize, long valueCount) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        PackedInts.INSTANCE.checkBlockSize(blockSize, 64, 0x8000000);
        this.packedIntsVersion = packedIntsVersion;
        this.blockSize = blockSize;
        this.values = new long[blockSize];
        this.valuesRef = new LongsRef(this.values, 0, 0);
        this.reset(in, valueCount);
    }

    @Nullable
    public final DataInput getIn() {
        return this.in;
    }

    public final void setIn(@Nullable DataInput dataInput) {
        this.in = dataInput;
    }

    public final int getPackedIntsVersion() {
        return this.packedIntsVersion;
    }

    public final long getValueCount() {
        return this.valueCount;
    }

    public final void setValueCount(long l) {
        this.valueCount = l;
    }

    public final int getBlockSize() {
        return this.blockSize;
    }

    @NotNull
    public final long[] getValues() {
        return this.values;
    }

    @NotNull
    public final LongsRef getValuesRef() {
        return this.valuesRef;
    }

    @Nullable
    public final byte[] getBlocks() {
        return this.blocks;
    }

    public final void setBlocks(@Nullable byte[] byArray) {
        this.blocks = byArray;
    }

    public final int getOff() {
        return this.off;
    }

    public final void setOff(int n) {
        this.off = n;
    }

    public final long getOrd() {
        return this.ord;
    }

    public final void setOrd(long l) {
        this.ord = l;
    }

    public final void reset(@NotNull DataInput in, long valueCount) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        this.in = in;
        if (!(valueCount >= 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.valueCount = valueCount;
        this.off = this.blockSize;
        this.ord = 0L;
    }

    public final void skip(long count) throws IOException {
        long count2 = count;
        if (!(count2 >= 0L)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.ord + count2 > this.valueCount || this.ord + count2 < 0L) {
            throw new EOFException();
        }
        int skipBuffer = (int)Math.min(count2, (long)(this.blockSize - this.off));
        this.off += skipBuffer;
        this.ord += (long)skipBuffer;
        if ((count2 -= (long)skipBuffer) == 0L) {
            return;
        }
        if (!(this.off == this.blockSize)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        while (count2 >= (long)this.blockSize) {
            DataInput dataInput = this.in;
            Intrinsics.checkNotNull((Object)dataInput);
            byte token = (byte)(dataInput.readByte() & 0xFFFFFFFF);
            int bitsPerValue = token >>> 1;
            if (bitsPerValue > 64) {
                throw new IOException("Corrupted");
            }
            if ((token & 1) == 0) {
                DataInput dataInput2 = this.in;
                Intrinsics.checkNotNull((Object)dataInput2);
                Companion.readVLong(dataInput2);
            }
            long blockBytes = PackedInts.Format.PACKED.byteCount(this.packedIntsVersion, this.blockSize, bitsPerValue);
            this.skipBytes(blockBytes);
            this.ord += (long)this.blockSize;
            count2 -= (long)this.blockSize;
        }
        if (count2 == 0L) {
            return;
        }
        if (!(count2 < (long)this.blockSize)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.refill();
        this.ord += count2;
        this.off += (int)count2;
    }

    private final void skipBytes(long count) throws IOException {
        if (this.in instanceof IndexInput) {
            DataInput dataInput = this.in;
            Intrinsics.checkNotNull((Object)dataInput, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.store.IndexInput");
            IndexInput indexInput = (IndexInput)dataInput;
            DataInput dataInput2 = this.in;
            Intrinsics.checkNotNull((Object)dataInput2, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.store.IndexInput");
            indexInput.seek(((IndexInput)dataInput2).getFilePointer() + count);
        } else {
            int toSkip;
            if (this.blocks == null) {
                this.blocks = new byte[this.blockSize];
            }
            for (long skipped = 0L; skipped < count; skipped += (long)toSkip) {
                Intrinsics.checkNotNull((Object)this.blocks);
                toSkip = (int)Math.min((long)this.blocks.length, count - skipped);
                DataInput dataInput = this.in;
                Intrinsics.checkNotNull((Object)dataInput);
                Intrinsics.checkNotNull((Object)this.blocks);
                dataInput.readBytes(this.blocks, 0, toSkip);
            }
        }
    }

    public final long next() throws IOException {
        if (this.ord == this.valueCount) {
            throw new EOFException();
        }
        if (this.off == this.blockSize) {
            this.refill();
        }
        int n = this.off;
        this.off = n + 1;
        long value = this.values[n];
        ++this.ord;
        return value;
    }

    @NotNull
    public final LongsRef next(int count) throws IOException {
        int count2 = count;
        if (!(count2 > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.ord == this.valueCount) {
            throw new EOFException();
        }
        if (this.off == this.blockSize) {
            this.refill();
        }
        count2 = Math.min(count2, this.blockSize - this.off);
        count2 = (int)Math.min((long)count2, this.valueCount - this.ord);
        this.valuesRef.setOffset(this.off);
        this.valuesRef.setLength(count2);
        this.off += count2;
        this.ord += (long)count2;
        return this.valuesRef;
    }

    private final void refill() throws IOException {
        block10: {
            int iterations;
            PackedInts.Decoder decoder;
            long minValue;
            int bitsPerValue;
            block12: {
                int blocksSize;
                block11: {
                    block9: {
                        DataInput dataInput = this.in;
                        Intrinsics.checkNotNull((Object)dataInput);
                        byte token = (byte)(dataInput.readByte() & 0xFFFFFFFF);
                        boolean minEquals0 = (token & 1) != 0;
                        bitsPerValue = token >>> 1;
                        if (bitsPerValue > 64) {
                            throw new IOException("Corrupted");
                        }
                        if (minEquals0) {
                            v1 = 0L;
                        } else {
                            DataInput dataInput2 = this.in;
                            Intrinsics.checkNotNull((Object)dataInput2);
                            v1 = minValue = BitUtil.INSTANCE.zigZagDecode(1L + Companion.readVLong(dataInput2));
                        }
                        if (!(minEquals0 || minValue != 0L)) {
                            String string = "Failed requirement.";
                            throw new IllegalArgumentException(string.toString());
                        }
                        if (bitsPerValue != 0) break block9;
                        Arrays.INSTANCE.fill(this.values, minValue);
                        break block10;
                    }
                    decoder = PackedInts.INSTANCE.getDecoder(PackedInts.Format.PACKED, this.packedIntsVersion, bitsPerValue);
                    iterations = this.blockSize / decoder.byteValueCount();
                    blocksSize = iterations * decoder.byteBlockCount();
                    if (this.blocks == null) break block11;
                    Intrinsics.checkNotNull((Object)this.blocks);
                    if (this.blocks.length >= blocksSize) break block12;
                }
                this.blocks = new byte[blocksSize];
            }
            int valueCount = (int)Math.min(this.valueCount - this.ord, (long)this.blockSize);
            int blocksCount = (int)PackedInts.Format.PACKED.byteCount(this.packedIntsVersion, valueCount, bitsPerValue);
            DataInput dataInput = this.in;
            Intrinsics.checkNotNull((Object)dataInput);
            Intrinsics.checkNotNull((Object)this.blocks);
            dataInput.readBytes(this.blocks, 0, blocksCount);
            Intrinsics.checkNotNull((Object)this.blocks);
            decoder.decode(this.blocks, 0, this.values, 0, iterations);
            if (minValue != 0L) {
                int i = 0;
                while (i < valueCount) {
                    long[] lArray = this.values;
                    int n = i++;
                    lArray[n] = lArray[n] + minValue;
                }
            }
        }
        this.off = 0;
    }

    public final long ord() {
        return this.ord;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/util/packed/BlockPackedReaderIterator$Companion;", "", "<init>", "()V", "readVLong", "", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final long readVLong(@NotNull DataInput in) throws IOException {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            long l = 0L;
            for (int shift = 0; shift < 56; shift += 7) {
                byte b = in.readByte();
                l |= ((long)b & 0x7FL) << shift;
                if (b < 0) continue;
                return l;
            }
            return l | (long)((byte)(in.readByte() & 0xFFFFFFFF) << 56);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

