/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.BitUtil;
import org.gnit.lucenekmp.util.packed.AbstractBlockPackedWriter;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/util/packed/BlockPackedWriter;", "Lorg/gnit/lucenekmp/util/packed/AbstractBlockPackedWriter;", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "blockSize", "", "<init>", "(Lorg/gnit/lucenekmp/store/DataOutput;I)V", "flush", "", "core"})
public final class BlockPackedWriter
extends AbstractBlockPackedWriter {
    public BlockPackedWriter(@NotNull DataOutput out, int blockSize) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        super(out, blockSize);
    }

    @Override
    protected void flush() throws IOException {
        int bitsRequired;
        if (!(this.getOff() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        int n = this.getOff();
        for (int i = 0; i < n; ++i) {
            min = Math.min(this.getValues()[i], min);
            max = Math.max(this.getValues()[i], max);
        }
        long delta = max - min;
        int n2 = bitsRequired = delta == 0L ? 0 : PackedInts.INSTANCE.unsignedBitsRequired(delta);
        if (bitsRequired == 64) {
            min = 0L;
        } else if (min > 0L) {
            min = Math.max(0L, max - PackedInts.INSTANCE.maxValue(bitsRequired));
        }
        int token = bitsRequired << 1 | (min == 0L ? 1 : 0);
        DataOutput dataOutput = this.getOut();
        Intrinsics.checkNotNull((Object)dataOutput);
        dataOutput.writeByte((byte)token);
        if (min != 0L) {
            DataOutput dataOutput2 = this.getOut();
            Intrinsics.checkNotNull((Object)dataOutput2);
            AbstractBlockPackedWriter.Companion.writeVLong(dataOutput2, BitUtil.INSTANCE.zigZagEncode(min) - 1L);
        }
        if (bitsRequired > 0) {
            if (min != 0L) {
                int i = 0;
                int n3 = this.getOff();
                while (i < n3) {
                    long[] lArray = this.getValues();
                    int n4 = i++;
                    lArray[n4] = lArray[n4] - min;
                }
            }
            this.writeValues(bitsRequired);
        }
        this.setOff(0);
    }
}

