/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.util.packed.BulkOperation;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\u0010\u0015\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J0\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J0\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J0\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J0\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0016J0\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/util/packed/BulkOperationPacked;", "Lorg/gnit/lucenekmp/util/packed/BulkOperation;", "bitsPerValue", "", "<init>", "(I)V", "longBlockCount", "longValueCount", "byteBlockCount", "byteValueCount", "mask", "", "intMask", "decode", "", "blocks", "", "blocksOffset", "values", "valuesOffset", "iterations", "", "", "encode", "core"})
public class BulkOperationPacked
extends BulkOperation {
    private final int bitsPerValue;
    private final int longBlockCount;
    private final int longValueCount;
    private final int byteBlockCount;
    private final int byteValueCount;
    private long mask;
    private final int intMask;

    public BulkOperationPacked(int bitsPerValue) {
        this.bitsPerValue = bitsPerValue;
        if (!(this.bitsPerValue > 0 && this.bitsPerValue <= 64)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int blocks = this.bitsPerValue;
        while ((blocks & 1) == 0) {
            blocks >>>= 1;
        }
        this.longBlockCount = blocks;
        this.longValueCount = 64 * this.longBlockCount / this.bitsPerValue;
        int byteBlockCount = 8 * this.longBlockCount;
        int byteValueCount = this.longValueCount;
        while ((byteBlockCount & 1) == 0 && (byteValueCount & 1) == 0) {
            byteBlockCount >>>= 1;
            byteValueCount >>>= 1;
        }
        this.byteBlockCount = byteBlockCount;
        this.byteValueCount = byteValueCount;
        this.mask = this.bitsPerValue == 64 ? -1L : (1L << this.bitsPerValue) - 1L;
        this.intMask = (int)this.mask;
        if (!(this.longValueCount * this.bitsPerValue == 64 * this.longBlockCount)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public int longBlockCount() {
        return this.longBlockCount;
    }

    @Override
    public int longValueCount() {
        return this.longValueCount;
    }

    @Override
    public int byteBlockCount() {
        return this.byteBlockCount;
    }

    @Override
    public int byteValueCount() {
        return this.byteValueCount;
    }

    @Override
    public void decode(@NotNull long[] blocks, int blocksOffset, @NotNull long[] values2, int valuesOffset, int iterations) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        int blocksOffset2 = blocksOffset;
        int valuesOffset2 = valuesOffset;
        int bitsLeft = 64;
        int n = this.longValueCount * iterations;
        for (int i = 0; i < n; ++i) {
            if ((bitsLeft -= this.bitsPerValue) < 0) {
                values2[valuesOffset2++] = (blocks[blocksOffset2++] & (1L << this.bitsPerValue + bitsLeft) - 1L) << -bitsLeft | blocks[blocksOffset2] >>> 64 + bitsLeft;
                bitsLeft += 64;
                continue;
            }
            values2[valuesOffset2++] = blocks[blocksOffset2] >>> bitsLeft & this.mask;
        }
    }

    @Override
    public void decode(@NotNull byte[] blocks, int blocksOffset, @NotNull long[] values2, int valuesOffset, int iterations) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        int blocksOffset2 = blocksOffset;
        int valuesOffset2 = valuesOffset;
        long nextValue = 0L;
        int bitsLeft = this.bitsPerValue;
        int n = iterations * this.byteBlockCount;
        for (int i = 0; i < n; ++i) {
            long bytes = (long)blocks[blocksOffset2++] & 0xFFL;
            if (bitsLeft > 8) {
                nextValue |= bytes << (bitsLeft -= 8);
                continue;
            }
            int bits = 8 - bitsLeft;
            values2[valuesOffset2++] = nextValue | bytes >>> bits;
            while (bits >= this.bitsPerValue) {
                values2[valuesOffset2++] = bytes >>> (bits -= this.bitsPerValue) & this.mask;
            }
            bitsLeft = this.bitsPerValue - bits;
            nextValue = (bytes & (1L << bits) - 1L) << bitsLeft;
        }
        if (!(bitsLeft == this.bitsPerValue)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void decode(@NotNull long[] blocks, int blocksOffset, @NotNull int[] values2, int valuesOffset, int iterations) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        int blocksOffset2 = blocksOffset;
        int valuesOffset2 = valuesOffset;
        if (this.bitsPerValue > 32) {
            throw new UnsupportedOperationException("Cannot decode " + this.bitsPerValue + "-bits values into an int[]");
        }
        int bitsLeft = 64;
        int n = this.longValueCount * iterations;
        for (int i = 0; i < n; ++i) {
            if ((bitsLeft -= this.bitsPerValue) < 0) {
                values2[valuesOffset2++] = (int)((blocks[blocksOffset2++] & (1L << this.bitsPerValue + bitsLeft) - 1L) << -bitsLeft | blocks[blocksOffset2] >>> 64 + bitsLeft);
                bitsLeft += 64;
                continue;
            }
            values2[valuesOffset2++] = (int)(blocks[blocksOffset2] >>> bitsLeft & this.mask);
        }
    }

    @Override
    public void decode(@NotNull byte[] blocks, int blocksOffset, @NotNull int[] values2, int valuesOffset, int iterations) {
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        int blocksOffset2 = blocksOffset;
        int valuesOffset2 = valuesOffset;
        int nextValue = 0;
        int bitsLeft = this.bitsPerValue;
        int n = iterations * this.byteBlockCount;
        for (int i = 0; i < n; ++i) {
            int bytes = blocks[blocksOffset2++] & 0xFF;
            if (bitsLeft > 8) {
                nextValue |= bytes << (bitsLeft -= 8);
                continue;
            }
            int bits = 8 - bitsLeft;
            values2[valuesOffset2++] = nextValue | bytes >>> bits;
            while (bits >= this.bitsPerValue) {
                values2[valuesOffset2++] = bytes >>> (bits -= this.bitsPerValue) & this.intMask;
            }
            bitsLeft = this.bitsPerValue - bits;
            nextValue = (bytes & (1 << bits) - 1) << bitsLeft;
        }
        if (!(bitsLeft == this.bitsPerValue)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void encode(@NotNull long[] values2, int valuesOffset, @NotNull long[] blocks, int blocksOffset, int iterations) {
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        int valuesOffset2 = valuesOffset;
        int blocksOffset2 = blocksOffset;
        long nextBlock = 0L;
        int bitsLeft = 64;
        int n = this.longValueCount * iterations;
        for (int i = 0; i < n; ++i) {
            if ((bitsLeft -= this.bitsPerValue) > 0) {
                nextBlock |= values2[valuesOffset2++] << bitsLeft;
                continue;
            }
            if (bitsLeft == 0) {
                blocks[blocksOffset2++] = nextBlock |= values2[valuesOffset2++];
                nextBlock = 0L;
                bitsLeft = 64;
                continue;
            }
            blocks[blocksOffset2++] = nextBlock |= values2[valuesOffset2] >>> -bitsLeft;
            nextBlock = (values2[valuesOffset2++] & (1L << -bitsLeft) - 1L) << 64 + bitsLeft;
            bitsLeft += 64;
        }
    }

    @Override
    public void encode(@NotNull int[] values2, int valuesOffset, @NotNull long[] blocks, int blocksOffset, int iterations) {
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        int valuesOffset2 = valuesOffset;
        int blocksOffset2 = blocksOffset;
        long nextBlock = 0L;
        int bitsLeft = 64;
        int n = this.longValueCount * iterations;
        for (int i = 0; i < n; ++i) {
            if ((bitsLeft -= this.bitsPerValue) > 0) {
                nextBlock |= ((long)values2[valuesOffset2++] & 0xFFFFFFFFL) << bitsLeft;
                continue;
            }
            if (bitsLeft == 0) {
                blocks[blocksOffset2++] = nextBlock |= (long)values2[valuesOffset2++] & 0xFFFFFFFFL;
                nextBlock = 0L;
                bitsLeft = 64;
                continue;
            }
            blocks[blocksOffset2++] = nextBlock |= ((long)values2[valuesOffset2] & 0xFFFFFFFFL) >>> -bitsLeft;
            nextBlock = ((long)values2[valuesOffset2++] & (1L << -bitsLeft) - 1L) << 64 + bitsLeft;
            bitsLeft += 64;
        }
    }

    @Override
    public void encode(@NotNull long[] values2, int valuesOffset, @NotNull byte[] blocks, int blocksOffset, int iterations) {
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        int valuesOffset2 = valuesOffset;
        int blocksOffset2 = blocksOffset;
        int nextBlock = 0;
        int bitsLeft = 8;
        int n = this.byteValueCount * iterations;
        for (int i = 0; i < n; ++i) {
            long v;
            if (!(PackedInts.INSTANCE.unsignedBitsRequired(v = values2[valuesOffset2++]) <= this.bitsPerValue)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.bitsPerValue < bitsLeft) {
                nextBlock = (int)((long)nextBlock | v << bitsLeft - this.bitsPerValue);
                bitsLeft -= this.bitsPerValue;
                continue;
            }
            int bits = this.bitsPerValue - bitsLeft;
            blocks[blocksOffset2++] = (byte)((long)nextBlock | v >>> bits);
            while (bits >= 8) {
                blocks[blocksOffset2++] = (byte)(v >>> (bits -= 8));
            }
            bitsLeft = 8 - bits;
            nextBlock = (int)((v & (1L << bits) - 1L) << bitsLeft);
        }
        if (!(bitsLeft == 8)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void encode(@NotNull int[] values2, int valuesOffset, @NotNull byte[] blocks, int blocksOffset, int iterations) {
        Intrinsics.checkNotNullParameter((Object)values2, (String)"values");
        Intrinsics.checkNotNullParameter((Object)blocks, (String)"blocks");
        int valuesOffset2 = valuesOffset;
        int blocksOffset2 = blocksOffset;
        int nextBlock = 0;
        int bitsLeft = 8;
        int n = this.byteValueCount * iterations;
        for (int i = 0; i < n; ++i) {
            int v;
            if (!(PackedInts.INSTANCE.bitsRequired((long)(v = values2[valuesOffset2++]) & 0xFFFFFFFFL) <= this.bitsPerValue)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.bitsPerValue < bitsLeft) {
                nextBlock |= v << bitsLeft - this.bitsPerValue;
                bitsLeft -= this.bitsPerValue;
                continue;
            }
            int bits = this.bitsPerValue - bitsLeft;
            blocks[blocksOffset2++] = (byte)(nextBlock | v >>> bits);
            while (bits >= 8) {
                blocks[blocksOffset2++] = (byte)(v >>> (bits -= 8));
            }
            bitsLeft = 8 - bits;
            nextBlock = (v & (1 << bits) - 1) << bitsLeft;
        }
        if (!(bitsLeft == 8)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }
}

