/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.packed.DirectWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0016\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 /2\u00020\u0001:\u0001/B)\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010'\u001a\u00020(H\u0002J\u000e\u0010,\u001a\u00020(2\u0006\u0010-\u001a\u00020\u0006J\u0006\u0010.\u001a\u00020(R\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0011\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001a\u0010)\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0011\"\u0004\b+\u0010 \u00a8\u00060"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectMonotonicWriter;", "", "metaOut", "Lorg/gnit/lucenekmp/store/IndexOutput;", "dataOut", "numValues", "", "blockShift", "", "<init>", "(Lorg/gnit/lucenekmp/store/IndexOutput;Lorg/gnit/lucenekmp/store/IndexOutput;JI)V", "meta", "getMeta", "()Lorg/gnit/lucenekmp/store/IndexOutput;", "data", "getData", "getNumValues", "()J", "baseDataPointer", "getBaseDataPointer", "buffer", "", "getBuffer", "()[J", "bufferSize", "getBufferSize", "()I", "setBufferSize", "(I)V", "count", "getCount", "setCount", "(J)V", "finished", "", "getFinished", "()Z", "setFinished", "(Z)V", "flush", "", "previous", "getPrevious", "setPrevious", "add", "v", "finish", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDirectMonotonicWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectMonotonicWriter.kt\norg/gnit/lucenekmp/util/packed/DirectMonotonicWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,147:1\n1#2:148\n*E\n"})
public final class DirectMonotonicWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IndexOutput meta;
    @NotNull
    private final IndexOutput data;
    private final long numValues;
    private final long baseDataPointer;
    @NotNull
    private final long[] buffer;
    private int bufferSize;
    private long count;
    private boolean finished;
    private long previous;
    public static final int MIN_BLOCK_SHIFT = 2;
    public static final int MAX_BLOCK_SHIFT = 22;

    public DirectMonotonicWriter(@NotNull IndexOutput metaOut, @NotNull IndexOutput dataOut, long numValues, int blockShift) {
        Intrinsics.checkNotNullParameter((Object)metaOut, (String)"metaOut");
        Intrinsics.checkNotNullParameter((Object)dataOut, (String)"dataOut");
        this.previous = Long.MIN_VALUE;
        if (!(blockShift >= 2 && blockShift <= 22)) {
            boolean $i$a$-require-DirectMonotonicWriter$42 = false;
            String $i$a$-require-DirectMonotonicWriter$42 = "blockShift must be in [2-22], got " + blockShift;
            throw new IllegalArgumentException($i$a$-require-DirectMonotonicWriter$42.toString());
        }
        if (!(numValues >= 0L)) {
            boolean bl = false;
            String string = "numValues can't be negative, got " + numValues;
            throw new IllegalArgumentException(string.toString());
        }
        long numBlocks = numValues == 0L ? 0L : (numValues - 1L >>> blockShift) + 1L;
        if (!(numBlocks <= (long)ArrayUtil.Companion.getMAX_ARRAY_LENGTH())) {
            boolean bl = false;
            String string = "blockShift is too low for the provided number of values: blockShift=" + blockShift + ", numValues=" + numValues + ", MAX_ARRAY_LENGTH=" + ArrayUtil.Companion.getMAX_ARRAY_LENGTH();
            throw new IllegalArgumentException(string.toString());
        }
        this.meta = metaOut;
        this.data = dataOut;
        this.numValues = numValues;
        int blockSize = 1 << blockShift;
        this.buffer = new long[(int)Math.min(numValues, (long)blockSize)];
        this.bufferSize = 0;
        this.baseDataPointer = dataOut.getFilePointer();
    }

    @NotNull
    public final IndexOutput getMeta() {
        return this.meta;
    }

    @NotNull
    public final IndexOutput getData() {
        return this.data;
    }

    public final long getNumValues() {
        return this.numValues;
    }

    public final long getBaseDataPointer() {
        return this.baseDataPointer;
    }

    @NotNull
    public final long[] getBuffer() {
        return this.buffer;
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    public final void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public final long getCount() {
        return this.count;
    }

    public final void setCount(long l) {
        this.count = l;
    }

    public final boolean getFinished() {
        return this.finished;
    }

    public final void setFinished(boolean bl) {
        this.finished = bl;
    }

    private final void flush() throws IOException {
        int n;
        long[] lArray;
        if (!(this.bufferSize != 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        double avgInc = (double)(this.buffer[this.bufferSize - 1] - this.buffer[0]) / (double)Math.max(1, this.bufferSize - 1);
        long min = Long.MAX_VALUE;
        int n2 = this.bufferSize;
        for (int i = 0; i < n2; ++i) {
            long expected = (long)(avgInc * (double)i);
            lArray = this.buffer;
            n = i;
            lArray[n] = lArray[n] - expected;
            min = Math.min(this.buffer[i], min);
        }
        long maxDelta = 0L;
        int n3 = this.bufferSize;
        for (int i = 0; i < n3; ++i) {
            lArray = this.buffer;
            n = i;
            lArray[n] = lArray[n] - min;
            maxDelta |= this.buffer[i];
        }
        this.meta.writeLong(min);
        this.meta.writeInt(FloatExtKt.floatToIntBits(FloatCompanionObject.INSTANCE, (float)avgInc));
        this.meta.writeLong(this.data.getFilePointer() - this.baseDataPointer);
        if (maxDelta == 0L) {
            this.meta.writeByte((byte)0);
        } else {
            int bitsRequired = DirectWriter.Companion.unsignedBitsRequired(maxDelta);
            DirectWriter writer = DirectWriter.Companion.getInstance(this.data, this.bufferSize, bitsRequired);
            n = this.bufferSize;
            for (int i = 0; i < n; ++i) {
                writer.add(this.buffer[i]);
            }
            writer.finish();
            this.meta.writeByte((byte)bitsRequired);
        }
        this.bufferSize = 0;
    }

    public final long getPrevious() {
        return this.previous;
    }

    public final void setPrevious(long l) {
        this.previous = l;
    }

    public final void add(long v) throws IOException {
        if (!(v >= this.previous)) {
            boolean bl = false;
            String string = "Values do not come in order: " + this.previous + ", " + v;
            throw new IllegalArgumentException(string.toString());
        }
        if (this.bufferSize == this.buffer.length) {
            this.flush();
        }
        int n = this.bufferSize;
        this.bufferSize = n + 1;
        this.buffer[n] = v;
        this.previous = v;
        long l = this.count;
        this.count = l + 1L;
    }

    public final void finish() throws IOException {
        if (!(this.count == this.numValues)) {
            boolean $i$a$-check-DirectMonotonicWriter$finish$32 = false;
            String $i$a$-check-DirectMonotonicWriter$finish$32 = "Wrong number of values added, expected: " + this.numValues + ", got: " + this.count;
            throw new IllegalStateException($i$a$-check-DirectMonotonicWriter$finish$32.toString());
        }
        if (!(!this.finished)) {
            boolean bl = false;
            String string = "#finish has been called already";
            throw new IllegalStateException(string.toString());
        }
        if (this.bufferSize > 0) {
            this.flush();
        }
        this.finished = true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectMonotonicWriter$Companion;", "", "<init>", "()V", "MIN_BLOCK_SHIFT", "", "MAX_BLOCK_SHIFT", "getInstance", "Lorg/gnit/lucenekmp/util/packed/DirectMonotonicWriter;", "metaOut", "Lorg/gnit/lucenekmp/store/IndexOutput;", "dataOut", "numValues", "", "blockShift", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DirectMonotonicWriter getInstance(@NotNull IndexOutput metaOut, @NotNull IndexOutput dataOut, long numValues, int blockShift) {
            Intrinsics.checkNotNullParameter((Object)metaOut, (String)"metaOut");
            Intrinsics.checkNotNullParameter((Object)dataOut, (String)"dataOut");
            return new DirectMonotonicWriter(metaOut, dataOut, numValues, blockShift);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

