/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.ByteCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.ShortCompanionObject;
import org.gnit.lucenekmp.jdkport.ByteExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.ShortExtKt;
import org.gnit.lucenekmp.jdkport.UncheckedIOException;
import org.gnit.lucenekmp.store.RandomAccessInput;
import org.gnit.lucenekmp.util.LongValues;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0012\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u000e\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000eJ \u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000eJ(\u0010\u000f\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectReader;", "", "<init>", "()V", "MERGE_BUFFER_SHIFT", "", "MERGE_BUFFER_SIZE", "MERGE_BUFFER_MASK", "getInstance", "Lorg/gnit/lucenekmp/util/LongValues;", "slice", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "bitsPerValue", "offset", "", "getMergeInstance", "numValues", "baseOffset", "DirectPackedReader1", "DirectPackedReader2", "DirectPackedReader4", "DirectPackedReader8", "DirectPackedReader12", "DirectPackedReader16", "DirectPackedReader20", "DirectPackedReader24", "DirectPackedReader28", "DirectPackedReader32", "DirectPackedReader40", "DirectPackedReader48", "DirectPackedReader56", "DirectPackedReader64", "core"})
public final class DirectReader {
    @NotNull
    public static final DirectReader INSTANCE = new DirectReader();
    public static final int MERGE_BUFFER_SHIFT = 7;
    private static final int MERGE_BUFFER_SIZE = 128;
    private static final int MERGE_BUFFER_MASK = 127;

    private DirectReader() {
    }

    @NotNull
    public final LongValues getInstance(@NotNull RandomAccessInput slice, int bitsPerValue) {
        Intrinsics.checkNotNullParameter((Object)slice, (String)"slice");
        return this.getInstance(slice, bitsPerValue, 0L);
    }

    @NotNull
    public final LongValues getInstance(@NotNull RandomAccessInput slice, int bitsPerValue, long offset) {
        Intrinsics.checkNotNullParameter((Object)slice, (String)"slice");
        switch (bitsPerValue) {
            case 1: {
                return new DirectPackedReader1(slice, offset);
            }
            case 2: {
                return new DirectPackedReader2(slice, offset);
            }
            case 4: {
                return new DirectPackedReader4(slice, offset);
            }
            case 8: {
                return new DirectPackedReader8(slice, offset);
            }
            case 12: {
                return new DirectPackedReader12(slice, offset);
            }
            case 16: {
                return new DirectPackedReader16(slice, offset);
            }
            case 20: {
                return new DirectPackedReader20(slice, offset);
            }
            case 24: {
                return new DirectPackedReader24(slice, offset);
            }
            case 28: {
                return new DirectPackedReader28(slice, offset);
            }
            case 32: {
                return new DirectPackedReader32(slice, offset);
            }
            case 40: {
                return new DirectPackedReader40(slice, offset);
            }
            case 48: {
                return new DirectPackedReader48(slice, offset);
            }
            case 56: {
                return new DirectPackedReader56(slice, offset);
            }
            case 64: {
                return new DirectPackedReader64(slice, offset);
            }
        }
        throw new IllegalArgumentException("unsupported bitsPerValue: " + bitsPerValue);
    }

    @Nullable
    public final LongValues getMergeInstance(@NotNull RandomAccessInput slice, int bitsPerValue, long numValues) {
        Intrinsics.checkNotNullParameter((Object)slice, (String)"slice");
        return this.getMergeInstance(slice, bitsPerValue, 0L, numValues);
    }

    @Nullable
    public final LongValues getMergeInstance(@NotNull RandomAccessInput slice, int bitsPerValue, long baseOffset, long numValues) {
        Intrinsics.checkNotNullParameter((Object)slice, (String)"slice");
        return new LongValues(numValues, slice, bitsPerValue, baseOffset){
            private final long[] buffer;
            private long blockIndex;
            final /* synthetic */ long $numValues;
            final /* synthetic */ RandomAccessInput $slice;
            final /* synthetic */ int $bitsPerValue;
            final /* synthetic */ long $baseOffset;
            {
                this.$numValues = $numValues;
                this.$slice = $slice;
                this.$bitsPerValue = $bitsPerValue;
                this.$baseOffset = $baseOffset;
                this.buffer = new long[128];
                this.blockIndex = -1L;
            }

            public long get(long index) {
                if (!(index < this.$numValues)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                long blockIndex = index >>> 7;
                if (this.blockIndex != blockIndex) {
                    try {
                        this.fillBuffer(blockIndex << 7);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    this.blockIndex = blockIndex;
                }
                return this.buffer[(int)(index & 0x7FL)];
            }

            public final void fillBuffer(long index) throws IOException {
                if (index >= this.$numValues - (long)128) {
                    LongValues slowInstance = DirectReader.INSTANCE.getInstance(this.$slice, this.$bitsPerValue, this.$baseOffset);
                    int numValuesLastBlock = Math.INSTANCE.toIntExact(this.$numValues - index);
                    for (int i = 0; i < numValuesLastBlock; ++i) {
                        this.buffer[i] = slowInstance.get(index + (long)i);
                    }
                } else if ((this.$bitsPerValue & 7) == 0) {
                    int bytesPerValue = this.$bitsPerValue / 8;
                    long mask = this.$bitsPerValue == 64 ? -1L : (1L << this.$bitsPerValue) - 1L;
                    long offset = this.$baseOffset + index * (long)this.$bitsPerValue / (long)8;
                    for (int i = 0; i < 128; ++i) {
                        this.buffer[i] = this.$bitsPerValue > 32 ? this.$slice.readLong(offset) & mask : (this.$bitsPerValue > 16 ? (long)this.$slice.readInt(offset) & mask : (this.$bitsPerValue > 8 ? ShortExtKt.toUnsignedLong(ShortCompanionObject.INSTANCE, this.$slice.readShort(offset)) : ByteExtKt.toUnsignedLong(ByteCompanionObject.INSTANCE, this.$slice.readByte(offset))));
                        offset += (long)bytesPerValue;
                    }
                } else if (this.$bitsPerValue < 8) {
                    int valuesPerLong = 64 / this.$bitsPerValue;
                    long mask = (1L << this.$bitsPerValue) - 1L;
                    long offset = this.$baseOffset + index * (long)this.$bitsPerValue / (long)8;
                    int i = 0;
                    int n = 2 * this.$bitsPerValue;
                    for (int l = 0; l < n; ++l) {
                        long bits = this.$slice.readLong(offset);
                        for (int j = 0; j < valuesPerLong; ++j) {
                            this.buffer[i++] = bits >>> j * this.$bitsPerValue & mask;
                        }
                        offset += 8L;
                    }
                } else {
                    int numBytesFor2Values = this.$bitsPerValue * 2 / 8;
                    long mask = (1L << this.$bitsPerValue) - 1L;
                    long offset = this.$baseOffset + index * (long)this.$bitsPerValue / (long)8;
                    for (int i = 0; i < 128; i += 2) {
                        long l = numBytesFor2Values > 4 ? this.$slice.readLong(offset) : (long)this.$slice.readInt(offset);
                        this.buffer[i] = l & mask;
                        this.buffer[i + 1] = l >>> this.$bitsPerValue & mask;
                        offset += (long)numBytesFor2Values;
                    }
                }
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectReader$DirectPackedReader1;", "Lorg/gnit/lucenekmp/util/LongValues;", "in", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "offset", "", "<init>", "(Lorg/gnit/lucenekmp/store/RandomAccessInput;J)V", "getIn", "()Lorg/gnit/lucenekmp/store/RandomAccessInput;", "getOffset", "()J", "get", "index", "core"})
    public static final class DirectPackedReader1
    extends LongValues {
        @NotNull
        private final RandomAccessInput in;
        private final long offset;

        public DirectPackedReader1(@NotNull RandomAccessInput in, long offset) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
            this.offset = offset;
        }

        @NotNull
        public final RandomAccessInput getIn() {
            return this.in;
        }

        public final long getOffset() {
            return this.offset;
        }

        @Override
        public long get(long index) {
            try {
                int shift = (int)(index & 7L);
                return this.in.readByte(this.offset + (index >>> 3)) >>> shift & 1;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectReader$DirectPackedReader12;", "Lorg/gnit/lucenekmp/util/LongValues;", "in", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "offset", "", "<init>", "(Lorg/gnit/lucenekmp/store/RandomAccessInput;J)V", "getIn", "()Lorg/gnit/lucenekmp/store/RandomAccessInput;", "getOffset", "()J", "get", "index", "core"})
    public static final class DirectPackedReader12
    extends LongValues {
        @NotNull
        private final RandomAccessInput in;
        private final long offset;

        public DirectPackedReader12(@NotNull RandomAccessInput in, long offset) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
            this.offset = offset;
        }

        @NotNull
        public final RandomAccessInput getIn() {
            return this.in;
        }

        public final long getOffset() {
            return this.offset;
        }

        @Override
        public long get(long index) {
            try {
                long offset = index * (long)12 >>> 3;
                int shift = (int)(index & 1L) << 2;
                return this.in.readShort(this.offset + offset) >>> shift & 0xFFF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectReader$DirectPackedReader16;", "Lorg/gnit/lucenekmp/util/LongValues;", "in", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "offset", "", "<init>", "(Lorg/gnit/lucenekmp/store/RandomAccessInput;J)V", "getIn", "()Lorg/gnit/lucenekmp/store/RandomAccessInput;", "getOffset", "()J", "get", "index", "core"})
    public static final class DirectPackedReader16
    extends LongValues {
        @NotNull
        private final RandomAccessInput in;
        private final long offset;

        public DirectPackedReader16(@NotNull RandomAccessInput in, long offset) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
            this.offset = offset;
        }

        @NotNull
        public final RandomAccessInput getIn() {
            return this.in;
        }

        public final long getOffset() {
            return this.offset;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readShort(this.offset + (index << 1)) & 0xFFFF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectReader$DirectPackedReader2;", "Lorg/gnit/lucenekmp/util/LongValues;", "in", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "offset", "", "<init>", "(Lorg/gnit/lucenekmp/store/RandomAccessInput;J)V", "getIn", "()Lorg/gnit/lucenekmp/store/RandomAccessInput;", "getOffset", "()J", "get", "index", "core"})
    public static final class DirectPackedReader2
    extends LongValues {
        @NotNull
        private final RandomAccessInput in;
        private final long offset;

        public DirectPackedReader2(@NotNull RandomAccessInput in, long offset) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
            this.offset = offset;
        }

        @NotNull
        public final RandomAccessInput getIn() {
            return this.in;
        }

        public final long getOffset() {
            return this.offset;
        }

        @Override
        public long get(long index) {
            try {
                int shift = (int)(index & 3L) << 1;
                return this.in.readByte(this.offset + (index >>> 2)) >>> shift & 3;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectReader$DirectPackedReader20;", "Lorg/gnit/lucenekmp/util/LongValues;", "in", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "offset", "", "<init>", "(Lorg/gnit/lucenekmp/store/RandomAccessInput;J)V", "getIn", "()Lorg/gnit/lucenekmp/store/RandomAccessInput;", "getOffset", "()J", "get", "index", "core"})
    public static final class DirectPackedReader20
    extends LongValues {
        @NotNull
        private final RandomAccessInput in;
        private final long offset;

        public DirectPackedReader20(@NotNull RandomAccessInput in, long offset) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
            this.offset = offset;
        }

        @NotNull
        public final RandomAccessInput getIn() {
            return this.in;
        }

        public final long getOffset() {
            return this.offset;
        }

        @Override
        public long get(long index) {
            try {
                long offset = index * (long)20 >>> 3;
                int shift = (int)(index & 1L) << 2;
                return this.in.readInt(this.offset + offset) >>> shift & 0xFFFFF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectReader$DirectPackedReader24;", "Lorg/gnit/lucenekmp/util/LongValues;", "in", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "offset", "", "<init>", "(Lorg/gnit/lucenekmp/store/RandomAccessInput;J)V", "getIn", "()Lorg/gnit/lucenekmp/store/RandomAccessInput;", "getOffset", "()J", "get", "index", "core"})
    public static final class DirectPackedReader24
    extends LongValues {
        @NotNull
        private final RandomAccessInput in;
        private final long offset;

        public DirectPackedReader24(@NotNull RandomAccessInput in, long offset) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
            this.offset = offset;
        }

        @NotNull
        public final RandomAccessInput getIn() {
            return this.in;
        }

        public final long getOffset() {
            return this.offset;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readInt(this.offset + index * (long)3) & 0xFFFFFF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectReader$DirectPackedReader28;", "Lorg/gnit/lucenekmp/util/LongValues;", "in", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "offset", "", "<init>", "(Lorg/gnit/lucenekmp/store/RandomAccessInput;J)V", "getIn", "()Lorg/gnit/lucenekmp/store/RandomAccessInput;", "getOffset", "()J", "get", "index", "core"})
    public static final class DirectPackedReader28
    extends LongValues {
        @NotNull
        private final RandomAccessInput in;
        private final long offset;

        public DirectPackedReader28(@NotNull RandomAccessInput in, long offset) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
            this.offset = offset;
        }

        @NotNull
        public final RandomAccessInput getIn() {
            return this.in;
        }

        public final long getOffset() {
            return this.offset;
        }

        @Override
        public long get(long index) {
            try {
                long offset = index * (long)28 >>> 3;
                int shift = (int)(index & 1L) << 2;
                return this.in.readInt(this.offset + offset) >>> shift & 0xFFFFFFF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectReader$DirectPackedReader32;", "Lorg/gnit/lucenekmp/util/LongValues;", "in", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "offset", "", "<init>", "(Lorg/gnit/lucenekmp/store/RandomAccessInput;J)V", "getIn", "()Lorg/gnit/lucenekmp/store/RandomAccessInput;", "getOffset", "()J", "get", "index", "core"})
    public static final class DirectPackedReader32
    extends LongValues {
        @NotNull
        private final RandomAccessInput in;
        private final long offset;

        public DirectPackedReader32(@NotNull RandomAccessInput in, long offset) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
            this.offset = offset;
        }

        @NotNull
        public final RandomAccessInput getIn() {
            return this.in;
        }

        public final long getOffset() {
            return this.offset;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readInt(this.offset + (index << 2)) & 0xFFFFFFFF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectReader$DirectPackedReader4;", "Lorg/gnit/lucenekmp/util/LongValues;", "in", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "offset", "", "<init>", "(Lorg/gnit/lucenekmp/store/RandomAccessInput;J)V", "getIn", "()Lorg/gnit/lucenekmp/store/RandomAccessInput;", "getOffset", "()J", "get", "index", "core"})
    public static final class DirectPackedReader4
    extends LongValues {
        @NotNull
        private final RandomAccessInput in;
        private final long offset;

        public DirectPackedReader4(@NotNull RandomAccessInput in, long offset) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
            this.offset = offset;
        }

        @NotNull
        public final RandomAccessInput getIn() {
            return this.in;
        }

        public final long getOffset() {
            return this.offset;
        }

        @Override
        public long get(long index) {
            try {
                int shift = (int)(index & 1L) << 2;
                return this.in.readByte(this.offset + (index >>> 1)) >>> shift & 0xF;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectReader$DirectPackedReader40;", "Lorg/gnit/lucenekmp/util/LongValues;", "in", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "offset", "", "<init>", "(Lorg/gnit/lucenekmp/store/RandomAccessInput;J)V", "getIn", "()Lorg/gnit/lucenekmp/store/RandomAccessInput;", "getOffset", "()J", "get", "index", "core"})
    public static final class DirectPackedReader40
    extends LongValues {
        @NotNull
        private final RandomAccessInput in;
        private final long offset;

        public DirectPackedReader40(@NotNull RandomAccessInput in, long offset) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
            this.offset = offset;
        }

        @NotNull
        public final RandomAccessInput getIn() {
            return this.in;
        }

        public final long getOffset() {
            return this.offset;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readLong(this.offset + index * (long)5) & 0xFFFFFFFFFFL;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectReader$DirectPackedReader48;", "Lorg/gnit/lucenekmp/util/LongValues;", "in", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "offset", "", "<init>", "(Lorg/gnit/lucenekmp/store/RandomAccessInput;J)V", "getIn", "()Lorg/gnit/lucenekmp/store/RandomAccessInput;", "getOffset", "()J", "get", "index", "core"})
    public static final class DirectPackedReader48
    extends LongValues {
        @NotNull
        private final RandomAccessInput in;
        private final long offset;

        public DirectPackedReader48(@NotNull RandomAccessInput in, long offset) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
            this.offset = offset;
        }

        @NotNull
        public final RandomAccessInput getIn() {
            return this.in;
        }

        public final long getOffset() {
            return this.offset;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readLong(this.offset + index * (long)6) & 0xFFFFFFFFFFFFL;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectReader$DirectPackedReader56;", "Lorg/gnit/lucenekmp/util/LongValues;", "in", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "offset", "", "<init>", "(Lorg/gnit/lucenekmp/store/RandomAccessInput;J)V", "getIn", "()Lorg/gnit/lucenekmp/store/RandomAccessInput;", "getOffset", "()J", "get", "index", "core"})
    public static final class DirectPackedReader56
    extends LongValues {
        @NotNull
        private final RandomAccessInput in;
        private final long offset;

        public DirectPackedReader56(@NotNull RandomAccessInput in, long offset) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
            this.offset = offset;
        }

        @NotNull
        public final RandomAccessInput getIn() {
            return this.in;
        }

        public final long getOffset() {
            return this.offset;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readLong(this.offset + index * (long)7) & 0xFFFFFFFFFFFFFFL;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectReader$DirectPackedReader64;", "Lorg/gnit/lucenekmp/util/LongValues;", "in", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "offset", "", "<init>", "(Lorg/gnit/lucenekmp/store/RandomAccessInput;J)V", "getIn", "()Lorg/gnit/lucenekmp/store/RandomAccessInput;", "getOffset", "()J", "get", "index", "core"})
    public static final class DirectPackedReader64
    extends LongValues {
        @NotNull
        private final RandomAccessInput in;
        private final long offset;

        public DirectPackedReader64(@NotNull RandomAccessInput in, long offset) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
            this.offset = offset;
        }

        @NotNull
        public final RandomAccessInput getIn() {
            return this.in;
        }

        public final long getOffset() {
            return this.offset;
        }

        @Override
        public long get(long index) {
            try {
                return this.in.readLong(this.offset + (index << 3));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectReader$DirectPackedReader8;", "Lorg/gnit/lucenekmp/util/LongValues;", "in", "Lorg/gnit/lucenekmp/store/RandomAccessInput;", "offset", "", "<init>", "(Lorg/gnit/lucenekmp/store/RandomAccessInput;J)V", "getIn", "()Lorg/gnit/lucenekmp/store/RandomAccessInput;", "getOffset", "()J", "get", "index", "core"})
    public static final class DirectPackedReader8
    extends LongValues {
        @NotNull
        private final RandomAccessInput in;
        private final long offset;

        public DirectPackedReader8(@NotNull RandomAccessInput in, long offset) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            this.in = in;
            this.offset = offset;
        }

        @NotNull
        public final RandomAccessInput getIn() {
            return this.in;
        }

        public final long getOffset() {
            return this.offset;
        }

        @Override
        public long get(long index) {
            try {
                return (byte)(this.in.readByte(this.offset + index) & 0xFFFFFFFF);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

