/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import java.io.EOFException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.BitUtil;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 +2\u00020\u0001:\u0001+B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0005J\b\u0010)\u001a\u00020'H\u0002J\u0006\u0010*\u001a\u00020'R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000f\"\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u0006,"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectWriter;", "", "output", "Lorg/gnit/lucenekmp/store/DataOutput;", "numValues", "", "bitsPerValue", "", "<init>", "(Lorg/gnit/lucenekmp/store/DataOutput;JI)V", "getOutput", "()Lorg/gnit/lucenekmp/store/DataOutput;", "getNumValues", "()J", "getBitsPerValue", "()I", "count", "getCount", "setCount", "(J)V", "finished", "", "getFinished", "()Z", "setFinished", "(Z)V", "off", "getOff", "setOff", "(I)V", "nextBlocks", "", "getNextBlocks", "()[B", "nextValues", "", "getNextValues", "()[J", "add", "", "l", "flush", "finish", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nDirectWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectWriter.kt\norg/gnit/lucenekmp/util/packed/DirectWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n1#2:224\n*E\n"})
public final class DirectWriter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataOutput output;
    private final long numValues;
    private final int bitsPerValue;
    private long count;
    private boolean finished;
    private int off;
    @NotNull
    private final byte[] nextBlocks;
    @NotNull
    private final long[] nextValues;
    @NotNull
    private static final int[] SUPPORTED_BITS_PER_VALUE;

    public DirectWriter(@NotNull DataOutput output, long numValues, int bitsPerValue) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        this.output = output;
        this.numValues = numValues;
        this.bitsPerValue = bitsPerValue;
        int memoryBudgetInBits = Math.INSTANCE.multiplyExact(8, 1024);
        int bufferSize = memoryBudgetInBits / (64 + this.bitsPerValue);
        if (!(bufferSize > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        bufferSize = Math.INSTANCE.toIntExact(bufferSize + 63) & 0xFFFFFFC0;
        this.nextValues = new long[bufferSize];
        this.nextBlocks = new byte[bufferSize * this.bitsPerValue / 8 + 8 - 1];
    }

    @NotNull
    public final DataOutput getOutput() {
        return this.output;
    }

    public final long getNumValues() {
        return this.numValues;
    }

    public final int getBitsPerValue() {
        return this.bitsPerValue;
    }

    public final long getCount() {
        return this.count;
    }

    public final void setCount(long l) {
        this.count = l;
    }

    public final boolean getFinished() {
        return this.finished;
    }

    public final void setFinished(boolean bl) {
        this.finished = bl;
    }

    public final int getOff() {
        return this.off;
    }

    public final void setOff(int n) {
        this.off = n;
    }

    @NotNull
    public final byte[] getNextBlocks() {
        return this.nextBlocks;
    }

    @NotNull
    public final long[] getNextValues() {
        return this.nextValues;
    }

    public final void add(long l) throws IOException {
        if (!(this.bitsPerValue == 64 || l >= 0L && l <= PackedInts.INSTANCE.maxValue(this.bitsPerValue))) {
            boolean bl = false;
            Integer n = this.bitsPerValue;
            throw new IllegalArgumentException(((Object)n).toString());
        }
        if (!(!this.finished)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.count >= this.numValues) {
            throw new EOFException("Writing past end of stream");
        }
        int n = this.off;
        this.off = n + 1;
        this.nextValues[n] = l;
        if (this.off == this.nextValues.length) {
            this.flush();
        }
        long l2 = this.count;
        this.count = l2 + 1L;
    }

    private final void flush() throws IOException {
        if (this.off == 0) {
            return;
        }
        Arrays.INSTANCE.fill(this.nextValues, this.off, this.nextValues.length, 0L);
        DirectWriter.Companion.encode(this.nextValues, this.off, this.nextBlocks, this.bitsPerValue);
        int blockCount = (int)PackedInts.Format.PACKED.byteCount(PackedInts.INSTANCE.getVERSION_CURRENT(), this.off, this.bitsPerValue);
        this.output.writeBytes(this.nextBlocks, blockCount);
        this.off = 0;
    }

    public final void finish() throws IOException {
        int paddingBitsNeeded;
        if (!(this.count == this.numValues)) {
            boolean $i$a$-check-DirectWriter$finish$22 = false;
            String $i$a$-check-DirectWriter$finish$22 = "Wrong number of values added, expected: " + this.numValues + ", got: " + this.count;
            throw new IllegalStateException($i$a$-check-DirectWriter$finish$22.toString());
        }
        if (!(!this.finished)) {
            String $i$a$-check-DirectWriter$finish$22 = "Failed requirement.";
            throw new IllegalArgumentException($i$a$-check-DirectWriter$finish$22.toString());
        }
        this.flush();
        int n = this.bitsPerValue > 32 ? 64 - this.bitsPerValue : (paddingBitsNeeded = this.bitsPerValue > 16 ? 32 - this.bitsPerValue : (this.bitsPerValue > 8 ? 16 - this.bitsPerValue : 0));
        if (!(paddingBitsNeeded >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int paddingBytesNeeded = (paddingBitsNeeded + 8 - 1) / 8;
        if (!(paddingBytesNeeded <= 3)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        for (int i = 0; i < paddingBytesNeeded; ++i) {
            this.output.writeByte((byte)0);
        }
        this.finished = true;
    }

    static {
        int[] nArray = new int[]{1, 2, 4, 8, 12, 16, 20, 24, 28, 32, 40, 48, 56, 64};
        SUPPORTED_BITS_PER_VALUE = nArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0016\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0002J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\tJ\u0010\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\tH\u0002J\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0012J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0012R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/util/packed/DirectWriter$Companion;", "", "<init>", "()V", "encode", "", "nextValues", "", "upTo", "", "nextBlocks", "", "bitsPerValue", "getInstance", "Lorg/gnit/lucenekmp/util/packed/DirectWriter;", "output", "Lorg/gnit/lucenekmp/store/DataOutput;", "numValues", "", "roundBits", "bitsRequired", "maxValue", "unsignedBitsRequired", "SUPPORTED_BITS_PER_VALUE", "", "getSUPPORTED_BITS_PER_VALUE", "()[I", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final void encode(long[] nextValues, int upTo, byte[] nextBlocks, int bitsPerValue) {
            if ((bitsPerValue & 7) == 0) {
                int bytesPerValue = bitsPerValue / 8;
                int i = 0;
                int o = 0;
                while (i < upTo) {
                    long l = nextValues[i];
                    if (bitsPerValue > 32) {
                        BitUtil.VH_LE_LONG.INSTANCE.set(nextBlocks, o, l);
                    } else if (bitsPerValue > 16) {
                        BitUtil.VH_LE_INT.INSTANCE.set(nextBlocks, o, (int)l);
                    } else if (bitsPerValue > 8) {
                        BitUtil.VH_LE_SHORT.INSTANCE.set(nextBlocks, o, (short)l);
                    } else {
                        nextBlocks[o] = (byte)l;
                    }
                    ++i;
                    o += bytesPerValue;
                }
            } else if (bitsPerValue < 8) {
                int valuesPerLong = 64 / bitsPerValue;
                int i = 0;
                int o = 0;
                while (i < upTo) {
                    long v = 0L;
                    for (int j = 0; j < valuesPerLong; ++j) {
                        v |= nextValues[i + j] << bitsPerValue * j;
                    }
                    BitUtil.VH_LE_LONG.INSTANCE.set(nextBlocks, o, v);
                    i += valuesPerLong;
                    o += 8;
                }
            } else {
                int numBytesFor2Values = bitsPerValue * 2 / 8;
                int i = 0;
                int o = 0;
                while (i < upTo) {
                    long l1 = nextValues[i];
                    long l2 = nextValues[i + 1];
                    long merged = l1 | l2 << bitsPerValue;
                    if (bitsPerValue <= 16) {
                        BitUtil.VH_LE_INT.INSTANCE.set(nextBlocks, o, (int)merged);
                    } else {
                        BitUtil.VH_LE_LONG.INSTANCE.set(nextBlocks, o, merged);
                    }
                    i += 2;
                    o += numBytesFor2Values;
                }
            }
        }

        @NotNull
        public final DirectWriter getInstance(@NotNull DataOutput output, long numValues, int bitsPerValue) {
            Intrinsics.checkNotNullParameter((Object)output, (String)"output");
            if (!(Arrays.INSTANCE.binarySearch(this.getSUPPORTED_BITS_PER_VALUE(), bitsPerValue) >= 0)) {
                boolean bl = false;
                String string = "Unsupported bitsPerValue " + bitsPerValue + ". Did you use bitsRequired?";
                throw new IllegalArgumentException(string.toString());
            }
            return new DirectWriter(output, numValues, bitsPerValue);
        }

        private final int roundBits(int bitsRequired) {
            int index = Arrays.INSTANCE.binarySearch(this.getSUPPORTED_BITS_PER_VALUE(), bitsRequired);
            return index < 0 ? this.getSUPPORTED_BITS_PER_VALUE()[-index - 1] : bitsRequired;
        }

        public final int bitsRequired(long maxValue) {
            return this.roundBits(PackedInts.INSTANCE.bitsRequired(maxValue));
        }

        public final int unsignedBitsRequired(long maxValue) {
            return this.roundBits(PackedInts.INSTANCE.unsignedBitsRequired(maxValue));
        }

        @NotNull
        public final int[] getSUPPORTED_BITS_PER_VALUE() {
            return SUPPORTED_BITS_PER_VALUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

