/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0016\n\u0002\b\t\u0018\u0000 $2\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\nH\u0002J\u0018\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\nH\u0016J\b\u0010\u0018\u001a\u00020\u0016H\u0016J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003J(\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J(\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0016J \u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\nH\u0016J\b\u0010#\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\f\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0001@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lorg/gnit/lucenekmp/util/packed/GrowableWriter;", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Mutable;", "startBitsPerValue", "", "valueCount", "acceptableOverheadRatio", "", "<init>", "(IIF)V", "currentMask", "", "value", "mutable", "getMutable", "()Lorg/gnit/lucenekmp/util/packed/PackedInts$Mutable;", "get", "index", "size", "bitsPerValue", "getBitsPerValue", "()I", "ensureCapacity", "", "set", "clear", "resize", "newSize", "arr", "", "off", "len", "fill", "fromIndex", "toIndex", "val", "ramBytesUsed", "Companion", "core"})
public final class GrowableWriter
extends PackedInts.Mutable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float acceptableOverheadRatio;
    private long currentMask;
    @NotNull
    private PackedInts.Mutable mutable;

    public GrowableWriter(int startBitsPerValue, int valueCount, float acceptableOverheadRatio) {
        this.acceptableOverheadRatio = acceptableOverheadRatio;
        this.mutable = PackedInts.INSTANCE.getMutable(valueCount, startBitsPerValue, this.acceptableOverheadRatio);
        this.currentMask = GrowableWriter.Companion.mask(this.mutable.getBitsPerValue());
    }

    @NotNull
    public final PackedInts.Mutable getMutable() {
        return this.mutable;
    }

    @Override
    public long get(int index) {
        return this.mutable.get(index);
    }

    @Override
    public int size() {
        return this.mutable.size();
    }

    @Override
    public int getBitsPerValue() {
        return this.mutable.getBitsPerValue();
    }

    private final void ensureCapacity(long value) {
        if ((value & this.currentMask) == value) {
            return;
        }
        int bitsRequired = PackedInts.INSTANCE.unsignedBitsRequired(value);
        if (!(bitsRequired > this.mutable.getBitsPerValue())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int valueCount = this.size();
        PackedInts.Mutable next = PackedInts.INSTANCE.getMutable(valueCount, bitsRequired, this.acceptableOverheadRatio);
        PackedInts.INSTANCE.copy((PackedInts.Reader)this.mutable, 0, next, 0, valueCount, 1024);
        this.mutable = next;
        this.currentMask = GrowableWriter.Companion.mask(this.mutable.getBitsPerValue());
    }

    @Override
    public void set(int index, long value) {
        this.ensureCapacity(value);
        this.mutable.set(index, value);
    }

    @Override
    public void clear() {
        this.mutable.clear();
    }

    @NotNull
    public final GrowableWriter resize(int newSize) {
        GrowableWriter next = new GrowableWriter(this.getBitsPerValue(), newSize, this.acceptableOverheadRatio);
        int limit = Math.min(this.size(), newSize);
        PackedInts.INSTANCE.copy((PackedInts.Reader)this.mutable, 0, (PackedInts.Mutable)next, 0, limit, 1024);
        return next;
    }

    @Override
    public int get(int index, @NotNull long[] arr, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
        return this.mutable.get(index, arr, off, len);
    }

    @Override
    public int set(int index, @NotNull long[] arr, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
        long max = 0L;
        int end = off + len;
        for (int i = off; i < end; ++i) {
            max |= arr[i];
        }
        this.ensureCapacity(max);
        return this.mutable.set(index, arr, off, len);
    }

    @Override
    public void fill(int fromIndex, int toIndex, long val) {
        this.ensureCapacity(val);
        this.mutable.fill(fromIndex, toIndex, val);
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.Companion.alignObjectSize(24L) + this.mutable.ramBytesUsed();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/gnit/lucenekmp/util/packed/GrowableWriter$Companion;", "", "<init>", "()V", "mask", "", "bitsPerValue", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final long mask(int bitsPerValue) {
            return bitsPerValue == 64 ? -1L : PackedInts.INSTANCE.maxValue(bitsPerValue);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

