/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import java.io.IOException;
import java.util.Collection;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.store.IndexInput;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.LongValues;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 *2\u00020\u00012\u00020\u0002:\u0001*B)\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010$\u001a\u00020\t2\u0006\u0010%\u001a\u00020\tH\u0016J\u0006\u0010&\u001a\u00020\tJ\b\u0010'\u001a\u00020\tH\u0016J\b\u0010(\u001a\u00020)H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001c\u00a2\u0006\n\n\u0002\u0010\u001f\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010 \u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\rR\u0011\u0010\"\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\r\u00a8\u0006+"}, d2={"Lorg/gnit/lucenekmp/util/packed/MonotonicBlockPackedReader;", "Lorg/gnit/lucenekmp/util/LongValues;", "Lorg/gnit/lucenekmp/util/Accountable;", "in", "Lorg/gnit/lucenekmp/store/IndexInput;", "packedIntsVersion", "", "blockSize", "valueCount", "", "<init>", "(Lorg/gnit/lucenekmp/store/IndexInput;IIJ)V", "getValueCount", "()J", "blockShift", "getBlockShift", "()I", "blockMask", "getBlockMask", "minValues", "", "getMinValues", "()[J", "averages", "", "getAverages", "()[F", "subReaders", "", "getSubReaders", "()[Lorg/gnit/lucenekmp/util/LongValues;", "[Lorg/gnit/lucenekmp/util/LongValues;", "sumBPV", "getSumBPV", "totalByteCount", "getTotalByteCount", "get", "index", "size", "ramBytesUsed", "toString", "", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nMonotonicBlockPackedReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MonotonicBlockPackedReader.kt\norg/gnit/lucenekmp/util/packed/MonotonicBlockPackedReader\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,146:1\n3#2,8:147\n10#3:155\n*S KotlinDebug\n*F\n+ 1 MonotonicBlockPackedReader.kt\norg/gnit/lucenekmp/util/packed/MonotonicBlockPackedReader\n*L\n97#1:147,8\n97#1:155\n*E\n"})
public final class MonotonicBlockPackedReader
extends LongValues
implements Accountable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long valueCount;
    private final int blockShift;
    private final int blockMask;
    @NotNull
    private final long[] minValues;
    @NotNull
    private final float[] averages;
    @NotNull
    private final LongValues[] subReaders;
    private final long sumBPV;
    private final long totalByteCount;
    private static final int BLOCK_SIZE = 8;
    private static final int BLOCK_BITS = 3;
    private static final int MOD_MASK = 7;

    private MonotonicBlockPackedReader(IndexInput in, int packedIntsVersion, int blockSize, long valueCount) {
        this.valueCount = valueCount;
        this.blockShift = PackedInts.INSTANCE.checkBlockSize(blockSize, 64, 0x8000000);
        this.blockMask = blockSize - 1;
        int numBlocks = PackedInts.INSTANCE.numBlocks(this.valueCount, blockSize);
        this.minValues = new long[numBlocks];
        this.averages = new float[numBlocks];
        this.subReaders = new LongValues[numBlocks];
        long sumBPV = 0L;
        long totalByteCount = 0L;
        for (int i = 0; i < numBlocks; ++i) {
            this.minValues[i] = in.readZLong();
            this.averages[i] = FloatExtKt.intBitsToFloat(FloatCompanionObject.INSTANCE, in.readInt());
            final int bitsPerValue = in.readVInt();
            sumBPV += (long)bitsPerValue;
            if (bitsPerValue > 64) {
                throw new IOException("Corrupted");
            }
            if (bitsPerValue == 0) {
                this.subReaders[i] = LongValues.Companion.getZEROES();
                continue;
            }
            int size2 = (int)java.lang.Math.min((long)blockSize, this.valueCount - (long)i * (long)blockSize);
            int byteCount = Math.INSTANCE.toIntExact(PackedInts.Format.PACKED.byteCount(packedIntsVersion, size2, bitsPerValue));
            totalByteCount += (long)byteCount;
            final byte[] blocks = new byte[byteCount];
            in.readBytes(blocks, 0, byteCount);
            final long maskRight = (1L << bitsPerValue) - 1L;
            final int bpvMinusBlockSize = bitsPerValue - 8;
            this.subReaders[i] = new LongValues(){

                @Override
                public long get(long index) {
                    long majorBitPos = index * (long)bitsPerValue;
                    int blockOffset = (int)(majorBitPos >>> 3);
                    long endBits = (majorBitPos & 7L) + (long)bpvMinusBlockSize;
                    if (endBits <= 0L) {
                        return ((long)blocks[blockOffset] & 0xFFL) >>> -((int)endBits) & maskRight;
                    }
                    long value = ((long)blocks[blockOffset++] & 0xFFL) << (int)endBits & maskRight;
                    while (endBits > 8L) {
                        value |= ((long)blocks[blockOffset++] & 0xFFL) << (int)(endBits -= 8L);
                    }
                    return value | ((long)blocks[blockOffset] & 0xFFL) >>> (int)((long)8 - endBits);
                }
            };
        }
        this.sumBPV = sumBPV;
        this.totalByteCount = totalByteCount;
    }

    public final long getValueCount() {
        return this.valueCount;
    }

    public final int getBlockShift() {
        return this.blockShift;
    }

    public final int getBlockMask() {
        return this.blockMask;
    }

    @NotNull
    public final long[] getMinValues() {
        return this.minValues;
    }

    @NotNull
    public final float[] getAverages() {
        return this.averages;
    }

    @NotNull
    public final LongValues[] getSubReaders() {
        return this.subReaders;
    }

    public final long getSumBPV() {
        return this.sumBPV;
    }

    public final long getTotalByteCount() {
        return this.totalByteCount;
    }

    @Override
    public long get(long index) {
        boolean condition$iv = index >= 0L && index < this.valueCount;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        int block2 = (int)(index >>> this.blockShift);
        int idx = (int)(index & (long)this.blockMask);
        long l = Companion.expected(this.minValues[block2], this.averages[block2], idx);
        LongValues longValues = this.subReaders[block2];
        Intrinsics.checkNotNull((Object)longValues);
        return l + longValues.get(idx);
    }

    public final long size() {
        return this.valueCount;
    }

    @Override
    public long ramBytesUsed() {
        long sizeInBytes = 0L;
        sizeInBytes += RamUsageEstimator.Companion.sizeOf(this.minValues);
        sizeInBytes += RamUsageEstimator.Companion.sizeOf(this.averages);
        return sizeInBytes += this.totalByteCount;
    }

    @NotNull
    public String toString() {
        long avgBPV = this.subReaders.length == 0 ? 0L : this.sumBPV / (long)this.subReaders.length;
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(blocksize=" + (1 << this.blockShift) + ",size=" + this.valueCount + ",avgBPV=" + avgBPV + ")";
    }

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    public /* synthetic */ MonotonicBlockPackedReader(IndexInput in, int packedIntsVersion, int blockSize, long valueCount, DefaultConstructorMarker $constructor_marker) {
        this(in, packedIntsVersion, blockSize, valueCount);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0005R\u000e\u0010\u000b\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/gnit/lucenekmp/util/packed/MonotonicBlockPackedReader$Companion;", "", "<init>", "()V", "expected", "", "origin", "average", "", "index", "", "BLOCK_SIZE", "BLOCK_BITS", "MOD_MASK", "of", "Lorg/gnit/lucenekmp/util/packed/MonotonicBlockPackedReader;", "in", "Lorg/gnit/lucenekmp/store/IndexInput;", "packedIntsVersion", "blockSize", "valueCount", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final long expected(long origin, float average, int index) {
            return origin + (long)(average * (float)index);
        }

        @NotNull
        public final MonotonicBlockPackedReader of(@NotNull IndexInput in, int packedIntsVersion, int blockSize, long valueCount) throws IOException {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            return new MonotonicBlockPackedReader(in, packedIntsVersion, blockSize, valueCount, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

