/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.util.RamUsageEstimator;
import org.gnit.lucenekmp.util.packed.BulkOperation;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0010\b \u0018\u0000 )2\u00020\u0001:\u000f\u001b\u001c\u001d\u001e\u001f !\"#$%&'()B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J(\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J(\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J \u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006*"}, d2={"Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock;", "Lorg/gnit/lucenekmp/util/packed/PackedInts$MutableImpl;", "valueCount", "", "bitsPerValue", "<init>", "(II)V", "blocks", "", "getBlocks", "()[J", "clear", "", "ramBytesUsed", "", "get", "index", "arr", "off", "len", "set", "fill", "fromIndex", "toIndex", "val", "toString", "", "Packed64SingleBlock1", "Packed64SingleBlock2", "Packed64SingleBlock3", "Packed64SingleBlock4", "Packed64SingleBlock5", "Packed64SingleBlock6", "Packed64SingleBlock7", "Packed64SingleBlock8", "Packed64SingleBlock9", "Packed64SingleBlock10", "Packed64SingleBlock12", "Packed64SingleBlock16", "Packed64SingleBlock21", "Packed64SingleBlock32", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nPacked64SingleBlock.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Packed64SingleBlock.kt\norg/gnit/lucenekmp/util/packed/Packed64SingleBlock\n+ 2 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt\n+ 3 Assert.kt\norg/gnit/lucenekmp/jdkport/AssertKt$assert$1\n*L\n1#1,449:1\n3#2,8:450\n8#2,2:459\n3#2,8:461\n3#2,8:470\n3#2,8:479\n3#2,8:488\n3#2,8:497\n3#2,8:506\n8#2,2:515\n3#2,8:517\n3#2,8:526\n3#2,8:535\n3#2,8:544\n3#2,8:553\n3#2,8:562\n3#2,8:571\n3#2,8:580\n3#2,8:589\n3#2,8:598\n3#2,8:607\n10#3:458\n10#3:469\n10#3:478\n10#3:487\n10#3:496\n10#3:505\n10#3:514\n10#3:525\n10#3:534\n10#3:543\n10#3:552\n10#3:561\n10#3:570\n10#3:579\n10#3:588\n10#3:597\n10#3:606\n10#3:615\n*S KotlinDebug\n*F\n+ 1 Packed64SingleBlock.kt\norg/gnit/lucenekmp/util/packed/Packed64SingleBlock\n*L\n17#1:450,8\n39#1:459,2\n40#1:461,8\n42#1:470,8\n62#1:479,8\n68#1:488,8\n69#1:497,8\n83#1:506,8\n92#1:515,2\n93#1:517,8\n95#1:526,8\n115#1:535,8\n121#1:544,8\n122#1:553,8\n136#1:562,8\n143#1:571,8\n144#1:580,8\n145#1:589,8\n161#1:598,8\n167#1:607,8\n17#1:458\n40#1:469\n42#1:478\n62#1:487\n68#1:496\n69#1:505\n83#1:514\n93#1:525\n95#1:534\n115#1:543\n121#1:552\n122#1:561\n136#1:570\n143#1:579\n144#1:588\n145#1:597\n161#1:606\n167#1:615\n*E\n"})
public abstract class Packed64SingleBlock
extends PackedInts.MutableImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final long[] blocks;
    public static final int MAX_SUPPORTED_BITS_PER_VALUE = 32;
    @NotNull
    private static final int[] SUPPORTED_BITS_PER_VALUE;

    public Packed64SingleBlock(int valueCount, int bitsPerValue) {
        super(valueCount, bitsPerValue);
        boolean condition$iv = Companion.isSupported(bitsPerValue);
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        int valuesPerBlock = 64 / bitsPerValue;
        this.blocks = new long[Packed64SingleBlock.Companion.requiredCapacity(valueCount, valuesPerBlock)];
    }

    @NotNull
    public final long[] getBlocks() {
        return this.blocks;
    }

    @Override
    public void clear() {
        Arrays.INSTANCE.fill(this.blocks, 0L);
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.Companion.alignObjectSize(20L) + RamUsageEstimator.Companion.sizeOf(this.blocks);
    }

    @Override
    public int get(int index, @NotNull long[] arr, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
        int index2 = index;
        int off2 = off;
        int len2 = 0;
        len2 = len;
        boolean condition$iv = len2 > 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "len must be > 0 (got " + len2 + ")";
            throw new AssertionError((Object)string);
        }
        condition$iv = index2 >= 0 && index2 < this.getValueCount();
        boolean $i$f$assert2 = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        condition$iv = off2 + (len2 = Math.min(len2, this.getValueCount() - index2)) <= arr.length;
        $i$f$assert2 = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$32 = false;
            String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
        }
        int originalIndex = index2;
        int valuesPerBlock = 64 / this.getBitsPerValue();
        int offsetInBlock = index2 % valuesPerBlock;
        if (offsetInBlock != 0) {
            for (int i = offsetInBlock; i < valuesPerBlock && len2 > 0; len2 += -1, ++i) {
                arr[off2++] = this.get(index2++);
            }
            if (len2 == 0) {
                return index2 - originalIndex;
            }
        }
        boolean condition$iv2 = index2 % valuesPerBlock == 0;
        boolean $i$f$assert3 = false;
        if (_Assertions.ENABLED && !condition$iv2) {
            boolean $i$a$-assert-AssertKt$assert$42 = false;
            String $i$a$-assert-AssertKt$assert$42 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$42);
        }
        PackedInts.Decoder decoder = BulkOperation.Companion.of(PackedInts.Format.PACKED_SINGLE_BLOCK, this.getBitsPerValue());
        boolean condition$iv3 = decoder.longBlockCount() == 1;
        boolean $i$f$assert4 = false;
        if (_Assertions.ENABLED && !condition$iv3) {
            boolean $i$a$-assert-AssertKt$assert$52 = false;
            String $i$a$-assert-AssertKt$assert$52 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$52);
        }
        condition$iv3 = decoder.longValueCount() == valuesPerBlock;
        $i$f$assert4 = false;
        if (_Assertions.ENABLED && !condition$iv3) {
            boolean $i$a$-assert-AssertKt$assert$62 = false;
            String $i$a$-assert-AssertKt$assert$62 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$62);
        }
        int blockIndex = index2 / valuesPerBlock;
        int nblocks = (index2 + len2) / valuesPerBlock - blockIndex;
        decoder.decode(this.blocks, blockIndex, arr, off2, nblocks);
        int diff = nblocks * valuesPerBlock;
        len2 -= diff;
        if ((index2 += diff) > originalIndex) {
            return index2 - originalIndex;
        }
        boolean condition$iv4 = index2 == originalIndex;
        boolean $i$f$assert5 = false;
        if (_Assertions.ENABLED && !condition$iv4) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        return super.get(index2, arr, off2, len2);
    }

    @Override
    public int set(int index, @NotNull long[] arr, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
        int index2 = index;
        int off2 = off;
        int len2 = 0;
        len2 = len;
        boolean condition$iv = len2 > 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean bl = false;
            String string = "len must be > 0 (got " + len2 + ")";
            throw new AssertionError((Object)string);
        }
        condition$iv = index2 >= 0 && index2 < this.getValueCount();
        boolean $i$f$assert2 = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        condition$iv = off2 + (len2 = Math.min(len2, this.getValueCount() - index2)) <= arr.length;
        $i$f$assert2 = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$32 = false;
            String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
        }
        int originalIndex = index2;
        int valuesPerBlock = 64 / this.getBitsPerValue();
        int offsetInBlock = index2 % valuesPerBlock;
        if (offsetInBlock != 0) {
            for (int i = offsetInBlock; i < valuesPerBlock && len2 > 0; len2 += -1, ++i) {
                this.set(index2++, arr[off2++]);
            }
            if (len2 == 0) {
                return index2 - originalIndex;
            }
        }
        boolean condition$iv2 = index2 % valuesPerBlock == 0;
        boolean $i$f$assert3 = false;
        if (_Assertions.ENABLED && !condition$iv2) {
            boolean $i$a$-assert-AssertKt$assert$42 = false;
            String $i$a$-assert-AssertKt$assert$42 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$42);
        }
        BulkOperation op = BulkOperation.Companion.of(PackedInts.Format.PACKED_SINGLE_BLOCK, this.getBitsPerValue());
        boolean condition$iv3 = op.longBlockCount() == 1;
        boolean $i$f$assert4 = false;
        if (_Assertions.ENABLED && !condition$iv3) {
            boolean $i$a$-assert-AssertKt$assert$52 = false;
            String $i$a$-assert-AssertKt$assert$52 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$52);
        }
        condition$iv3 = op.longValueCount() == valuesPerBlock;
        $i$f$assert4 = false;
        if (_Assertions.ENABLED && !condition$iv3) {
            boolean $i$a$-assert-AssertKt$assert$62 = false;
            String $i$a$-assert-AssertKt$assert$62 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$62);
        }
        int blockIndex = index2 / valuesPerBlock;
        int nblocks = (index2 + len2) / valuesPerBlock - blockIndex;
        op.encode(arr, off2, this.blocks, blockIndex, nblocks);
        int diff = nblocks * valuesPerBlock;
        len2 -= diff;
        if ((index2 += diff) > originalIndex) {
            return index2 - originalIndex;
        }
        boolean condition$iv4 = index2 == originalIndex;
        boolean $i$f$assert5 = false;
        if (_Assertions.ENABLED && !condition$iv4) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        return super.set(index2, arr, off2, len2);
    }

    @Override
    public void fill(int fromIndex, int toIndex, long val) {
        int i;
        int fromIndex2 = fromIndex;
        boolean condition$iv = fromIndex2 >= 0;
        boolean $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$22 = false;
            String $i$a$-assert-AssertKt$assert$22 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$22);
        }
        condition$iv = fromIndex2 <= toIndex;
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$32 = false;
            String $i$a$-assert-AssertKt$assert$32 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$32);
        }
        condition$iv = PackedInts.INSTANCE.unsignedBitsRequired(val) <= this.getBitsPerValue();
        $i$f$assert = false;
        if (_Assertions.ENABLED && !condition$iv) {
            boolean $i$a$-assert-AssertKt$assert$42 = false;
            String $i$a$-assert-AssertKt$assert$42 = "assertion failed";
            throw new AssertionError((Object)$i$a$-assert-AssertKt$assert$42);
        }
        int valuesPerBlock = 64 / this.getBitsPerValue();
        if (toIndex - fromIndex2 <= valuesPerBlock << 1) {
            super.fill(fromIndex2, toIndex, val);
            return;
        }
        int fromOffsetInBlock = fromIndex2 % valuesPerBlock;
        if (fromOffsetInBlock != 0) {
            for (int i2 = fromOffsetInBlock; i2 < valuesPerBlock; ++i2) {
                this.set(fromIndex2++, val);
            }
            boolean condition$iv2 = fromIndex2 % valuesPerBlock == 0;
            boolean $i$f$assert2 = false;
            if (_Assertions.ENABLED && !condition$iv2) {
                boolean bl = false;
                String string = "assertion failed";
                throw new AssertionError((Object)string);
            }
        }
        int fromBlock = fromIndex2 / valuesPerBlock;
        int toBlock = toIndex / valuesPerBlock;
        boolean condition$iv3 = fromBlock * valuesPerBlock == fromIndex2;
        boolean $i$f$assert3 = false;
        if (_Assertions.ENABLED && !condition$iv3) {
            boolean bl = false;
            String string = "assertion failed";
            throw new AssertionError((Object)string);
        }
        long blockValue = 0L;
        for (i = 0; i < valuesPerBlock; ++i) {
            blockValue |= val << i * this.getBitsPerValue();
        }
        Arrays.INSTANCE.fill(this.blocks, fromBlock, toBlock, blockValue);
        for (i = valuesPerBlock * toBlock; i < toIndex; ++i) {
            this.set(i, val);
        }
    }

    @Override
    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(bitsPerValue=" + this.getBitsPerValue() + ",size=" + this.size() + ",blocks=" + this.blocks.length + ")";
    }

    static {
        int[] nArray = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 12, 16, 21, 32};
        SUPPORTED_BITS_PER_VALUE = nArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock$Companion;", "", "<init>", "()V", "MAX_SUPPORTED_BITS_PER_VALUE", "", "SUPPORTED_BITS_PER_VALUE", "", "isSupported", "", "bitsPerValue", "requiredCapacity", "valueCount", "valuesPerBlock", "create", "Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock;", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isSupported(int bitsPerValue) {
            return Arrays.INSTANCE.binarySearch(SUPPORTED_BITS_PER_VALUE, bitsPerValue) >= 0;
        }

        private final int requiredCapacity(int valueCount, int valuesPerBlock) {
            return valueCount / valuesPerBlock + (valueCount % valuesPerBlock == 0 ? 0 : 1);
        }

        @NotNull
        public final Packed64SingleBlock create(int valueCount, int bitsPerValue) {
            switch (bitsPerValue) {
                case 1: {
                    return new Packed64SingleBlock1(valueCount);
                }
                case 2: {
                    return new Packed64SingleBlock2(valueCount);
                }
                case 3: {
                    return new Packed64SingleBlock3(valueCount);
                }
                case 4: {
                    return new Packed64SingleBlock4(valueCount);
                }
                case 5: {
                    return new Packed64SingleBlock5(valueCount);
                }
                case 6: {
                    return new Packed64SingleBlock6(valueCount);
                }
                case 7: {
                    return new Packed64SingleBlock7(valueCount);
                }
                case 8: {
                    return new Packed64SingleBlock8(valueCount);
                }
                case 9: {
                    return new Packed64SingleBlock9(valueCount);
                }
                case 10: {
                    return new Packed64SingleBlock10(valueCount);
                }
                case 12: {
                    return new Packed64SingleBlock12(valueCount);
                }
                case 16: {
                    return new Packed64SingleBlock16(valueCount);
                }
                case 21: {
                    return new Packed64SingleBlock21(valueCount);
                }
                case 32: {
                    return new Packed64SingleBlock32(valueCount);
                }
            }
            throw new IllegalArgumentException("Unsupported number of bits per value: 32");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock$Packed64SingleBlock1;", "Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock;", "valueCount", "", "<init>", "(I)V", "get", "", "index", "set", "", "value", "core"})
    public static final class Packed64SingleBlock1
    extends Packed64SingleBlock {
        public Packed64SingleBlock1(int valueCount) {
            super(valueCount, 1);
        }

        @Override
        public long get(int index) {
            int o = index >>> 6;
            int b = index & 0x3F;
            int shift = b << 0;
            return this.getBlocks()[o] >>> shift & 1L;
        }

        @Override
        public void set(int index, long value) {
            int o = index >>> 6;
            int b = index & 0x3F;
            int shift = b << 0;
            this.getBlocks()[o] = this.getBlocks()[o] & (1L << shift ^ 0xFFFFFFFFFFFFFFFFL) | value << shift;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock$Packed64SingleBlock10;", "Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock;", "valueCount", "", "<init>", "(I)V", "get", "", "index", "set", "", "value", "core"})
    public static final class Packed64SingleBlock10
    extends Packed64SingleBlock {
        public Packed64SingleBlock10(int valueCount) {
            super(valueCount, 10);
        }

        @Override
        public long get(int index) {
            int o = index / 6;
            int b = index % 6;
            int shift = b * 10;
            return this.getBlocks()[o] >>> shift & 0x3FFL;
        }

        @Override
        public void set(int index, long value) {
            int o = index / 6;
            int b = index % 6;
            int shift = b * 10;
            this.getBlocks()[o] = this.getBlocks()[o] & (1023L << shift ^ 0xFFFFFFFFFFFFFFFFL) | value << shift;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock$Packed64SingleBlock12;", "Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock;", "valueCount", "", "<init>", "(I)V", "get", "", "index", "set", "", "value", "core"})
    public static final class Packed64SingleBlock12
    extends Packed64SingleBlock {
        public Packed64SingleBlock12(int valueCount) {
            super(valueCount, 12);
        }

        @Override
        public long get(int index) {
            int o = index / 5;
            int b = index % 5;
            int shift = b * 12;
            return this.getBlocks()[o] >>> shift & 0xFFFL;
        }

        @Override
        public void set(int index, long value) {
            int o = index / 5;
            int b = index % 5;
            int shift = b * 12;
            this.getBlocks()[o] = this.getBlocks()[o] & (4095L << shift ^ 0xFFFFFFFFFFFFFFFFL) | value << shift;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock$Packed64SingleBlock16;", "Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock;", "valueCount", "", "<init>", "(I)V", "get", "", "index", "set", "", "value", "core"})
    public static final class Packed64SingleBlock16
    extends Packed64SingleBlock {
        public Packed64SingleBlock16(int valueCount) {
            super(valueCount, 16);
        }

        @Override
        public long get(int index) {
            int o = index >>> 2;
            int b = index & 3;
            int shift = b << 4;
            return this.getBlocks()[o] >>> shift & 0xFFFFL;
        }

        @Override
        public void set(int index, long value) {
            int o = index >>> 2;
            int b = index & 3;
            int shift = b << 4;
            this.getBlocks()[o] = this.getBlocks()[o] & (65535L << shift ^ 0xFFFFFFFFFFFFFFFFL) | value << shift;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock$Packed64SingleBlock2;", "Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock;", "valueCount", "", "<init>", "(I)V", "get", "", "index", "set", "", "value", "core"})
    public static final class Packed64SingleBlock2
    extends Packed64SingleBlock {
        public Packed64SingleBlock2(int valueCount) {
            super(valueCount, 2);
        }

        @Override
        public long get(int index) {
            int o = index >>> 5;
            int b = index & 0x1F;
            int shift = b << 1;
            return this.getBlocks()[o] >>> shift & 3L;
        }

        @Override
        public void set(int index, long value) {
            int o = index >>> 5;
            int b = index & 0x1F;
            int shift = b << 1;
            this.getBlocks()[o] = this.getBlocks()[o] & (3L << shift ^ 0xFFFFFFFFFFFFFFFFL) | value << shift;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock$Packed64SingleBlock21;", "Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock;", "valueCount", "", "<init>", "(I)V", "get", "", "index", "set", "", "value", "core"})
    public static final class Packed64SingleBlock21
    extends Packed64SingleBlock {
        public Packed64SingleBlock21(int valueCount) {
            super(valueCount, 21);
        }

        @Override
        public long get(int index) {
            int o = index / 3;
            int b = index % 3;
            int shift = b * 21;
            return this.getBlocks()[o] >>> shift & 0x1FFFFFL;
        }

        @Override
        public void set(int index, long value) {
            int o = index / 3;
            int b = index % 3;
            int shift = b * 21;
            this.getBlocks()[o] = this.getBlocks()[o] & (0x1FFFFFL << shift ^ 0xFFFFFFFFFFFFFFFFL) | value << shift;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock$Packed64SingleBlock3;", "Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock;", "valueCount", "", "<init>", "(I)V", "get", "", "index", "set", "", "value", "core"})
    public static final class Packed64SingleBlock3
    extends Packed64SingleBlock {
        public Packed64SingleBlock3(int valueCount) {
            super(valueCount, 3);
        }

        @Override
        public long get(int index) {
            int o = index / 21;
            int b = index % 21;
            int shift = b * 3;
            return this.getBlocks()[o] >>> shift & 7L;
        }

        @Override
        public void set(int index, long value) {
            int o = index / 21;
            int b = index % 21;
            int shift = b * 3;
            this.getBlocks()[o] = this.getBlocks()[o] & (7L << shift ^ 0xFFFFFFFFFFFFFFFFL) | value << shift;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock$Packed64SingleBlock32;", "Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock;", "valueCount", "", "<init>", "(I)V", "get", "", "index", "set", "", "value", "core"})
    public static final class Packed64SingleBlock32
    extends Packed64SingleBlock {
        public Packed64SingleBlock32(int valueCount) {
            super(valueCount, 32);
        }

        @Override
        public long get(int index) {
            int o = index >>> 1;
            int b = index & 1;
            int shift = b << 5;
            return this.getBlocks()[o] >>> shift & 0xFFFFFFFFL;
        }

        @Override
        public void set(int index, long value) {
            int o = index >>> 1;
            int b = index & 1;
            int shift = b << 5;
            this.getBlocks()[o] = this.getBlocks()[o] & (0xFFFFFFFFL << shift ^ 0xFFFFFFFFFFFFFFFFL) | value << shift;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock$Packed64SingleBlock4;", "Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock;", "valueCount", "", "<init>", "(I)V", "get", "", "index", "set", "", "value", "core"})
    public static final class Packed64SingleBlock4
    extends Packed64SingleBlock {
        public Packed64SingleBlock4(int valueCount) {
            super(valueCount, 4);
        }

        @Override
        public long get(int index) {
            int o = index >>> 4;
            int b = index & 0xF;
            int shift = b << 2;
            return this.getBlocks()[o] >>> shift & 0xFL;
        }

        @Override
        public void set(int index, long value) {
            int o = index >>> 4;
            int b = index & 0xF;
            int shift = b << 2;
            this.getBlocks()[o] = this.getBlocks()[o] & (15L << shift ^ 0xFFFFFFFFFFFFFFFFL) | value << shift;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock$Packed64SingleBlock5;", "Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock;", "valueCount", "", "<init>", "(I)V", "get", "", "index", "set", "", "value", "core"})
    public static final class Packed64SingleBlock5
    extends Packed64SingleBlock {
        public Packed64SingleBlock5(int valueCount) {
            super(valueCount, 5);
        }

        @Override
        public long get(int index) {
            int o = index / 12;
            int b = index % 12;
            int shift = b * 5;
            return this.getBlocks()[o] >>> shift & 0x1FL;
        }

        @Override
        public void set(int index, long value) {
            int o = index / 12;
            int b = index % 12;
            int shift = b * 5;
            this.getBlocks()[o] = this.getBlocks()[o] & (31L << shift ^ 0xFFFFFFFFFFFFFFFFL) | value << shift;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock$Packed64SingleBlock6;", "Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock;", "valueCount", "", "<init>", "(I)V", "get", "", "index", "set", "", "value", "core"})
    public static final class Packed64SingleBlock6
    extends Packed64SingleBlock {
        public Packed64SingleBlock6(int valueCount) {
            super(valueCount, 6);
        }

        @Override
        public long get(int index) {
            int o = index / 10;
            int b = index % 10;
            int shift = b * 6;
            return this.getBlocks()[o] >>> shift & 0x3FL;
        }

        @Override
        public void set(int index, long value) {
            int o = index / 10;
            int b = index % 10;
            int shift = b * 6;
            this.getBlocks()[o] = this.getBlocks()[o] & (63L << shift ^ 0xFFFFFFFFFFFFFFFFL) | value << shift;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock$Packed64SingleBlock7;", "Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock;", "valueCount", "", "<init>", "(I)V", "get", "", "index", "set", "", "value", "core"})
    public static final class Packed64SingleBlock7
    extends Packed64SingleBlock {
        public Packed64SingleBlock7(int valueCount) {
            super(valueCount, 7);
        }

        @Override
        public long get(int index) {
            int o = index / 9;
            int b = index % 9;
            int shift = b * 7;
            return this.getBlocks()[o] >>> shift & 0x7FL;
        }

        @Override
        public void set(int index, long value) {
            int o = index / 9;
            int b = index % 9;
            int shift = b * 7;
            this.getBlocks()[o] = this.getBlocks()[o] & (127L << shift ^ 0xFFFFFFFFFFFFFFFFL) | value << shift;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock$Packed64SingleBlock8;", "Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock;", "valueCount", "", "<init>", "(I)V", "get", "", "index", "set", "", "value", "core"})
    public static final class Packed64SingleBlock8
    extends Packed64SingleBlock {
        public Packed64SingleBlock8(int valueCount) {
            super(valueCount, 8);
        }

        @Override
        public long get(int index) {
            int o = index >>> 3;
            int b = index & 7;
            int shift = b << 3;
            return this.getBlocks()[o] >>> shift & 0xFFL;
        }

        @Override
        public void set(int index, long value) {
            int o = index >>> 3;
            int b = index & 7;
            int shift = b << 3;
            this.getBlocks()[o] = this.getBlocks()[o] & (255L << shift ^ 0xFFFFFFFFFFFFFFFFL) | value << shift;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0007H\u0016\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock$Packed64SingleBlock9;", "Lorg/gnit/lucenekmp/util/packed/Packed64SingleBlock;", "valueCount", "", "<init>", "(I)V", "get", "", "index", "set", "", "value", "core"})
    public static final class Packed64SingleBlock9
    extends Packed64SingleBlock {
        public Packed64SingleBlock9(int valueCount) {
            super(valueCount, 9);
        }

        @Override
        public long get(int index) {
            int o = index / 7;
            int b = index % 7;
            int shift = b * 9;
            return this.getBlocks()[o] >>> shift & 0x1FFL;
        }

        @Override
        public void set(int index, long value) {
            int o = index / 7;
            int b = index % 7;
            int shift = b * 9;
            this.getBlocks()[o] = this.getBlocks()[o] & (511L << shift ^ 0xFFFFFFFFFFFFFFFFL) | value << shift;
        }
    }
}

