/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.packed;

import java.io.EOFException;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.store.DataInput;
import org.gnit.lucenekmp.util.LongsRef;
import org.gnit.lucenekmp.util.packed.BulkOperation;
import org.gnit.lucenekmp.util.packed.PackedInts;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u0005H\u0016J\b\u0010%\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0010R\u001a\u0010\u001f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0010\"\u0004\b!\u0010\"\u00a8\u0006&"}, d2={"Lorg/gnit/lucenekmp/util/packed/PackedReaderIterator;", "Lorg/gnit/lucenekmp/util/packed/PackedInts$ReaderIteratorImpl;", "format", "Lorg/gnit/lucenekmp/util/packed/PackedInts$Format;", "packedIntsVersion", "", "valueCount", "bitsPerValue", "in", "Lorg/gnit/lucenekmp/store/DataInput;", "mem", "<init>", "(Lorg/gnit/lucenekmp/util/packed/PackedInts$Format;IIILorg/gnit/lucenekmp/store/DataInput;I)V", "getFormat", "()Lorg/gnit/lucenekmp/util/packed/PackedInts$Format;", "getPackedIntsVersion", "()I", "bulkOperation", "Lorg/gnit/lucenekmp/util/packed/BulkOperation;", "getBulkOperation", "()Lorg/gnit/lucenekmp/util/packed/BulkOperation;", "nextBlocks", "", "getNextBlocks", "()[B", "nextValues", "Lorg/gnit/lucenekmp/util/LongsRef;", "getNextValues", "()Lorg/gnit/lucenekmp/util/LongsRef;", "iterations", "getIterations", "position", "getPosition", "setPosition", "(I)V", "next", "count", "ord", "core"})
public final class PackedReaderIterator
extends PackedInts.ReaderIteratorImpl {
    @NotNull
    private final PackedInts.Format format;
    private final int packedIntsVersion;
    @NotNull
    private final BulkOperation bulkOperation;
    @NotNull
    private final byte[] nextBlocks;
    @NotNull
    private final LongsRef nextValues;
    private final int iterations;
    private int position;

    public PackedReaderIterator(@NotNull PackedInts.Format format, int packedIntsVersion, int valueCount, int bitsPerValue, @NotNull DataInput in, int mem) {
        Intrinsics.checkNotNullParameter((Object)((Object)format), (String)"format");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        super(valueCount, bitsPerValue, in);
        this.format = format;
        this.packedIntsVersion = packedIntsVersion;
        this.bulkOperation = BulkOperation.Companion.of(this.format, bitsPerValue);
        this.iterations = this.bulkOperation.computeIterations(valueCount, mem);
        if (!(valueCount == 0 || this.iterations > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.nextBlocks = new byte[this.iterations * this.bulkOperation.byteBlockCount()];
        this.nextValues = new LongsRef(new long[this.iterations * this.bulkOperation.byteValueCount()], 0, 0);
        this.nextValues.setOffset(this.nextValues.getLongs().length);
        this.position = -1;
    }

    @NotNull
    public final PackedInts.Format getFormat() {
        return this.format;
    }

    public final int getPackedIntsVersion() {
        return this.packedIntsVersion;
    }

    @NotNull
    public final BulkOperation getBulkOperation() {
        return this.bulkOperation;
    }

    @NotNull
    public final byte[] getNextBlocks() {
        return this.nextBlocks;
    }

    @NotNull
    public final LongsRef getNextValues() {
        return this.nextValues;
    }

    public final int getIterations() {
        return this.iterations;
    }

    public final int getPosition() {
        return this.position;
    }

    public final void setPosition(int n) {
        this.position = n;
    }

    @Override
    @NotNull
    public LongsRef next(int count) throws IOException {
        int count2 = count;
        if (!(this.nextValues.getLength() >= 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(count2 > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.nextValues.getOffset() + this.nextValues.getLength() <= this.nextValues.getLongs().length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        LongsRef longsRef = this.nextValues;
        longsRef.setOffset(longsRef.getOffset() + this.nextValues.getLength());
        int remaining = this.getValueCount() - this.position - 1;
        if (remaining <= 0) {
            throw new EOFException();
        }
        count2 = Math.min(remaining, count2);
        if (this.nextValues.getOffset() == this.nextValues.getLongs().length) {
            long remainingBlocks = this.format.byteCount(this.packedIntsVersion, remaining, this.getBitsPerValue());
            int blocksToRead = Math.min((int)remainingBlocks, this.nextBlocks.length);
            this.getIn().readBytes(this.nextBlocks, 0, blocksToRead);
            if (blocksToRead < this.nextBlocks.length) {
                ArraysKt.fill((byte[])this.nextBlocks, (byte)0, (int)blocksToRead, (int)this.nextBlocks.length);
            }
            this.bulkOperation.decode(this.nextBlocks, 0, this.nextValues.getLongs(), 0, this.iterations);
            this.nextValues.setOffset(0);
        }
        this.nextValues.setLength(Math.min(this.nextValues.getLongs().length - this.nextValues.getOffset(), count2));
        this.position += this.nextValues.getLength();
        return this.nextValues;
    }

    @Override
    public int ord() {
        return this.position;
    }
}

