/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.quantization;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.VectorSimilarityFunction;
import org.gnit.lucenekmp.util.VectorUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0012\n\u0002\b\t\bf\u0018\u0000 \r2\u00020\u0001:\u0005\t\n\u000b\f\rJ(\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0003H&\u00a8\u0006\u000e\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizedVectorSimilarity;", "", "score", "", "queryVector", "", "queryVectorOffset", "storedVector", "vectorOffset", "Euclidean", "DotProduct", "MaximumInnerProduct", "ByteVectorComparator", "Companion", "core"})
public interface ScalarQuantizedVectorSimilarity {
    @NotNull
    public static final Companion Companion = org.gnit.lucenekmp.util.quantization.ScalarQuantizedVectorSimilarity$Companion.$$INSTANCE;

    public float score(@NotNull byte[] var1, float var2, @NotNull byte[] var3, float var4);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H&\u00a8\u0006\u0007\u00c0\u0006\u0003"}, d2={"Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizedVectorSimilarity$ByteVectorComparator;", "", "compare", "", "v1", "", "v2", "core"})
    public static interface ByteVectorComparator {
        public int compare(@NotNull byte[] var1, @NotNull byte[] var2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizedVectorSimilarity$Companion;", "", "<init>", "()V", "fromVectorSimilarity", "Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizedVectorSimilarity;", "sim", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "constMultiplier", "", "bits", "", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final ScalarQuantizedVectorSimilarity fromVectorSimilarity(@NotNull VectorSimilarityFunction sim, float constMultiplier, byte bits) {
            Intrinsics.checkNotNullParameter((Object)((Object)sim), (String)"sim");
            return switch (WhenMappings.$EnumSwitchMapping$0[sim.ordinal()]) {
                case 1 -> new Euclidean(constMultiplier);
                case 2, 3 -> new DotProduct(constMultiplier, new ByteVectorComparator(bits){
                    final /* synthetic */ byte $bits;
                    {
                        this.$bits = $bits;
                    }

                    public int compare(byte[] v1, byte[] v2) {
                        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
                        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
                        return this.$bits <= 4 ? VectorUtil.INSTANCE.int4DotProduct(v1, v2) : VectorUtil.INSTANCE.dotProduct(v1, v2);
                    }
                });
                case 4 -> new MaximumInnerProduct(constMultiplier, new ByteVectorComparator(bits){
                    final /* synthetic */ byte $bits;
                    {
                        this.$bits = $bits;
                    }

                    public int compare(byte[] v1, byte[] v2) {
                        Intrinsics.checkNotNullParameter((Object)v1, (String)"v1");
                        Intrinsics.checkNotNullParameter((Object)v2, (String)"v2");
                        return this.$bits <= 4 ? VectorUtil.INSTANCE.int4DotProduct(v1, v2) : VectorUtil.INSTANCE.dotProduct(v1, v2);
                    }
                });
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        static {
            $$INSTANCE = new Companion();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[VectorSimilarityFunction.values().length];
                try {
                    nArray[VectorSimilarityFunction.EUCLIDEAN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VectorSimilarityFunction.COSINE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VectorSimilarityFunction.DOT_PRODUCT.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[VectorSimilarityFunction.MAXIMUM_INNER_PRODUCT.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizedVectorSimilarity$DotProduct;", "Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizedVectorSimilarity;", "constMultiplier", "", "comparator", "Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizedVectorSimilarity$ByteVectorComparator;", "<init>", "(FLorg/gnit/lucenekmp/util/quantization/ScalarQuantizedVectorSimilarity$ByteVectorComparator;)V", "score", "queryVector", "", "queryOffset", "storedVector", "vectorOffset", "core"})
    public static final class DotProduct
    implements ScalarQuantizedVectorSimilarity {
        private final float constMultiplier;
        @NotNull
        private final ByteVectorComparator comparator;

        public DotProduct(float constMultiplier, @NotNull ByteVectorComparator comparator2) {
            Intrinsics.checkNotNullParameter((Object)comparator2, (String)"comparator");
            this.constMultiplier = constMultiplier;
            this.comparator = comparator2;
        }

        @Override
        public float score(@NotNull byte[] queryVector, float queryOffset, @NotNull byte[] storedVector, float vectorOffset) {
            Intrinsics.checkNotNullParameter((Object)queryVector, (String)"queryVector");
            Intrinsics.checkNotNullParameter((Object)storedVector, (String)"storedVector");
            int dotProduct = this.comparator.compare(storedVector, queryVector);
            if (!(dotProduct >= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            float adjustedDistance = (float)dotProduct * this.constMultiplier + queryOffset + vectorOffset;
            return Math.max((1.0f + adjustedDistance) / (float)2, 0.0f);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizedVectorSimilarity$Euclidean;", "Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizedVectorSimilarity;", "constMultiplier", "", "<init>", "(F)V", "score", "queryVector", "", "queryVectorOffset", "storedVector", "vectorOffset", "core"})
    public static final class Euclidean
    implements ScalarQuantizedVectorSimilarity {
        private final float constMultiplier;

        public Euclidean(float constMultiplier) {
            this.constMultiplier = constMultiplier;
        }

        @Override
        public float score(@NotNull byte[] queryVector, float queryVectorOffset, @NotNull byte[] storedVector, float vectorOffset) {
            Intrinsics.checkNotNullParameter((Object)queryVector, (String)"queryVector");
            Intrinsics.checkNotNullParameter((Object)storedVector, (String)"storedVector");
            int squareDistance = VectorUtil.INSTANCE.squareDistance(storedVector, queryVector);
            float adjustedDistance = (float)squareDistance * this.constMultiplier;
            return 1.0f / (1.0f + adjustedDistance);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizedVectorSimilarity$MaximumInnerProduct;", "Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizedVectorSimilarity;", "constMultiplier", "", "comparator", "Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizedVectorSimilarity$ByteVectorComparator;", "<init>", "(FLorg/gnit/lucenekmp/util/quantization/ScalarQuantizedVectorSimilarity$ByteVectorComparator;)V", "score", "queryVector", "", "queryOffset", "storedVector", "vectorOffset", "core"})
    public static final class MaximumInnerProduct
    implements ScalarQuantizedVectorSimilarity {
        private final float constMultiplier;
        @NotNull
        private final ByteVectorComparator comparator;

        public MaximumInnerProduct(float constMultiplier, @NotNull ByteVectorComparator comparator2) {
            Intrinsics.checkNotNullParameter((Object)comparator2, (String)"comparator");
            this.constMultiplier = constMultiplier;
            this.comparator = comparator2;
        }

        @Override
        public float score(@NotNull byte[] queryVector, float queryOffset, @NotNull byte[] storedVector, float vectorOffset) {
            Intrinsics.checkNotNullParameter((Object)queryVector, (String)"queryVector");
            Intrinsics.checkNotNullParameter((Object)storedVector, (String)"storedVector");
            int dotProduct = this.comparator.compare(storedVector, queryVector);
            if (!(dotProduct >= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            float adjustedDistance = (float)dotProduct * this.constMultiplier + queryOffset + vectorOffset;
            return VectorUtil.INSTANCE.scaleMaxInnerProductScore(adjustedDistance);
        }
    }
}

