/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.util.quantization;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.DoubleCompanionObject;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import org.gnit.lucenekmp.index.FloatVectorValues;
import org.gnit.lucenekmp.index.KnnVectorValues;
import org.gnit.lucenekmp.index.VectorSimilarityFunction;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.DoubleExtKt;
import org.gnit.lucenekmp.jdkport.FloatExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.search.HitQueue;
import org.gnit.lucenekmp.search.ScoreDoc;
import org.gnit.lucenekmp.util.IntroSelector;
import org.gnit.lucenekmp.util.Selector;
import org.gnit.lucenekmp.util.VectorUtil;
import org.gnit.lucenekmp.util.quantization.ScalarQuantizedVectorSimilarity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\r\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 *2\u00020\u0001:\u0005&'()*B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001e\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001e\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010 \u001a\u00020!2\u0006\u0010\u0013\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014J\b\u0010$\u001a\u00020%H\u0016R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\"\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000f\u00a8\u0006+"}, d2={"Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizer;", "", "minQuantile", "", "maxQuantile", "bits", "", "<init>", "(FFB)V", "alpha", "scale", "getBits", "()B", "lowerQuantile", "getLowerQuantile", "()F", "upperQuantile", "getUpperQuantile", "quantize", "src", "", "dest", "", "similarityFunction", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "quantizeFloat", "v", "destIndex", "", "recalculateCorrectiveOffset", "quantizedVector", "oldQuantizer", "deQuantize", "", "constantMultiplier", "getConstantMultiplier", "toString", "", "FloatSelector", "ScoreDocsAndScoreVariance", "OnlineMeanAndVar", "ScoreErrorCorrelator", "Companion", "core"})
public final class ScalarQuantizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float alpha;
    private final float scale;
    private final byte bits;
    private final float lowerQuantile;
    private final float upperQuantile;
    public static final int SCALAR_QUANTIZATION_SAMPLE_SIZE = 25000;
    public static final int SCRATCH_SIZE = 20;
    @NotNull
    private static final Random random = RandomKt.Random((int)42);

    public ScalarQuantizer(float minQuantile, float maxQuantile, byte bits) {
        if (!(!FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, minQuantile) && !FloatExtKt.isInfinite(FloatCompanionObject.INSTANCE, minQuantile) && !FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, maxQuantile) && !FloatExtKt.isInfinite(FloatCompanionObject.INSTANCE, maxQuantile))) {
            boolean bl = false;
            String string = "Scalar quantizer does not support infinite or NaN values";
            throw new IllegalStateException(string.toString());
        }
        if (!(maxQuantile >= minQuantile)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(bits > 0 && bits <= 8)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.bits = bits;
        float divisor = (1 << bits) - 1;
        if (minQuantile == maxQuantile) {
            this.lowerQuantile = minQuantile - divisor;
            this.upperQuantile = maxQuantile + divisor;
        } else {
            this.lowerQuantile = minQuantile;
            this.upperQuantile = maxQuantile;
        }
        this.scale = divisor / (this.upperQuantile - this.lowerQuantile);
        this.alpha = (this.upperQuantile - this.lowerQuantile) / divisor;
    }

    public final byte getBits() {
        return this.bits;
    }

    public final float getLowerQuantile() {
        return this.lowerQuantile;
    }

    public final float getUpperQuantile() {
        return this.upperQuantile;
    }

    public final float quantize(@NotNull float[] src, @NotNull byte[] dest, @NotNull VectorSimilarityFunction similarityFunction) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)((Object)similarityFunction), (String)"similarityFunction");
        if (!(src.length == dest.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(similarityFunction != VectorSimilarityFunction.COSINE || VectorUtil.INSTANCE.isUnitVector(src))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        float correction = 0.0f;
        int n = src.length;
        for (int i = 0; i < n; ++i) {
            correction += this.quantizeFloat(src[i], dest, i);
        }
        if (similarityFunction == VectorSimilarityFunction.EUCLIDEAN) {
            return 0.0f;
        }
        return correction;
    }

    private final float quantizeFloat(float v, byte[] dest, int destIndex) {
        if (!(dest == null || destIndex < dest.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        float dx = v - this.lowerQuantile;
        float dxc = java.lang.Math.max(this.lowerQuantile, java.lang.Math.min(this.upperQuantile, v)) - this.lowerQuantile;
        float dxs = this.scale * dxc;
        float dxq = (float)Math.INSTANCE.round(dxs) * this.alpha;
        if (dest != null) {
            dest[destIndex] = (byte)Math.INSTANCE.round(dxs);
        }
        return this.lowerQuantile * (v - this.lowerQuantile / 2.0f) + (dx - dxq) * dxq;
    }

    public final float recalculateCorrectiveOffset(@NotNull byte[] quantizedVector, @NotNull ScalarQuantizer oldQuantizer, @NotNull VectorSimilarityFunction similarityFunction) {
        Intrinsics.checkNotNullParameter((Object)quantizedVector, (String)"quantizedVector");
        Intrinsics.checkNotNullParameter((Object)oldQuantizer, (String)"oldQuantizer");
        Intrinsics.checkNotNullParameter((Object)((Object)similarityFunction), (String)"similarityFunction");
        if (similarityFunction == VectorSimilarityFunction.EUCLIDEAN) {
            return 0.0f;
        }
        float correctiveOffset = 0.0f;
        int n = quantizedVector.length;
        for (int i = 0; i < n; ++i) {
            float v = oldQuantizer.alpha * (float)quantizedVector[i] + oldQuantizer.lowerQuantile;
            correctiveOffset += this.quantizeFloat(v, null, 0);
        }
        return correctiveOffset;
    }

    public final void deQuantize(@NotNull byte[] src, @NotNull float[] dest) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (!(src.length == dest.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int n = src.length;
        for (int i = 0; i < n; ++i) {
            dest[i] = this.alpha * (float)src[i] + this.lowerQuantile;
        }
    }

    public final float getConstantMultiplier() {
        return this.alpha * this.alpha;
    }

    @NotNull
    public String toString() {
        return "ScalarQuantizer{minQuantile=" + this.lowerQuantile + ", maxQuantile=" + this.upperQuantile + ", bits=" + this.bits + "}";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J&\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J.\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005J&\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J(\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 H\u0002J0\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u000e\u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0%2\u0006\u0010&\u001a\u00020\u0005H\u0002JF\u0010'\u001a\u00020\u001d2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0%2\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0%2\u0006\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J&\u0010-\u001a\b\u0012\u0004\u0012\u00020)0%2\u000e\u0010*\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001d0%2\u0006\u0010.\u001a\u00020\u0019H\u0002J\u0016\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u001d2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizer$Companion;", "", "<init>", "()V", "SCALAR_QUANTIZATION_SAMPLE_SIZE", "", "SCRATCH_SIZE", "random", "Lkotlin/random/Random;", "reservoirSampleIndices", "", "numFloatVecs", "sampleSize", "fromVectors", "Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizer;", "floatVectorValues", "Lorg/gnit/lucenekmp/index/FloatVectorValues;", "confidenceInterval", "", "totalVectorCount", "bits", "", "quantizationSampleSize", "fromVectorsAutoInterval", "function", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "extractQuantiles", "", "confidenceIntervals", "", "quantileGatheringScratch", "upperSum", "", "lowerSum", "gatherSample", "vectorValue", "sampledDocs", "", "i", "candidateGridSearch", "nearestNeighbors", "Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizer$ScoreDocsAndScoreVariance;", "vectors", "lowerCandidates", "upperCandidates", "findNearestNeighbors", "similarityFunction", "getUpperAndLowerQuantile", "arr", "core"})
    @SourceDebugExtension(value={"SMAP\nScalarQuantizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScalarQuantizer.kt\norg/gnit/lucenekmp/util/quantization/ScalarQuantizer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,696:1\n1#2:697\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final int[] reservoirSampleIndices(int numFloatVecs, int sampleSize) {
            int n = 0;
            int[] nArray = new int[sampleSize];
            while (n < sampleSize) {
                int n2;
                nArray[n2] = n2 = n++;
            }
            int[] vectorsToTake = nArray;
            for (int i = sampleSize; i < numFloatVecs; ++i) {
                int j = random.nextInt(i + 1);
                if (j >= sampleSize) continue;
                vectorsToTake[j] = i;
            }
            Arrays.INSTANCE.sort(vectorsToTake);
            return vectorsToTake;
        }

        @NotNull
        public final ScalarQuantizer fromVectors(@NotNull FloatVectorValues floatVectorValues, float confidenceInterval, int totalVectorCount, byte bits) throws IOException {
            Intrinsics.checkNotNullParameter((Object)floatVectorValues, (String)"floatVectorValues");
            return this.fromVectors(floatVectorValues, confidenceInterval, totalVectorCount, bits, 25000);
        }

        @NotNull
        public final ScalarQuantizer fromVectors(@NotNull FloatVectorValues floatVectorValues, float confidenceInterval, int totalVectorCount, byte bits, int quantizationSampleSize) throws IOException {
            Intrinsics.checkNotNullParameter((Object)floatVectorValues, (String)"floatVectorValues");
            if (!(0.9f <= confidenceInterval && confidenceInterval <= 1.0f)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(quantizationSampleSize > 20)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (totalVectorCount == 0) {
                return new ScalarQuantizer(0.0f, 0.0f, bits);
            }
            KnnVectorValues.DocIndexIterator iterator2 = floatVectorValues.iterator();
            if (confidenceInterval == 1.0f) {
                float min = Float.POSITIVE_INFINITY;
                float max = Float.NEGATIVE_INFINITY;
                while (iterator2.nextDoc() != Integer.MAX_VALUE) {
                    for (float v : floatVectorValues.vectorValue(iterator2.index())) {
                        min = java.lang.Math.min(min, v);
                        max = java.lang.Math.max(max, v);
                    }
                }
                return new ScalarQuantizer(min, max, bits);
            }
            float[] quantileGatheringScratch = new float[floatVectorValues.dimension() * java.lang.Math.min(20, totalVectorCount)];
            int count = 0;
            double[] upperSum = new double[1];
            double[] lowerSum = new double[1];
            float[] v = new float[]{confidenceInterval};
            float[] confidenceIntervals = v;
            if (totalVectorCount <= quantizationSampleSize) {
                int scratchSize = java.lang.Math.min(20, totalVectorCount);
                int i = 0;
                while (iterator2.nextDoc() != Integer.MAX_VALUE) {
                    float[] vectorValue = floatVectorValues.vectorValue(iterator2.index());
                    System.INSTANCE.arraycopy(vectorValue, 0, quantileGatheringScratch, i * vectorValue.length, vectorValue.length);
                    if (++i != scratchSize) continue;
                    this.extractQuantiles(confidenceIntervals, quantileGatheringScratch, upperSum, lowerSum);
                    i = 0;
                    ++count;
                }
                return new ScalarQuantizer((float)lowerSum[0] / (float)count, (float)upperSum[0] / (float)count, bits);
            }
            int[] vectorsToTake = this.reservoirSampleIndices(totalVectorCount, quantizationSampleSize);
            int index = 0;
            int idx = 0;
            for (int i : vectorsToTake) {
                while (index <= i) {
                    iterator2.nextDoc();
                    ++index;
                }
                if (!(iterator2.docID() != Integer.MAX_VALUE)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                float[] vectorValue = floatVectorValues.vectorValue(iterator2.index());
                System.INSTANCE.arraycopy(vectorValue, 0, quantileGatheringScratch, idx * vectorValue.length, vectorValue.length);
                if (++idx != 20) continue;
                this.extractQuantiles(confidenceIntervals, quantileGatheringScratch, upperSum, lowerSum);
                ++count;
                idx = 0;
            }
            return new ScalarQuantizer((float)lowerSum[0] / (float)count, (float)upperSum[0] / (float)count, bits);
        }

        @NotNull
        public final ScalarQuantizer fromVectorsAutoInterval(@NotNull FloatVectorValues floatVectorValues, @NotNull VectorSimilarityFunction function, int totalVectorCount, byte bits) throws IOException {
            Intrinsics.checkNotNullParameter((Object)floatVectorValues, (String)"floatVectorValues");
            Intrinsics.checkNotNullParameter((Object)((Object)function), (String)"function");
            if (!(function != VectorSimilarityFunction.COSINE)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (totalVectorCount == 0) {
                return new ScalarQuantizer(0.0f, 0.0f, bits);
            }
            int sampleSize = java.lang.Math.min(totalVectorCount, 1000);
            float[] quantileGatheringScratch = new float[floatVectorValues.dimension() * java.lang.Math.min(20, totalVectorCount)];
            int count = 0;
            double[] upperSum = new double[2];
            double[] lowerSum = new double[2];
            List sampledDocs = new ArrayList(sampleSize);
            float[] fArray = new float[]{1.0f - java.lang.Math.min(32.0f, (float)floatVectorValues.dimension() / 10.0f) / (float)(floatVectorValues.dimension() + 1), 1.0f - 1.0f / (float)(floatVectorValues.dimension() + 1)};
            float[] confidenceIntervals = fArray;
            KnnVectorValues.DocIndexIterator iterator2 = floatVectorValues.iterator();
            if (totalVectorCount <= sampleSize) {
                int scratchSize = java.lang.Math.min(20, totalVectorCount);
                int i = 0;
                while (iterator2.nextDoc() != Integer.MAX_VALUE) {
                    this.gatherSample(floatVectorValues.vectorValue(iterator2.index()), quantileGatheringScratch, sampledDocs, i);
                    if (++i != scratchSize) continue;
                    this.extractQuantiles(confidenceIntervals, quantileGatheringScratch, upperSum, lowerSum);
                    i = 0;
                    ++count;
                }
            } else {
                int[] vectorsToTake = this.reservoirSampleIndices(totalVectorCount, 1000);
                int index = 0;
                int idx = 0;
                for (int i : vectorsToTake) {
                    while (index <= i) {
                        iterator2.nextDoc();
                        ++index;
                    }
                    if (!(iterator2.docID() != Integer.MAX_VALUE)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.gatherSample(floatVectorValues.vectorValue(iterator2.index()), quantileGatheringScratch, sampledDocs, idx);
                    if (++idx != 20) continue;
                    this.extractQuantiles(confidenceIntervals, quantileGatheringScratch, upperSum, lowerSum);
                    ++count;
                    idx = 0;
                }
            }
            float al = (float)lowerSum[1] / (float)count;
            float bu = (float)upperSum[1] / (float)count;
            float au = (float)lowerSum[0] / (float)count;
            float bl = (float)upperSum[0] / (float)count;
            if (!(!FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, al) && !FloatExtKt.isInfinite(FloatCompanionObject.INSTANCE, al) && !FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, au) && !FloatExtKt.isInfinite(FloatCompanionObject.INSTANCE, au) && !FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, bl) && !FloatExtKt.isInfinite(FloatCompanionObject.INSTANCE, bl) && !FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, bu) && !FloatExtKt.isInfinite(FloatCompanionObject.INSTANCE, bu))) {
                boolean $i$a$-check-ScalarQuantizer$Companion$fromVectorsAutoInterval$22 = false;
                String $i$a$-check-ScalarQuantizer$Companion$fromVectorsAutoInterval$22 = "Quantile calculation resulted in NaN or infinite values";
                throw new IllegalStateException($i$a$-check-ScalarQuantizer$Companion$fromVectorsAutoInterval$22.toString());
            }
            float[] lowerCandidates = new float[16];
            float[] upperCandidates = new float[16];
            int idx = 0;
            for (float i = 0.0f; i < 32.0f; i += 2.0f) {
                lowerCandidates[idx] = al + i * (au - al) / 32.0f;
                upperCandidates[idx] = bl + i * (bu - bl) / 32.0f;
                ++idx;
            }
            List<ScoreDocsAndScoreVariance> nearestNeighbors = this.findNearestNeighbors(sampledDocs, function);
            float[] bestPair = this.candidateGridSearch(nearestNeighbors, sampledDocs, lowerCandidates, upperCandidates, function, bits);
            return new ScalarQuantizer(bestPair[0], bestPair[1], bits);
        }

        private final void extractQuantiles(float[] confidenceIntervals, float[] quantileGatheringScratch, double[] upperSum, double[] lowerSum) {
            if (!(confidenceIntervals.length == upperSum.length && confidenceIntervals.length == lowerSum.length)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int i = 0;
            int n = confidenceIntervals.length;
            while (i < n) {
                float[] upperAndLower = this.getUpperAndLowerQuantile(quantileGatheringScratch, confidenceIntervals[i]);
                int n2 = i;
                upperSum[n2] = upperSum[n2] + (double)upperAndLower[1];
                n2 = i++;
                lowerSum[n2] = lowerSum[n2] + (double)upperAndLower[0];
            }
        }

        private final void gatherSample(float[] vectorValue, float[] quantileGatheringScratch, List<float[]> sampledDocs, int i) {
            float[] copy = new float[vectorValue.length];
            System.INSTANCE.arraycopy(vectorValue, 0, copy, 0, vectorValue.length);
            sampledDocs.add(copy);
            System.INSTANCE.arraycopy(vectorValue, 0, quantileGatheringScratch, i * vectorValue.length, vectorValue.length);
        }

        private final float[] candidateGridSearch(List<ScoreDocsAndScoreVariance> nearestNeighbors, List<float[]> vectors, float[] lowerCandidates, float[] upperCandidates, VectorSimilarityFunction function, byte bits) {
            float upper;
            float lower;
            double maxCorr = 0.0;
            maxCorr = Double.NEGATIVE_INFINITY;
            float bestLower = 0.0f;
            float bestUpper = 0.0f;
            ScoreErrorCorrelator scoreErrorCorrelator = new ScoreErrorCorrelator(function, nearestNeighbors, vectors, bits);
            int bestQuandrantLower = 0;
            int bestQuandrantUpper = 0;
            Companion $this$candidateGridSearch_u24lambda_u243 = this;
            boolean bl = false;
            for (int i = 0; i < lowerCandidates.length; i += 4) {
                block16: {
                    block15: {
                        lower = lowerCandidates[i];
                        if (FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, lower)) break block15;
                        if (!FloatExtKt.isInfinite(FloatCompanionObject.INSTANCE, lower)) break block16;
                    }
                    boolean $i$a$-require-ScalarQuantizer$Companion$candidateGridSearch$1$32 = false;
                    String $i$a$-require-ScalarQuantizer$Companion$candidateGridSearch$1$32 = "Lower candidate is NaN or infinite";
                    throw new IllegalArgumentException($i$a$-require-ScalarQuantizer$Companion$candidateGridSearch$1$32.toString());
                }
                int j = 0;
                while (j < upperCandidates.length) {
                    block18: {
                        block17: {
                            upper = upperCandidates[j];
                            if (FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, upper)) break block17;
                            if (!FloatExtKt.isInfinite(FloatCompanionObject.INSTANCE, upper)) break block18;
                        }
                        boolean $i$a$-require-ScalarQuantizer$Companion$candidateGridSearch$1$42 = false;
                        String $i$a$-require-ScalarQuantizer$Companion$candidateGridSearch$1$42 = "Upper candidate is NaN or infinite";
                        throw new IllegalArgumentException($i$a$-require-ScalarQuantizer$Companion$candidateGridSearch$1$42.toString());
                    }
                    if (upper <= lower) {
                        j += 4;
                        continue;
                    }
                    double mean = scoreErrorCorrelator.scoreErrorCorrelation(lower, upper);
                    if (mean > maxCorr) {
                        maxCorr = mean;
                        bestLower = lower;
                        bestUpper = upper;
                        bestQuandrantLower = i;
                        bestQuandrantUpper = j;
                    }
                    j += 4;
                }
            }
            int n = bestQuandrantLower + 4;
            for (int i = bestQuandrantLower + 1; i < n; ++i) {
                int n2 = bestQuandrantUpper + 4;
                for (int j = bestQuandrantUpper + 1; j < n2; ++j) {
                    double mean;
                    block20: {
                        block19: {
                            lower = lowerCandidates[i];
                            upper = upperCandidates[j];
                            if (FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, lower) || FloatExtKt.isInfinite(FloatCompanionObject.INSTANCE, lower) || FloatExtKt.isNaN(FloatCompanionObject.INSTANCE, upper)) break block19;
                            if (!FloatExtKt.isInfinite(FloatCompanionObject.INSTANCE, upper)) break block20;
                        }
                        boolean bl2 = false;
                        String string = "Lower or upper candidate is NaN or infinite";
                        throw new IllegalArgumentException(string.toString());
                    }
                    if (upper <= lower || !((mean = scoreErrorCorrelator.scoreErrorCorrelation(lower, upper)) > maxCorr)) continue;
                    maxCorr = mean;
                    bestLower = lower;
                    bestUpper = upper;
                }
            }
            float[] fArray = new float[]{bestLower, bestUpper};
            return fArray;
        }

        private final List<ScoreDocsAndScoreVariance> findNearestNeighbors(List<float[]> vectors, VectorSimilarityFunction similarityFunction) {
            List queues = new ArrayList(vectors.size());
            queues.add(new HitQueue(10, false));
            int n = ((Collection)vectors).size();
            for (int i = 0; i < n; ++i) {
                float[] vector = vectors.get(i);
                int n2 = vectors.size();
                for (int j = i + 1; j < n2; ++j) {
                    float[] otherVector = vectors.get(j);
                    Intrinsics.checkNotNull((Object)vector);
                    Intrinsics.checkNotNull((Object)otherVector);
                    float score2 = similarityFunction.compare(vector, otherVector);
                    if (queues.size() <= j) {
                        queues.add(new HitQueue(10, false));
                    }
                    ((HitQueue)queues.get(i)).insertWithOverflow(new ScoreDoc(j, score2, 0, 4, null));
                    ((HitQueue)queues.get(j)).insertWithOverflow(new ScoreDoc(i, score2, 0, 4, null));
                }
            }
            List result = new ArrayList(vectors.size());
            OnlineMeanAndVar meanAndVar = new OnlineMeanAndVar();
            int n3 = ((Collection)vectors).size();
            for (int i = 0; i < n3; ++i) {
                HitQueue queue2 = (HitQueue)queues.get(i);
                ScoreDoc[] scoreDocs = new ScoreDoc[queue2.size()];
                for (int j = queue2.size() - 1; -1 < j; --j) {
                    scoreDocs[j] = queue2.pop();
                    if (scoreDocs[j] == null) {
                        String string = "Required value was null.";
                        throw new IllegalStateException(string.toString());
                    }
                    ScoreDoc scoreDoc = scoreDocs[j];
                    Intrinsics.checkNotNull((Object)scoreDoc);
                    meanAndVar.add(scoreDoc.getScore());
                }
                result.add(new ScoreDocsAndScoreVariance(scoreDocs, meanAndVar.var()));
                meanAndVar.reset();
            }
            return result;
        }

        @NotNull
        public final float[] getUpperAndLowerQuantile(@NotNull float[] arr, float confidenceInterval) {
            Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
            if (!(!(arr.length == 0))) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (arr.length <= 2) {
                Arrays.INSTANCE.sort(arr);
                float[] fArray = new float[]{arr[0], arr[arr.length - 1]};
                return fArray;
            }
            int selectorIndex = (int)((float)arr.length * (1.0f - confidenceInterval) / 2.0f + 0.5f);
            if (selectorIndex > 0) {
                Selector selector = new FloatSelector(arr);
                selector.select(0, arr.length, arr.length - selectorIndex);
                selector.select(0, arr.length - selectorIndex, selectorIndex);
            }
            float min = Float.POSITIVE_INFINITY;
            float max = Float.NEGATIVE_INFINITY;
            int n = arr.length - selectorIndex;
            for (int i = selectorIndex; i < n; ++i) {
                min = java.lang.Math.min(arr[i], min);
                max = java.lang.Math.max(arr[i], max);
            }
            float[] fArray = new float[]{min, max};
            return fArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0014J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizer$FloatSelector;", "Lorg/gnit/lucenekmp/util/IntroSelector;", "arr", "", "<init>", "([F)V", "pivot", "", "getPivot", "()F", "setPivot", "(F)V", "", "i", "", "comparePivot", "j", "swap", "core"})
    private static final class FloatSelector
    extends IntroSelector {
        @NotNull
        private final float[] arr;
        private float pivot;

        public FloatSelector(@NotNull float[] arr) {
            Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
            this.arr = arr;
            this.pivot = Float.NaN;
        }

        public final float getPivot() {
            return this.pivot;
        }

        public final void setPivot(float f) {
            this.pivot = f;
        }

        @Override
        protected void setPivot(int i) {
            this.pivot = this.arr[i];
        }

        @Override
        protected int comparePivot(int j) {
            return FloatExtKt.compare(FloatCompanionObject.INSTANCE, this.pivot, this.arr[j]);
        }

        @Override
        protected void swap(int i, int j) {
            float tmp = this.arr[i];
            this.arr[i] = this.arr[j];
            this.arr[j] = tmp;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\n\u001a\u00020\u0011R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizer$OnlineMeanAndVar;", "", "<init>", "()V", "mean", "", "getMean", "()D", "setMean", "(D)V", "var", "n", "", "reset", "", "add", "x", "", "core"})
    private static final class OnlineMeanAndVar {
        private double mean;
        private double var;
        private int n;

        public final double getMean() {
            return this.mean;
        }

        public final void setMean(double d) {
            this.mean = d;
        }

        public final void reset() {
            this.mean = 0.0;
            this.var = 0.0;
            this.n = 0;
        }

        public final void add(double x) {
            int n = this.n;
            this.n = n + 1;
            double delta = x - this.mean;
            this.mean += delta / (double)this.n;
            this.var += delta * (x - this.mean);
        }

        public final float var() {
            return (float)(this.var / (double)(this.n - 1));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0019\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizer$ScoreDocsAndScoreVariance;", "", "scoreDocs", "", "Lorg/gnit/lucenekmp/search/ScoreDoc;", "scoreVariance", "", "<init>", "([Lorg/gnit/lucenekmp/search/ScoreDoc;F)V", "getScoreDocs", "()[Lorg/gnit/lucenekmp/search/ScoreDoc;", "[Lorg/gnit/lucenekmp/search/ScoreDoc;", "getScoreVariance", "()F", "core"})
    private static final class ScoreDocsAndScoreVariance {
        @NotNull
        private final ScoreDoc[] scoreDocs;
        private final float scoreVariance;

        public ScoreDocsAndScoreVariance(@NotNull ScoreDoc[] scoreDocs, float scoreVariance) {
            Intrinsics.checkNotNullParameter((Object)scoreDocs, (String)"scoreDocs");
            this.scoreDocs = scoreDocs;
            this.scoreVariance = scoreVariance;
        }

        @NotNull
        public final ScoreDoc[] getScoreDocs() {
            return this.scoreDocs;
        }

        public final float getScoreVariance() {
            return this.scoreVariance;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizer$ScoreErrorCorrelator;", "", "function", "Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;", "nearestNeighbors", "", "Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizer$ScoreDocsAndScoreVariance;", "vectors", "", "bits", "", "<init>", "(Lorg/gnit/lucenekmp/index/VectorSimilarityFunction;Ljava/util/List;Ljava/util/List;B)V", "corr", "Lorg/gnit/lucenekmp/util/quantization/ScalarQuantizer$OnlineMeanAndVar;", "errors", "query", "", "vector", "scoreErrorCorrelation", "", "lowerQuantile", "", "upperQuantile", "core"})
    private static final class ScoreErrorCorrelator {
        @NotNull
        private final VectorSimilarityFunction function;
        @NotNull
        private final List<ScoreDocsAndScoreVariance> nearestNeighbors;
        @NotNull
        private final List<float[]> vectors;
        private final byte bits;
        @NotNull
        private final OnlineMeanAndVar corr;
        @NotNull
        private final OnlineMeanAndVar errors;
        @NotNull
        private final byte[] query;
        @NotNull
        private final byte[] vector;

        public ScoreErrorCorrelator(@NotNull VectorSimilarityFunction function, @NotNull List<ScoreDocsAndScoreVariance> nearestNeighbors, @NotNull List<float[]> vectors, byte bits) {
            Intrinsics.checkNotNullParameter((Object)((Object)function), (String)"function");
            Intrinsics.checkNotNullParameter(nearestNeighbors, (String)"nearestNeighbors");
            Intrinsics.checkNotNullParameter(vectors, (String)"vectors");
            this.function = function;
            this.nearestNeighbors = nearestNeighbors;
            this.vectors = vectors;
            this.bits = bits;
            this.corr = new OnlineMeanAndVar();
            this.errors = new OnlineMeanAndVar();
            float[] fArray = this.vectors.get(0);
            Intrinsics.checkNotNull((Object)fArray);
            this.query = new byte[fArray.length];
            float[] fArray2 = this.vectors.get(0);
            Intrinsics.checkNotNull((Object)fArray2);
            this.vector = new byte[fArray2.length];
        }

        public final double scoreErrorCorrelation(float lowerQuantile, float upperQuantile) {
            this.corr.reset();
            ScalarQuantizer quantizer = new ScalarQuantizer(lowerQuantile, upperQuantile, this.bits);
            ScalarQuantizedVectorSimilarity scalarQuantizedVectorSimilarity = ScalarQuantizedVectorSimilarity.Companion.fromVectorSimilarity(this.function, quantizer.getConstantMultiplier(), quantizer.getBits());
            int n = ((Collection)this.nearestNeighbors).size();
            for (int i = 0; i < n; ++i) {
                float[] fArray = this.vectors.get(i);
                Intrinsics.checkNotNull((Object)fArray);
                float queryCorrection = quantizer.quantize(fArray, this.query, this.function);
                ScoreDocsAndScoreVariance scoreDocsAndScoreVariance = this.nearestNeighbors.get(i);
                ScoreDoc[] scoreDocs = scoreDocsAndScoreVariance.getScoreDocs();
                float scoreVariance = scoreDocsAndScoreVariance.getScoreVariance();
                this.errors.reset();
                for (ScoreDoc scoreDoc : scoreDocs) {
                    float[] fArray2 = this.vectors.get(scoreDoc.getDoc());
                    Intrinsics.checkNotNull((Object)fArray2);
                    float vectorCorrection = quantizer.quantize(fArray2, this.vector, this.function);
                    float qScore = scalarQuantizedVectorSimilarity.score(this.query, queryCorrection, this.vector, vectorCorrection);
                    this.errors.add(qScore - scoreDoc.getScore());
                }
                this.corr.add(1.0f - this.errors.var() / scoreVariance);
            }
            return DoubleExtKt.isNaN(DoubleCompanionObject.INSTANCE, this.corr.getMean()) ? 0.0 : this.corr.getMean();
        }
    }
}

