/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.analysis;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.TypeIntrinsics;
import org.gnit.lucenekmp.analysis.ReusableStringReader;
import org.gnit.lucenekmp.analysis.TokenStream;
import org.gnit.lucenekmp.analysis.Tokenizer;
import org.gnit.lucenekmp.analysis.tokenattributes.CharTermAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.OffsetAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.TermToBytesRefAttribute;
import org.gnit.lucenekmp.jdkport.Consumer;
import org.gnit.lucenekmp.jdkport.Reader;
import org.gnit.lucenekmp.jdkport.StringReader;
import org.gnit.lucenekmp.store.AlreadyClosedException;
import org.gnit.lucenekmp.util.AttributeFactory;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.CloseableThreadLocal;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u0000 (2\u00060\u0001j\u0002`\u0002:\u0004%&'(B\u0013\b\u0004\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H$J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0014J\u0016\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u001b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0013J\u0018\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J\u001a\u0010\u001d\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0004J\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0004J\u0012\u0010 \u001a\u00020!2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\"\u001a\u00020!2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\b\u0010#\u001a\u00020$H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006)"}, d2={"Lorg/gnit/lucenekmp/analysis/Analyzer;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "reuseStrategy", "Lorg/gnit/lucenekmp/analysis/Analyzer$ReuseStrategy;", "<init>", "(Lorg/gnit/lucenekmp/analysis/Analyzer$ReuseStrategy;)V", "getReuseStrategy", "()Lorg/gnit/lucenekmp/analysis/Analyzer$ReuseStrategy;", "storedValue", "Lorg/gnit/lucenekmp/util/CloseableThreadLocal;", "", "getStoredValue", "()Lorg/gnit/lucenekmp/util/CloseableThreadLocal;", "setStoredValue", "(Lorg/gnit/lucenekmp/util/CloseableThreadLocal;)V", "createComponents", "Lorg/gnit/lucenekmp/analysis/Analyzer$TokenStreamComponents;", "fieldName", "", "normalize", "Lorg/gnit/lucenekmp/analysis/TokenStream;", "in", "tokenStream", "reader", "Lorg/gnit/lucenekmp/jdkport/Reader;", "text", "Lorg/gnit/lucenekmp/util/BytesRef;", "initReader", "initReaderForNormalization", "attributeFactory", "Lorg/gnit/lucenekmp/util/AttributeFactory;", "getPositionIncrementGap", "", "getOffsetGap", "close", "", "TokenStreamComponents", "ReuseStrategy", "StringTokenStream", "Companion", "core"})
public abstract class Analyzer
implements AutoCloseable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReuseStrategy reuseStrategy;
    @Nullable
    private CloseableThreadLocal<Object> storedValue;
    @NotNull
    private static final ReuseStrategy GLOBAL_REUSE_STRATEGY = new ReuseStrategy(){

        public TokenStreamComponents getReusableComponents(Analyzer analyzer, String fieldName) {
            Intrinsics.checkNotNullParameter((Object)analyzer, (String)"analyzer");
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Object object = this.getStoredValue(analyzer);
            return object instanceof TokenStreamComponents ? (TokenStreamComponents)object : null;
        }

        public void setReusableComponents(Analyzer analyzer, String fieldName, TokenStreamComponents components) {
            Intrinsics.checkNotNullParameter((Object)analyzer, (String)"analyzer");
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Intrinsics.checkNotNullParameter((Object)components, (String)"components");
            this.setStoredValue(analyzer, components);
        }
    };
    @NotNull
    private static final ReuseStrategy PER_FIELD_REUSE_STRATEGY = new ReuseStrategy(){

        public TokenStreamComponents getReusableComponents(Analyzer analyzer, String fieldName) {
            Map componentsPerField;
            Intrinsics.checkNotNullParameter((Object)analyzer, (String)"analyzer");
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Object object = this.getStoredValue(analyzer);
            Map map2 = componentsPerField = TypeIntrinsics.isMutableMap((Object)object) ? (Map)object : null;
            return map2 != null ? (TokenStreamComponents)map2.get(fieldName) : null;
        }

        public void setReusableComponents(Analyzer analyzer, String fieldName, TokenStreamComponents components) {
            Map componentsPerField;
            Intrinsics.checkNotNullParameter((Object)analyzer, (String)"analyzer");
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Intrinsics.checkNotNullParameter((Object)components, (String)"components");
            Object object = this.getStoredValue(analyzer);
            Map map2 = componentsPerField = TypeIntrinsics.isMutableMap((Object)object) ? (Map)object : null;
            if (componentsPerField == null) {
                componentsPerField = new LinkedHashMap<K, V>();
                this.setStoredValue(analyzer, componentsPerField);
            }
            componentsPerField.put(fieldName, components);
        }
    };

    protected Analyzer(@NotNull ReuseStrategy reuseStrategy) {
        Intrinsics.checkNotNullParameter((Object)reuseStrategy, (String)"reuseStrategy");
        this.reuseStrategy = reuseStrategy;
        this.storedValue = new CloseableThreadLocal();
    }

    public /* synthetic */ Analyzer(ReuseStrategy reuseStrategy, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            reuseStrategy = GLOBAL_REUSE_STRATEGY;
        }
        this(reuseStrategy);
    }

    @NotNull
    public final ReuseStrategy getReuseStrategy() {
        return this.reuseStrategy;
    }

    @Nullable
    public final CloseableThreadLocal<Object> getStoredValue() {
        return this.storedValue;
    }

    public final void setStoredValue(@Nullable CloseableThreadLocal<Object> closeableThreadLocal) {
        this.storedValue = closeableThreadLocal;
    }

    @NotNull
    protected abstract TokenStreamComponents createComponents(@NotNull String var1);

    @NotNull
    protected TokenStream normalize(@NotNull String fieldName, @NotNull TokenStream in) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        return in;
    }

    @NotNull
    public final TokenStream tokenStream(@NotNull String fieldName, @NotNull Reader reader2) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        TokenStreamComponents components = this.reuseStrategy.getReusableComponents(this, fieldName);
        Reader r = this.initReader(fieldName, reader2);
        if (components == null) {
            components = this.createComponents(fieldName);
            this.reuseStrategy.setReusableComponents(this, fieldName, components);
        }
        components.setReader(r);
        return components.getTokenStream();
    }

    @NotNull
    public final TokenStream tokenStream(@NotNull String fieldName, @NotNull String text) {
        ReusableStringReader reusableStringReader;
        TokenStreamComponents components;
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TokenStreamComponents tokenStreamComponents = components = this.reuseStrategy.getReusableComponents(this, fieldName);
        if ((tokenStreamComponents != null ? tokenStreamComponents.getReusableStringReader() : null) == null) {
            reusableStringReader = new ReusableStringReader();
        } else {
            ReusableStringReader reusableStringReader2 = components.getReusableStringReader();
            reusableStringReader = reusableStringReader2;
            Intrinsics.checkNotNull((Object)reusableStringReader2);
        }
        ReusableStringReader strReader = reusableStringReader;
        strReader.setValue(text);
        Reader r = this.initReader(fieldName, strReader);
        if (components == null) {
            components = this.createComponents(fieldName);
            this.reuseStrategy.setReusableComponents(this, fieldName, components);
        }
        components.setReader(r);
        components.setReusableStringReader(strReader);
        return components.getTokenStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final BytesRef normalize(@NotNull String fieldName, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            Object object;
            Object object2;
            String filteredText = null;
            try {
                AutoCloseable autoCloseable = new StringReader(text);
                object2 = null;
                try {
                    int read;
                    StringReader reader2 = (StringReader)autoCloseable;
                    boolean bl = false;
                    Reader filterReader = this.initReaderForNormalization(fieldName, reader2);
                    char[] buffer = new char[64];
                    StringBuilder builder = new StringBuilder();
                    while ((read = filterReader.read(buffer, 0, buffer.length)) != -1) {
                        StringBuilder stringBuilder = builder;
                        int n = 0;
                        int n2 = 0 + read;
                        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append(buffer, n, n2 - n), (String)"append(...)");
                    }
                    String string = builder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                    filteredText = string;
                    object = Unit.INSTANCE;
                }
                catch (Throwable bl) {
                    object2 = bl;
                    throw bl;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)object2);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Normalization threw an unexpected exception", e);
            }
            AttributeFactory attributeFactory = this.attributeFactory(fieldName);
            object2 = this.normalize(fieldName, new StringTokenStream(attributeFactory, filteredText, text.length()));
            object = null;
            try {
                TokenStream ts = (TokenStream)object2;
                boolean bl = false;
                TermToBytesRefAttribute termAtt = (TermToBytesRefAttribute)ts.addAttribute(Reflection.getOrCreateKotlinClass(TermToBytesRefAttribute.class));
                ts.reset();
                if (!ts.incrementToken()) {
                    boolean bl2 = false;
                    String string = "The normalization token stream is expected to produce exactly 1 token, but got 0 for analyzer " + this + " and input \"" + text + "\"";
                    throw new IllegalStateException(string.toString());
                }
                BytesRef term = BytesRef.Companion.deepCopyOf(termAtt.getBytesRef());
                if (!(!ts.incrementToken())) {
                    boolean bl3 = false;
                    String string = "The normalization token stream is expected to produce exactly 1 token, but got 2+ for analyzer " + this + " and input \"" + text + "\"";
                    throw new IllegalStateException(string.toString());
                }
                ts.end();
                BytesRef bytesRef = term;
                return bytesRef;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)object2, (Throwable)object);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Normalization threw an unexpected exception", e);
        }
    }

    @NotNull
    protected final Reader initReader(@NotNull String fieldName, @NotNull Reader reader2) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        return reader2;
    }

    @NotNull
    protected final Reader initReaderForNormalization(@Nullable String fieldName, @NotNull Reader reader2) {
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        return reader2;
    }

    @NotNull
    protected final AttributeFactory attributeFactory(@Nullable String fieldName) {
        return TokenStream.Companion.getDEFAULT_TOKEN_ATTRIBUTE_FACTORY();
    }

    public int getPositionIncrementGap(@Nullable String fieldName) {
        return 0;
    }

    public int getOffsetGap(@Nullable String fieldName) {
        return 1;
    }

    @Override
    public void close() {
        if (this.storedValue != null) {
            CloseableThreadLocal<Object> closeableThreadLocal = this.storedValue;
            Intrinsics.checkNotNull(closeableThreadLocal);
            closeableThreadLocal.close();
            this.storedValue = null;
        }
    }

    protected Analyzer() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/analysis/Analyzer$Companion;", "", "<init>", "()V", "GLOBAL_REUSE_STRATEGY", "Lorg/gnit/lucenekmp/analysis/Analyzer$ReuseStrategy;", "getGLOBAL_REUSE_STRATEGY", "()Lorg/gnit/lucenekmp/analysis/Analyzer$ReuseStrategy;", "PER_FIELD_REUSE_STRATEGY", "getPER_FIELD_REUSE_STRATEGY", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReuseStrategy getGLOBAL_REUSE_STRATEGY() {
            return GLOBAL_REUSE_STRATEGY;
        }

        @NotNull
        public final ReuseStrategy getPER_FIELD_REUSE_STRATEGY() {
            return PER_FIELD_REUSE_STRATEGY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J \u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0005H&J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007H\u0004J\u001a\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0004\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/analysis/Analyzer$ReuseStrategy;", "", "<init>", "()V", "getReusableComponents", "Lorg/gnit/lucenekmp/analysis/Analyzer$TokenStreamComponents;", "analyzer", "Lorg/gnit/lucenekmp/analysis/Analyzer;", "fieldName", "", "setReusableComponents", "", "components", "getStoredValue", "setStoredValue", "storedValue", "core"})
    public static abstract class ReuseStrategy {
        protected ReuseStrategy() {
        }

        @Nullable
        public abstract TokenStreamComponents getReusableComponents(@NotNull Analyzer var1, @NotNull String var2);

        public abstract void setReusableComponents(@NotNull Analyzer var1, @NotNull String var2, @NotNull TokenStreamComponents var3);

        @Nullable
        protected final Object getStoredValue(@NotNull Analyzer analyzer) {
            Intrinsics.checkNotNullParameter((Object)analyzer, (String)"analyzer");
            if (analyzer.getStoredValue() == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            CloseableThreadLocal<Object> closeableThreadLocal = analyzer.getStoredValue();
            Intrinsics.checkNotNull(closeableThreadLocal);
            return closeableThreadLocal.get();
        }

        protected final void setStoredValue(@NotNull Analyzer analyzer, @Nullable Object storedValue) {
            Intrinsics.checkNotNullParameter((Object)analyzer, (String)"analyzer");
            if (analyzer.getStoredValue() == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            CloseableThreadLocal<Object> closeableThreadLocal = analyzer.getStoredValue();
            Intrinsics.checkNotNull(closeableThreadLocal);
            closeableThreadLocal.set(storedValue);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/analysis/Analyzer$StringTokenStream;", "Lorg/gnit/lucenekmp/analysis/TokenStream;", "attributeFactory", "Lorg/gnit/lucenekmp/util/AttributeFactory;", "value", "", "length", "", "<init>", "(Lorg/gnit/lucenekmp/util/AttributeFactory;Ljava/lang/String;I)V", "used", "", "termAttribute", "Lorg/gnit/lucenekmp/analysis/tokenattributes/CharTermAttribute;", "offsetAttribute", "Lorg/gnit/lucenekmp/analysis/tokenattributes/OffsetAttribute;", "reset", "", "incrementToken", "end", "core"})
    private static final class StringTokenStream
    extends TokenStream {
        @NotNull
        private final String value;
        private final int length;
        private boolean used;
        @NotNull
        private final CharTermAttribute termAttribute;
        @NotNull
        private final OffsetAttribute offsetAttribute;

        public StringTokenStream(@NotNull AttributeFactory attributeFactory, @NotNull String value, int length) {
            Intrinsics.checkNotNullParameter((Object)attributeFactory, (String)"attributeFactory");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(attributeFactory);
            this.value = value;
            this.length = length;
            this.used = true;
            this.termAttribute = (CharTermAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(CharTermAttribute.class));
            this.offsetAttribute = (OffsetAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(OffsetAttribute.class));
        }

        @Override
        public void reset() {
            this.used = false;
        }

        @Override
        public boolean incrementToken() {
            if (this.used) {
                return false;
            }
            this.clearAttributes();
            this.termAttribute.append(this.value);
            this.offsetAttribute.setOffset(0, this.length);
            this.used = true;
            return true;
        }

        @Override
        public void end() throws IOException {
            super.end();
            this.offsetAttribute.setOffset(this.length, this.length);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\fJ\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0017\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/analysis/Analyzer$TokenStreamComponents;", "", "source", "Lorg/gnit/lucenekmp/jdkport/Consumer;", "Lorg/gnit/lucenekmp/jdkport/Reader;", "result", "Lorg/gnit/lucenekmp/analysis/TokenStream;", "<init>", "(Lorg/gnit/lucenekmp/jdkport/Consumer;Lorg/gnit/lucenekmp/analysis/TokenStream;)V", "tokenizer", "Lorg/gnit/lucenekmp/analysis/Tokenizer;", "(Lorg/gnit/lucenekmp/analysis/Tokenizer;Lorg/gnit/lucenekmp/analysis/TokenStream;)V", "(Lorg/gnit/lucenekmp/analysis/Tokenizer;)V", "sink", "reusableStringReader", "Lorg/gnit/lucenekmp/analysis/ReusableStringReader;", "getReusableStringReader", "()Lorg/gnit/lucenekmp/analysis/ReusableStringReader;", "setReusableStringReader", "(Lorg/gnit/lucenekmp/analysis/ReusableStringReader;)V", "setReader", "", "reader", "tokenStream", "getTokenStream", "()Lorg/gnit/lucenekmp/analysis/TokenStream;", "getSource", "core"})
    public static final class TokenStreamComponents {
        @NotNull
        private final Consumer<Reader> source;
        @NotNull
        private final TokenStream sink;
        @Nullable
        private transient ReusableStringReader reusableStringReader;

        public TokenStreamComponents(@NotNull Consumer<Reader> source, @NotNull TokenStream result) {
            Intrinsics.checkNotNullParameter(source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            this.source = source;
            this.sink = result;
        }

        @Nullable
        public final ReusableStringReader getReusableStringReader() {
            return this.reusableStringReader;
        }

        public final void setReusableStringReader(@Nullable ReusableStringReader reusableStringReader) {
            this.reusableStringReader = reusableStringReader;
        }

        public TokenStreamComponents(final @NotNull Tokenizer tokenizer, @NotNull TokenStream result) {
            Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            this(new Consumer(){

                public final void accept(Reader p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    tokenizer.setReader(p0);
                }

                public final Function<?> getFunctionDelegate() {
                    return (Function)new FunctionReferenceImpl(1, (Object)tokenizer, Tokenizer.class, "setReader", "setReader(Lorg/gnit/lucenekmp/jdkport/Reader;)V", 0);
                }

                public final boolean equals(Object other) {
                    return other instanceof Consumer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
                }

                @Override
                public Consumer<T> andThen(Consumer<? super T> after) {
                    return Consumer.super.andThen(after);
                }
            }, result);
        }

        public TokenStreamComponents(final @NotNull Tokenizer tokenizer) {
            Intrinsics.checkNotNullParameter((Object)tokenizer, (String)"tokenizer");
            this(new Consumer(){

                public final void accept(Reader p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    tokenizer.setReader(p0);
                }

                public final Function<?> getFunctionDelegate() {
                    return (Function)new FunctionReferenceImpl(1, (Object)tokenizer, Tokenizer.class, "setReader", "setReader(Lorg/gnit/lucenekmp/jdkport/Reader;)V", 0);
                }

                public final boolean equals(Object other) {
                    return other instanceof Consumer ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
                }

                public final int hashCode() {
                    return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
                }

                @Override
                public Consumer<T> andThen(Consumer<? super T> after) {
                    return Consumer.super.andThen(after);
                }
            }, (TokenStream)tokenizer);
        }

        public final void setReader(@NotNull Reader reader2) {
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            this.source.accept(reader2);
        }

        @NotNull
        public final TokenStream getTokenStream() {
            return this.sink;
        }

        @NotNull
        public final Consumer<Reader> getSource() {
            return this.source;
        }
    }
}

