/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.analysis;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.AbstractMutableMap;
import kotlin.collections.AbstractMutableSet;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.text.StringsKt;
import org.gnit.lucenekmp.analysis.CharArraySet;
import org.gnit.lucenekmp.analysis.CharacterUtils;
import org.gnit.lucenekmp.jdkport.Character;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.util.CharsRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0019\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 R*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u0002H\u00010\u0002:\u0006MNOPQRB\u0019\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB%\b\u0016\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u000b\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\fB\u0017\b\u0012\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0000\u00a2\u0006\u0004\b\b\u0010\u000eJ\b\u0010#\u001a\u00020$H\u0016J \u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005H\u0016J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u0010%\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0003H\u0016J'\u0010,\u001a\u0004\u0018\u00018\u00002\u0006\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010-J\u0017\u0010,\u001a\u0004\u0018\u00018\u00002\u0006\u0010)\u001a\u00020*H\u0016\u00a2\u0006\u0002\u0010.J\u0018\u0010,\u001a\u0004\u0018\u00018\u00002\u0006\u0010+\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0002\u0010/J \u00100\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005H\u0002J\u0010\u00100\u001a\u00020\u00052\u0006\u0010&\u001a\u00020*H\u0002J\u001f\u00101\u001a\u0004\u0018\u00018\u00002\u0006\u0010+\u001a\u00020\u00032\u0006\u00102\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00103J\u001f\u00101\u001a\u0004\u0018\u00018\u00002\u0006\u0010&\u001a\u0002042\u0006\u00102\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u00105J!\u00106\u001a\u0004\u0018\u00018\u00002\u0006\u0010&\u001a\u00020\u00172\b\u00102\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u00107J\b\u00108\u001a\u00020$H\u0002J(\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u00052\u0006\u0010;\u001a\u00020\u0017H\u0002J\u0018\u00109\u001a\u00020\u00072\u0006\u0010:\u001a\u00020*2\u0006\u0010;\u001a\u00020\u0017H\u0002J \u0010<\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u00172\u0006\u0010=\u001a\u00020\u00052\u0006\u0010(\u001a\u00020\u0005H\u0002J\u0010\u0010<\u001a\u00020\u00052\u0006\u0010&\u001a\u00020*H\u0002J\u0017\u0010>\u001a\u0004\u0018\u00018\u00002\u0006\u0010?\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010/J\b\u0010C\u001a\u000204H\u0016J\u0012\u0010H\u001a\f0ER\b\u0012\u0004\u0012\u00028\u00000\u0000H\u0016J\u0010\u0010D\u001a\f0ER\b\u0012\u0004\u0012\u00028\u00000\u0000J\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u00120\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u0016X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001c\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0016X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\"\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0014\u0010@\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010BR\u001a\u0010D\u001a\u000e\u0018\u00010ER\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010F\u001a\u0004\u0018\u00010GX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010J\u001a\u00020G8F\u00a2\u0006\u0006\u001a\u0004\bK\u0010L\u00a8\u0006S"}, d2={"Lorg/gnit/lucenekmp/analysis/CharArrayMap;", "V", "Lkotlin/collections/AbstractMutableMap;", "", "startSize", "", "ignoreCase", "", "<init>", "(IZ)V", "c", "", "(Ljava/util/Map;Z)V", "toCopy", "(Lorg/gnit/lucenekmp/analysis/CharArrayMap;)V", "count", "entries", "", "", "getEntries", "()Ljava/util/Set;", "keysArray", "", "", "getKeysArray", "()[[C", "setKeysArray", "([[C)V", "[[C", "valuesArray", "getValuesArray", "()[Ljava/lang/Object;", "setValuesArray", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "clear", "", "containsKey", "text", "off", "len", "cs", "", "o", "get", "([CII)Ljava/lang/Object;", "(Ljava/lang/CharSequence;)Ljava/lang/Object;", "(Ljava/lang/Object;)Ljava/lang/Object;", "getSlot", "put", "value", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "putCharArray", "([CLjava/lang/Object;)Ljava/lang/Object;", "rehash", "equals", "text1", "text2", "getHashCode", "offset", "remove", "key", "size", "getSize", "()I", "toString", "entrySet", "Lorg/gnit/lucenekmp/analysis/CharArrayMap$EntrySet;", "_keySet", "Lorg/gnit/lucenekmp/analysis/CharArraySet;", "createEntrySet", "originalKeySet", "keySet", "getKeySet", "()Lorg/gnit/lucenekmp/analysis/CharArraySet;", "EntryIterator", "MapEntry", "EntrySet", "UnmodifiableCharArrayMap", "EmptyCharArrayMap", "Companion", "core"})
public class CharArrayMap<V>
extends AbstractMutableMap<Object, V> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean ignoreCase;
    private int count;
    @NotNull
    private char[][] keysArray;
    @NotNull
    private V[] valuesArray;
    @Nullable
    private EntrySet entrySet;
    @Nullable
    private CharArraySet _keySet;
    @NotNull
    private static final CharArrayMap<?> EMPTY_MAP = new EmptyCharArrayMap();
    private static final int INIT_SIZE = 8;

    @NotNull
    public Set<Map.Entry<Object, V>> getEntries() {
        return (Set)((Object)this.entrySet());
    }

    @NotNull
    public final char[][] getKeysArray() {
        return this.keysArray;
    }

    public final void setKeysArray(@NotNull char[][] cArray) {
        Intrinsics.checkNotNullParameter((Object)cArray, (String)"<set-?>");
        this.keysArray = cArray;
    }

    @NotNull
    public final V[] getValuesArray() {
        return this.valuesArray;
    }

    public final void setValuesArray(@NotNull V[] VArray) {
        Intrinsics.checkNotNullParameter(VArray, (String)"<set-?>");
        this.valuesArray = VArray;
    }

    public CharArrayMap(int startSize, boolean ignoreCase) {
        int size2;
        this.ignoreCase = ignoreCase;
        for (size2 = 8; startSize + (startSize >> 2) > size2; size2 <<= 1) {
        }
        this.keysArray = new char[size2][];
        this.valuesArray = new Object[size2];
    }

    public CharArrayMap(@NotNull Map<Object, V> c, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter(c, (String)"c");
        this(c.size(), ignoreCase);
        this.putAll(c);
    }

    private CharArrayMap(CharArrayMap<V> toCopy) {
        this.keysArray = toCopy.keysArray;
        this.valuesArray = toCopy.valuesArray;
        this.ignoreCase = toCopy.ignoreCase;
        this.count = toCopy.count;
    }

    public void clear() {
        this.count = 0;
        org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.fill((Object[])this.keysArray, null);
        org.gnit.lucenekmp.jdkport.Arrays.INSTANCE.fill(this.valuesArray, null);
    }

    public boolean containsKey(@NotNull char[] text, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.keysArray[this.getSlot(text, off, len)] != null;
    }

    public boolean containsKey(@NotNull CharSequence cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        return this.keysArray[this.getSlot(cs)] != null;
    }

    public boolean containsKey(@Nullable Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof char[]) {
            return this.containsKey((char[])o, 0, ((char[])o).length);
        }
        return this.containsKey(o.toString());
    }

    @Nullable
    public V get(@NotNull char[] text, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.valuesArray[this.getSlot(text, off, len)];
    }

    @Nullable
    public V get(@NotNull CharSequence cs) {
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        return this.valuesArray[this.getSlot(cs)];
    }

    @Nullable
    public V get(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof char[]) {
            return this.get((char[])o, 0, ((char[])o).length);
        }
        return this.get(o.toString());
    }

    private final int getSlot(char[] text, int off, int len) {
        int code = this.getHashCode(text, off, len);
        int pos = code & ((Object[])this.keysArray).length - 1;
        char[] text2 = this.keysArray[pos];
        if (text2 != null && !this.equals(text, off, len, text2)) {
            int inc = (code >> 8) + code | 1;
            while ((text2 = this.keysArray[pos = (code += inc) & ((Object[])this.keysArray).length - 1]) != null && !this.equals(text, off, len, text2)) {
            }
        }
        return pos;
    }

    private final int getSlot(CharSequence text) {
        int code = this.getHashCode(text);
        int pos = code & ((Object[])this.keysArray).length - 1;
        char[] text2 = this.keysArray[pos];
        if (text2 != null && !this.equals(text, text2)) {
            int inc = (code >> 8) + code | 1;
            while ((text2 = this.keysArray[pos = (code += inc) & ((Object[])this.keysArray).length - 1]) != null && !this.equals(text, text2)) {
            }
        }
        return pos;
    }

    @Nullable
    public V put(@NotNull Object o, V value) {
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        if (o instanceof char[]) {
            return this.putCharArray((char[])o, value);
        }
        return this.put(o.toString(), value);
    }

    @Nullable
    public V put(@NotNull String text, V value) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        char[] cArray = text.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        return this.putCharArray(cArray, value);
    }

    @Nullable
    public V putCharArray(@NotNull char[] text, @Nullable V value) {
        int slot;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this.ignoreCase) {
            CharacterUtils.INSTANCE.toLowerCase(text, 0, text.length);
        }
        if (this.keysArray[slot = this.getSlot(text, 0, text.length)] != null) {
            V oldValue = this.valuesArray[slot];
            this.valuesArray[slot] = value;
            return oldValue;
        }
        this.keysArray[slot] = text;
        this.valuesArray[slot] = value;
        int n = this.count;
        this.count = n + 1;
        if (this.count + (this.count >> 2) > ((Object[])this.keysArray).length) {
            this.rehash();
        }
        return null;
    }

    private final void rehash() {
        if (!(((Object[])this.keysArray).length == this.valuesArray.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        int newSize = 2 * ((Object[])this.keysArray).length;
        char[][] oldkeys = this.keysArray;
        V[] oldvalues = this.valuesArray;
        this.keysArray = new char[newSize][];
        this.valuesArray = new Object[newSize];
        int n = ((Object[])oldkeys).length;
        for (int i = 0; i < n; ++i) {
            char[] text = oldkeys[i];
            if (text == null) continue;
            int slot = this.getSlot(text, 0, text.length);
            this.keysArray[slot] = text;
            this.valuesArray[slot] = oldvalues[i];
        }
    }

    private final boolean equals(char[] text1, int off, int len, char[] text2) {
        if (len != text2.length) {
            return false;
        }
        int limit = off + len;
        if (this.ignoreCase) {
            int codePointAt;
            for (int i = 0; i < len; i += Character.Companion.charCount(codePointAt)) {
                codePointAt = Character.Companion.codePointAt(text1, off + i, limit);
                if (Character.Companion.toLowerCase(codePointAt) == Character.Companion.codePointAt(text2, i, text2.length)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (text1[off + i] == text2[i]) continue;
                return false;
            }
        }
        return true;
    }

    private final boolean equals(CharSequence text1, char[] text2) {
        int len = text1.length();
        if (len != text2.length) {
            return false;
        }
        if (this.ignoreCase) {
            int codePointAt;
            for (int i = 0; i < len; i += Character.Companion.charCount(codePointAt)) {
                codePointAt = Character.Companion.codePointAt(text1, i);
                if (Character.Companion.toLowerCase(codePointAt) == Character.Companion.codePointAt(text2, i, text2.length)) continue;
                return false;
            }
        } else {
            for (int i = 0; i < len; ++i) {
                if (text1.charAt(i) == text2[i]) continue;
                return false;
            }
        }
        return true;
    }

    private final int getHashCode(char[] text, int offset, int len) {
        if (this.ignoreCase) {
            int codePointAt;
            int stop = offset + len;
            int code = 0;
            for (int i = offset; i < stop; i += Character.Companion.charCount(codePointAt)) {
                codePointAt = Character.Companion.codePointAt(text, i, stop);
                code = code * 31 + Character.Companion.toLowerCase(codePointAt);
            }
            return code;
        }
        return CharsRef.Companion.stringHashCode(text, offset, len);
    }

    private final int getHashCode(CharSequence text) {
        int code = 0;
        int len = text.length();
        if (this.ignoreCase) {
            int codePointAt;
            for (int i = 0; i < len; i += Character.Companion.charCount(codePointAt)) {
                codePointAt = Character.Companion.codePointAt(text, i);
                code = code * 31 + Character.Companion.toLowerCase(codePointAt);
            }
        } else {
            for (int i = 0; i < len; ++i) {
                code = code * 31 + text.charAt(i);
            }
        }
        return code;
    }

    @Nullable
    public V remove(@Nullable Object key) {
        if (key == null) {
            return null;
        }
        throw new UnsupportedOperationException();
    }

    public int getSize() {
        return this.count;
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        for (Map.Entry entry : this.entrySet()) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(entry);
        }
        String string = sb.append('}').toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public EntrySet createEntrySet() {
        return new EntrySet(true);
    }

    @NotNull
    public final EntrySet entrySet() {
        if (this.entrySet == null) {
            this.entrySet = this.createEntrySet();
        }
        EntrySet entrySet2 = this.entrySet;
        Intrinsics.checkNotNull((Object)((Object)entrySet2));
        return entrySet2;
    }

    @NotNull
    public final Set<Object> originalKeySet() {
        return super.keySet();
    }

    @NotNull
    public final CharArraySet getKeySet() {
        if (this._keySet == null) {
            this._keySet = new CharArraySet(this){
                {
                    Intrinsics.checkNotNull($receiver, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.analysis.CharArrayMap<kotlin.Any>");
                    super($receiver);
                }

                public boolean add(Object o) {
                    Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                    throw new UnsupportedOperationException();
                }

                public boolean add(CharSequence text) {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    throw new UnsupportedOperationException();
                }

                public boolean add(String text) {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    throw new UnsupportedOperationException();
                }

                public boolean add(char[] text) {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    throw new UnsupportedOperationException();
                }
            };
        }
        CharArraySet charArraySet = this._keySet;
        Intrinsics.checkNotNull((Object)((Object)charArraySet));
        return charArraySet;
    }

    public /* synthetic */ CharArrayMap(CharArrayMap toCopy, DefaultConstructorMarker $constructor_marker) {
        this(toCopy);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\b\u001a\b\u0012\u0004\u0012\u0002H\t0\u0005\"\u0004\b\u0001\u0010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\t0\u0005J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\u0005\"\u0004\b\u0001\u0010\t2\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H\t0\fJ\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\t0\u0005\"\u0004\b\u0001\u0010\tR\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/analysis/CharArrayMap$Companion;", "", "<init>", "()V", "EMPTY_MAP", "Lorg/gnit/lucenekmp/analysis/CharArrayMap;", "INIT_SIZE", "", "unmodifiableMap", "V", "map", "copy", "", "emptyMap", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <V> CharArrayMap<V> unmodifiableMap(@NotNull CharArrayMap<V> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            if (map2 == this.emptyMap() || map2.isEmpty()) {
                return this.emptyMap();
            }
            if (map2 instanceof UnmodifiableCharArrayMap) {
                return map2;
            }
            return new UnmodifiableCharArrayMap<V>(map2);
        }

        @NotNull
        public final <V> CharArrayMap<V> copy(@NotNull Map<Object, V> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            if (map2 == EMPTY_MAP) {
                return this.emptyMap();
            }
            if (map2 instanceof CharArrayMap) {
                CharArrayMap<Object> m = (CharArrayMap<Object>)((Object)map2);
                char[][] keys = new char[((Object[])m.getKeysArray()).length][];
                System.INSTANCE.arraycopyKtNullable((Object[])m.getKeysArray(), 0, (Object[])keys, 0, ((Object[])keys).length);
                Object[] values2 = new Object[m.getValuesArray().length];
                System.INSTANCE.arraycopyKtNullable(m.getValuesArray(), 0, values2, 0, values2.length);
                m = new CharArrayMap<Object>(m, null);
                m.setKeysArray(keys);
                m.setValuesArray(values2);
                return m;
            }
            return new CharArrayMap<V>(map2, false);
        }

        @NotNull
        public final <V> CharArrayMap<V> emptyMap() {
            CharArrayMap charArrayMap = EMPTY_MAP;
            Intrinsics.checkNotNull((Object)((Object)charArrayMap), (String)"null cannot be cast to non-null type org.gnit.lucenekmp.analysis.CharArrayMap<V of org.gnit.lucenekmp.analysis.CharArrayMap.Companion.emptyMap>");
            return charArrayMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0002\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J'\u0010\u0010\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u0011J\u0017\u0010\u0010\u001a\u0004\u0018\u00018\u00012\u0006\u0010\f\u001a\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010\u0010\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/analysis/CharArrayMap$EmptyCharArrayMap;", "V", "Lorg/gnit/lucenekmp/analysis/CharArrayMap$UnmodifiableCharArrayMap;", "<init>", "()V", "containsKey", "", "text", "", "off", "", "len", "cs", "", "o", "", "get", "([CII)Ljava/lang/Object;", "(Ljava/lang/CharSequence;)Ljava/lang/Object;", "(Ljava/lang/Object;)Ljava/lang/Object;", "core"})
    private static final class EmptyCharArrayMap<V>
    extends UnmodifiableCharArrayMap<V> {
        public EmptyCharArrayMap() {
            super(new CharArrayMap(0, false));
        }

        @Override
        public boolean containsKey(@NotNull char[] text, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return false;
        }

        @Override
        public boolean containsKey(@NotNull CharSequence cs) {
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            return false;
        }

        @Override
        public boolean containsKey(@Nullable Object o) {
            if (o == null) {
                return false;
            }
            return false;
        }

        @Override
        @Nullable
        public V get(@NotNull char[] text, int off, int len) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            return null;
        }

        @Override
        @Nullable
        public V get(@NotNull CharSequence cs) {
            Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
            return null;
        }

        @Override
        @Nullable
        public V get(@Nullable Object o) {
            if (o == null) {
                return null;
            }
            return null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010)\n\u0002\u0010'\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0002J\t\u0010\r\u001a\u00020\u0005H\u0096\u0002J\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\r\u0010\u0012\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0013J\u0017\u0010\u0014\u001a\u0004\u0018\u00018\u00002\b\u0010\u0015\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0016J\u0015\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u0002H\u0096\u0002J\b\u0010\u0018\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/analysis/CharArrayMap$EntryIterator;", "", "", "", "allowModify", "", "<init>", "(Lorg/gnit/lucenekmp/analysis/CharArrayMap;Z)V", "pos", "", "lastPos", "goNext", "", "hasNext", "nextKey", "", "nextKeyString", "", "currentValue", "()Ljava/lang/Object;", "setValue", "value", "(Ljava/lang/Object;)Ljava/lang/Object;", "next", "remove", "core"})
    public final class EntryIterator
    implements Iterator<Map.Entry<Object, V>>,
    KMutableIterator {
        private final boolean allowModify;
        private int pos;
        private int lastPos;

        public EntryIterator(boolean allowModify) {
            this.allowModify = allowModify;
            this.pos = -1;
            this.goNext();
        }

        private final void goNext() {
            this.lastPos = this.pos;
            int n = this.pos;
            this.pos = n + 1;
            while (this.pos < ((Object[])CharArrayMap.this.getKeysArray()).length && CharArrayMap.this.getKeysArray()[this.pos] == null) {
                n = this.pos;
                this.pos = n + 1;
            }
        }

        @Override
        public boolean hasNext() {
            return this.pos < ((Object[])CharArrayMap.this.getKeysArray()).length;
        }

        @Nullable
        public final char[] nextKey() {
            this.goNext();
            return CharArrayMap.this.getKeysArray()[this.lastPos];
        }

        @NotNull
        public final String nextKeyString() {
            char[] cArray = this.nextKey();
            Intrinsics.checkNotNull((Object)cArray);
            return StringsKt.concatToString((char[])cArray);
        }

        @Nullable
        public final V currentValue() {
            return CharArrayMap.this.getValuesArray()[this.lastPos];
        }

        @Nullable
        public final V setValue(@Nullable V value) {
            if (!this.allowModify) {
                throw new UnsupportedOperationException();
            }
            Object old = CharArrayMap.this.getValuesArray()[this.lastPos];
            CharArrayMap.this.getValuesArray()[this.lastPos] = value;
            return old;
        }

        @Override
        @NotNull
        public Map.Entry<Object, V> next() {
            this.goNext();
            return new MapEntry(this.lastPos, this.allowModify);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010'\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\b\u001a\f0\tR\b\u0012\u0004\u0012\u00028\u00000\nH\u0096\u0002J\u001c\u0010\u000b\u001a\u00020\u00052\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u0002H\u0016J\u001d\u0010\r\u001a\u00020\u00052\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u0002H\u0096\u0002J\u001c\u0010\u000f\u001a\u00020\u00052\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00028\u00000\u0002H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0016"}, d2={"Lorg/gnit/lucenekmp/analysis/CharArrayMap$EntrySet;", "Lkotlin/collections/AbstractMutableSet;", "", "", "allowModify", "", "<init>", "(Lorg/gnit/lucenekmp/analysis/CharArrayMap;Z)V", "iterator", "Lorg/gnit/lucenekmp/analysis/CharArrayMap$EntryIterator;", "Lorg/gnit/lucenekmp/analysis/CharArrayMap;", "add", "element", "contains", "o", "remove", "size", "", "getSize", "()I", "clear", "", "core"})
    public final class EntrySet
    extends AbstractMutableSet<Map.Entry<Object, V>> {
        private final boolean allowModify;

        public EntrySet(boolean allowModify) {
            this.allowModify = allowModify;
        }

        @NotNull
        public EntryIterator iterator() {
            return new EntryIterator(this.allowModify);
        }

        public boolean add(@NotNull Map.Entry<Object, V> element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            String string = "Not yet implemented";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }

        public boolean contains(@NotNull Map.Entry<Object, V> o) {
            Object v;
            Intrinsics.checkNotNullParameter(o, (String)"o");
            if (!TypeIntrinsics.isMutableMapEntry(o)) {
                return false;
            }
            Map.Entry e = o;
            Object key = e.getKey();
            Object val = e.getValue();
            Object v2 = v = CharArrayMap.this.get(key);
            return v2 == null ? val == null : Intrinsics.areEqual(v2, val);
        }

        public boolean remove(@NotNull Map.Entry<Object, V> o) {
            Intrinsics.checkNotNullParameter(o, (String)"o");
            throw new UnsupportedOperationException();
        }

        public int getSize() {
            return CharArrayMap.this.count;
        }

        public void clear() {
            if (!this.allowModify) {
                throw new UnsupportedOperationException();
            }
            CharArrayMap.this.clear();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010'\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00028\u00000\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\u000e\u001a\u00028\u00002\u0006\u0010\f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00028\u00008VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/analysis/CharArrayMap$MapEntry;", "", "", "pos", "", "allowModify", "", "<init>", "(Lorg/gnit/lucenekmp/analysis/CharArrayMap;IZ)V", "key", "getKey", "()Ljava/lang/Object;", "value", "getValue", "setValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "toString", "", "core"})
    private final class MapEntry
    implements Map.Entry<Object, V>,
    KMutableMap.Entry {
        private final int pos;
        private final boolean allowModify;

        public MapEntry(int pos, boolean allowModify) {
            this.pos = pos;
            this.allowModify = allowModify;
        }

        @Override
        @NotNull
        public Object getKey() {
            char[] cArray = CharArrayMap.this.getKeysArray()[this.pos];
            Intrinsics.checkNotNull((Object)cArray, (String)"null cannot be cast to non-null type kotlin.CharArray");
            char[] cArray2 = cArray;
            char[] cArray3 = Arrays.copyOf(cArray2, cArray2.length);
            Intrinsics.checkNotNullExpressionValue((Object)cArray3, (String)"copyOf(...)");
            return cArray3;
        }

        @Override
        public V getValue() {
            Object v = CharArrayMap.this.getValuesArray()[this.pos];
            Intrinsics.checkNotNull(v);
            return v;
        }

        @Override
        public V setValue(V value) {
            if (!this.allowModify) {
                throw new UnsupportedOperationException();
            }
            Object old = CharArrayMap.this.getValuesArray()[this.pos];
            CharArrayMap.this.getValuesArray()[this.pos] = value;
            Object v = old;
            Intrinsics.checkNotNull(v);
            return v;
        }

        @NotNull
        public String toString() {
            char[] cArray = CharArrayMap.this.getKeysArray()[this.pos];
            Intrinsics.checkNotNull((Object)cArray);
            return StringsKt.concatToString((char[])cArray) + "=" + (CharArrayMap.this.getValuesArray()[this.pos] == CharArrayMap.this ? "(this Map)" : CharArrayMap.this.getValuesArray()[this.pos]);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0010\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u001f\u0010\b\u001a\u0004\u0018\u00018\u00012\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\fJ!\u0010\r\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00018\u0001H\u0016\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\b\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u000e\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u0013J\u0017\u0010\u0014\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0015\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\f0\u0018R\b\u0012\u0004\u0012\u00028\u00010\u0002H\u0016\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/analysis/CharArrayMap$UnmodifiableCharArrayMap;", "V", "Lorg/gnit/lucenekmp/analysis/CharArrayMap;", "map", "<init>", "(Lorg/gnit/lucenekmp/analysis/CharArrayMap;)V", "clear", "", "put", "o", "", "val", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", "putCharArray", "text", "", "value", "([CLjava/lang/Object;)Ljava/lang/Object;", "", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "remove", "key", "(Ljava/lang/Object;)Ljava/lang/Object;", "createEntrySet", "Lorg/gnit/lucenekmp/analysis/CharArrayMap$EntrySet;", "core"})
    public static class UnmodifiableCharArrayMap<V>
    extends CharArrayMap<V> {
        public UnmodifiableCharArrayMap(@NotNull CharArrayMap<V> map2) {
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            super(map2, null);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public V put(@NotNull Object o, V val) {
            Intrinsics.checkNotNullParameter((Object)o, (String)"o");
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public V putCharArray(@NotNull char[] text, @Nullable V value) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public V put(@NotNull String text, V value) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            throw new UnsupportedOperationException();
        }

        @Override
        @Nullable
        public V remove(@Nullable Object key) {
            if (key == null) {
                return null;
            }
            throw new UnsupportedOperationException();
        }

        @Override
        @NotNull
        public EntrySet createEntrySet() {
            return new EntrySet(false);
        }
    }
}

