/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.analysis;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.jdkport.Character;
import org.gnit.lucenekmp.jdkport.Reader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0019\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007J\u001e\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0007J.\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0007J.\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0007J\"\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u0007H\u0007J&\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u0007\u00a8\u0006\u001f"}, d2={"Lorg/gnit/lucenekmp/analysis/CharacterUtils;", "", "<init>", "()V", "newCharacterBuffer", "Lorg/gnit/lucenekmp/analysis/CharacterUtils$CharacterBuffer;", "bufferSize", "", "toLowerCase", "", "buffer", "", "offset", "limit", "toUpperCase", "toCodePoints", "src", "srcOff", "srcLen", "dest", "", "destOff", "toChars", "fill", "", "reader", "Lorg/gnit/lucenekmp/jdkport/Reader;", "numChars", "readFully", "len", "CharacterBuffer", "core"})
@SourceDebugExtension(value={"SMAP\nCharacterUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CharacterUtils.kt\norg/gnit/lucenekmp/analysis/CharacterUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
public final class CharacterUtils {
    @NotNull
    public static final CharacterUtils INSTANCE = new CharacterUtils();

    private CharacterUtils() {
    }

    @NotNull
    public final CharacterBuffer newCharacterBuffer(int bufferSize) {
        if (!(bufferSize >= 2)) {
            boolean bl = false;
            String string = "buffersize must be >= 2";
            throw new IllegalArgumentException(string.toString());
        }
        return new CharacterBuffer(new char[bufferSize], 0, 0);
    }

    public final void toLowerCase(@NotNull char[] buffer, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (!(buffer.length >= limit)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(0 <= offset && offset <= buffer.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        for (int i = offset; i < limit; i += Character.Companion.toChars(Character.Companion.toLowerCase(Character.Companion.codePointAt(buffer, i, limit)), buffer, i)) {
        }
    }

    public final void toUpperCase(@NotNull char[] buffer, int offset, int limit) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (!(buffer.length >= limit)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(0 <= offset && offset <= buffer.length)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        for (int i = offset; i < limit; i += Character.Companion.toChars(Character.Companion.toUpperCase(Character.Companion.codePointAt(buffer, i, limit)), buffer, i)) {
        }
    }

    public final int toCodePoints(@NotNull char[] src, int srcOff, int srcLen, @NotNull int[] dest, int destOff) {
        int charCount;
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (!(srcLen >= 0)) {
            boolean $i$a$-require-CharacterUtils$toCodePoints$22 = false;
            String $i$a$-require-CharacterUtils$toCodePoints$22 = "srcLen must be >= 0";
            throw new IllegalArgumentException($i$a$-require-CharacterUtils$toCodePoints$22.toString());
        }
        int codePointCount = 0;
        for (int i = 0; i < srcLen; i += charCount) {
            int cp = Character.Companion.codePointAt(src, srcOff + i, srcOff + srcLen);
            charCount = Character.Companion.charCount(cp);
            dest[destOff + codePointCount++] = cp;
        }
        return codePointCount;
    }

    public final int toChars(@NotNull int[] src, int srcOff, int srcLen, @NotNull char[] dest, int destOff) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        if (!(srcLen >= 0)) {
            boolean $i$a$-require-CharacterUtils$toChars$22 = false;
            String $i$a$-require-CharacterUtils$toChars$22 = "srcLen must be >= 0";
            throw new IllegalArgumentException($i$a$-require-CharacterUtils$toChars$22.toString());
        }
        int written = 0;
        for (int i = 0; i < srcLen; ++i) {
            written += Character.Companion.toChars(src[srcOff + i], dest, destOff + written);
        }
        return written;
    }

    @JvmOverloads
    public final boolean fill(@NotNull CharacterBuffer buffer, @NotNull Reader reader2, int numChars) throws IOException {
        boolean result;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        if (!(buffer.getBuffer().length >= 2)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(numChars >= 2 && numChars <= buffer.getBuffer().length)) {
            boolean $i$a$-require-CharacterUtils$fill$22 = false;
            String $i$a$-require-CharacterUtils$fill$22 = "numChars must be >= 2 and <= the buffer size";
            throw new IllegalArgumentException($i$a$-require-CharacterUtils$fill$22.toString());
        }
        char[] charBuffer = buffer.getBuffer();
        buffer.setOffset(0);
        int offset = 0;
        if (buffer.getLastTrailingHighSurrogate() != '\u0000') {
            charBuffer[0] = buffer.getLastTrailingHighSurrogate();
            buffer.setLastTrailingHighSurrogate('\u0000');
            offset = 1;
        } else {
            offset = 0;
        }
        int read = this.readFully(reader2, charBuffer, offset, numChars - offset);
        buffer.setLength(offset + read);
        boolean bl = result = buffer.getLength() == numChars;
        if (buffer.getLength() < numChars) {
            return result;
        }
        if (Character.Companion.isHighSurrogate(charBuffer[buffer.getLength() - 1])) {
            buffer.setLength(buffer.getLength() + -1);
            buffer.setLastTrailingHighSurrogate(charBuffer[buffer.getLength()]);
        }
        return result;
    }

    public static /* synthetic */ boolean fill$default(CharacterUtils characterUtils, CharacterBuffer characterBuffer, Reader reader2, int n, int n2, Object object) throws IOException {
        if ((n2 & 4) != 0) {
            n = characterBuffer.getBuffer().length;
        }
        return characterUtils.fill(characterBuffer, reader2, n);
    }

    public final int readFully(@NotNull Reader reader2, @NotNull char[] dest, int offset, int len) throws IOException {
        int read;
        int r;
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        for (read = 0; read < len && (r = reader2.read(dest, offset + read, len - read)) != -1; read += r) {
        }
        return read;
    }

    @JvmOverloads
    public final boolean fill(@NotNull CharacterBuffer buffer, @NotNull Reader reader2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
        return CharacterUtils.fill$default(this, buffer, reader2, 0, 4, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\f\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lorg/gnit/lucenekmp/analysis/CharacterUtils$CharacterBuffer;", "", "buffer", "", "offset", "", "length", "<init>", "([CII)V", "getBuffer", "()[C", "getOffset", "()I", "setOffset", "(I)V", "getLength", "setLength", "lastTrailingHighSurrogate", "", "getLastTrailingHighSurrogate", "()C", "setLastTrailingHighSurrogate", "(C)V", "reset", "", "core"})
    public static final class CharacterBuffer {
        @NotNull
        private final char[] buffer;
        private int offset;
        private int length;
        private char lastTrailingHighSurrogate;

        public CharacterBuffer(@NotNull char[] buffer, int offset, int length) {
            Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
            this.buffer = buffer;
            this.offset = offset;
            this.length = length;
        }

        @NotNull
        public final char[] getBuffer() {
            return this.buffer;
        }

        public final int getOffset() {
            return this.offset;
        }

        public final void setOffset(int n) {
            this.offset = n;
        }

        public final int getLength() {
            return this.length;
        }

        public final void setLength(int n) {
            this.length = n;
        }

        public final char getLastTrailingHighSurrogate() {
            return this.lastTrailingHighSurrogate;
        }

        public final void setLastTrailingHighSurrogate(char c) {
            this.lastTrailingHighSurrogate = c;
        }

        public final void reset() {
            this.offset = 0;
            this.length = 0;
            this.lastTrailingHighSurrogate = '\u0000';
        }
    }
}

