/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.analysis;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gnit.lucenekmp.analysis.TokenFilter;
import org.gnit.lucenekmp.analysis.TokenStream;
import org.gnit.lucenekmp.analysis.tokenattributes.PositionIncrementAttribute;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\n\u001a\u00020\u000bH$J\b\u0010\f\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/analysis/FilteringTokenFilter;", "Lorg/gnit/lucenekmp/analysis/TokenFilter;", "in", "Lorg/gnit/lucenekmp/analysis/TokenStream;", "<init>", "(Lorg/gnit/lucenekmp/analysis/TokenStream;)V", "posIncrAtt", "Lorg/gnit/lucenekmp/analysis/tokenattributes/PositionIncrementAttribute;", "skippedPositions", "", "accept", "", "incrementToken", "reset", "", "end", "core"})
public abstract class FilteringTokenFilter
extends TokenFilter {
    @NotNull
    private final PositionIncrementAttribute posIncrAtt;
    private int skippedPositions;

    public FilteringTokenFilter(@Nullable TokenStream in) {
        TokenStream tokenStream = in;
        Intrinsics.checkNotNull((Object)tokenStream);
        super(tokenStream);
        this.posIncrAtt = (PositionIncrementAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(PositionIncrementAttribute.class));
    }

    protected abstract boolean accept() throws IOException;

    @Override
    public boolean incrementToken() throws IOException {
        this.skippedPositions = 0;
        while (this.getInput().incrementToken()) {
            if (this.accept()) {
                if (this.skippedPositions != 0) {
                    this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + this.skippedPositions);
                }
                return true;
            }
            this.skippedPositions += this.posIncrAtt.getPositionIncrement();
        }
        return false;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.skippedPositions = 0;
    }

    @Override
    public void end() throws IOException {
        super.end();
        this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + this.skippedPositions);
    }
}

