/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.analysis;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.jdkport.Reader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bJ\b\u0010\u000b\u001a\u00020\u0005H\u0016J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/analysis/ReusableStringReader;", "Lorg/gnit/lucenekmp/jdkport/Reader;", "<init>", "()V", "pos", "", "size", "s", "", "setValue", "", "read", "c", "", "off", "len", "close", "core"})
public final class ReusableStringReader
extends Reader {
    private int pos;
    private int size;
    @Nullable
    private String s;

    public final void setValue(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.s = s;
        this.size = s.length();
        this.pos = 0;
    }

    @Override
    public int read() {
        if (this.pos < this.size) {
            String string = this.s;
            Intrinsics.checkNotNull((Object)string);
            int n = this.pos;
            this.pos = n + 1;
            return string.charAt(n);
        }
        this.s = null;
        return -1;
    }

    @Override
    public int read(@NotNull char[] c, int off, int len) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        int len2 = len;
        if (this.pos < this.size) {
            int n = this.size - this.pos;
            len2 = Math.min(len2, n);
            String string = this.s;
            Intrinsics.checkNotNull((Object)string);
            String string2 = string;
            int n2 = this.pos;
            int n3 = this.pos + len2;
            string2.getChars(n2, n3, c, off);
            this.pos += len2;
            return len2;
        }
        this.s = null;
        return -1;
    }

    @Override
    public void close() {
        this.pos = this.size;
        this.s = null;
    }
}

