/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.analysis.standard;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.analysis.Analyzer;
import org.gnit.lucenekmp.analysis.CharArraySet;
import org.gnit.lucenekmp.analysis.LowerCaseFilter;
import org.gnit.lucenekmp.analysis.StopFilter;
import org.gnit.lucenekmp.analysis.StopwordAnalyzerBase;
import org.gnit.lucenekmp.analysis.TokenStream;
import org.gnit.lucenekmp.analysis.standard.StandardTokenizer;
import org.gnit.lucenekmp.jdkport.Reader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\t\b\u0016\u00a2\u0006\u0004\b\u0004\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\u0004\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0015H\u0014R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lorg/gnit/lucenekmp/analysis/standard/StandardAnalyzer;", "Lorg/gnit/lucenekmp/analysis/StopwordAnalyzerBase;", "stopWords", "Lorg/gnit/lucenekmp/analysis/CharArraySet;", "<init>", "(Lorg/gnit/lucenekmp/analysis/CharArraySet;)V", "()V", "stopwords", "Lorg/gnit/lucenekmp/jdkport/Reader;", "(Lorg/gnit/lucenekmp/jdkport/Reader;)V", "maxTokenLength", "", "getMaxTokenLength", "()I", "setMaxTokenLength", "(I)V", "createComponents", "Lorg/gnit/lucenekmp/analysis/Analyzer$TokenStreamComponents;", "fieldName", "", "normalize", "Lorg/gnit/lucenekmp/analysis/TokenStream;", "in", "Companion", "core"})
public final class StandardAnalyzer
extends StopwordAnalyzerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int maxTokenLength;
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;

    public StandardAnalyzer(@NotNull CharArraySet stopWords) {
        Intrinsics.checkNotNullParameter((Object)((Object)stopWords), (String)"stopWords");
        super(stopWords);
        this.maxTokenLength = 255;
    }

    public final int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public final void setMaxTokenLength(int n) {
        this.maxTokenLength = n;
    }

    public StandardAnalyzer() {
        this(CharArraySet.Companion.getEMPTY_SET());
    }

    public StandardAnalyzer(@NotNull Reader stopwords) {
        Intrinsics.checkNotNullParameter((Object)stopwords, (String)"stopwords");
        this(StopwordAnalyzerBase.Companion.loadStopwordSet(stopwords));
    }

    @Override
    @NotNull
    protected Analyzer.TokenStreamComponents createComponents(@NotNull String fieldName) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        StandardTokenizer src = new StandardTokenizer();
        src.setMaxTokenLength(this.maxTokenLength);
        TokenStream tok = new LowerCaseFilter(src);
        tok = new StopFilter(tok, this.getStopwords());
        return new Analyzer.TokenStreamComponents(arg_0 -> StandardAnalyzer.createComponents$lambda$0(src, this, arg_0), tok);
    }

    @Override
    @NotNull
    protected TokenStream normalize(@NotNull String fieldName, @NotNull TokenStream in) {
        Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        return new LowerCaseFilter(in);
    }

    private static final void createComponents$lambda$0(StandardTokenizer $src, StandardAnalyzer this$0, Reader r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        $src.setMaxTokenLength(this$0.maxTokenLength);
        $src.setReader(r);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/analysis/standard/StandardAnalyzer$Companion;", "", "<init>", "()V", "DEFAULT_MAX_TOKEN_LENGTH", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

