/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.analysis.standard;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.analysis.Tokenizer;
import org.gnit.lucenekmp.analysis.standard.StandardTokenizerImpl;
import org.gnit.lucenekmp.analysis.tokenattributes.CharTermAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.OffsetAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.PositionIncrementAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.TypeAttribute;
import org.gnit.lucenekmp.util.AttributeFactory;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0002\u0010\u0006J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\nJ\u0006\u0010\u000f\u001a\u00020\nJ\b\u0010\u0010\u001a\u00020\rH\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\rH\u0016J\b\u0010\u001c\u001a\u00020\rH\u0016J\b\u0010\u001d\u001a\u00020\rH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/gnit/lucenekmp/analysis/standard/StandardTokenizer;", "Lorg/gnit/lucenekmp/analysis/Tokenizer;", "<init>", "()V", "factory", "Lorg/gnit/lucenekmp/util/AttributeFactory;", "(Lorg/gnit/lucenekmp/util/AttributeFactory;)V", "scanner", "Lorg/gnit/lucenekmp/analysis/standard/StandardTokenizerImpl;", "skippedPositions", "", "maxTokenLength", "setMaxTokenLength", "", "length", "getMaxTokenLength", "init", "termAtt", "Lorg/gnit/lucenekmp/analysis/tokenattributes/CharTermAttribute;", "offsetAtt", "Lorg/gnit/lucenekmp/analysis/tokenattributes/OffsetAttribute;", "posIncrAtt", "Lorg/gnit/lucenekmp/analysis/tokenattributes/PositionIncrementAttribute;", "typeAtt", "Lorg/gnit/lucenekmp/analysis/tokenattributes/TypeAttribute;", "incrementToken", "", "end", "close", "reset", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nStandardTokenizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardTokenizer.kt\norg/gnit/lucenekmp/analysis/standard/StandardTokenizer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,181:1\n1#2:182\n*E\n"})
public final class StandardTokenizer
extends Tokenizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private StandardTokenizerImpl scanner;
    private int skippedPositions;
    private int maxTokenLength;
    @NotNull
    private final CharTermAttribute termAtt;
    @NotNull
    private final OffsetAttribute offsetAtt;
    @NotNull
    private final PositionIncrementAttribute posIncrAtt;
    @NotNull
    private final TypeAttribute typeAtt;
    public static final int ALPHANUM = 0;
    public static final int NUM = 1;
    public static final int SOUTHEAST_ASIAN = 2;
    public static final int IDEOGRAPHIC = 3;
    public static final int HIRAGANA = 4;
    public static final int KATAKANA = 5;
    public static final int HANGUL = 6;
    public static final int EMOJI = 7;
    @NotNull
    private static final String[] TOKEN_TYPES;
    public static final int MAX_TOKEN_LENGTH_LIMIT = 0x100000;

    public final void setMaxTokenLength(int length) {
        if (!(length >= 1)) {
            boolean $i$a$-require-StandardTokenizer$setMaxTokenLength$32 = false;
            String $i$a$-require-StandardTokenizer$setMaxTokenLength$32 = "maxTokenLength must be greater than zero";
            throw new IllegalArgumentException($i$a$-require-StandardTokenizer$setMaxTokenLength$32.toString());
        }
        if (!(length <= 0x100000)) {
            boolean bl = false;
            String string = "maxTokenLength may not exceed 1048576";
            throw new IllegalArgumentException(string.toString());
        }
        if (length != this.maxTokenLength) {
            this.maxTokenLength = length;
            StandardTokenizerImpl standardTokenizerImpl = this.scanner;
            if (standardTokenizerImpl == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"scanner");
                standardTokenizerImpl = null;
            }
            standardTokenizerImpl.setBufferSize(length);
        }
    }

    public final int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    public StandardTokenizer() {
        this.maxTokenLength = 255;
        this.termAtt = (CharTermAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(CharTermAttribute.class));
        this.offsetAtt = (OffsetAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(OffsetAttribute.class));
        this.posIncrAtt = (PositionIncrementAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(PositionIncrementAttribute.class));
        this.typeAtt = (TypeAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(TypeAttribute.class));
        this.init();
    }

    public StandardTokenizer(@NotNull AttributeFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        super(factory);
        this.maxTokenLength = 255;
        this.termAtt = (CharTermAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(CharTermAttribute.class));
        this.offsetAtt = (OffsetAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(OffsetAttribute.class));
        this.posIncrAtt = (PositionIncrementAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(PositionIncrementAttribute.class));
        this.typeAtt = (TypeAttribute)this.addAttribute(Reflection.getOrCreateKotlinClass(TypeAttribute.class));
        this.init();
    }

    private final void init() {
        this.scanner = new StandardTokenizerImpl(this.getInput());
    }

    @Override
    public boolean incrementToken() throws IOException {
        this.clearAttributes();
        this.skippedPositions = 0;
        while (true) {
            int tokenType;
            StandardTokenizerImpl standardTokenizerImpl;
            if ((standardTokenizerImpl = this.scanner) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"scanner");
                standardTokenizerImpl = null;
            }
            if ((tokenType = standardTokenizerImpl.getNextToken()) == -1) {
                return false;
            }
            StandardTokenizerImpl standardTokenizerImpl2 = this.scanner;
            if (standardTokenizerImpl2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"scanner");
                standardTokenizerImpl2 = null;
            }
            if (standardTokenizerImpl2.yylength() <= this.maxTokenLength) {
                this.posIncrAtt.setPositionIncrement(this.skippedPositions + 1);
                StandardTokenizerImpl standardTokenizerImpl3 = this.scanner;
                if (standardTokenizerImpl3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"scanner");
                    standardTokenizerImpl3 = null;
                }
                standardTokenizerImpl3.getText(this.termAtt);
                StandardTokenizerImpl standardTokenizerImpl4 = this.scanner;
                if (standardTokenizerImpl4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"scanner");
                    standardTokenizerImpl4 = null;
                }
                int start = standardTokenizerImpl4.yychar();
                this.offsetAtt.setOffset(this.correctOffset(start), this.correctOffset(start + this.termAtt.length()));
                this.typeAtt.setType(TOKEN_TYPES[tokenType]);
                return true;
            }
            int n = this.skippedPositions;
            this.skippedPositions = n + 1;
        }
    }

    @Override
    public void end() throws IOException {
        super.end();
        StandardTokenizerImpl standardTokenizerImpl = this.scanner;
        if (standardTokenizerImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanner");
            standardTokenizerImpl = null;
        }
        int n = standardTokenizerImpl.yychar();
        StandardTokenizerImpl standardTokenizerImpl2 = this.scanner;
        if (standardTokenizerImpl2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanner");
            standardTokenizerImpl2 = null;
        }
        int finalOffset = this.correctOffset(n + standardTokenizerImpl2.yylength());
        this.offsetAtt.setOffset(finalOffset, finalOffset);
        this.posIncrAtt.setPositionIncrement(this.posIncrAtt.getPositionIncrement() + this.skippedPositions);
    }

    @Override
    public void close() {
        super.close();
        StandardTokenizerImpl standardTokenizerImpl = this.scanner;
        if (standardTokenizerImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanner");
            standardTokenizerImpl = null;
        }
        standardTokenizerImpl.yyreset(this.getInput());
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        StandardTokenizerImpl standardTokenizerImpl = this.scanner;
        if (standardTokenizerImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"scanner");
            standardTokenizerImpl = null;
        }
        standardTokenizerImpl.yyreset(this.getInput());
        this.skippedPositions = 0;
    }

    static {
        String[] stringArray = new String[]{"<ALPHANUM>", "<NUM>", "<SOUTHEAST_ASIAN>", "<IDEOGRAPHIC>", "<HIRAGANA>", "<KATAKANA>", "<HANGUL>", "<EMOJI>"};
        TOKEN_TYPES = stringArray;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0019\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\n\n\u0002\u0010\u0012\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/analysis/standard/StandardTokenizer$Companion;", "", "<init>", "()V", "ALPHANUM", "", "NUM", "SOUTHEAST_ASIAN", "IDEOGRAPHIC", "HIRAGANA", "KATAKANA", "HANGUL", "EMOJI", "TOKEN_TYPES", "", "", "getTOKEN_TYPES", "()[Ljava/lang/String;", "[Ljava/lang/String;", "MAX_TOKEN_LENGTH_LIMIT", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getTOKEN_TYPES() {
            return TOKEN_TYPES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

