/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.analysis.tokenattributes;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.reflect.KClass;
import org.gnit.lucenekmp.analysis.tokenattributes.CharTermAttribute;
import org.gnit.lucenekmp.analysis.tokenattributes.TermToBytesRefAttribute;
import org.gnit.lucenekmp.jdkport.CharBuffer;
import org.gnit.lucenekmp.jdkport.Objects;
import org.gnit.lucenekmp.jdkport.StringBuffer;
import org.gnit.lucenekmp.jdkport.StringExtKt;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.Attribute;
import org.gnit.lucenekmp.util.AttributeImpl;
import org.gnit.lucenekmp.util.AttributeReflector;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.BytesRefBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 >2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001>B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0010\u001a\u00020\u0001H\u0014J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\tH\u0016J\b\u0010\u0013\u001a\u00020\u0007H\u0016J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\tH\u0002J\u0010\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\tH\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0002H\u0016J\u0011\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\tH\u0096\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\tH\u0016J\u0012\u0010(\u001a\u00020\u00022\b\u0010)\u001a\u0004\u0018\u00010%H\u0016J\"\u0010(\u001a\u00020\u00022\b\u0010)\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\t2\u0006\u0010'\u001a\u00020\tH\u0016J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010*\u001a\u00020\"H\u0016J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,H\u0016J\u0014\u0010(\u001a\u00020\u00022\n\u0010+\u001a\u00060-j\u0002`.H\u0016J\u0010\u0010(\u001a\u00020\u00022\u0006\u0010/\u001a\u00020\u0002H\u0016J\n\u00100\u001a\u0004\u0018\u00010\u0002H\u0002J\b\u00101\u001a\u00020\tH\u0016J\b\u00102\u001a\u00020\u0012H\u0016J\b\u00103\u001a\u00020\u0000H\u0016J\u0013\u00104\u001a\u0002052\b\u00106\u001a\u0004\u0018\u000107H\u0096\u0002J\b\u00108\u001a\u00020,H\u0016J\u0010\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020;H\u0016J\u0010\u0010<\u001a\u00020\u00122\u0006\u0010=\u001a\u00020\u0001H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u0015\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \u00a8\u0006?"}, d2={"Lorg/gnit/lucenekmp/analysis/tokenattributes/CharTermAttributeImpl;", "Lorg/gnit/lucenekmp/util/AttributeImpl;", "Lorg/gnit/lucenekmp/analysis/tokenattributes/CharTermAttribute;", "Lorg/gnit/lucenekmp/analysis/tokenattributes/TermToBytesRefAttribute;", "<init>", "()V", "termBuffer", "", "termLength", "", "builder", "Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "getBuilder", "()Lorg/gnit/lucenekmp/util/BytesRefBuilder;", "setBuilder", "(Lorg/gnit/lucenekmp/util/BytesRefBuilder;)V", "newInstance", "copyBuffer", "", "buffer", "offset", "length", "resizeBuffer", "newSize", "growTermBuffer", "setLength", "setEmpty", "bytesRef", "Lorg/gnit/lucenekmp/util/BytesRef;", "getBytesRef", "()Lorg/gnit/lucenekmp/util/BytesRef;", "getLength", "()I", "get", "", "index", "subSequence", "", "start", "end", "append", "csq", "c", "s", "", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "ta", "appendNull", "hashCode", "clear", "clone", "equals", "", "other", "", "toString", "reflectWith", "reflector", "Lorg/gnit/lucenekmp/util/AttributeReflector;", "copyTo", "target", "Companion", "core"})
public class CharTermAttributeImpl
extends AttributeImpl
implements CharTermAttribute,
TermToBytesRefAttribute {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private char[] termBuffer = new char[ArrayUtil.Companion.oversize(10, 2)];
    private int termLength;
    @NotNull
    private BytesRefBuilder builder = new BytesRefBuilder();
    private static final int MIN_BUFFER_SIZE = 10;

    @NotNull
    protected final BytesRefBuilder getBuilder() {
        return this.builder;
    }

    protected final void setBuilder(@NotNull BytesRefBuilder bytesRefBuilder) {
        Intrinsics.checkNotNullParameter((Object)bytesRefBuilder, (String)"<set-?>");
        this.builder = bytesRefBuilder;
    }

    @Override
    @NotNull
    protected AttributeImpl newInstance() {
        return new CharTermAttributeImpl();
    }

    @Override
    public void copyBuffer(@NotNull char[] buffer, int offset, int length) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.growTermBuffer(length);
        ArraysKt.copyInto((char[])buffer, (char[])this.termBuffer, (int)0, (int)offset, (int)length);
        this.termLength = length;
    }

    @Override
    @NotNull
    public char[] buffer() {
        return this.termBuffer;
    }

    @Override
    @NotNull
    public char[] resizeBuffer(int newSize) {
        if (this.termBuffer.length < newSize) {
            char[] newCharBuffer = new char[ArrayUtil.Companion.oversize(newSize, 2)];
            ArraysKt.copyInto((char[])this.termBuffer, (char[])newCharBuffer, (int)0, (int)0, (int)this.termLength);
            this.termBuffer = newCharBuffer;
        }
        return this.termBuffer;
    }

    private final void growTermBuffer(int newSize) {
        if (this.termBuffer.length < newSize) {
            this.termBuffer = new char[ArrayUtil.Companion.oversize(newSize, 2)];
        }
    }

    @Override
    @NotNull
    public CharTermAttribute setLength(int length) {
        Objects.INSTANCE.checkFromIndexSize(0, length, this.termBuffer.length);
        this.termLength = length;
        return this;
    }

    @Override
    @Nullable
    public CharTermAttribute setEmpty() {
        this.termLength = 0;
        return this;
    }

    @Override
    @NotNull
    public BytesRef getBytesRef() {
        this.builder.copyChars(this.termBuffer, 0, this.termLength);
        return this.builder.get();
    }

    public int getLength() {
        return this.termLength;
    }

    public char get(int index) {
        Objects.INSTANCE.checkIndex(index, this.termLength);
        return this.termBuffer[index];
    }

    @Override
    @NotNull
    public CharSequence subSequence(int start, int end) {
        Objects.INSTANCE.checkFromToIndex(start, end, this.termLength);
        return StringExtKt.fromCharArray(StringCompanionObject.INSTANCE, this.termBuffer, start, end - start);
    }

    @Override
    @NotNull
    public CharTermAttribute append(@Nullable CharSequence csq) {
        if (csq == null) {
            CharTermAttribute charTermAttribute = this.appendNull();
            Intrinsics.checkNotNull((Object)charTermAttribute);
            return charTermAttribute;
        }
        return this.append(csq, 0, csq.length());
    }

    @Override
    @NotNull
    public CharTermAttribute append(@Nullable CharSequence csq, int start, int end) {
        CharSequence csq2 = csq;
        int start2 = start;
        if (csq2 == null) {
            csq2 = "null";
        }
        Objects.INSTANCE.checkFromToIndex(start2, end, csq2.length());
        int len = end - start2;
        if (len == 0) {
            return this;
        }
        this.resizeBuffer(this.termLength + len);
        if (len > 4) {
            if (csq2 instanceof String) {
                String string = (String)csq2;
                char[] cArray = this.termBuffer;
                int n = this.termLength;
                string.getChars(start2, end, cArray, n);
            } else if (csq2 instanceof StringBuilder) {
                ((StringBuilder)csq2).getChars(start2, end, this.termBuffer, this.termLength);
            } else if (csq2 instanceof CharTermAttribute) {
                ArraysKt.copyInto((char[])((CharTermAttribute)csq2).buffer(), (char[])this.termBuffer, (int)this.termLength, (int)start2, (int)end);
            } else if (csq2 instanceof CharBuffer && ((CharBuffer)csq2).hasArray()) {
                ArraysKt.copyInto((char[])((CharBuffer)csq2).array(), (char[])this.termBuffer, (int)this.termLength, (int)(((CharBuffer)csq2).arrayOffset() + ((CharBuffer)csq2).position() + start2), (int)(((CharBuffer)csq2).arrayOffset() + ((CharBuffer)csq2).position() + end));
            } else if (csq2 instanceof StringBuffer) {
                ((StringBuffer)csq2).getChars(start2, end, this.termBuffer, this.termLength);
            } else {
                while (start2 < end) {
                    int n = this.termLength;
                    this.termLength = n + 1;
                    this.termBuffer[n] = csq2.charAt(start2++);
                }
                return this;
            }
            this.termLength += len;
            return this;
        }
        while (start2 < end) {
            int n = this.termLength;
            this.termLength = n + 1;
            this.termBuffer[n] = csq2.charAt(start2++);
        }
        return this;
    }

    @Override
    @NotNull
    public CharTermAttribute append(char c) {
        int n = this.termLength;
        this.termLength = n + 1;
        this.resizeBuffer((int)(this.termLength + 1))[n] = c;
        return this;
    }

    @Override
    @NotNull
    public CharTermAttribute append(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        int len = s.length();
        String string = s;
        char[] cArray = this.resizeBuffer(this.termLength + len);
        int n = this.termLength;
        int n2 = 0;
        string.getChars(n2, len, cArray, n);
        this.termLength += len;
        return this;
    }

    @Override
    @NotNull
    public CharTermAttribute append(@NotNull StringBuilder s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        int len = s.length();
        s.getChars(0, len, this.resizeBuffer(this.termLength + len), this.termLength);
        this.termLength += len;
        return this;
    }

    @Override
    @NotNull
    public CharTermAttribute append(@NotNull CharTermAttribute ta) {
        Intrinsics.checkNotNullParameter((Object)ta, (String)"ta");
        int len = ta.length();
        ArraysKt.copyInto((char[])ta.buffer(), (char[])this.resizeBuffer(this.termLength + len), (int)this.termLength, (int)0, (int)len);
        this.termLength += len;
        return this;
    }

    private final CharTermAttribute appendNull() {
        this.resizeBuffer(this.termLength + 4);
        int n = this.termLength;
        this.termLength = n + 1;
        this.termBuffer[n] = 110;
        n = this.termLength;
        this.termLength = n + 1;
        this.termBuffer[n] = 117;
        n = this.termLength;
        this.termLength = n + 1;
        this.termBuffer[n] = 108;
        n = this.termLength;
        this.termLength = n + 1;
        this.termBuffer[n] = 108;
        return this;
    }

    public int hashCode() {
        int code = this.termLength;
        code = code * 31 + ArrayUtil.Companion.hashCode(this.termBuffer, 0, this.termLength);
        return code;
    }

    @Override
    public void clear() {
        this.termLength = 0;
    }

    @Override
    @NotNull
    public CharTermAttributeImpl clone() {
        AttributeImpl attributeImpl = super.clone();
        Intrinsics.checkNotNull((Object)attributeImpl, (String)"null cannot be cast to non-null type org.gnit.lucenekmp.analysis.tokenattributes.CharTermAttributeImpl");
        CharTermAttributeImpl t = (CharTermAttributeImpl)attributeImpl;
        t.termBuffer = new char[this.termLength];
        ArraysKt.copyInto((char[])this.termBuffer, (char[])t.termBuffer, (int)0, (int)0, (int)this.termLength);
        t.builder = new BytesRefBuilder();
        t.builder.copyBytes(this.builder.get());
        return t;
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof CharTermAttributeImpl) {
            Object o = other;
            if (this.termLength != ((CharTermAttributeImpl)o).termLength) {
                return false;
            }
            int n = this.termLength;
            for (int i = 0; i < n; ++i) {
                if (this.termBuffer[i] == ((CharTermAttributeImpl)o).termBuffer[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String toString() {
        return StringExtKt.fromCharArray(StringCompanionObject.INSTANCE, this.termBuffer, 0, this.termLength);
    }

    @Override
    public void reflectWith(@NotNull AttributeReflector reflector) {
        Intrinsics.checkNotNullParameter((Object)reflector, (String)"reflector");
        reflector.reflect((KClass<? extends Attribute>)Reflection.getOrCreateKotlinClass(CharTermAttribute.class), "term", this.toString());
        reflector.reflect((KClass<? extends Attribute>)Reflection.getOrCreateKotlinClass(TermToBytesRefAttribute.class), "bytes", this.getBytesRef());
    }

    @Override
    public void copyTo(@NotNull AttributeImpl target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        CharTermAttribute t = (CharTermAttribute)((Object)target);
        t.copyBuffer(this.termBuffer, 0, this.termLength);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/gnit/lucenekmp/analysis/tokenattributes/CharTermAttributeImpl$Companion;", "", "<init>", "()V", "MIN_BUFFER_SIZE", "", "core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

