/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.ByteCompanionObject;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import org.gnit.lucenekmp.index.Impact;
import org.gnit.lucenekmp.jdkport.Arrays;
import org.gnit.lucenekmp.jdkport.ByteExtKt;
import org.gnit.lucenekmp.jdkport.IntExtKt;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.SortedSet;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.jdkport.TreeSet;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0000J\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014J\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\b2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/gnit/lucenekmp/codecs/CompetitiveImpactAccumulator;", "", "<init>", "()V", "maxFreqs", "", "otherFreqNormPairs", "Lorg/gnit/lucenekmp/jdkport/TreeSet;", "Lorg/gnit/lucenekmp/index/Impact;", "clear", "", "add", "freq", "", "norm", "", "addAll", "acc", "copy", "getCompetitiveFreqNormPairs", "", "newEntry", "freqNormPairs", "toString", "", "assertConsistent", "", "core"})
public final class CompetitiveImpactAccumulator {
    @NotNull
    private final int[] maxFreqs = new int[256];
    @NotNull
    private final TreeSet<Impact> otherFreqNormPairs = new TreeSet(CompetitiveImpactAccumulator::otherFreqNormPairs$lambda$0);

    public final void clear() {
        Arrays.INSTANCE.fill(this.maxFreqs, 0);
        this.otherFreqNormPairs.clear();
        if (!this.assertConsistent()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void add(int freq, long norm) {
        if (norm >= -128L && norm <= 127L) {
            int index = ByteExtKt.toUnsignedInt(ByteCompanionObject.INSTANCE, (byte)norm);
            this.maxFreqs[index] = Math.max(this.maxFreqs[index], freq);
        } else {
            this.add(new Impact(freq, norm), this.otherFreqNormPairs);
        }
        if (!this.assertConsistent()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void addAll(@NotNull CompetitiveImpactAccumulator acc) {
        Intrinsics.checkNotNullParameter((Object)acc, (String)"acc");
        int[] maxFreqs = this.maxFreqs;
        int[] otherMaxFreqs = acc.maxFreqs;
        int n = maxFreqs.length;
        for (int i = 0; i < n; ++i) {
            maxFreqs[i] = Math.max(maxFreqs[i], otherMaxFreqs[i]);
        }
        for (Impact entry : acc.otherFreqNormPairs) {
            this.add(entry, this.otherFreqNormPairs);
        }
        if (!this.assertConsistent()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final void copy(@NotNull CompetitiveImpactAccumulator acc) {
        Intrinsics.checkNotNullParameter((Object)acc, (String)"acc");
        int[] maxFreqs = this.maxFreqs;
        int[] otherMaxFreqs = acc.maxFreqs;
        System.INSTANCE.arraycopy(otherMaxFreqs, 0, maxFreqs, 0, maxFreqs.length);
        this.otherFreqNormPairs.clear();
        this.otherFreqNormPairs.addAll((Collection<Impact>)acc.otherFreqNormPairs);
        if (!this.assertConsistent()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final List<Impact> getCompetitiveFreqNormPairs() {
        List impacts2 = new ArrayList();
        int maxFreqForLowerNorms = 0;
        int n = this.maxFreqs.length;
        for (int i = 0; i < n; ++i) {
            int maxFreq = this.maxFreqs[i];
            if (maxFreq <= maxFreqForLowerNorms) continue;
            impacts2.add(new Impact(maxFreq, i));
            maxFreqForLowerNorms = maxFreq;
        }
        if (this.otherFreqNormPairs.isEmpty()) {
            return impacts2;
        }
        TreeSet<Impact> freqNormPairs = new TreeSet<Impact>((SortedSet)this.otherFreqNormPairs);
        for (Impact impact : impacts2) {
            this.add(impact, freqNormPairs);
        }
        return CollectionsKt.toMutableList((Collection)freqNormPairs);
    }

    private final void add(Impact newEntry, TreeSet<Impact> freqNormPairs) {
        Impact entry;
        Impact next = freqNormPairs.ceiling(newEntry);
        if (next == null) {
            v0 = freqNormPairs.add(newEntry);
        } else {
            if (LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, next.getNorm(), newEntry.getNorm()) <= 0) {
                return;
            }
            v0 = freqNormPairs.add(newEntry);
        }
        Iterator<Impact> it = freqNormPairs.headSet(newEntry, false).descendingIterator();
        while (it.hasNext() && LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, (entry = it.next()).getNorm(), newEntry.getNorm()) >= 0) {
            it.remove();
        }
    }

    @NotNull
    public String toString() {
        String string = new ArrayList(this.getCompetitiveFreqNormPairs()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final boolean assertConsistent() {
        int previousFreq = 0;
        long previousNorm = 0L;
        for (Impact impact : this.otherFreqNormPairs) {
            if (!(impact.getNorm() < -128L || impact.getNorm() > 127L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(previousFreq < impact.getFreq())) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, previousNorm, impact.getNorm()) < 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            previousFreq = impact.getFreq();
            previousNorm = impact.getNorm();
        }
        return true;
    }

    private static final int otherFreqNormPairs$lambda$0(Impact o1, Impact o2) {
        Intrinsics.checkNotNullParameter((Object)o1, (String)"o1");
        Intrinsics.checkNotNullParameter((Object)o2, (String)"o2");
        int cmp = IntExtKt.compare(IntCompanionObject.INSTANCE, o1.getFreq(), o2.getFreq());
        if (cmp == 0) {
            cmp = LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, o2.getNorm(), o1.getNorm());
        }
        return cmp;
    }
}

