/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.PointsReader;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.MergeState;
import org.gnit.lucenekmp.index.PointValues;
import org.gnit.lucenekmp.search.DocIdSetIterator;
import org.gnit.lucenekmp.util.IntsRef;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00060\u0001j\u0002`\u0002B\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0004J\u0010\u0010\u000e\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000f\u001a\u00020\u0006H&\u00a8\u0006\u0010"}, d2={"Lorg/gnit/lucenekmp/codecs/PointsWriter;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "writeField", "", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "values", "Lorg/gnit/lucenekmp/codecs/PointsReader;", "mergeOneField", "mergeState", "Lorg/gnit/lucenekmp/index/MergeState;", "merge", "finish", "core"})
public abstract class PointsWriter
implements AutoCloseable {
    protected PointsWriter() {
    }

    public abstract void writeField(@NotNull FieldInfo var1, @NotNull PointsReader var2) throws IOException;

    protected final void mergeOneField(@NotNull MergeState mergeState, @NotNull FieldInfo fieldInfo) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        long maxPointCount = 0L;
        int n = mergeState.getPointsReaders().length;
        for (int i = 0; i < n; ++i) {
            PointValues values2;
            PointsReader pointsReader2 = mergeState.getPointsReaders()[i];
            if (pointsReader2 == null) continue;
            FieldInfos fieldInfos = mergeState.getFieldInfos()[i];
            Intrinsics.checkNotNull((Object)fieldInfos);
            FieldInfo readerFieldInfo = fieldInfos.fieldInfo(fieldInfo.getName());
            if (readerFieldInfo == null || readerFieldInfo.getPointDimensionCount() <= 0 || (values2 = pointsReader2.getValues(fieldInfo.getName())) == null) continue;
            maxPointCount += values2.size();
        }
        long finalMaxPointCount = maxPointCount;
        this.writeField(fieldInfo, new PointsReader(fieldInfo, finalMaxPointCount, mergeState){
            final /* synthetic */ FieldInfo $fieldInfo;
            final /* synthetic */ long $finalMaxPointCount;
            final /* synthetic */ MergeState $mergeState;
            {
                this.$fieldInfo = $fieldInfo;
                this.$finalMaxPointCount = $finalMaxPointCount;
                this.$mergeState = $mergeState;
            }

            public void close() throws IOException {
            }

            public PointValues getValues(String fieldName) {
                Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
                if (!Intrinsics.areEqual((Object)fieldName, (Object)this.$fieldInfo.getName())) {
                    boolean bl = false;
                    String string = "field name must match the field being merged";
                    throw new IllegalArgumentException(string.toString());
                }
                return new PointValues(this.$finalMaxPointCount, this.$mergeState, fieldName){
                    final /* synthetic */ long $finalMaxPointCount;
                    final /* synthetic */ MergeState $mergeState;
                    final /* synthetic */ String $fieldName;
                    {
                        this.$finalMaxPointCount = $finalMaxPointCount;
                        this.$mergeState = $mergeState;
                        this.$fieldName = $fieldName;
                    }

                    public PointValues.PointTree getPointTree() {
                        return new PointValues.PointTree(this.$finalMaxPointCount, this.$mergeState, this.$fieldName){
                            final /* synthetic */ long $finalMaxPointCount;
                            final /* synthetic */ MergeState $mergeState;
                            final /* synthetic */ String $fieldName;
                            {
                                this.$finalMaxPointCount = $finalMaxPointCount;
                                this.$mergeState = $mergeState;
                                this.$fieldName = $fieldName;
                            }

                            public PointValues.PointTree clone() {
                                throw new UnsupportedOperationException();
                            }

                            public boolean moveToChild() {
                                return false;
                            }

                            public boolean moveToSibling() {
                                return false;
                            }

                            public boolean moveToParent() {
                                return false;
                            }

                            public byte[] getMinPackedValue() {
                                throw new UnsupportedOperationException();
                            }

                            public byte[] getMaxPackedValue() {
                                throw new UnsupportedOperationException();
                            }

                            public long size() {
                                return this.$finalMaxPointCount;
                            }

                            public void visitDocIDs(PointValues.IntersectVisitor visitor2) {
                                Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
                                throw new UnsupportedOperationException();
                            }

                            public void visitDocValues(PointValues.IntersectVisitor mergedVisitor) throws IOException {
                                Intrinsics.checkNotNullParameter((Object)mergedVisitor, (String)"mergedVisitor");
                                int n = this.$mergeState.getPointsReaders().length;
                                for (int i = 0; i < n; ++i) {
                                    PointValues values2;
                                    PointsReader pointsReader2 = this.$mergeState.getPointsReaders()[i];
                                    if (pointsReader2 == null) continue;
                                    FieldInfos fieldInfos = this.$mergeState.getFieldInfos()[i];
                                    Intrinsics.checkNotNull((Object)fieldInfos);
                                    FieldInfo readerFieldInfo = fieldInfos.fieldInfo(this.$fieldName);
                                    if (readerFieldInfo == null || readerFieldInfo.getPointDimensionCount() == 0 || (values2 = pointsReader2.getValues(this.$fieldName)) == null) continue;
                                    MergeState.DocMap[] docMapArray = this.$mergeState.getDocMaps();
                                    Intrinsics.checkNotNull((Object)docMapArray);
                                    MergeState.DocMap docMap = docMapArray[i];
                                    values2.getPointTree().visitDocValues(new PointValues.IntersectVisitor(docMap, mergedVisitor){
                                        final /* synthetic */ MergeState.DocMap $docMap;
                                        final /* synthetic */ PointValues.IntersectVisitor $mergedVisitor;
                                        {
                                            this.$docMap = $docMap;
                                            this.$mergedVisitor = $mergedVisitor;
                                        }

                                        public void visit(int docID) {
                                            throw new IllegalStateException();
                                        }

                                        public void visit(int docID, byte[] packedValue) throws IOException {
                                            Intrinsics.checkNotNullParameter((Object)packedValue, (String)"packedValue");
                                            int newDocID = this.$docMap.get(docID);
                                            if (newDocID != -1) {
                                                this.$mergedVisitor.visit(newDocID, packedValue);
                                            }
                                        }

                                        public PointValues.Relation compare(byte[] minPackedValue, byte[] maxPackedValue) {
                                            Intrinsics.checkNotNullParameter((Object)minPackedValue, (String)"minPackedValue");
                                            Intrinsics.checkNotNullParameter((Object)maxPackedValue, (String)"maxPackedValue");
                                            return PointValues.Relation.CELL_CROSSES_QUERY;
                                        }

                                        public void visit(DocIdSetIterator iterator2) throws IOException {
                                            PointValues.IntersectVisitor.super.visit(iterator2);
                                        }

                                        public void visit(IntsRef ref) throws IOException {
                                            PointValues.IntersectVisitor.super.visit(ref);
                                        }

                                        public void visit(DocIdSetIterator iterator2, byte[] packedValue) throws IOException {
                                            PointValues.IntersectVisitor.super.visit(iterator2, packedValue);
                                        }

                                        public void grow(int count) {
                                            PointValues.IntersectVisitor.super.grow(count);
                                        }
                                    });
                                }
                            }
                        };
                    }

                    public byte[] getMinPackedValue() {
                        throw new UnsupportedOperationException();
                    }

                    public byte[] getMaxPackedValue() {
                        throw new UnsupportedOperationException();
                    }

                    public int getNumDimensions() {
                        throw new UnsupportedOperationException();
                    }

                    public int getNumIndexDimensions() {
                        throw new UnsupportedOperationException();
                    }

                    public int getBytesPerDimension() {
                        throw new UnsupportedOperationException();
                    }

                    public long size() {
                        return this.$finalMaxPointCount;
                    }

                    public int getDocCount() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            public void checkIntegrity() throws IOException {
                throw new UnsupportedOperationException();
            }
        });
    }

    public void merge(@NotNull MergeState mergeState) throws IOException {
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        PointsReader[] pointsReaderArray = mergeState.getPointsReaders();
        int n = pointsReaderArray.length;
        for (int i = 0; i < n; ++i) {
            PointsReader reader2;
            PointsReader pointsReader2 = reader2 = pointsReaderArray[i];
            if (pointsReader2 == null) continue;
            pointsReader2.checkIntegrity();
        }
        FieldInfos fieldInfos = mergeState.getMergeFieldInfos();
        Intrinsics.checkNotNull((Object)fieldInfos);
        for (FieldInfo fieldInfo : fieldInfos) {
            if (fieldInfo.getPointDimensionCount() == 0) continue;
            this.mergeOneField(mergeState, fieldInfo);
        }
        this.finish();
    }

    public abstract void finish() throws IOException;
}

