/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs;

import java.io.IOException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.gnit.lucenekmp.codecs.FieldsConsumer;
import org.gnit.lucenekmp.codecs.FieldsProducer;
import org.gnit.lucenekmp.codecs.lucene101.Lucene101PostingsFormat;
import org.gnit.lucenekmp.index.SegmentReadState;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.jdkport.ClassLoader;
import org.gnit.lucenekmp.util.NamedSPILoader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH&J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\u0003H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lorg/gnit/lucenekmp/codecs/PostingsFormat;", "Lorg/gnit/lucenekmp/util/NamedSPILoader$NamedSPI;", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "fieldsConsumer", "Lorg/gnit/lucenekmp/codecs/FieldsConsumer;", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "fieldsProducer", "Lorg/gnit/lucenekmp/codecs/FieldsProducer;", "Lorg/gnit/lucenekmp/index/SegmentReadState;", "toString", "Holder", "Companion", "core"})
public abstract class PostingsFormat
implements NamedSPILoader.NamedSPI {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private static final PostingsFormat[] EMPTY = new PostingsFormat[0];

    protected PostingsFormat(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        NamedSPILoader.Companion.checkServiceName(this.getName());
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public abstract FieldsConsumer fieldsConsumer(@NotNull SegmentWriteState var1) throws IOException;

    @NotNull
    public abstract FieldsProducer fieldsProducer(@NotNull SegmentReadState var1) throws IOException;

    @NotNull
    public String toString() {
        return "PostingsFormat(name=" + this.getName() + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0019\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/gnit/lucenekmp/codecs/PostingsFormat$Companion;", "", "<init>", "()V", "EMPTY", "", "Lorg/gnit/lucenekmp/codecs/PostingsFormat;", "getEMPTY", "()[Lorg/gnit/lucenekmp/codecs/PostingsFormat;", "[Lorg/gnit/lucenekmp/codecs/PostingsFormat;", "forName", "name", "", "availablePostingsFormats", "", "reloadPostingsFormats", "", "classloader", "Lorg/gnit/lucenekmp/jdkport/ClassLoader;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PostingsFormat[] getEMPTY() {
            return EMPTY;
        }

        @NotNull
        public final PostingsFormat forName(@NotNull String name) {
            PostingsFormat postingsFormat2;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            if (Intrinsics.areEqual((Object)name, (Object)"Lucene101")) {
                postingsFormat2 = new Lucene101PostingsFormat(0, 0, 0, 7, null);
            } else {
                PostingsFormat postingsFormat3;
                try {
                    postingsFormat3 = Holder.INSTANCE.getLoader().lookup(name);
                }
                catch (Throwable e) {
                    throw new UnsupportedOperationException("PostingsFormat '" + name + "' is not available. Known built-ins: [Lucene101].", e);
                }
                postingsFormat2 = postingsFormat3;
            }
            return postingsFormat2;
        }

        @NotNull
        public final Set<String> availablePostingsFormats() {
            return Holder.INSTANCE.getLoader().availableServices();
        }

        public final void reloadPostingsFormats(@NotNull ClassLoader classloader) {
            Intrinsics.checkNotNullParameter((Object)classloader, (String)"classloader");
            throw new NotImplementedError(null, 1, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/gnit/lucenekmp/codecs/PostingsFormat$Holder;", "", "<init>", "()V", "LOADER", "Lorg/gnit/lucenekmp/util/NamedSPILoader;", "Lorg/gnit/lucenekmp/codecs/PostingsFormat;", "loader", "getLoader", "()Lorg/gnit/lucenekmp/util/NamedSPILoader;", "core"})
    private static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();
        @NotNull
        private static final NamedSPILoader<PostingsFormat> LOADER = new NamedSPILoader(Reflection.getOrCreateKotlinClass(PostingsFormat.class), null, 2, null);

        private Holder() {
        }

        @NotNull
        public final NamedSPILoader<PostingsFormat> getLoader() {
            if (LOADER == null) {
                boolean bl = false;
                String string = "You tried to lookup a PostingsFormat by name before all formats could be initialized. This likely happens if you call PostingsFormat#forName from a PostingsFormat's ctor.";
                throw new IllegalStateException(string.toString());
            }
            return LOADER;
        }
    }
}

