/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.BlockTermState;
import org.gnit.lucenekmp.codecs.NormsProducer;
import org.gnit.lucenekmp.codecs.PostingsWriterBase;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.IndexOptions;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.PostingsEnum;
import org.gnit.lucenekmp.index.TermsEnum;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010#\u001a\u00020$H&J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H&J\u0010\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020$H&J\u0010\u0010+\u001a\u00020&2\u0006\u0010\b\u001a\u00020\tH\u0016J*\u0010,\u001a\u0004\u0018\u00010$2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010'\u001a\u000203H\u0016J\u0018\u00104\u001a\u00020&2\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u0007H&J*\u00107\u001a\u00020&2\u0006\u00108\u001a\u00020\u00072\b\u00109\u001a\u0004\u0018\u00010.2\u0006\u0010:\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u0007H&J\b\u0010<\u001a\u00020&H&R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0017\"\u0004\b\u001c\u0010\u0019R\u001a\u0010\u001d\u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u0019R\u001a\u0010 \u001a\u00020\u0015X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0017\"\u0004\b\"\u0010\u0019\u00a8\u0006="}, d2={"Lorg/gnit/lucenekmp/codecs/PushPostingsWriterBase;", "Lorg/gnit/lucenekmp/codecs/PostingsWriterBase;", "<init>", "()V", "postingsEnum", "Lorg/gnit/lucenekmp/index/PostingsEnum;", "enumFlags", "", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "getFieldInfo", "()Lorg/gnit/lucenekmp/index/FieldInfo;", "setFieldInfo", "(Lorg/gnit/lucenekmp/index/FieldInfo;)V", "indexOptions", "Lorg/gnit/lucenekmp/index/IndexOptions;", "getIndexOptions", "()Lorg/gnit/lucenekmp/index/IndexOptions;", "setIndexOptions", "(Lorg/gnit/lucenekmp/index/IndexOptions;)V", "writeFreqs", "", "getWriteFreqs", "()Z", "setWriteFreqs", "(Z)V", "writePositions", "getWritePositions", "setWritePositions", "writePayloads", "getWritePayloads", "setWritePayloads", "writeOffsets", "getWriteOffsets", "setWriteOffsets", "newTermState", "Lorg/gnit/lucenekmp/codecs/BlockTermState;", "startTerm", "", "norms", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "finishTerm", "state", "setField", "writeTerm", "term", "Lorg/gnit/lucenekmp/util/BytesRef;", "termsEnum", "Lorg/gnit/lucenekmp/index/TermsEnum;", "docsSeen", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "Lorg/gnit/lucenekmp/codecs/NormsProducer;", "startDoc", "docID", "freq", "addPosition", "position", "payload", "startOffset", "endOffset", "finishDoc", "core"})
public abstract class PushPostingsWriterBase
extends PostingsWriterBase {
    @Nullable
    private PostingsEnum postingsEnum;
    private int enumFlags;
    @Nullable
    private FieldInfo fieldInfo;
    @Nullable
    private IndexOptions indexOptions;
    private boolean writeFreqs;
    private boolean writePositions;
    private boolean writePayloads;
    private boolean writeOffsets;

    protected PushPostingsWriterBase() {
    }

    @Nullable
    protected final FieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    protected final void setFieldInfo(@Nullable FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
    }

    @Nullable
    protected final IndexOptions getIndexOptions() {
        return this.indexOptions;
    }

    protected final void setIndexOptions(@Nullable IndexOptions indexOptions) {
        this.indexOptions = indexOptions;
    }

    protected final boolean getWriteFreqs() {
        return this.writeFreqs;
    }

    protected final void setWriteFreqs(boolean bl) {
        this.writeFreqs = bl;
    }

    protected final boolean getWritePositions() {
        return this.writePositions;
    }

    protected final void setWritePositions(boolean bl) {
        this.writePositions = bl;
    }

    protected final boolean getWritePayloads() {
        return this.writePayloads;
    }

    protected final void setWritePayloads(boolean bl) {
        this.writePayloads = bl;
    }

    protected final boolean getWriteOffsets() {
        return this.writeOffsets;
    }

    protected final void setWriteOffsets(boolean bl) {
        this.writeOffsets = bl;
    }

    @NotNull
    public abstract BlockTermState newTermState() throws IOException;

    public abstract void startTerm(@NotNull NumericDocValues var1) throws IOException;

    public abstract void finishTerm(@NotNull BlockTermState var1) throws IOException;

    @Override
    public void setField(@NotNull FieldInfo fieldInfo) {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        this.fieldInfo = fieldInfo;
        IndexOptions indexOptions = this.indexOptions = fieldInfo.getIndexOptions();
        Intrinsics.checkNotNull((Object)((Object)indexOptions));
        this.writeFreqs = indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS) >= 0;
        IndexOptions indexOptions2 = this.indexOptions;
        Intrinsics.checkNotNull((Object)((Object)indexOptions2));
        this.writePositions = indexOptions2.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        IndexOptions indexOptions3 = this.indexOptions;
        Intrinsics.checkNotNull((Object)((Object)indexOptions3));
        this.writeOffsets = indexOptions3.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        this.writePayloads = fieldInfo.hasPayloads();
        this.enumFlags = !this.writeFreqs ? 0 : (!this.writePositions ? (int)PostingsEnum.Companion.getFREQS() : (!this.writeOffsets ? (this.writePayloads ? (int)PostingsEnum.Companion.getPAYLOADS() : (int)PostingsEnum.Companion.getPOSITIONS()) : (this.writePayloads ? (int)((short)(PostingsEnum.Companion.getPAYLOADS() | PostingsEnum.Companion.getOFFSETS())) : (int)PostingsEnum.Companion.getOFFSETS())));
    }

    @Override
    @Nullable
    public BlockTermState writeTerm(@NotNull BytesRef term, @NotNull TermsEnum termsEnum, @NotNull FixedBitSet docsSeen, @NotNull NormsProducer norms) throws IOException {
        NumericDocValues normValues;
        NumericDocValues numericDocValues;
        Intrinsics.checkNotNullParameter((Object)term, (String)"term");
        Intrinsics.checkNotNullParameter((Object)termsEnum, (String)"termsEnum");
        Intrinsics.checkNotNullParameter((Object)docsSeen, (String)"docsSeen");
        Intrinsics.checkNotNullParameter((Object)norms, (String)"norms");
        FieldInfo fieldInfo = this.fieldInfo;
        Intrinsics.checkNotNull((Object)fieldInfo);
        if (!fieldInfo.hasNorms()) {
            numericDocValues = null;
        } else {
            FieldInfo fieldInfo2 = this.fieldInfo;
            Intrinsics.checkNotNull((Object)fieldInfo2);
            numericDocValues = norms.getNorms(fieldInfo2);
        }
        NumericDocValues numericDocValues2 = normValues = numericDocValues;
        Intrinsics.checkNotNull((Object)numericDocValues2);
        this.startTerm(numericDocValues2);
        this.postingsEnum = termsEnum.postings(this.postingsEnum, this.enumFlags);
        if (this.postingsEnum == null) {
            String string = "Required value was null.";
            throw new IllegalStateException(string.toString());
        }
        int docFreq = 0;
        long totalTermFreq = 0L;
        while (true) {
            PostingsEnum postingsEnum = this.postingsEnum;
            Intrinsics.checkNotNull((Object)postingsEnum);
            int docID = postingsEnum.nextDoc();
            if (docID == Integer.MAX_VALUE) break;
            ++docFreq;
            docsSeen.set(docID);
            int freq = 0;
            if (this.writeFreqs) {
                PostingsEnum postingsEnum2 = this.postingsEnum;
                Intrinsics.checkNotNull((Object)postingsEnum2);
                freq = postingsEnum2.freq();
                totalTermFreq += (long)freq;
            } else {
                freq = -1;
            }
            this.startDoc(docID, freq);
            if (this.writePositions) {
                for (int i = 0; i < freq; ++i) {
                    BytesRef bytesRef;
                    PostingsEnum postingsEnum3 = this.postingsEnum;
                    Intrinsics.checkNotNull((Object)postingsEnum3);
                    int pos = postingsEnum3.nextPosition();
                    if (this.writePayloads) {
                        PostingsEnum postingsEnum4 = this.postingsEnum;
                        Intrinsics.checkNotNull((Object)postingsEnum4);
                        bytesRef = postingsEnum4.getPayload();
                    } else {
                        bytesRef = null;
                    }
                    BytesRef payload = bytesRef;
                    int startOffset = 0;
                    int endOffset = 0;
                    if (this.writeOffsets) {
                        PostingsEnum postingsEnum5 = this.postingsEnum;
                        Intrinsics.checkNotNull((Object)postingsEnum5);
                        startOffset = postingsEnum5.startOffset();
                        PostingsEnum postingsEnum6 = this.postingsEnum;
                        Intrinsics.checkNotNull((Object)postingsEnum6);
                        endOffset = postingsEnum6.endOffset();
                    } else {
                        startOffset = -1;
                        endOffset = -1;
                    }
                    this.addPosition(pos, payload, startOffset, endOffset);
                }
            }
            this.finishDoc();
        }
        if (docFreq == 0) {
            return null;
        }
        BlockTermState state2 = this.newTermState();
        state2.setDocFreq(docFreq);
        state2.setTotalTermFreq(this.writeFreqs ? totalTermFreq : -1L);
        this.finishTerm(state2);
        return state2;
    }

    public abstract void startDoc(int var1, int var2) throws IOException;

    public abstract void addPosition(int var1, @Nullable BytesRef var2, int var3, int var4) throws IOException;

    public abstract void finishDoc() throws IOException;
}

