/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.StoredFieldsReader;
import org.gnit.lucenekmp.document.StoredValue;
import org.gnit.lucenekmp.index.DocIDMerger;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.MergeState;
import org.gnit.lucenekmp.index.StoredFieldDataInput;
import org.gnit.lucenekmp.index.StoredFieldVisitor;
import org.gnit.lucenekmp.util.Accountable;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\u0010\u0007\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00060\u0001j\u0002`\u00022\u00020\u0003:\u0002\u001a\u001bB\t\b\u0004\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H&J\b\u0010\b\u001a\u00020\u0007H\u0016J\u001a\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH&J\u001a\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000eH&J\u001a\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000fH&J\u001a\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0010H&J\u001a\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0011H\u0016J\u001a\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0012H&J\u001a\u0010\t\u001a\u00020\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u0013H&J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\rH&J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0007H&\u00a8\u0006\u001c"}, d2={"Lorg/gnit/lucenekmp/codecs/StoredFieldsWriter;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "Lorg/gnit/lucenekmp/util/Accountable;", "<init>", "()V", "startDocument", "", "finishDocument", "writeField", "info", "Lorg/gnit/lucenekmp/index/FieldInfo;", "value", "", "", "", "", "Lorg/gnit/lucenekmp/index/StoredFieldDataInput;", "Lorg/gnit/lucenekmp/util/BytesRef;", "", "finish", "numDocs", "merge", "mergeState", "Lorg/gnit/lucenekmp/index/MergeState;", "close", "StoredFieldsMergeSub", "MergeVisitor", "core"})
public abstract class StoredFieldsWriter
implements AutoCloseable,
Accountable {
    protected StoredFieldsWriter() {
    }

    public abstract void startDocument() throws IOException;

    public void finishDocument() throws IOException {
    }

    public abstract void writeField(@Nullable FieldInfo var1, int var2) throws IOException;

    public abstract void writeField(@Nullable FieldInfo var1, long var2) throws IOException;

    public abstract void writeField(@Nullable FieldInfo var1, float var2) throws IOException;

    public abstract void writeField(@Nullable FieldInfo var1, double var2) throws IOException;

    public void writeField(@Nullable FieldInfo info, @NotNull StoredFieldDataInput value) throws IOException {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int length = value.getLength();
        byte[] bytes = new byte[length];
        value.getDataInput().readBytes(bytes, 0, length);
        this.writeField(info, new BytesRef(bytes, 0, length));
    }

    public abstract void writeField(@Nullable FieldInfo var1, @NotNull BytesRef var2) throws IOException;

    public abstract void writeField(@Nullable FieldInfo var1, @NotNull String var2) throws IOException;

    public abstract void finish(int var1) throws IOException;

    public int merge(@NotNull MergeState mergeState) throws IOException {
        StoredFieldsMergeSub sub;
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        List subs = new ArrayList();
        int n = mergeState.getStoredFieldsReaders().length;
        for (int i = 0; i < n; ++i) {
            StoredFieldsReader storedFieldsReader;
            Intrinsics.checkNotNull((Object)mergeState.getStoredFieldsReaders()[i]);
            storedFieldsReader.checkIntegrity();
            MergeVisitor mergeVisitor = new MergeVisitor(mergeState, i);
            MergeState.DocMap[] docMapArray = mergeState.getDocMaps();
            Intrinsics.checkNotNull((Object)docMapArray);
            subs.add(new StoredFieldsMergeSub(mergeVisitor, docMapArray[i], storedFieldsReader, mergeState.getMaxDocs()[i]));
        }
        DocIDMerger docIDMerger = DocIDMerger.Companion.of(subs, mergeState.getNeedsIndexSort());
        int docCount = 0;
        while ((sub = (StoredFieldsMergeSub)docIDMerger.next()) != null) {
            if (!(sub.getMappedDocID() == docCount)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.startDocument();
            sub.getReader().document(sub.getDocID(), sub.getVisitor());
            this.finishDocument();
            ++docCount;
        }
        this.finish(docCount);
        return docCount;
    }

    @Override
    public abstract void close();

    @Override
    @NotNull
    public Collection<Accountable> getChildResources() {
        return Accountable.super.getChildResources();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020!H\u0016J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016J\u0018\u0010#\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010\u000f2\u0006\u0010,\u001a\u00020\u000fH\u0002R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006-"}, d2={"Lorg/gnit/lucenekmp/codecs/StoredFieldsWriter$MergeVisitor;", "Lorg/gnit/lucenekmp/index/StoredFieldVisitor;", "mergeState", "Lorg/gnit/lucenekmp/index/MergeState;", "readerIndex", "", "<init>", "(Lorg/gnit/lucenekmp/codecs/StoredFieldsWriter;Lorg/gnit/lucenekmp/index/MergeState;I)V", "storedValue", "Lorg/gnit/lucenekmp/document/StoredValue;", "getStoredValue", "()Lorg/gnit/lucenekmp/document/StoredValue;", "setStoredValue", "(Lorg/gnit/lucenekmp/document/StoredValue;)V", "currentField", "Lorg/gnit/lucenekmp/index/FieldInfo;", "getCurrentField", "()Lorg/gnit/lucenekmp/index/FieldInfo;", "setCurrentField", "(Lorg/gnit/lucenekmp/index/FieldInfo;)V", "remapper", "Lorg/gnit/lucenekmp/index/FieldInfos;", "getRemapper", "()Lorg/gnit/lucenekmp/index/FieldInfos;", "setRemapper", "(Lorg/gnit/lucenekmp/index/FieldInfos;)V", "binaryField", "", "fieldInfo", "value", "Lorg/gnit/lucenekmp/index/StoredFieldDataInput;", "", "stringField", "", "intField", "longField", "", "floatField", "", "doubleField", "", "needsField", "Lorg/gnit/lucenekmp/index/StoredFieldVisitor$Status;", "remap", "field", "core"})
    @SourceDebugExtension(value={"SMAP\nStoredFieldsWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StoredFieldsWriter.kt\norg/gnit/lucenekmp/codecs/StoredFieldsWriter$MergeVisitor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n1#2:235\n*E\n"})
    protected final class MergeVisitor
    extends StoredFieldVisitor {
        @Nullable
        private StoredValue storedValue;
        @Nullable
        private FieldInfo currentField;
        @Nullable
        private FieldInfos remapper;

        public MergeVisitor(MergeState mergeState, int readerIndex) {
            Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
            FieldInfos fieldInfos = mergeState.getFieldInfos()[readerIndex];
            Intrinsics.checkNotNull((Object)fieldInfos);
            for (FieldInfo fi : fieldInfos) {
                FieldInfos fieldInfos2 = mergeState.getMergeFieldInfos();
                Intrinsics.checkNotNull((Object)fieldInfos2);
                FieldInfo other = fieldInfos2.fieldInfo(fi.getNumber());
                if (other != null && Intrinsics.areEqual((Object)other.getName(), (Object)fi.getName())) continue;
                this.remapper = mergeState.getMergeFieldInfos();
                break;
            }
        }

        @Nullable
        public final StoredValue getStoredValue() {
            return this.storedValue;
        }

        public final void setStoredValue(@Nullable StoredValue storedValue) {
            this.storedValue = storedValue;
        }

        @Nullable
        public final FieldInfo getCurrentField() {
            return this.currentField;
        }

        public final void setCurrentField(@Nullable FieldInfo fieldInfo) {
            this.currentField = fieldInfo;
        }

        @Nullable
        public final FieldInfos getRemapper() {
            return this.remapper;
        }

        public final void setRemapper(@Nullable FieldInfos fieldInfos) {
            this.remapper = fieldInfos;
        }

        @Override
        public void binaryField(@NotNull FieldInfo fieldInfo, @NotNull StoredFieldDataInput value) throws IOException {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            StoredFieldsWriter.this.writeField(this.remap(fieldInfo), value);
        }

        @Override
        public void binaryField(@NotNull FieldInfo fieldInfo, @NotNull byte[] value) throws IOException {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            StoredFieldsWriter.this.writeField(this.remap(fieldInfo), new BytesRef(value));
        }

        @Override
        public void stringField(@NotNull FieldInfo fieldInfo, @NotNull String value) throws IOException {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            StoredFieldsWriter.this.writeField(this.remap(fieldInfo), value);
        }

        @Override
        public void intField(@NotNull FieldInfo fieldInfo, int value) throws IOException {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            StoredFieldsWriter.this.writeField(this.remap(fieldInfo), value);
        }

        @Override
        public void longField(@NotNull FieldInfo fieldInfo, long value) throws IOException {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            StoredFieldsWriter.this.writeField(this.remap(fieldInfo), value);
        }

        @Override
        public void floatField(@NotNull FieldInfo fieldInfo, float value) throws IOException {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            StoredFieldsWriter.this.writeField(this.remap(fieldInfo), value);
        }

        @Override
        public void doubleField(@NotNull FieldInfo fieldInfo, double value) throws IOException {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            StoredFieldsWriter.this.writeField(this.remap(fieldInfo), value);
        }

        @Override
        @NotNull
        public StoredFieldVisitor.Status needsField(@NotNull FieldInfo fieldInfo) throws IOException {
            Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
            return StoredFieldVisitor.Status.YES;
        }

        private final FieldInfo remap(FieldInfo field) {
            FieldInfo fieldInfo;
            if (this.remapper != null) {
                FieldInfos fieldInfos = this.remapper;
                Intrinsics.checkNotNull((Object)fieldInfos);
                fieldInfo = fieldInfos.fieldInfo(field.getName());
            } else {
                fieldInfo = field;
            }
            return fieldInfo;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B+\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0016\u001a\u00020\nH\u0016R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0017"}, d2={"Lorg/gnit/lucenekmp/codecs/StoredFieldsWriter$StoredFieldsMergeSub;", "Lorg/gnit/lucenekmp/index/DocIDMerger$Sub;", "visitor", "Lorg/gnit/lucenekmp/codecs/StoredFieldsWriter$MergeVisitor;", "Lorg/gnit/lucenekmp/codecs/StoredFieldsWriter;", "docMap", "Lorg/gnit/lucenekmp/index/MergeState$DocMap;", "reader", "Lorg/gnit/lucenekmp/codecs/StoredFieldsReader;", "maxDoc", "", "<init>", "(Lorg/gnit/lucenekmp/codecs/StoredFieldsWriter$MergeVisitor;Lorg/gnit/lucenekmp/index/MergeState$DocMap;Lorg/gnit/lucenekmp/codecs/StoredFieldsReader;I)V", "getVisitor", "()Lorg/gnit/lucenekmp/codecs/StoredFieldsWriter$MergeVisitor;", "getReader", "()Lorg/gnit/lucenekmp/codecs/StoredFieldsReader;", "docID", "getDocID", "()I", "setDocID", "(I)V", "nextDoc", "core"})
    private static final class StoredFieldsMergeSub
    extends DocIDMerger.Sub {
        @NotNull
        private final MergeVisitor visitor;
        @NotNull
        private final StoredFieldsReader reader;
        private final int maxDoc;
        private int docID;

        public StoredFieldsMergeSub(@NotNull MergeVisitor visitor2, @NotNull MergeState.DocMap docMap, @NotNull StoredFieldsReader reader2, int maxDoc) {
            Intrinsics.checkNotNullParameter((Object)visitor2, (String)"visitor");
            Intrinsics.checkNotNullParameter((Object)docMap, (String)"docMap");
            Intrinsics.checkNotNullParameter((Object)reader2, (String)"reader");
            super(docMap);
            this.visitor = visitor2;
            this.reader = reader2;
            this.maxDoc = maxDoc;
            this.docID = -1;
        }

        @NotNull
        public final MergeVisitor getVisitor() {
            return this.visitor;
        }

        @NotNull
        public final StoredFieldsReader getReader() {
            return this.reader;
        }

        public final int getDocID() {
            return this.docID;
        }

        public final void setDocID(int n) {
            this.docID = n;
        }

        @Override
        public int nextDoc() {
            int n = this.docID;
            this.docID = n + 1;
            return this.docID == this.maxDoc ? Integer.MAX_VALUE : this.docID;
        }
    }
}

