/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.compressing;

import java.io.IOException;
import java.util.zip.Deflater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.compressing.Compressor;
import org.gnit.lucenekmp.store.ByteBuffersDataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lorg/gnit/lucenekmp/codecs/compressing/DeflateCompressor;", "Lorg/gnit/lucenekmp/codecs/compressing/Compressor;", "level", "", "<init>", "(I)V", "getLevel", "()I", "compressor", "Ljava/util/zip/Deflater;", "compressed", "", "getCompressed", "()[B", "setCompressed", "([B)V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "compress", "", "buffersInput", "Lorg/gnit/lucenekmp/store/ByteBuffersDataInput;", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "close", "core"})
@SourceDebugExtension(value={"SMAP\nDeflateCompressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeflateCompressor.kt\norg/gnit/lucenekmp/codecs/compressing/DeflateCompressor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class DeflateCompressor
extends Compressor {
    private final int level;
    @NotNull
    private final Deflater compressor;
    @NotNull
    private byte[] compressed;
    private boolean closed;

    public DeflateCompressor(int level) {
        this.level = level;
        this.compressor = new Deflater(this.level, true);
        this.compressed = new byte[64];
    }

    public final int getLevel() {
        return this.level;
    }

    @NotNull
    public final byte[] getCompressed() {
        return this.compressed;
    }

    public final void setCompressed(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.compressed = byArray;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
    }

    @Override
    public void compress(@NotNull ByteBuffersDataInput buffersInput, @NotNull DataOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffersInput, (String)"buffersInput");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int len = (Integer)buffersInput.length();
        byte[] bytes = new byte[len];
        buffersInput.readBytes(bytes, 0, len);
        this.compressor.reset();
        this.compressor.setInput(bytes, 0, len);
        this.compressor.finish();
        if (this.compressor.needsInput()) {
            if (!(len == 0)) {
                boolean $i$a$-require-DeflateCompressor$compress$22 = false;
                Integer $i$a$-require-DeflateCompressor$compress$22 = len;
                throw new IllegalArgumentException(((Object)$i$a$-require-DeflateCompressor$compress$22).toString());
            }
            out.writeVInt(0);
            return;
        }
        int totalCount = 0;
        while (true) {
            int count;
            if (!((totalCount += (count = this.compressor.deflate(this.compressed, totalCount, this.compressed.length - totalCount))) <= this.compressed.length)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.compressor.finished()) break;
            this.compressed = ArrayUtil.Companion.grow(this.compressed);
        }
        out.writeVInt(totalCount);
        out.writeBytes(this.compressed, totalCount);
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.compressor.end();
            this.closed = true;
        }
    }
}

