/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.compressing;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.MergeState;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/gnit/lucenekmp/codecs/compressing/MatchingReaders;", "", "mergeState", "Lorg/gnit/lucenekmp/index/MergeState;", "<init>", "(Lorg/gnit/lucenekmp/index/MergeState;)V", "matchingReaders", "", "getMatchingReaders", "()[Z", "count", "", "getCount", "()I", "core"})
public final class MatchingReaders {
    @NotNull
    private final boolean[] matchingReaders;
    private final int count;

    public MatchingReaders(@NotNull MergeState mergeState) {
        Intrinsics.checkNotNullParameter((Object)mergeState, (String)"mergeState");
        int numReaders = mergeState.getMaxDocs().length;
        int matchedCount = 0;
        this.matchingReaders = new boolean[numReaders];
        block0: for (int i = 0; i < numReaders; ++i) {
            FieldInfos fieldInfos = mergeState.getFieldInfos()[i];
            Intrinsics.checkNotNull((Object)fieldInfos);
            for (FieldInfo fi : fieldInfos) {
                FieldInfos fieldInfos2 = mergeState.getMergeFieldInfos();
                Intrinsics.checkNotNull((Object)fieldInfos2);
                FieldInfo other = fieldInfos2.fieldInfo(fi.getNumber());
                if (other != null && Intrinsics.areEqual((Object)other.getName(), (Object)fi.getName())) continue;
                continue block0;
            }
            this.matchingReaders[i] = true;
            ++matchedCount;
        }
        this.count = matchedCount;
        if (mergeState.getInfoStream().isEnabled("SM")) {
            mergeState.getInfoStream().message("SM", "merge store matchedCount=" + this.count + " vs " + numReaders);
            if (this.count != numReaders) {
                mergeState.getInfoStream().message("SM", numReaders - this.count + " non-bulk merges");
            }
        }
    }

    @NotNull
    public final boolean[] getMatchingReaders() {
        return this.matchingReaders;
    }

    public final int getCount() {
        return this.count;
    }
}

