/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene101;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.internal.vectorization.PostingDecodingUtil;
import org.gnit.lucenekmp.store.DataOutput;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\r\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene101/ForUtil;", "", "<init>", "()V", "tmp", "", "encode", "", "ints", "bitsPerValue", "", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "decode", "pdu", "Lorg/gnit/lucenekmp/internal/vectorization/PostingDecodingUtil;", "Companion", "core"})
public final class ForUtil {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final int[] tmp = new int[128];
    public static final int BLOCK_SIZE = 128;
    public static final int BLOCK_SIZE_LOG2 = 7;
    @NotNull
    private static final int[] MASKS8;
    @NotNull
    private static final int[] MASKS16;
    @NotNull
    private static final int[] MASKS32;
    private static final int MASK8_1;
    private static final int MASK8_2;
    private static final int MASK8_3;
    private static final int MASK8_4;
    private static final int MASK8_5;
    private static final int MASK8_6;
    private static final int MASK8_7;
    private static final int MASK16_1;
    private static final int MASK16_2;
    private static final int MASK16_3;
    private static final int MASK16_4;
    private static final int MASK16_5;
    private static final int MASK16_6;
    private static final int MASK16_7;
    private static final int MASK16_8;
    private static final int MASK16_9;
    private static final int MASK16_10;
    private static final int MASK16_11;
    private static final int MASK16_12;
    private static final int MASK16_13;
    private static final int MASK16_14;
    private static final int MASK16_15;
    private static final int MASK32_1;
    private static final int MASK32_2;
    private static final int MASK32_3;
    private static final int MASK32_4;
    private static final int MASK32_5;
    private static final int MASK32_6;
    private static final int MASK32_7;
    private static final int MASK32_8;
    private static final int MASK32_9;
    private static final int MASK32_10;
    private static final int MASK32_11;
    private static final int MASK32_12;
    private static final int MASK32_13;
    private static final int MASK32_14;
    private static final int MASK32_15;
    private static final int MASK32_16;

    public final void encode(@NotNull int[] ints, int bitsPerValue, @NotNull DataOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int nextPrimitive = 0;
        if (bitsPerValue <= 8) {
            nextPrimitive = 8;
            Companion.collapse8(ints);
        } else if (bitsPerValue <= 16) {
            nextPrimitive = 16;
            Companion.collapse16(ints);
        } else {
            nextPrimitive = 32;
        }
        Companion.encode(ints, bitsPerValue, nextPrimitive, out, this.tmp);
    }

    public final void decode(int bitsPerValue, @NotNull PostingDecodingUtil pdu, @NotNull int[] ints) throws IOException {
        Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
        Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
        switch (bitsPerValue) {
            case 1: {
                Companion.decode1(pdu, ints);
                Companion.expand8(ints);
                break;
            }
            case 2: {
                Companion.decode2(pdu, ints);
                Companion.expand8(ints);
                break;
            }
            case 3: {
                Companion.decode3(pdu, this.tmp, ints);
                Companion.expand8(ints);
                break;
            }
            case 4: {
                Companion.decode4(pdu, ints);
                Companion.expand8(ints);
                break;
            }
            case 5: {
                Companion.decode5(pdu, this.tmp, ints);
                Companion.expand8(ints);
                break;
            }
            case 6: {
                Companion.decode6(pdu, this.tmp, ints);
                Companion.expand8(ints);
                break;
            }
            case 7: {
                Companion.decode7(pdu, this.tmp, ints);
                Companion.expand8(ints);
                break;
            }
            case 8: {
                Companion.decode8(pdu, ints);
                Companion.expand8(ints);
                break;
            }
            case 9: {
                Companion.decode9(pdu, this.tmp, ints);
                Companion.expand16(ints);
                break;
            }
            case 10: {
                Companion.decode10(pdu, this.tmp, ints);
                Companion.expand16(ints);
                break;
            }
            case 11: {
                Companion.decode11(pdu, this.tmp, ints);
                Companion.expand16(ints);
                break;
            }
            case 12: {
                Companion.decode12(pdu, this.tmp, ints);
                Companion.expand16(ints);
                break;
            }
            case 13: {
                Companion.decode13(pdu, this.tmp, ints);
                Companion.expand16(ints);
                break;
            }
            case 14: {
                Companion.decode14(pdu, this.tmp, ints);
                Companion.expand16(ints);
                break;
            }
            case 15: {
                Companion.decode15(pdu, this.tmp, ints);
                Companion.expand16(ints);
                break;
            }
            case 16: {
                Companion.decode16(pdu, ints);
                Companion.expand16(ints);
                break;
            }
            default: {
                Companion.decodeSlow(bitsPerValue, pdu, this.tmp, ints);
            }
        }
    }

    static {
        int i;
        Companion = new Companion(null);
        MASKS8 = new int[8];
        MASKS16 = new int[16];
        MASKS32 = new int[32];
        for (i = 0; i < 8; ++i) {
            ForUtil.MASKS8[i] = Companion.mask8(i);
        }
        for (i = 0; i < 16; ++i) {
            ForUtil.MASKS16[i] = Companion.mask16(i);
        }
        for (i = 0; i < 32; ++i) {
            ForUtil.MASKS32[i] = Companion.mask32(i);
        }
        MASK8_1 = MASKS8[1];
        MASK8_2 = MASKS8[2];
        MASK8_3 = MASKS8[3];
        MASK8_4 = MASKS8[4];
        MASK8_5 = MASKS8[5];
        MASK8_6 = MASKS8[6];
        MASK8_7 = MASKS8[7];
        MASK16_1 = MASKS16[1];
        MASK16_2 = MASKS16[2];
        MASK16_3 = MASKS16[3];
        MASK16_4 = MASKS16[4];
        MASK16_5 = MASKS16[5];
        MASK16_6 = MASKS16[6];
        MASK16_7 = MASKS16[7];
        MASK16_8 = MASKS16[8];
        MASK16_9 = MASKS16[9];
        MASK16_10 = MASKS16[10];
        MASK16_11 = MASKS16[11];
        MASK16_12 = MASKS16[12];
        MASK16_13 = MASKS16[13];
        MASK16_14 = MASKS16[14];
        MASK16_15 = MASKS16[15];
        MASK32_1 = MASKS32[1];
        MASK32_2 = MASKS32[2];
        MASK32_3 = MASKS32[3];
        MASK32_4 = MASKS32[4];
        MASK32_5 = MASKS32[5];
        MASK32_6 = MASKS32[6];
        MASK32_7 = MASKS32[7];
        MASK32_8 = MASKS32[8];
        MASK32_9 = MASKS32[9];
        MASK32_10 = MASKS32[10];
        MASK32_11 = MASKS32[11];
        MASK32_12 = MASKS32[12];
        MASK32_13 = MASKS32[13];
        MASK32_14 = MASKS32[14];
        MASK32_15 = MASKS32[15];
        MASK32_16 = MASKS32[16];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\be\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J.\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010J\u000e\u0010\u001a\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J&\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\u0016\u0010r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0010J\u0016\u0010s\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0010J\u001e\u0010t\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\u0016\u0010u\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0010J\u001e\u0010v\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\u001e\u0010w\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\u001e\u0010x\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\u0016\u0010y\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0010J\u001e\u0010z\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\u001e\u0010{\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\u001e\u0010|\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\u001e\u0010}\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\u001e\u0010~\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\u001e\u0010\u007f\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\u001f\u0010\u0080\u0001\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0010J\u0017\u0010\u0081\u0001\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001e\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010 R\u0011\u0010#\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010 R\u0011\u0010%\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010'R\u0011\u0010*\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010'R\u0011\u0010,\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010'R\u0011\u0010.\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010'R\u0011\u00100\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010'R\u0011\u00102\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010'R\u0011\u00104\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010'R\u0011\u00106\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010'R\u0011\u00108\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010'R\u0011\u0010:\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010'R\u0011\u0010<\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010'R\u0011\u0010>\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010'R\u0011\u0010@\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010'R\u0011\u0010B\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bC\u0010'R\u0011\u0010D\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010'R\u0011\u0010F\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010'R\u0011\u0010H\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bI\u0010'R\u0011\u0010J\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010'R\u0011\u0010L\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bM\u0010'R\u0011\u0010N\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010'R\u0011\u0010P\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010'R\u0011\u0010R\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bS\u0010'R\u0011\u0010T\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bU\u0010'R\u0011\u0010V\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bW\u0010'R\u0011\u0010X\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bY\u0010'R\u0011\u0010Z\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b[\u0010'R\u0011\u0010\\\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b]\u0010'R\u0011\u0010^\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b_\u0010'R\u0011\u0010`\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\ba\u0010'R\u0011\u0010b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bc\u0010'R\u0011\u0010d\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\be\u0010'R\u0011\u0010f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bg\u0010'R\u0011\u0010h\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bi\u0010'R\u0011\u0010j\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bk\u0010'R\u0011\u0010l\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bm\u0010'R\u0011\u0010n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bo\u0010'R\u0011\u0010p\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bq\u0010'\u00a8\u0006\u0082\u0001"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene101/ForUtil$Companion;", "", "<init>", "()V", "BLOCK_SIZE", "", "BLOCK_SIZE_LOG2", "expandMask16", "mask16", "expandMask8", "mask8", "mask32", "bitsPerValue", "expand8", "", "arr", "", "collapse8", "expand16", "collapse16", "encode", "ints", "primitiveSize", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "tmp", "numBytes", "decodeSlow", "pdu", "Lorg/gnit/lucenekmp/internal/vectorization/PostingDecodingUtil;", "MASKS8", "getMASKS8", "()[I", "MASKS16", "getMASKS16", "MASKS32", "getMASKS32", "MASK8_1", "getMASK8_1", "()I", "MASK8_2", "getMASK8_2", "MASK8_3", "getMASK8_3", "MASK8_4", "getMASK8_4", "MASK8_5", "getMASK8_5", "MASK8_6", "getMASK8_6", "MASK8_7", "getMASK8_7", "MASK16_1", "getMASK16_1", "MASK16_2", "getMASK16_2", "MASK16_3", "getMASK16_3", "MASK16_4", "getMASK16_4", "MASK16_5", "getMASK16_5", "MASK16_6", "getMASK16_6", "MASK16_7", "getMASK16_7", "MASK16_8", "getMASK16_8", "MASK16_9", "getMASK16_9", "MASK16_10", "getMASK16_10", "MASK16_11", "getMASK16_11", "MASK16_12", "getMASK16_12", "MASK16_13", "getMASK16_13", "MASK16_14", "getMASK16_14", "MASK16_15", "getMASK16_15", "MASK32_1", "getMASK32_1", "MASK32_2", "getMASK32_2", "MASK32_3", "getMASK32_3", "MASK32_4", "getMASK32_4", "MASK32_5", "getMASK32_5", "MASK32_6", "getMASK32_6", "MASK32_7", "getMASK32_7", "MASK32_8", "getMASK32_8", "MASK32_9", "getMASK32_9", "MASK32_10", "getMASK32_10", "MASK32_11", "getMASK32_11", "MASK32_12", "getMASK32_12", "MASK32_13", "getMASK32_13", "MASK32_14", "getMASK32_14", "MASK32_15", "getMASK32_15", "MASK32_16", "getMASK32_16", "decode1", "decode2", "decode3", "decode4", "decode5", "decode6", "decode7", "decode8", "decode9", "decode10", "decode11", "decode12", "decode13", "decode14", "decode15", "decode16", "core"})
    public static final class Companion {
        private Companion() {
        }

        public final int expandMask16(int mask16) {
            return mask16 | mask16 << 16;
        }

        public final int expandMask8(int mask8) {
            return this.expandMask16(mask8 | mask8 << 8);
        }

        public final int mask32(int bitsPerValue) {
            return (1 << bitsPerValue) - 1;
        }

        public final int mask16(int bitsPerValue) {
            return this.expandMask16((1 << bitsPerValue) - 1);
        }

        public final int mask8(int bitsPerValue) {
            return this.expandMask8((1 << bitsPerValue) - 1);
        }

        public final void expand8(@NotNull int[] arr) {
            Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
            for (int i = 0; i < 32; ++i) {
                int l = arr[i];
                arr[i] = l >>> 24 & 0xFF;
                arr[32 + i] = l >>> 16 & 0xFF;
                arr[64 + i] = l >>> 8 & 0xFF;
                arr[96 + i] = l & 0xFF;
            }
        }

        public final void collapse8(@NotNull int[] arr) {
            Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
            for (int i = 0; i < 32; ++i) {
                arr[i] = arr[i] << 24 | arr[32 + i] << 16 | arr[64 + i] << 8 | arr[96 + i];
            }
        }

        public final void expand16(@NotNull int[] arr) {
            Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
            for (int i = 0; i < 64; ++i) {
                int l = arr[i];
                arr[i] = l >>> 16 & 0xFFFF;
                arr[64 + i] = l & 0xFFFF;
            }
        }

        public final void collapse16(@NotNull int[] arr) {
            Intrinsics.checkNotNullParameter((Object)arr, (String)"arr");
            for (int i = 0; i < 64; ++i) {
                arr[i] = arr[i] << 16 | arr[64 + i];
            }
        }

        public final void encode(@NotNull int[] ints, int bitsPerValue, int primitiveSize, @NotNull DataOutput out, @NotNull int[] tmp) throws IOException {
            int i;
            Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)tmp, (String)"tmp");
            int numInts = 128 * primitiveSize / 32;
            int numIntsPerShift = bitsPerValue * 4;
            int idx = 0;
            int shift = primitiveSize - bitsPerValue;
            for (i = 0; i < numIntsPerShift; ++i) {
                tmp[i] = ints[idx++] << shift;
            }
            shift -= bitsPerValue;
            while (shift >= 0) {
                for (i = 0; i < numIntsPerShift; ++i) {
                    tmp[i] = tmp[i] | ints[idx++] << shift;
                }
                shift -= bitsPerValue;
            }
            int remainingBitsPerInt = shift + bitsPerValue;
            int maskRemainingBitsPerInt = switch (primitiveSize) {
                case 8 -> this.getMASKS8()[remainingBitsPerInt];
                case 16 -> this.getMASKS16()[remainingBitsPerInt];
                default -> this.getMASKS32()[remainingBitsPerInt];
            };
            int tmpIdx = 0;
            int remainingBitsPerValue = bitsPerValue;
            while (idx < numInts) {
                if (remainingBitsPerValue >= remainingBitsPerInt) {
                    tmp[tmpIdx] = tmp[tmpIdx] | ints[idx] >>> (remainingBitsPerValue -= remainingBitsPerInt) & maskRemainingBitsPerInt;
                    ++tmpIdx;
                    if (remainingBitsPerValue != 0) continue;
                    ++idx;
                    remainingBitsPerValue = bitsPerValue;
                    continue;
                }
                int mask1 = 0;
                int mask2 = 0;
                switch (primitiveSize) {
                    case 8: {
                        mask1 = this.getMASKS8()[remainingBitsPerValue];
                        mask2 = this.getMASKS8()[remainingBitsPerInt - remainingBitsPerValue];
                        break;
                    }
                    case 16: {
                        mask1 = this.getMASKS16()[remainingBitsPerValue];
                        mask2 = this.getMASKS16()[remainingBitsPerInt - remainingBitsPerValue];
                        break;
                    }
                    default: {
                        mask1 = this.getMASKS32()[remainingBitsPerValue];
                        mask2 = this.getMASKS32()[remainingBitsPerInt - remainingBitsPerValue];
                    }
                }
                tmp[tmpIdx] = tmp[tmpIdx] | (ints[idx++] & mask1) << remainingBitsPerInt - remainingBitsPerValue;
                remainingBitsPerValue = bitsPerValue - remainingBitsPerInt + remainingBitsPerValue;
                tmp[tmpIdx] = tmp[tmpIdx] | ints[idx] >>> remainingBitsPerValue & mask2;
                ++tmpIdx;
            }
            for (int i2 = 0; i2 < numIntsPerShift; ++i2) {
                out.writeInt(tmp[i2]);
            }
        }

        public final int numBytes(int bitsPerValue) {
            return bitsPerValue << 4;
        }

        public final void decodeSlow(int bitsPerValue, @NotNull PostingDecodingUtil pdu, @NotNull int[] tmp, @NotNull int[] ints) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
            Intrinsics.checkNotNullParameter((Object)tmp, (String)"tmp");
            Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
            int numInts = bitsPerValue << 2;
            int mask = this.getMASKS32()[bitsPerValue];
            pdu.splitInts(numInts, ints, 32 - bitsPerValue, 32, mask, tmp, 0, -1);
            int remainingBitsPerInt = 32 - bitsPerValue;
            int mask32RemainingBitsPerInt = this.getMASKS32()[remainingBitsPerInt];
            int tmpIdx = 0;
            int remainingBits = remainingBitsPerInt;
            for (int intsIdx = numInts; intsIdx < 128; ++intsIdx) {
                int b = bitsPerValue - remainingBits;
                int l = (tmp[tmpIdx++] & this.getMASKS32()[remainingBits]) << b;
                while (b >= remainingBitsPerInt) {
                    l |= (tmp[tmpIdx++] & mask32RemainingBitsPerInt) << (b -= remainingBitsPerInt);
                }
                if (b > 0) {
                    l |= tmp[tmpIdx] >>> remainingBitsPerInt - b & this.getMASKS32()[b];
                    remainingBits = remainingBitsPerInt - b;
                } else {
                    remainingBits = remainingBitsPerInt;
                }
                ints[intsIdx] = l;
            }
        }

        @NotNull
        public final int[] getMASKS8() {
            return MASKS8;
        }

        @NotNull
        public final int[] getMASKS16() {
            return MASKS16;
        }

        @NotNull
        public final int[] getMASKS32() {
            return MASKS32;
        }

        public final int getMASK8_1() {
            return MASK8_1;
        }

        public final int getMASK8_2() {
            return MASK8_2;
        }

        public final int getMASK8_3() {
            return MASK8_3;
        }

        public final int getMASK8_4() {
            return MASK8_4;
        }

        public final int getMASK8_5() {
            return MASK8_5;
        }

        public final int getMASK8_6() {
            return MASK8_6;
        }

        public final int getMASK8_7() {
            return MASK8_7;
        }

        public final int getMASK16_1() {
            return MASK16_1;
        }

        public final int getMASK16_2() {
            return MASK16_2;
        }

        public final int getMASK16_3() {
            return MASK16_3;
        }

        public final int getMASK16_4() {
            return MASK16_4;
        }

        public final int getMASK16_5() {
            return MASK16_5;
        }

        public final int getMASK16_6() {
            return MASK16_6;
        }

        public final int getMASK16_7() {
            return MASK16_7;
        }

        public final int getMASK16_8() {
            return MASK16_8;
        }

        public final int getMASK16_9() {
            return MASK16_9;
        }

        public final int getMASK16_10() {
            return MASK16_10;
        }

        public final int getMASK16_11() {
            return MASK16_11;
        }

        public final int getMASK16_12() {
            return MASK16_12;
        }

        public final int getMASK16_13() {
            return MASK16_13;
        }

        public final int getMASK16_14() {
            return MASK16_14;
        }

        public final int getMASK16_15() {
            return MASK16_15;
        }

        public final int getMASK32_1() {
            return MASK32_1;
        }

        public final int getMASK32_2() {
            return MASK32_2;
        }

        public final int getMASK32_3() {
            return MASK32_3;
        }

        public final int getMASK32_4() {
            return MASK32_4;
        }

        public final int getMASK32_5() {
            return MASK32_5;
        }

        public final int getMASK32_6() {
            return MASK32_6;
        }

        public final int getMASK32_7() {
            return MASK32_7;
        }

        public final int getMASK32_8() {
            return MASK32_8;
        }

        public final int getMASK32_9() {
            return MASK32_9;
        }

        public final int getMASK32_10() {
            return MASK32_10;
        }

        public final int getMASK32_11() {
            return MASK32_11;
        }

        public final int getMASK32_12() {
            return MASK32_12;
        }

        public final int getMASK32_13() {
            return MASK32_13;
        }

        public final int getMASK32_14() {
            return MASK32_14;
        }

        public final int getMASK32_15() {
            return MASK32_15;
        }

        public final int getMASK32_16() {
            return MASK32_16;
        }

        public final void decode1(@NotNull PostingDecodingUtil pdu, @NotNull int[] ints) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
            Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
            pdu.splitInts(4, ints, 7, 1, this.getMASK8_1(), ints, 28, this.getMASK8_1());
        }

        public final void decode2(@NotNull PostingDecodingUtil pdu, @NotNull int[] ints) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
            Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
            pdu.splitInts(8, ints, 6, 2, this.getMASK8_2(), ints, 24, this.getMASK8_2());
        }

        public final void decode3(@NotNull PostingDecodingUtil pdu, @NotNull int[] tmp, @NotNull int[] ints) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
            Intrinsics.checkNotNullParameter((Object)tmp, (String)"tmp");
            Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
            pdu.splitInts(12, ints, 5, 3, this.getMASK8_3(), tmp, 0, this.getMASK8_2());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 24;
            while (iter < 4) {
                int l0 = tmp[tmpIdx + 0] << 1;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 1 & this.getMASK8_1();
                int l1 = (tmp[tmpIdx + 1] & this.getMASK8_1()) << 2;
                ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 2] << 0;
                ++iter;
                tmpIdx += 3;
                intsIdx += 2;
            }
        }

        public final void decode4(@NotNull PostingDecodingUtil pdu, @NotNull int[] ints) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
            Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
            pdu.splitInts(16, ints, 4, 4, this.getMASK8_4(), ints, 16, this.getMASK8_4());
        }

        public final void decode5(@NotNull PostingDecodingUtil pdu, @NotNull int[] tmp, @NotNull int[] ints) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
            Intrinsics.checkNotNullParameter((Object)tmp, (String)"tmp");
            Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
            pdu.splitInts(20, ints, 3, 5, this.getMASK8_5(), tmp, 0, this.getMASK8_3());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 20;
            while (iter < 4) {
                int l0 = tmp[tmpIdx + 0] << 2;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 1 & this.getMASK8_2();
                int l1 = (tmp[tmpIdx + 1] & this.getMASK8_1()) << 4;
                l1 |= tmp[tmpIdx + 2] << 1;
                ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 3] >>> 2 & this.getMASK8_1();
                int l2 = (tmp[tmpIdx + 3] & this.getMASK8_2()) << 3;
                ints[intsIdx + 2] = l2 |= tmp[tmpIdx + 4] << 0;
                ++iter;
                tmpIdx += 5;
                intsIdx += 3;
            }
        }

        public final void decode6(@NotNull PostingDecodingUtil pdu, @NotNull int[] tmp, @NotNull int[] ints) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
            Intrinsics.checkNotNullParameter((Object)tmp, (String)"tmp");
            Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
            pdu.splitInts(24, ints, 2, 6, this.getMASK8_6(), tmp, 0, this.getMASK8_2());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 24;
            while (iter < 8) {
                int l0 = tmp[tmpIdx + 0] << 4;
                l0 |= tmp[tmpIdx + 1] << 2;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 2] << 0;
                ++iter;
                tmpIdx += 3;
                ++intsIdx;
            }
        }

        public final void decode7(@NotNull PostingDecodingUtil pdu, @NotNull int[] tmp, @NotNull int[] ints) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
            Intrinsics.checkNotNullParameter((Object)tmp, (String)"tmp");
            Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
            pdu.splitInts(28, ints, 1, 7, this.getMASK8_7(), tmp, 0, this.getMASK8_1());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 28;
            while (iter < 4) {
                int l0 = tmp[tmpIdx + 0] << 6;
                l0 |= tmp[tmpIdx + 1] << 5;
                l0 |= tmp[tmpIdx + 2] << 4;
                l0 |= tmp[tmpIdx + 3] << 3;
                l0 |= tmp[tmpIdx + 4] << 2;
                l0 |= tmp[tmpIdx + 5] << 1;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 6] << 0;
                ++iter;
                tmpIdx += 7;
                ++intsIdx;
            }
        }

        public final void decode8(@NotNull PostingDecodingUtil pdu, @NotNull int[] ints) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
            Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
            pdu.getIn().readInts(ints, 0, 32);
        }

        public final void decode9(@NotNull PostingDecodingUtil pdu, @NotNull int[] tmp, @NotNull int[] ints) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
            Intrinsics.checkNotNullParameter((Object)tmp, (String)"tmp");
            Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
            pdu.splitInts(36, ints, 7, 9, this.getMASK16_9(), tmp, 0, this.getMASK16_7());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 36;
            while (iter < 4) {
                int l0 = tmp[tmpIdx + 0] << 2;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 5 & this.getMASK16_2();
                int l1 = (tmp[tmpIdx + 1] & this.getMASK16_5()) << 4;
                ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 2] >>> 3 & this.getMASK16_4();
                int l2 = (tmp[tmpIdx + 2] & this.getMASK16_3()) << 6;
                ints[intsIdx + 2] = l2 |= tmp[tmpIdx + 3] >>> 1 & this.getMASK16_6();
                int l3 = (tmp[tmpIdx + 3] & this.getMASK16_1()) << 8;
                l3 |= tmp[tmpIdx + 4] << 1;
                ints[intsIdx + 3] = l3 |= tmp[tmpIdx + 5] >>> 6 & this.getMASK16_1();
                int l4 = (tmp[tmpIdx + 5] & this.getMASK16_6()) << 3;
                ints[intsIdx + 4] = l4 |= tmp[tmpIdx + 6] >>> 4 & this.getMASK16_3();
                int l5 = (tmp[tmpIdx + 6] & this.getMASK16_4()) << 5;
                ints[intsIdx + 5] = l5 |= tmp[tmpIdx + 7] >>> 2 & this.getMASK16_5();
                int l6 = (tmp[tmpIdx + 7] & this.getMASK16_2()) << 7;
                ints[intsIdx + 6] = l6 |= tmp[tmpIdx + 8] << 0;
                ++iter;
                tmpIdx += 9;
                intsIdx += 7;
            }
        }

        public final void decode10(@NotNull PostingDecodingUtil pdu, @NotNull int[] tmp, @NotNull int[] ints) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
            Intrinsics.checkNotNullParameter((Object)tmp, (String)"tmp");
            Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
            pdu.splitInts(40, ints, 6, 10, this.getMASK16_10(), tmp, 0, this.getMASK16_6());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 40;
            while (iter < 8) {
                int l0 = tmp[tmpIdx + 0] << 4;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 1] >>> 2 & this.getMASK16_4();
                int l1 = (tmp[tmpIdx + 1] & this.getMASK16_2()) << 8;
                l1 |= tmp[tmpIdx + 2] << 2;
                ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 3] >>> 4 & this.getMASK16_2();
                int l2 = (tmp[tmpIdx + 3] & this.getMASK16_4()) << 6;
                ints[intsIdx + 2] = l2 |= tmp[tmpIdx + 4] << 0;
                ++iter;
                tmpIdx += 5;
                intsIdx += 3;
            }
        }

        public final void decode11(@NotNull PostingDecodingUtil pdu, @NotNull int[] tmp, @NotNull int[] ints) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
            Intrinsics.checkNotNullParameter((Object)tmp, (String)"tmp");
            Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
            pdu.splitInts(44, ints, 5, 11, this.getMASK16_11(), tmp, 0, this.getMASK16_5());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 44;
            while (iter < 4) {
                int l0 = tmp[tmpIdx + 0] << 6;
                l0 |= tmp[tmpIdx + 1] << 1;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 2] >>> 4 & this.getMASK16_1();
                int l1 = (tmp[tmpIdx + 2] & this.getMASK16_4()) << 7;
                l1 |= tmp[tmpIdx + 3] << 2;
                ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 4] >>> 3 & this.getMASK16_2();
                int l2 = (tmp[tmpIdx + 4] & this.getMASK16_3()) << 8;
                l2 |= tmp[tmpIdx + 5] << 3;
                ints[intsIdx + 2] = l2 |= tmp[tmpIdx + 6] >>> 2 & this.getMASK16_3();
                int l3 = (tmp[tmpIdx + 6] & this.getMASK16_2()) << 9;
                l3 |= tmp[tmpIdx + 7] << 4;
                ints[intsIdx + 3] = l3 |= tmp[tmpIdx + 8] >>> 1 & this.getMASK16_4();
                int l4 = (tmp[tmpIdx + 8] & this.getMASK16_1()) << 10;
                l4 |= tmp[tmpIdx + 9] << 5;
                ints[intsIdx + 4] = l4 |= tmp[tmpIdx + 10] << 0;
                ++iter;
                tmpIdx += 11;
                intsIdx += 5;
            }
        }

        public final void decode12(@NotNull PostingDecodingUtil pdu, @NotNull int[] tmp, @NotNull int[] ints) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
            Intrinsics.checkNotNullParameter((Object)tmp, (String)"tmp");
            Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
            pdu.splitInts(48, ints, 4, 12, this.getMASK16_12(), tmp, 0, this.getMASK16_4());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 48;
            while (iter < 16) {
                int l0 = tmp[tmpIdx + 0] << 8;
                l0 |= tmp[tmpIdx + 1] << 4;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 2] << 0;
                ++iter;
                tmpIdx += 3;
                ++intsIdx;
            }
        }

        public final void decode13(@NotNull PostingDecodingUtil pdu, @NotNull int[] tmp, @NotNull int[] ints) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
            Intrinsics.checkNotNullParameter((Object)tmp, (String)"tmp");
            Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
            pdu.splitInts(52, ints, 3, 13, this.getMASK16_13(), tmp, 0, this.getMASK16_3());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 52;
            while (iter < 4) {
                int l0 = tmp[tmpIdx + 0] << 10;
                l0 |= tmp[tmpIdx + 1] << 7;
                l0 |= tmp[tmpIdx + 2] << 4;
                l0 |= tmp[tmpIdx + 3] << 1;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 4] >>> 2 & this.getMASK16_1();
                int l1 = (tmp[tmpIdx + 4] & this.getMASK16_2()) << 11;
                l1 |= tmp[tmpIdx + 5] << 8;
                l1 |= tmp[tmpIdx + 6] << 5;
                l1 |= tmp[tmpIdx + 7] << 2;
                ints[intsIdx + 1] = l1 |= tmp[tmpIdx + 8] >>> 1 & this.getMASK16_2();
                int l2 = (tmp[tmpIdx + 8] & this.getMASK16_1()) << 12;
                l2 |= tmp[tmpIdx + 9] << 9;
                l2 |= tmp[tmpIdx + 10] << 6;
                l2 |= tmp[tmpIdx + 11] << 3;
                ints[intsIdx + 2] = l2 |= tmp[tmpIdx + 12] << 0;
                ++iter;
                tmpIdx += 13;
                intsIdx += 3;
            }
        }

        public final void decode14(@NotNull PostingDecodingUtil pdu, @NotNull int[] tmp, @NotNull int[] ints) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
            Intrinsics.checkNotNullParameter((Object)tmp, (String)"tmp");
            Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
            pdu.splitInts(56, ints, 2, 14, this.getMASK16_14(), tmp, 0, this.getMASK16_2());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 56;
            while (iter < 8) {
                int l0 = tmp[tmpIdx + 0] << 12;
                l0 |= tmp[tmpIdx + 1] << 10;
                l0 |= tmp[tmpIdx + 2] << 8;
                l0 |= tmp[tmpIdx + 3] << 6;
                l0 |= tmp[tmpIdx + 4] << 4;
                l0 |= tmp[tmpIdx + 5] << 2;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 6] << 0;
                ++iter;
                tmpIdx += 7;
                ++intsIdx;
            }
        }

        public final void decode15(@NotNull PostingDecodingUtil pdu, @NotNull int[] tmp, @NotNull int[] ints) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
            Intrinsics.checkNotNullParameter((Object)tmp, (String)"tmp");
            Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
            pdu.splitInts(60, ints, 1, 15, this.getMASK16_15(), tmp, 0, this.getMASK16_1());
            int iter = 0;
            int tmpIdx = 0;
            int intsIdx = 60;
            while (iter < 4) {
                int l0 = tmp[tmpIdx + 0] << 14;
                l0 |= tmp[tmpIdx + 1] << 13;
                l0 |= tmp[tmpIdx + 2] << 12;
                l0 |= tmp[tmpIdx + 3] << 11;
                l0 |= tmp[tmpIdx + 4] << 10;
                l0 |= tmp[tmpIdx + 5] << 9;
                l0 |= tmp[tmpIdx + 6] << 8;
                l0 |= tmp[tmpIdx + 7] << 7;
                l0 |= tmp[tmpIdx + 8] << 6;
                l0 |= tmp[tmpIdx + 9] << 5;
                l0 |= tmp[tmpIdx + 10] << 4;
                l0 |= tmp[tmpIdx + 11] << 3;
                l0 |= tmp[tmpIdx + 12] << 2;
                l0 |= tmp[tmpIdx + 13] << 1;
                ints[intsIdx + 0] = l0 |= tmp[tmpIdx + 14] << 0;
                ++iter;
                tmpIdx += 15;
                ++intsIdx;
            }
        }

        public final void decode16(@NotNull PostingDecodingUtil pdu, @NotNull int[] ints) throws IOException {
            Intrinsics.checkNotNullParameter((Object)pdu, (String)"pdu");
            Intrinsics.checkNotNullParameter((Object)ints, (String)"ints");
            pdu.getIn().readInts(ints, 0, 64);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

