/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene101;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.gnit.lucenekmp.codecs.BlockTermState;
import org.gnit.lucenekmp.codecs.FieldsConsumer;
import org.gnit.lucenekmp.codecs.FieldsProducer;
import org.gnit.lucenekmp.codecs.PostingsFormat;
import org.gnit.lucenekmp.codecs.PostingsReaderBase;
import org.gnit.lucenekmp.codecs.PostingsWriterBase;
import org.gnit.lucenekmp.codecs.lucene101.Lucene101PostingsReader;
import org.gnit.lucenekmp.codecs.lucene101.Lucene101PostingsWriter;
import org.gnit.lucenekmp.codecs.lucene90.blocktree.Lucene90BlockTreeTermsReader;
import org.gnit.lucenekmp.codecs.lucene90.blocktree.Lucene90BlockTreeTermsWriter;
import org.gnit.lucenekmp.index.ImpactsEnum;
import org.gnit.lucenekmp.index.SegmentReadState;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.index.TermState;
import org.gnit.lucenekmp.util.IOUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0002\u000f\u0010B'\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000eH\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsFormat;", "Lorg/gnit/lucenekmp/codecs/PostingsFormat;", "minTermBlockSize", "", "maxTermBlockSize", "version", "<init>", "(III)V", "fieldsConsumer", "Lorg/gnit/lucenekmp/codecs/FieldsConsumer;", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "fieldsProducer", "Lorg/gnit/lucenekmp/codecs/FieldsProducer;", "Lorg/gnit/lucenekmp/index/SegmentReadState;", "IntBlockTermState", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLucene101PostingsFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene101PostingsFormat.kt\norg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsFormat\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,517:1\n1#2:518\n*E\n"})
public final class Lucene101PostingsFormat
extends PostingsFormat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int version;
    private final int minTermBlockSize;
    private final int maxTermBlockSize;
    @NotNull
    public static final String META_EXTENSION = "psm";
    @NotNull
    public static final String DOC_EXTENSION = "doc";
    @NotNull
    public static final String POS_EXTENSION = "pos";
    @NotNull
    public static final String PAY_EXTENSION = "pay";
    public static final int BLOCK_SIZE = 128;
    public static final int BLOCK_MASK = 127;
    public static final int LEVEL1_FACTOR = 32;
    public static final int LEVEL1_NUM_DOCS = 4096;
    public static final int LEVEL1_MASK = 4095;
    @NotNull
    public static final String TERMS_CODEC = "Lucene90PostingsWriterTerms";
    @NotNull
    public static final String META_CODEC = "Lucene101PostingsWriterMeta";
    @NotNull
    public static final String DOC_CODEC = "Lucene101PostingsWriterDoc";
    @NotNull
    public static final String POS_CODEC = "Lucene101PostingsWriterPos";
    @NotNull
    public static final String PAY_CODEC = "Lucene101PostingsWriterPay";
    public static final int VERSION_START = 0;
    public static final int VERSION_DENSE_BLOCKS_AS_BITSETS = 1;
    public static final int VERSION_CURRENT = 1;

    @JvmOverloads
    public Lucene101PostingsFormat(int minTermBlockSize, int maxTermBlockSize, int version) {
        super("Lucene101");
        if (!(version >= 0 && version <= 1)) {
            boolean bl = false;
            String string = "Version out of range: " + version;
            throw new IllegalArgumentException(string.toString());
        }
        this.version = version;
        Lucene90BlockTreeTermsWriter.Companion.validateSettings(minTermBlockSize, maxTermBlockSize);
        this.minTermBlockSize = minTermBlockSize;
        this.maxTermBlockSize = maxTermBlockSize;
    }

    public /* synthetic */ Lucene101PostingsFormat(int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 1) != 0) {
            n = 25;
        }
        if ((n4 & 2) != 0) {
            n2 = 48;
        }
        if ((n4 & 4) != 0) {
            n3 = 1;
        }
        this(n, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FieldsConsumer fieldsConsumer(@NotNull SegmentWriteState state2) throws IOException {
        FieldsConsumer fieldsConsumer;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        PostingsWriterBase postingsWriter = new Lucene101PostingsWriter(state2, this.version);
        boolean success = false;
        try {
            FieldsConsumer ret = new Lucene90BlockTreeTermsWriter(state2, postingsWriter, this.minTermBlockSize, this.maxTermBlockSize);
            success = true;
            fieldsConsumer = ret;
        }
        catch (Throwable throwable) {
            if (!success) {
                AutoCloseable[] autoCloseableArray = new AutoCloseable[]{postingsWriter};
                IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
            }
            throw throwable;
        }
        return fieldsConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FieldsProducer fieldsProducer(@NotNull SegmentReadState state2) throws IOException {
        FieldsProducer fieldsProducer;
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        PostingsReaderBase postingsReader2 = new Lucene101PostingsReader(state2);
        boolean success = false;
        try {
            FieldsProducer ret = new Lucene90BlockTreeTermsReader(postingsReader2, state2);
            success = true;
            fieldsProducer = ret;
        }
        catch (Throwable throwable) {
            if (!success) {
                AutoCloseable[] autoCloseableArray = new AutoCloseable[]{postingsReader2};
                IOUtils.INSTANCE.closeWhileHandlingException(autoCloseableArray);
            }
            throw throwable;
        }
        return fieldsProducer;
    }

    @JvmOverloads
    public Lucene101PostingsFormat(int minTermBlockSize, int maxTermBlockSize) {
        this(minTermBlockSize, maxTermBlockSize, 0, 4, null);
    }

    @JvmOverloads
    public Lucene101PostingsFormat(int minTermBlockSize) {
        this(minTermBlockSize, 0, 0, 6, null);
    }

    @JvmOverloads
    public Lucene101PostingsFormat() {
        this(0, 0, 0, 7, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsFormat$Companion;", "", "<init>", "()V", "META_EXTENSION", "", "DOC_EXTENSION", "POS_EXTENSION", "PAY_EXTENSION", "BLOCK_SIZE", "", "BLOCK_MASK", "LEVEL1_FACTOR", "LEVEL1_NUM_DOCS", "LEVEL1_MASK", "getImpactsEnumImpl", "Lkotlin/reflect/KClass;", "Lorg/gnit/lucenekmp/index/ImpactsEnum;", "TERMS_CODEC", "META_CODEC", "DOC_CODEC", "POS_CODEC", "PAY_CODEC", "VERSION_START", "VERSION_DENSE_BLOCKS_AS_BITSETS", "VERSION_CURRENT", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KClass<? extends ImpactsEnum> getImpactsEnumImpl() {
            return Reflection.getOrCreateKotlinClass(Lucene101PostingsReader.BlockPostingsEnum.class);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0019\u001a\u00020\u0000H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001a\u0010\r\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006 "}, d2={"Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsFormat$IntBlockTermState;", "Lorg/gnit/lucenekmp/codecs/BlockTermState;", "<init>", "()V", "docStartFP", "", "getDocStartFP", "()J", "setDocStartFP", "(J)V", "posStartFP", "getPosStartFP", "setPosStartFP", "payStartFP", "getPayStartFP", "setPayStartFP", "lastPosBlockOffset", "getLastPosBlockOffset", "setLastPosBlockOffset", "singletonDocID", "", "getSingletonDocID", "()I", "setSingletonDocID", "(I)V", "clone", "copyFrom", "", "_other", "Lorg/gnit/lucenekmp/index/TermState;", "toString", "", "core"})
    public static final class IntBlockTermState
    extends BlockTermState {
        private long docStartFP;
        private long posStartFP;
        private long payStartFP;
        private long lastPosBlockOffset = -1L;
        private int singletonDocID = -1;

        public final long getDocStartFP() {
            return this.docStartFP;
        }

        public final void setDocStartFP(long l) {
            this.docStartFP = l;
        }

        public final long getPosStartFP() {
            return this.posStartFP;
        }

        public final void setPosStartFP(long l) {
            this.posStartFP = l;
        }

        public final long getPayStartFP() {
            return this.payStartFP;
        }

        public final void setPayStartFP(long l) {
            this.payStartFP = l;
        }

        public final long getLastPosBlockOffset() {
            return this.lastPosBlockOffset;
        }

        public final void setLastPosBlockOffset(long l) {
            this.lastPosBlockOffset = l;
        }

        public final int getSingletonDocID() {
            return this.singletonDocID;
        }

        public final void setSingletonDocID(int n) {
            this.singletonDocID = n;
        }

        @Override
        @NotNull
        public IntBlockTermState clone() {
            IntBlockTermState other = new IntBlockTermState();
            other.copyFrom(this);
            return other;
        }

        @Override
        public void copyFrom(@NotNull TermState _other) {
            Intrinsics.checkNotNullParameter((Object)_other, (String)"_other");
            super.copyFrom(_other);
            IntBlockTermState other = (IntBlockTermState)_other;
            this.docStartFP = other.docStartFP;
            this.posStartFP = other.posStartFP;
            this.payStartFP = other.payStartFP;
            this.lastPosBlockOffset = other.lastPosBlockOffset;
            this.singletonDocID = other.singletonDocID;
        }

        @Override
        @NotNull
        public String toString() {
            return super.toString() + " docStartFP=" + this.docStartFP + " posStartFP=" + this.posStartFP + " payStartFP=" + this.payStartFP + " lastPosBlockOffset=" + this.lastPosBlockOffset + " singletonDocID=" + this.singletonDocID;
        }
    }
}

