/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene101;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.LongCompanionObject;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gnit.lucenekmp.codecs.BlockTermState;
import org.gnit.lucenekmp.codecs.CodecUtil;
import org.gnit.lucenekmp.codecs.CompetitiveImpactAccumulator;
import org.gnit.lucenekmp.codecs.PushPostingsWriterBase;
import org.gnit.lucenekmp.codecs.lucene101.ForDeltaUtil;
import org.gnit.lucenekmp.codecs.lucene101.Lucene101PostingsFormat;
import org.gnit.lucenekmp.codecs.lucene101.PForUtil;
import org.gnit.lucenekmp.codecs.lucene101.PostingsUtil;
import org.gnit.lucenekmp.index.CorruptIndexException;
import org.gnit.lucenekmp.index.FieldInfo;
import org.gnit.lucenekmp.index.FieldInfos;
import org.gnit.lucenekmp.index.Impact;
import org.gnit.lucenekmp.index.IndexFileNames;
import org.gnit.lucenekmp.index.NumericDocValues;
import org.gnit.lucenekmp.index.SegmentWriteState;
import org.gnit.lucenekmp.jdkport.LongExtKt;
import org.gnit.lucenekmp.jdkport.Math;
import org.gnit.lucenekmp.jdkport.System;
import org.gnit.lucenekmp.store.ByteBuffersDataOutput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.store.IndexOutput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BitUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.gnit.lucenekmp.util.FixedBitSet;
import org.gnit.lucenekmp.util.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u000f\n\u0002\u0010\u0012\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 p2\u00020\u0001:\u0001pB\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\bJ\b\u0010U\u001a\u00020\u0019H\u0016J\u0018\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u0010\u0010Y\u001a\u00020W2\u0006\u0010Z\u001a\u00020[H\u0016J\u0010\u0010\\\u001a\u00020W2\u0006\u0010F\u001a\u00020GH\u0016J\u0018\u0010]\u001a\u00020W2\u0006\u0010;\u001a\u00020\u00052\u0006\u0010^\u001a\u00020\u0005H\u0016J*\u0010_\u001a\u00020W2\u0006\u0010`\u001a\u00020\u00052\b\u0010a\u001a\u0004\u0018\u00010b2\u0006\u0010c\u001a\u00020\u00052\u0006\u0010d\u001a\u00020\u0005H\u0016J\b\u0010e\u001a\u00020WH\u0016J\u0010\u0010f\u001a\u00020W2\u0006\u0010g\u001a\u00020EH\u0002J\b\u0010h\u001a\u00020WH\u0002J\u0010\u0010g\u001a\u00020W2\u0006\u0010i\u001a\u00020jH\u0016J(\u0010k\u001a\u00020W2\u0006\u0010l\u001a\u00020m2\u0006\u0010Z\u001a\u00020[2\u0006\u0010i\u001a\u00020j2\u0006\u0010n\u001a\u00020EH\u0016J\b\u0010o\u001a\u00020WH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\f\"\u0004\b\u0014\u0010\u000eR\u001c\u0010\u0015\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\f\"\u0004\b\u0017\u0010\u000eR\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010%R\u000e\u0010(\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010)\u001a\u0004\u0018\u00010#\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010%R\u0013\u0010+\u001a\u0004\u0018\u00010#\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010%R\u0013\u0010-\u001a\u0004\u0018\u00010#\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010%R\u0013\u0010/\u001a\u0004\u0018\u00010#\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010%R\u000e\u00101\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00108\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010<\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010=\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010>\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010?\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u00020AX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010B\u001a\u00020CX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010D\u001a\u00020EX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010F\u001a\u0004\u0018\u00010GX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010H\u001a\u00020IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020IX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010L\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010M\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010N\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020PX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010Q\u001a\u00020PX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010R\u001a\u00020PX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010S\u001a\u00020TX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006q"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsWriter;", "Lorg/gnit/lucenekmp/codecs/PushPostingsWriterBase;", "state", "Lorg/gnit/lucenekmp/index/SegmentWriteState;", "version", "", "<init>", "(Lorg/gnit/lucenekmp/index/SegmentWriteState;I)V", "(Lorg/gnit/lucenekmp/index/SegmentWriteState;)V", "metaOut", "Lorg/gnit/lucenekmp/store/IndexOutput;", "getMetaOut", "()Lorg/gnit/lucenekmp/store/IndexOutput;", "setMetaOut", "(Lorg/gnit/lucenekmp/store/IndexOutput;)V", "docOut", "getDocOut", "setDocOut", "posOut", "getPosOut", "setPosOut", "payOut", "getPayOut", "setPayOut", "lastState", "Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsFormat$IntBlockTermState;", "getLastState", "()Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsFormat$IntBlockTermState;", "setLastState", "(Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsFormat$IntBlockTermState;)V", "docStartFP", "", "posStartFP", "payStartFP", "docDeltaBuffer", "", "getDocDeltaBuffer", "()[I", "freqBuffer", "getFreqBuffer", "docBufferUpto", "posDeltaBuffer", "getPosDeltaBuffer", "payloadLengthBuffer", "getPayloadLengthBuffer", "offsetStartDeltaBuffer", "getOffsetStartDeltaBuffer", "offsetLengthBuffer", "getOffsetLengthBuffer", "posBufferUpto", "payloadBytes", "", "payloadByteUpto", "level0LastDocID", "level0LastPosFP", "level0LastPayFP", "level1LastDocID", "level1LastPosFP", "level1LastPayFP", "docID", "lastDocID", "lastPosition", "lastStartOffset", "docCount", "pforUtil", "Lorg/gnit/lucenekmp/codecs/lucene101/PForUtil;", "forDeltaUtil", "Lorg/gnit/lucenekmp/codecs/lucene101/ForDeltaUtil;", "fieldHasNorms", "", "norms", "Lorg/gnit/lucenekmp/index/NumericDocValues;", "level0FreqNormAccumulator", "Lorg/gnit/lucenekmp/codecs/CompetitiveImpactAccumulator;", "level1CompetitiveFreqNormAccumulator", "maxNumImpactsAtLevel0", "maxImpactNumBytesAtLevel0", "maxNumImpactsAtLevel1", "maxImpactNumBytesAtLevel1", "scratchOutput", "Lorg/gnit/lucenekmp/store/ByteBuffersDataOutput;", "level0Output", "level1Output", "spareBitSet", "Lorg/gnit/lucenekmp/util/FixedBitSet;", "newTermState", "init", "", "termsOut", "setField", "fieldInfo", "Lorg/gnit/lucenekmp/index/FieldInfo;", "startTerm", "startDoc", "termDocFreq", "addPosition", "position", "payload", "Lorg/gnit/lucenekmp/util/BytesRef;", "startOffset", "endOffset", "finishDoc", "flushDocBlock", "finishTerm", "writeLevel1SkipData", "_state", "Lorg/gnit/lucenekmp/codecs/BlockTermState;", "encodeTerm", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "absolute", "close", "Companion", "core"})
@SourceDebugExtension(value={"SMAP\nLucene101PostingsWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Lucene101PostingsWriter.kt\norg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsWriter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,729:1\n1#2:730\n*E\n"})
public final class Lucene101PostingsWriter
extends PushPostingsWriterBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int version;
    @Nullable
    private IndexOutput metaOut;
    @Nullable
    private IndexOutput docOut;
    @Nullable
    private IndexOutput posOut;
    @Nullable
    private IndexOutput payOut;
    @Nullable
    private Lucene101PostingsFormat.IntBlockTermState lastState;
    private long docStartFP;
    private long posStartFP;
    private long payStartFP;
    @NotNull
    private final int[] docDeltaBuffer;
    @NotNull
    private final int[] freqBuffer;
    private int docBufferUpto;
    @Nullable
    private final int[] posDeltaBuffer;
    @Nullable
    private final int[] payloadLengthBuffer;
    @Nullable
    private final int[] offsetStartDeltaBuffer;
    @Nullable
    private final int[] offsetLengthBuffer;
    private int posBufferUpto;
    @Nullable
    private byte[] payloadBytes;
    private int payloadByteUpto;
    private int level0LastDocID;
    private long level0LastPosFP;
    private long level0LastPayFP;
    private int level1LastDocID;
    private long level1LastPosFP;
    private long level1LastPayFP;
    private int docID;
    private int lastDocID;
    private int lastPosition;
    private int lastStartOffset;
    private int docCount;
    @NotNull
    private final PForUtil pforUtil;
    @NotNull
    private final ForDeltaUtil forDeltaUtil;
    private boolean fieldHasNorms;
    @Nullable
    private NumericDocValues norms;
    @NotNull
    private final CompetitiveImpactAccumulator level0FreqNormAccumulator;
    @NotNull
    private final CompetitiveImpactAccumulator level1CompetitiveFreqNormAccumulator;
    private int maxNumImpactsAtLevel0;
    private int maxImpactNumBytesAtLevel0;
    private int maxNumImpactsAtLevel1;
    private int maxImpactNumBytesAtLevel1;
    @NotNull
    private final ByteBuffersDataOutput scratchOutput;
    @NotNull
    private final ByteBuffersDataOutput level0Output;
    @NotNull
    private final ByteBuffersDataOutput level1Output;
    @NotNull
    private final FixedBitSet spareBitSet;
    @NotNull
    private static final Lucene101PostingsFormat.IntBlockTermState EMPTY_STATE = new Lucene101PostingsFormat.IntBlockTermState();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lucene101PostingsWriter(@NotNull SegmentWriteState state2, int version) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.version = version;
        this.level0FreqNormAccumulator = new CompetitiveImpactAccumulator();
        this.level1CompetitiveFreqNormAccumulator = new CompetitiveImpactAccumulator();
        this.scratchOutput = ByteBuffersDataOutput.Companion.newResettableInstance();
        this.level0Output = ByteBuffersDataOutput.Companion.newResettableInstance();
        this.level1Output = ByteBuffersDataOutput.Companion.newResettableInstance();
        this.spareBitSet = new FixedBitSet(4096);
        String metaFileName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), "psm");
        String docFileName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), "doc");
        this.metaOut = state2.getDirectory().createOutput(metaFileName, state2.getContext());
        IndexOutput posOut = null;
        IndexOutput payOut = null;
        boolean success = false;
        try {
            this.docOut = state2.getDirectory().createOutput(docFileName, state2.getContext());
            IndexOutput indexOutput = this.metaOut;
            Intrinsics.checkNotNull((Object)indexOutput);
            CodecUtil.INSTANCE.writeIndexHeader(indexOutput, "Lucene101PostingsWriterMeta", this.version, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
            IndexOutput indexOutput2 = this.docOut;
            Intrinsics.checkNotNull((Object)indexOutput2);
            CodecUtil.INSTANCE.writeIndexHeader(indexOutput2, "Lucene101PostingsWriterDoc", this.version, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
            this.forDeltaUtil = new ForDeltaUtil();
            this.pforUtil = new PForUtil();
            FieldInfos fieldInfos = state2.getFieldInfos();
            Intrinsics.checkNotNull((Object)fieldInfos);
            if (fieldInfos.hasProx()) {
                this.posDeltaBuffer = new int[128];
                String posFileName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), "pos");
                posOut = state2.getDirectory().createOutput(posFileName, state2.getContext());
                CodecUtil.INSTANCE.writeIndexHeader(posOut, "Lucene101PostingsWriterPos", this.version, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
                if (state2.getFieldInfos().hasPayloads()) {
                    this.payloadBytes = new byte[128];
                    this.payloadLengthBuffer = new int[128];
                } else {
                    this.payloadBytes = null;
                    this.payloadLengthBuffer = null;
                }
                if (state2.getFieldInfos().hasOffsets()) {
                    this.offsetStartDeltaBuffer = new int[128];
                    this.offsetLengthBuffer = new int[128];
                } else {
                    this.offsetStartDeltaBuffer = null;
                    this.offsetLengthBuffer = null;
                }
                if (state2.getFieldInfos().hasPayloads() || state2.getFieldInfos().hasOffsets()) {
                    String payFileName = IndexFileNames.INSTANCE.segmentFileName(state2.getSegmentInfo().getName(), state2.getSegmentSuffix(), "pay");
                    payOut = state2.getDirectory().createOutput(payFileName, state2.getContext());
                    CodecUtil.INSTANCE.writeIndexHeader(payOut, "Lucene101PostingsWriterPay", this.version, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
                }
            } else {
                this.posDeltaBuffer = null;
                this.payloadLengthBuffer = null;
                this.offsetStartDeltaBuffer = null;
                this.offsetLengthBuffer = null;
                this.payloadBytes = null;
            }
            this.payOut = payOut;
            this.posOut = posOut;
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.metaOut, this.docOut, posOut, payOut};
            IOUtils.INSTANCE.closeWhileHandlingExceptionNullable(autoCloseableArray);
            throw throwable;
        }
        this.docDeltaBuffer = new int[128];
        this.freqBuffer = new int[128];
    }

    @Nullable
    public final IndexOutput getMetaOut() {
        return this.metaOut;
    }

    public final void setMetaOut(@Nullable IndexOutput indexOutput) {
        this.metaOut = indexOutput;
    }

    @Nullable
    public final IndexOutput getDocOut() {
        return this.docOut;
    }

    public final void setDocOut(@Nullable IndexOutput indexOutput) {
        this.docOut = indexOutput;
    }

    @Nullable
    public final IndexOutput getPosOut() {
        return this.posOut;
    }

    public final void setPosOut(@Nullable IndexOutput indexOutput) {
        this.posOut = indexOutput;
    }

    @Nullable
    public final IndexOutput getPayOut() {
        return this.payOut;
    }

    public final void setPayOut(@Nullable IndexOutput indexOutput) {
        this.payOut = indexOutput;
    }

    @Nullable
    public final Lucene101PostingsFormat.IntBlockTermState getLastState() {
        return this.lastState;
    }

    public final void setLastState(@Nullable Lucene101PostingsFormat.IntBlockTermState intBlockTermState) {
        this.lastState = intBlockTermState;
    }

    @NotNull
    public final int[] getDocDeltaBuffer() {
        return this.docDeltaBuffer;
    }

    @NotNull
    public final int[] getFreqBuffer() {
        return this.freqBuffer;
    }

    @Nullable
    public final int[] getPosDeltaBuffer() {
        return this.posDeltaBuffer;
    }

    @Nullable
    public final int[] getPayloadLengthBuffer() {
        return this.payloadLengthBuffer;
    }

    @Nullable
    public final int[] getOffsetStartDeltaBuffer() {
        return this.offsetStartDeltaBuffer;
    }

    @Nullable
    public final int[] getOffsetLengthBuffer() {
        return this.offsetLengthBuffer;
    }

    public Lucene101PostingsWriter(@NotNull SegmentWriteState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this(state2, 1);
    }

    @Override
    @NotNull
    public Lucene101PostingsFormat.IntBlockTermState newTermState() {
        return new Lucene101PostingsFormat.IntBlockTermState();
    }

    @Override
    public void init(@NotNull IndexOutput termsOut, @NotNull SegmentWriteState state2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)termsOut, (String)"termsOut");
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        CodecUtil.INSTANCE.writeIndexHeader(termsOut, "Lucene90PostingsWriterTerms", this.version, state2.getSegmentInfo().getId(), state2.getSegmentSuffix());
        termsOut.writeVInt(128);
    }

    @Override
    public void setField(@NotNull FieldInfo fieldInfo) {
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        super.setField(fieldInfo);
        this.lastState = EMPTY_STATE;
        this.fieldHasNorms = fieldInfo.hasNorms();
    }

    @Override
    public void startTerm(@NotNull NumericDocValues norms) {
        Intrinsics.checkNotNullParameter((Object)norms, (String)"norms");
        IndexOutput indexOutput = this.docOut;
        Intrinsics.checkNotNull((Object)indexOutput);
        this.docStartFP = indexOutput.getFilePointer();
        if (this.getWritePositions()) {
            IndexOutput indexOutput2 = this.posOut;
            Intrinsics.checkNotNull((Object)indexOutput2);
            this.level1LastPosFP = this.level0LastPosFP = (this.posStartFP = indexOutput2.getFilePointer());
            if (this.getWritePayloads() || this.getWriteOffsets()) {
                IndexOutput indexOutput3 = this.payOut;
                Intrinsics.checkNotNull((Object)indexOutput3);
                this.level1LastPayFP = this.level0LastPayFP = (this.payStartFP = indexOutput3.getFilePointer());
            }
        }
        this.lastDocID = -1;
        this.level0LastDocID = -1;
        this.level1LastDocID = -1;
        this.norms = norms;
        if (this.getWriteFreqs()) {
            this.level0FreqNormAccumulator.clear();
        }
    }

    @Override
    public void startDoc(int docID, int termDocFreq) throws IOException {
        if (this.docBufferUpto == 128) {
            this.flushDocBlock(false);
            this.docBufferUpto = 0;
        }
        int docDelta = docID - this.lastDocID;
        if (docID < 0 || docDelta <= 0) {
            String string = "docs out of order (" + docID + " <= " + this.lastDocID + " )";
            IndexOutput indexOutput = this.docOut;
            Intrinsics.checkNotNull((Object)indexOutput);
            throw new CorruptIndexException(string, indexOutput);
        }
        this.docDeltaBuffer[this.docBufferUpto] = docDelta;
        if (this.getWriteFreqs()) {
            this.freqBuffer[this.docBufferUpto] = termDocFreq;
        }
        this.docID = docID;
        this.lastPosition = 0;
        this.lastStartOffset = 0;
        if (this.getWriteFreqs()) {
            long norm = 0L;
            if (this.fieldHasNorms) {
                NumericDocValues numericDocValues = this.norms;
                Intrinsics.checkNotNull((Object)numericDocValues);
                boolean found = numericDocValues.advanceExact(docID);
                if (!found) {
                    norm = 1L;
                } else {
                    NumericDocValues numericDocValues2 = this.norms;
                    Intrinsics.checkNotNull((Object)numericDocValues2);
                    norm = numericDocValues2.longValue();
                    if (!(norm != 0L)) {
                        boolean bl = false;
                        Integer n = docID;
                        throw new IllegalArgumentException(((Object)n).toString());
                    }
                }
            } else {
                norm = 1L;
            }
            this.level0FreqNormAccumulator.add(termDocFreq, norm);
        }
    }

    @Override
    public void addPosition(int position, @Nullable BytesRef payload, int startOffset, int endOffset) throws IOException {
        if (position > 0x7FFFFF7F) {
            String string = "position=" + position + " is too large (> IndexWriter.MAX_POSITION=2147483519)";
            IndexOutput indexOutput = this.docOut;
            Intrinsics.checkNotNull((Object)indexOutput);
            throw new CorruptIndexException(string, indexOutput);
        }
        if (position < 0) {
            String string = "position=" + position + " is < 0";
            IndexOutput indexOutput = this.docOut;
            Intrinsics.checkNotNull((Object)indexOutput);
            throw new CorruptIndexException(string, indexOutput);
        }
        Intrinsics.checkNotNull((Object)this.posDeltaBuffer);
        this.posDeltaBuffer[this.posBufferUpto] = position - this.lastPosition;
        if (this.getWritePayloads()) {
            if (payload == null || payload.getLength() == 0) {
                Intrinsics.checkNotNull((Object)this.payloadLengthBuffer);
                this.payloadLengthBuffer[this.posBufferUpto] = 0;
            } else {
                Intrinsics.checkNotNull((Object)this.payloadLengthBuffer);
                this.payloadLengthBuffer[this.posBufferUpto] = payload.getLength();
                int n = this.payloadByteUpto + payload.getLength();
                Intrinsics.checkNotNull((Object)this.payloadBytes);
                if (n > this.payloadBytes.length) {
                    Intrinsics.checkNotNull((Object)this.payloadBytes);
                    this.payloadBytes = ArrayUtil.Companion.grow(this.payloadBytes, this.payloadByteUpto + payload.getLength());
                }
                byte[] byArray = payload.getBytes();
                int n2 = payload.getOffset();
                Intrinsics.checkNotNull((Object)this.payloadBytes);
                System.INSTANCE.arraycopy(byArray, n2, this.payloadBytes, this.payloadByteUpto, payload.getLength());
                this.payloadByteUpto += payload.getLength();
            }
        }
        if (this.getWriteOffsets()) {
            if (!(startOffset >= this.lastStartOffset)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(endOffset >= startOffset)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            Intrinsics.checkNotNull((Object)this.offsetStartDeltaBuffer);
            this.offsetStartDeltaBuffer[this.posBufferUpto] = startOffset - this.lastStartOffset;
            Intrinsics.checkNotNull((Object)this.offsetLengthBuffer);
            this.offsetLengthBuffer[this.posBufferUpto] = endOffset - startOffset;
            this.lastStartOffset = startOffset;
        }
        int n = this.posBufferUpto;
        this.posBufferUpto = n + 1;
        this.lastPosition = position;
        if (this.posBufferUpto == 128) {
            IndexOutput indexOutput = this.posOut;
            Intrinsics.checkNotNull((Object)indexOutput);
            this.pforUtil.encode(this.posDeltaBuffer, indexOutput);
            if (this.getWritePayloads()) {
                Intrinsics.checkNotNull((Object)this.payloadLengthBuffer);
                IndexOutput indexOutput2 = this.payOut;
                Intrinsics.checkNotNull((Object)indexOutput2);
                this.pforUtil.encode(this.payloadLengthBuffer, indexOutput2);
                IndexOutput indexOutput3 = this.payOut;
                Intrinsics.checkNotNull((Object)indexOutput3);
                indexOutput3.writeVInt(this.payloadByteUpto);
                IndexOutput indexOutput4 = this.payOut;
                Intrinsics.checkNotNull((Object)indexOutput4);
                Intrinsics.checkNotNull((Object)this.payloadBytes);
                indexOutput4.writeBytes(this.payloadBytes, 0, this.payloadByteUpto);
                this.payloadByteUpto = 0;
            }
            if (this.getWriteOffsets()) {
                Intrinsics.checkNotNull((Object)this.offsetStartDeltaBuffer);
                IndexOutput indexOutput5 = this.payOut;
                Intrinsics.checkNotNull((Object)indexOutput5);
                this.pforUtil.encode(this.offsetStartDeltaBuffer, indexOutput5);
                Intrinsics.checkNotNull((Object)this.offsetLengthBuffer);
                IndexOutput indexOutput6 = this.payOut;
                Intrinsics.checkNotNull((Object)indexOutput6);
                this.pforUtil.encode(this.offsetLengthBuffer, indexOutput6);
            }
            this.posBufferUpto = 0;
        }
    }

    @Override
    public void finishDoc() {
        int n = this.docBufferUpto;
        this.docBufferUpto = n + 1;
        n = this.docCount;
        this.docCount = n + 1;
        this.lastDocID = this.docID;
    }

    private final void flushDocBlock(boolean finishTerm) throws IOException {
        if (!(this.docBufferUpto != 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (this.docBufferUpto < 128) {
            if (!finishTerm) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            PostingsUtil.INSTANCE.writeVIntBlock(this.level0Output, this.docDeltaBuffer, this.freqBuffer, this.docBufferUpto, this.getWriteFreqs());
        } else {
            if (this.getWriteFreqs()) {
                List<Impact> impacts2 = this.level0FreqNormAccumulator.getCompetitiveFreqNormPairs();
                if (impacts2.size() > this.maxNumImpactsAtLevel0) {
                    this.maxNumImpactsAtLevel0 = impacts2.size();
                }
                Companion.writeImpacts((Collection<Impact>)impacts2, this.scratchOutput);
                if (!(this.level0Output.size() == 0L)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (this.scratchOutput.size() > (long)this.maxImpactNumBytesAtLevel0) {
                    this.maxImpactNumBytesAtLevel0 = Math.INSTANCE.toIntExact(this.scratchOutput.size());
                }
                this.level0Output.writeVLong(this.scratchOutput.size());
                this.scratchOutput.copyTo(this.level0Output);
                this.scratchOutput.reset();
                if (this.getWritePositions()) {
                    IndexOutput indexOutput = this.posOut;
                    Intrinsics.checkNotNull((Object)indexOutput);
                    this.level0Output.writeVLong(indexOutput.getFilePointer() - this.level0LastPosFP);
                    this.level0Output.writeByte((byte)this.posBufferUpto);
                    IndexOutput indexOutput2 = this.posOut;
                    Intrinsics.checkNotNull((Object)indexOutput2);
                    this.level0LastPosFP = indexOutput2.getFilePointer();
                    if (this.getWriteOffsets() || this.getWritePayloads()) {
                        IndexOutput indexOutput3 = this.payOut;
                        Intrinsics.checkNotNull((Object)indexOutput3);
                        this.level0Output.writeVLong(indexOutput3.getFilePointer() - this.level0LastPayFP);
                        this.level0Output.writeVInt(this.payloadByteUpto);
                        IndexOutput indexOutput4 = this.payOut;
                        Intrinsics.checkNotNull((Object)indexOutput4);
                        this.level0LastPayFP = indexOutput4.getFilePointer();
                    }
                }
            }
            long numSkipBytes = this.level0Output.size();
            int bitsPerValue = this.forDeltaUtil.bitsRequired(this.docDeltaBuffer);
            int sum = Math.INSTANCE.toIntExact(ArraysKt.sum((int[])this.docDeltaBuffer));
            int numBitSetLongs = FixedBitSet.Companion.bits2words(sum);
            int numBitsNextBitsPerValue = java.lang.Math.min(32, bitsPerValue + 1) * 128;
            if (sum == 128) {
                this.level0Output.writeByte((byte)0);
            } else if (this.version < 1 || numBitsNextBitsPerValue <= sum) {
                this.level0Output.writeByte((byte)bitsPerValue);
                this.forDeltaUtil.encodeDeltas(bitsPerValue, this.docDeltaBuffer, this.level0Output);
            } else {
                this.spareBitSet.clear(0, numBitSetLongs << 6);
                int s = -1;
                for (int i : this.docDeltaBuffer) {
                    this.spareBitSet.set(s += i);
                }
                if (!(numBitSetLongs <= 64)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                this.level0Output.writeByte((byte)(-numBitSetLongs));
                for (int i = 0; i < numBitSetLongs; ++i) {
                    this.level0Output.writeLong(this.spareBitSet.getBits()[i]);
                }
            }
            if (this.getWriteFreqs()) {
                this.pforUtil.encode(this.freqBuffer, this.level0Output);
            }
            Companion.writeVInt15(this.scratchOutput, this.docID - this.level0LastDocID);
            Companion.writeVLong15(this.scratchOutput, this.level0Output.size());
            this.level1Output.writeVLong(numSkipBytes += this.scratchOutput.size());
            this.scratchOutput.copyTo(this.level1Output);
            this.scratchOutput.reset();
        }
        this.level0Output.copyTo(this.level1Output);
        this.level0Output.reset();
        this.level0LastDocID = this.docID;
        if (this.getWriteFreqs()) {
            this.level1CompetitiveFreqNormAccumulator.addAll(this.level0FreqNormAccumulator);
            this.level0FreqNormAccumulator.clear();
        }
        if ((this.docCount & 0xFFF) == 0) {
            this.writeLevel1SkipData();
            this.level1LastDocID = this.docID;
            this.level1CompetitiveFreqNormAccumulator.clear();
        } else if (finishTerm) {
            IndexOutput indexOutput = this.docOut;
            Intrinsics.checkNotNull((Object)indexOutput);
            this.level1Output.copyTo(indexOutput);
            this.level1Output.reset();
            this.level1CompetitiveFreqNormAccumulator.clear();
        }
    }

    private final void writeLevel1SkipData() throws IOException {
        IndexOutput indexOutput = this.docOut;
        Intrinsics.checkNotNull((Object)indexOutput);
        indexOutput.writeVInt(this.docID - this.level1LastDocID);
        long level1End = 0L;
        if (this.getWriteFreqs()) {
            List<Impact> impacts2 = this.level1CompetitiveFreqNormAccumulator.getCompetitiveFreqNormPairs();
            if (impacts2.size() > this.maxNumImpactsAtLevel1) {
                this.maxNumImpactsAtLevel1 = impacts2.size();
            }
            Companion.writeImpacts((Collection<Impact>)impacts2, this.scratchOutput);
            long numImpactBytes = this.scratchOutput.size();
            if (numImpactBytes > (long)this.maxImpactNumBytesAtLevel1) {
                this.maxImpactNumBytesAtLevel1 = Math.INSTANCE.toIntExact(numImpactBytes);
            }
            if (this.getWritePositions()) {
                IndexOutput indexOutput2 = this.posOut;
                Intrinsics.checkNotNull((Object)indexOutput2);
                this.scratchOutput.writeVLong(indexOutput2.getFilePointer() - this.level1LastPosFP);
                this.scratchOutput.writeByte((byte)this.posBufferUpto);
                IndexOutput indexOutput3 = this.posOut;
                Intrinsics.checkNotNull((Object)indexOutput3);
                this.level1LastPosFP = indexOutput3.getFilePointer();
                if (this.getWriteOffsets() || this.getWritePayloads()) {
                    IndexOutput indexOutput4 = this.payOut;
                    Intrinsics.checkNotNull((Object)indexOutput4);
                    this.scratchOutput.writeVLong(indexOutput4.getFilePointer() - this.level1LastPayFP);
                    this.scratchOutput.writeVInt(this.payloadByteUpto);
                    IndexOutput indexOutput5 = this.payOut;
                    Intrinsics.checkNotNull((Object)indexOutput5);
                    this.level1LastPayFP = indexOutput5.getFilePointer();
                }
            }
            long level1Len = (long)4 + this.scratchOutput.size() + this.level1Output.size();
            IndexOutput indexOutput6 = this.docOut;
            Intrinsics.checkNotNull((Object)indexOutput6);
            indexOutput6.writeVLong(level1Len);
            IndexOutput indexOutput7 = this.docOut;
            Intrinsics.checkNotNull((Object)indexOutput7);
            level1End = indexOutput7.getFilePointer() + level1Len;
            if (!(numImpactBytes <= 32767L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!(this.scratchOutput.size() + (long)2 <= 32767L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            IndexOutput indexOutput8 = this.docOut;
            Intrinsics.checkNotNull((Object)indexOutput8);
            indexOutput8.writeShort((short)(this.scratchOutput.size() + (long)2));
            IndexOutput indexOutput9 = this.docOut;
            Intrinsics.checkNotNull((Object)indexOutput9);
            indexOutput9.writeShort((short)numImpactBytes);
            IndexOutput indexOutput10 = this.docOut;
            Intrinsics.checkNotNull((Object)indexOutput10);
            this.scratchOutput.copyTo(indexOutput10);
            this.scratchOutput.reset();
        } else {
            IndexOutput indexOutput11 = this.docOut;
            Intrinsics.checkNotNull((Object)indexOutput11);
            indexOutput11.writeVLong(this.level1Output.size());
            IndexOutput indexOutput12 = this.docOut;
            Intrinsics.checkNotNull((Object)indexOutput12);
            level1End = indexOutput12.getFilePointer() + this.level1Output.size();
        }
        IndexOutput indexOutput13 = this.docOut;
        Intrinsics.checkNotNull((Object)indexOutput13);
        this.level1Output.copyTo(indexOutput13);
        this.level1Output.reset();
        IndexOutput indexOutput14 = this.docOut;
        Intrinsics.checkNotNull((Object)indexOutput14);
        if (!(indexOutput14.getFilePointer() == level1End)) {
            boolean bl = false;
            IndexOutput indexOutput15 = this.docOut;
            Intrinsics.checkNotNull((Object)indexOutput15);
            String string = indexOutput15.getFilePointer() + " " + level1End;
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    public void finishTerm(@NotNull BlockTermState _state) throws IOException {
        Intrinsics.checkNotNullParameter((Object)_state, (String)"_state");
        Lucene101PostingsFormat.IntBlockTermState state2 = (Lucene101PostingsFormat.IntBlockTermState)_state;
        if (!(state2.getDocFreq() > 0)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(state2.getDocFreq() == this.docCount)) {
            boolean $i$a$-require-Lucene101PostingsWriter$finishTerm$22 = false;
            String $i$a$-require-Lucene101PostingsWriter$finishTerm$22 = state2.getDocFreq() + " vs " + this.docCount;
            throw new IllegalArgumentException($i$a$-require-Lucene101PostingsWriter$finishTerm$22.toString());
        }
        int singletonDocID = 0;
        if (state2.getDocFreq() == 1) {
            singletonDocID = this.docDeltaBuffer[0] - 1;
        } else {
            singletonDocID = -1;
            this.flushDocBlock(true);
        }
        long lastPosBlockOffset = 0L;
        if (this.getWritePositions()) {
            if (!(state2.getTotalTermFreq() != -1L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (state2.getTotalTermFreq() > 128L) {
                IndexOutput indexOutput = this.posOut;
                Intrinsics.checkNotNull((Object)indexOutput);
                v1 = indexOutput.getFilePointer() - this.posStartFP;
            } else {
                v1 = lastPosBlockOffset = -1L;
            }
            if (this.posBufferUpto > 0) {
                if (!(this.posBufferUpto < 128)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                int lastPayloadLength = -1;
                int lastOffsetLength = -1;
                int payloadBytesReadUpto = 0;
                int n = this.posBufferUpto;
                for (int i = 0; i < n; ++i) {
                    Intrinsics.checkNotNull((Object)this.posDeltaBuffer);
                    int posDelta = this.posDeltaBuffer[i];
                    if (this.getWritePayloads()) {
                        Intrinsics.checkNotNull((Object)this.payloadLengthBuffer);
                        int payloadLength = this.payloadLengthBuffer[i];
                        if (payloadLength != lastPayloadLength) {
                            lastPayloadLength = payloadLength;
                            IndexOutput indexOutput = this.posOut;
                            Intrinsics.checkNotNull((Object)indexOutput);
                            indexOutput.writeVInt(posDelta << 1 | 1);
                            IndexOutput indexOutput2 = this.posOut;
                            Intrinsics.checkNotNull((Object)indexOutput2);
                            indexOutput2.writeVInt(payloadLength);
                        } else {
                            IndexOutput indexOutput = this.posOut;
                            Intrinsics.checkNotNull((Object)indexOutput);
                            indexOutput.writeVInt(posDelta << 1);
                        }
                        if (payloadLength != 0) {
                            IndexOutput indexOutput = this.posOut;
                            Intrinsics.checkNotNull((Object)indexOutput);
                            Intrinsics.checkNotNull((Object)this.payloadBytes);
                            indexOutput.writeBytes(this.payloadBytes, payloadBytesReadUpto, payloadLength);
                            payloadBytesReadUpto += payloadLength;
                        }
                    } else {
                        IndexOutput indexOutput = this.posOut;
                        Intrinsics.checkNotNull((Object)indexOutput);
                        indexOutput.writeVInt(posDelta);
                    }
                    if (!this.getWriteOffsets()) continue;
                    Intrinsics.checkNotNull((Object)this.offsetStartDeltaBuffer);
                    int delta = this.offsetStartDeltaBuffer[i];
                    Intrinsics.checkNotNull((Object)this.offsetLengthBuffer);
                    int length = this.offsetLengthBuffer[i];
                    if (length == lastOffsetLength) {
                        IndexOutput indexOutput = this.posOut;
                        Intrinsics.checkNotNull((Object)indexOutput);
                        indexOutput.writeVInt(delta << 1);
                        continue;
                    }
                    IndexOutput indexOutput = this.posOut;
                    Intrinsics.checkNotNull((Object)indexOutput);
                    indexOutput.writeVInt(delta << 1 | 1);
                    IndexOutput indexOutput3 = this.posOut;
                    Intrinsics.checkNotNull((Object)indexOutput3);
                    indexOutput3.writeVInt(length);
                    lastOffsetLength = length;
                }
                if (this.getWritePayloads()) {
                    if (!(payloadBytesReadUpto == this.payloadByteUpto)) {
                        String string = "Failed requirement.";
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.payloadByteUpto = 0;
                }
            }
        } else {
            lastPosBlockOffset = -1L;
        }
        state2.setDocStartFP(this.docStartFP);
        state2.setPosStartFP(this.posStartFP);
        state2.setPayStartFP(this.payStartFP);
        state2.setSingletonDocID(singletonDocID);
        state2.setLastPosBlockOffset(lastPosBlockOffset);
        this.docBufferUpto = 0;
        this.posBufferUpto = 0;
        this.lastDocID = -1;
        this.docCount = 0;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void encodeTerm(@NotNull DataOutput out, @NotNull FieldInfo fieldInfo, @NotNull BlockTermState _state, boolean absolute) throws IOException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        Intrinsics.checkNotNullParameter((Object)fieldInfo, (String)"fieldInfo");
        Intrinsics.checkNotNullParameter((Object)_state, (String)"_state");
        state = (Lucene101PostingsFormat.IntBlockTermState)_state;
        if (absolute) {
            v0 = this.lastState = Lucene101PostingsWriter.EMPTY_STATE;
            Intrinsics.checkNotNull((Object)v0);
            if (!(v0.getDocStartFP() == 0L)) {
                var7_6 = "Failed requirement.";
                throw new IllegalArgumentException(var7_6.toString());
            }
        }
        v1 = this.lastState;
        Intrinsics.checkNotNull((Object)v1);
        if (v1.getSingletonDocID() == -1 || state.getSingletonDocID() == -1) ** GOTO lbl-1000
        v2 = state.getDocStartFP();
        v3 = this.lastState;
        Intrinsics.checkNotNull((Object)v3);
        if (v2 == v3.getDocStartFP()) {
            v4 = state.getSingletonDocID();
            v5 = this.lastState;
            Intrinsics.checkNotNull((Object)v5);
            delta = v4 - (long)v5.getSingletonDocID();
            out.writeVLong(BitUtil.INSTANCE.zigZagEncode(delta) << 1 | 1L);
        } else lbl-1000:
        // 2 sources

        {
            v6 = state.getDocStartFP();
            v7 = this.lastState;
            Intrinsics.checkNotNull((Object)v7);
            out.writeVLong(v6 - v7.getDocStartFP() << 1);
            if (state.getSingletonDocID() != -1) {
                out.writeVInt(state.getSingletonDocID());
            }
        }
        if (this.getWritePositions()) {
            v8 = state.getPosStartFP();
            v9 = this.lastState;
            Intrinsics.checkNotNull((Object)v9);
            out.writeVLong(v8 - v9.getPosStartFP());
            if (this.getWritePayloads() || this.getWriteOffsets()) {
                v10 = state.getPayStartFP();
                v11 = this.lastState;
                Intrinsics.checkNotNull((Object)v11);
                out.writeVLong(v10 - v11.getPayStartFP());
            }
        }
        if (this.getWritePositions() && state.getLastPosBlockOffset() != -1L) {
            out.writeVLong(state.getLastPosBlockOffset());
        }
        this.lastState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        boolean success = false;
        try {
            if (this.docOut != null) {
                IndexOutput indexOutput = this.docOut;
                Intrinsics.checkNotNull((Object)indexOutput);
                CodecUtil.INSTANCE.writeFooter(indexOutput);
            }
            if (this.posOut != null) {
                IndexOutput indexOutput = this.posOut;
                Intrinsics.checkNotNull((Object)indexOutput);
                CodecUtil.INSTANCE.writeFooter(indexOutput);
            }
            if (this.payOut != null) {
                IndexOutput indexOutput = this.payOut;
                Intrinsics.checkNotNull((Object)indexOutput);
                CodecUtil.INSTANCE.writeFooter(indexOutput);
            }
            if (this.metaOut != null) {
                IndexOutput indexOutput = this.metaOut;
                Intrinsics.checkNotNull((Object)indexOutput);
                indexOutput.writeInt(this.maxNumImpactsAtLevel0);
                IndexOutput indexOutput2 = this.metaOut;
                Intrinsics.checkNotNull((Object)indexOutput2);
                indexOutput2.writeInt(this.maxImpactNumBytesAtLevel0);
                IndexOutput indexOutput3 = this.metaOut;
                Intrinsics.checkNotNull((Object)indexOutput3);
                indexOutput3.writeInt(this.maxNumImpactsAtLevel1);
                IndexOutput indexOutput4 = this.metaOut;
                Intrinsics.checkNotNull((Object)indexOutput4);
                indexOutput4.writeInt(this.maxImpactNumBytesAtLevel1);
                IndexOutput indexOutput5 = this.metaOut;
                Intrinsics.checkNotNull((Object)indexOutput5);
                IndexOutput indexOutput6 = this.docOut;
                Intrinsics.checkNotNull((Object)indexOutput6);
                indexOutput5.writeLong(indexOutput6.getFilePointer());
                if (this.posOut != null) {
                    IndexOutput indexOutput7 = this.metaOut;
                    Intrinsics.checkNotNull((Object)indexOutput7);
                    IndexOutput indexOutput8 = this.posOut;
                    Intrinsics.checkNotNull((Object)indexOutput8);
                    indexOutput7.writeLong(indexOutput8.getFilePointer());
                    if (this.payOut != null) {
                        IndexOutput indexOutput9 = this.metaOut;
                        Intrinsics.checkNotNull((Object)indexOutput9);
                        IndexOutput indexOutput10 = this.payOut;
                        Intrinsics.checkNotNull((Object)indexOutput10);
                        indexOutput9.writeLong(indexOutput10.getFilePointer());
                    }
                }
                IndexOutput indexOutput11 = this.metaOut;
                Intrinsics.checkNotNull((Object)indexOutput11);
                CodecUtil.INSTANCE.writeFooter(indexOutput11);
            }
            success = true;
        }
        catch (Throwable throwable) {
            AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.metaOut, this.docOut, this.posOut, this.payOut};
            IOUtils.INSTANCE.closeWhileHandlingExceptionNullable(autoCloseableArray);
            this.metaOut = this.docOut = (this.posOut = (this.payOut = null));
            throw throwable;
        }
        AutoCloseable[] autoCloseableArray = new AutoCloseable[]{this.metaOut, this.docOut, this.posOut, this.payOut};
        IOUtils.INSTANCE.closeNullable(autoCloseableArray);
        this.metaOut = this.docOut = (this.posOut = (this.payOut = null));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000fJ\u001c\u0010\u0010\u001a\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\n\u001a\u00020\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsWriter$Companion;", "", "<init>", "()V", "EMPTY_STATE", "Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsFormat$IntBlockTermState;", "getEMPTY_STATE", "()Lorg/gnit/lucenekmp/codecs/lucene101/Lucene101PostingsFormat$IntBlockTermState;", "writeVInt15", "", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "v", "", "writeVLong15", "", "writeImpacts", "impacts", "", "Lorg/gnit/lucenekmp/index/Impact;", "core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Lucene101PostingsFormat.IntBlockTermState getEMPTY_STATE() {
            return EMPTY_STATE;
        }

        public final void writeVInt15(@NotNull DataOutput out, int v) throws IOException {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            if (!(v >= 0)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.writeVLong15(out, v);
        }

        public final void writeVLong15(@NotNull DataOutput out, long v) throws IOException {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            if (!(v >= 0L)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if ((v & 0xFFFFFFFFFFFF8000L) == 0L) {
                out.writeShort((short)v);
            } else {
                out.writeShort((short)(0x8000L | v & 0x7FFFL));
                out.writeVLong(v >> 15);
            }
        }

        public final void writeImpacts(@NotNull Collection<Impact> impacts2, @NotNull DataOutput out) throws IOException {
            Intrinsics.checkNotNullParameter(impacts2, (String)"impacts");
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Impact previous = new Impact(0, 0L);
            for (Impact impact : impacts2) {
                if (!(impact.getFreq() > previous.getFreq())) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!(LongExtKt.compareUnsigned(LongCompanionObject.INSTANCE, impact.getNorm(), previous.getNorm()) > 0)) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                int freqDelta = impact.getFreq() - previous.getFreq() - 1;
                long normDelta = impact.getNorm() - previous.getNorm() - 1L;
                if (normDelta == 0L) {
                    out.writeVInt(freqDelta << 1);
                } else {
                    out.writeVInt(freqDelta << 1 | 1);
                    out.writeZLong(normDelta);
                }
                previous = impact;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

