/*
 * Decompiled with CFR 0.152.
 */
package org.gnit.lucenekmp.codecs.lucene90;

import java.io.IOException;
import java.util.zip.Deflater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gnit.lucenekmp.codecs.compressing.Compressor;
import org.gnit.lucenekmp.store.ByteBuffersDataInput;
import org.gnit.lucenekmp.store.DataOutput;
import org.gnit.lucenekmp.util.ArrayUtil;
import org.gnit.lucenekmp.util.BytesRef;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J&\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010 \u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010#\u001a\u00020\u001aH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\r\"\u0004\b\u0018\u0010\u000f\u00a8\u0006$"}, d2={"Lorg/gnit/lucenekmp/codecs/lucene90/DeflateWithPresetDictCompressor;", "Lorg/gnit/lucenekmp/codecs/compressing/Compressor;", "level", "", "<init>", "(I)V", "compressor", "Ljava/util/zip/Deflater;", "getCompressor", "()Ljava/util/zip/Deflater;", "compressed", "", "getCompressed", "()[B", "setCompressed", "([B)V", "closed", "", "getClosed", "()Z", "setClosed", "(Z)V", "buffer", "getBuffer", "setBuffer", "doCompress", "", "bytes", "off", "len", "out", "Lorg/gnit/lucenekmp/store/DataOutput;", "compress", "buffersInput", "Lorg/gnit/lucenekmp/store/ByteBuffersDataInput;", "close", "core"})
public final class DeflateWithPresetDictCompressor
extends Compressor {
    @NotNull
    private final Deflater compressor;
    @NotNull
    private byte[] compressed;
    private boolean closed;
    @NotNull
    private byte[] buffer;

    @NotNull
    public final Deflater getCompressor() {
        return this.compressor;
    }

    @NotNull
    public final byte[] getCompressed() {
        return this.compressed;
    }

    public final void setCompressed(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.compressed = byArray;
    }

    public final boolean getClosed() {
        return this.closed;
    }

    public final void setClosed(boolean bl) {
        this.closed = bl;
    }

    @NotNull
    public final byte[] getBuffer() {
        return this.buffer;
    }

    public final void setBuffer(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.buffer = byArray;
    }

    public DeflateWithPresetDictCompressor(int level) {
        this.compressor = new Deflater(level, true);
        this.compressed = new byte[64];
        this.buffer = BytesRef.Companion.getEMPTY_BYTES();
    }

    public final void doCompress(@NotNull byte[] bytes, int off, int len, @NotNull DataOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        if (len == 0) {
            out.writeVInt(0);
            return;
        }
        this.compressor.setInput(bytes, off, len);
        this.compressor.finish();
        if (!(!this.compressor.needsInput())) {
            throw new IllegalStateException("Check failed.");
        }
        int totalCount = 0;
        while (true) {
            int count;
            if (!((totalCount += (count = this.compressor.deflate(this.compressed, totalCount, this.compressed.length - totalCount))) <= this.compressed.length)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.compressor.finished()) break;
            this.compressed = ArrayUtil.Companion.grow(this.compressed);
        }
        out.writeVInt(totalCount);
        out.writeBytes(this.compressed, totalCount);
    }

    @Override
    public void compress(@NotNull ByteBuffersDataInput buffersInput, @NotNull DataOutput out) throws IOException {
        Intrinsics.checkNotNullParameter((Object)buffersInput, (String)"buffersInput");
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        int len = (int)(buffersInput.length() - buffersInput.position());
        int dictLength = len / 60;
        int blockLength = (len - dictLength + 10 - 1) / 10;
        out.writeVInt(dictLength);
        out.writeVInt(blockLength);
        this.compressor.reset();
        this.buffer = ArrayUtil.Companion.growNoCopy(this.buffer, dictLength + blockLength);
        buffersInput.readBytes(this.buffer, 0, dictLength);
        this.doCompress(this.buffer, 0, dictLength, out);
        for (int start = dictLength; start < len; start += blockLength) {
            this.compressor.reset();
            this.compressor.setDictionary(this.buffer, 0, dictLength);
            int l = Math.min(blockLength, len - start);
            buffersInput.readBytes(this.buffer, dictLength, l);
            this.doCompress(this.buffer, dictLength, l, out);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.compressor.end();
            this.closed = true;
        }
    }
}

